-- Measurements
insert into DICTIONARY_ITEM(ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION, ENTITY_ID,
                            ENTITY_CLASS, NAME, DESCRIPTION, SEQUENTIAL_NUMBER)
values (DICTIONARY_ITEM_SEQ.nextval, sysdate, sysdate, 'admin', 'admin', 'VALID', 1,
        null,
        'INVOICE_ATTACHMENT', 'Aufmaße', '',
        (Select 1 + nvl(max(SEQUENTIAL_NUMBER), 0) from DICTIONARY_ITEM where ENTITY_CLASS = 'INVOICE_ATTACHMENT'));

-- Time Sheet
insert into DICTIONARY_ITEM(ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION, ENTITY_ID,
                            ENTITY_CLASS, NAME, DESCRIPTION, SEQUENTIAL_NUMBER)
values (DICTIONARY_ITEM_SEQ.nextval, sysdate, sysdate, 'admin', 'admin', 'VALID', 1,
        null,
        'INVOICE_ATTACHMENT', 'Stundennachweis', '',
        (Select 1 + nvl(max(SEQUENTIAL_NUMBER), 0) from DICTIONARY_ITEM where ENTITY_CLASS = 'INVOICE_ATTACHMENT'));

-- Images
insert into DICTIONARY_ITEM(ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION, ENTITY_ID,
                            ENTITY_CLASS, NAME, DESCRIPTION, SEQUENTIAL_NUMBER)
values (DICTIONARY_ITEM_SEQ.nextval, sysdate, sysdate, 'admin', 'admin', 'VALID', 1,
        null,
        'INVOICE_ATTACHMENT', 'Bilder', '',
        (Select 1 + nvl(max(SEQUENTIAL_NUMBER), 0) from DICTIONARY_ITEM where ENTITY_CLASS = 'INVOICE_ATTACHMENT'));

-- test log
insert into DICTIONARY_ITEM(ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION, ENTITY_ID,
                            ENTITY_CLASS, NAME, DESCRIPTION, SEQUENTIAL_NUMBER)
values (DICTIONARY_ITEM_SEQ.nextval, sysdate, sysdate, 'admin', 'admin', 'VALID', 1,
        null,
        'INVOICE_ATTACHMENT', 'Prüfprotokolle', '',
        (Select 1 + nvl(max(SEQUENTIAL_NUMBER), 0) from DICTIONARY_ITEM where ENTITY_CLASS = 'INVOICE_ATTACHMENT'));

-- completion certificate
insert into DICTIONARY_ITEM(ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION, ENTITY_ID,
                            ENTITY_CLASS, NAME, DESCRIPTION, SEQUENTIAL_NUMBER)
values (DICTIONARY_ITEM_SEQ.nextval, sysdate, sysdate, 'admin', 'admin', 'VALID', 1,
        null,
        'INVOICE_ATTACHMENT', 'Abnahmeprotokoll', '',
        (Select 1 + nvl(max(SEQUENTIAL_NUMBER), 0) from DICTIONARY_ITEM where ENTITY_CLASS = 'INVOICE_ATTACHMENT'));

-- paintings
insert into DICTIONARY_ITEM(ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION, ENTITY_ID,
                            ENTITY_CLASS, NAME, DESCRIPTION, SEQUENTIAL_NUMBER)
values (DICTIONARY_ITEM_SEQ.nextval, sysdate, sysdate, 'admin', 'admin', 'VALID', 1,
        null,
        'INVOICE_ATTACHMENT', 'Zeichnungen', '',
        (Select 1 + nvl(max(SEQUENTIAL_NUMBER), 0) from DICTIONARY_ITEM where ENTITY_CLASS = 'INVOICE_ATTACHMENT'));

-- condition statement
insert into DICTIONARY_ITEM(ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION, ENTITY_ID,
                            ENTITY_CLASS, NAME, DESCRIPTION, SEQUENTIAL_NUMBER)
values (DICTIONARY_ITEM_SEQ.nextval, sysdate, sysdate, 'admin', 'admin', 'VALID', 1,
        null,
        'INVOICE_ATTACHMENT', 'Zustandsfeststellung', '',
        (Select 1 + nvl(max(SEQUENTIAL_NUMBER), 0) from DICTIONARY_ITEM where ENTITY_CLASS = 'INVOICE_ATTACHMENT'));

-- other supporting documents
insert into DICTIONARY_ITEM(ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION, ENTITY_ID,
                            ENTITY_CLASS, NAME, DESCRIPTION, SEQUENTIAL_NUMBER)
values (DICTIONARY_ITEM_SEQ.nextval, sysdate, sysdate, 'admin', 'admin', 'VALID', 1,
        null,
        'INVOICE_ATTACHMENT', 'sonstige Nachweise', '',
        (Select 1 + nvl(max(SEQUENTIAL_NUMBER), 0) from DICTIONARY_ITEM where ENTITY_CLASS = 'INVOICE_ATTACHMENT'));







-- data

insert into INVOICE_COMPANY(ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION,
                            COMPANY_NAME_1, COMPANY_NAME_2, COMPANY_STREET, COMPANY_STREET_NO, COMPANY_CITY,
                            COMPANY_ZIP_CODE,
                            COMPANY_EMAIL, FLAG_DEFAULT,
                            FOOTER_COLUMN_1, FOOTER_COLUMN_2, FOOTER_COLUMN_3, FOOTER_COLUMN_4, FOOTER_COLUMN_5)
values (INVOICE_COMPANY_SEQ.nextval, sysdate, sysdate, 'system', 'system', 'VALID', 1,
        'QFM Fernmelde- und', 'Elektromontagen GmbH', 'Großbeerenstr.', '136', 'Berlin', '12277',
        'info@qfm.eu', 1,
        'Tel + 49 (0)30 740 05 - 0' || u'\000A' || 'Fax + 49 (0)30 740 05 - 123' || u'\000A' ||
        'Mail info@qfm.eu | qfm.eu',
        'Berliner Sparkasse' || u'\000A' || 'DE71 1005 0000 0190 0863 78' || u'\000A' || 'BIC BELADEBEXXX',
        'Commerzbank AG' || u'\000A' || 'DE81 1004 0000 0575 2555 00' || u'\000A' || 'BIC COBADEFFXXX',
        'Geschäftsführer' || u'\000A' || 'Jörg Lenius',
        'Amtsgericht Berlin (Charlottenburg)' || u'\000A' || 'UST-Ident Nr. DE 811 294 839' || u'\000A' || 'HRB 28881');

update INVOICE_NUMBER
set INVOICE_NUMBER_GROUP = 'EXTERNAL_INVOICE'
where INVOICE_NUMBER_GROUP in ('INVOICE', 'PARTIAL_INVOICE', 'PARTIAL_FINAL_INVOICE', 'FINAL_INVOICE', 'CUMULATIVE_INVOICE', 'PARTIAL_CUMULATIVE_INVOICE', 'FINAL_CUMULATIVE_INVOICE');

update INVOICE_NUMBER
set INVOICE_NUMBER_GROUP = 'CREDIT_VOUCHER'
where INVOICE_NUMBER_GROUP in ('SUBCONTRACTOR_CREDIT_VOUCHER');


-- tax keys
-- data
/**
USt-Satz    Steuerschlüssel	Konto	Art     Belegart	        Beschreibung
0%	        99	            9000	intern	interne Rechnung	Interne Erlöse
0%	        78	            1456	extern	externe Rechnung	Teilrechungen 0% (13b)
0%	        88	            8069	extern	externe Rechnung	Rechnung / Schlussrechnung / Teilschlussrechnung 0% (13b)
--
16%	        79	            1455	extern	externe Rechnung	Teilrechungen 16%
16%	        86	            8000	extern	externe Rechnung	Rechnung / Schlussrechnung / Teilschlussrechnung 16%
16%	        86	            8000	intern	interner Beleg	    interner Beleg für GS-Verfahren Kunde 16%
--
19%	        77	            1454	extern	externe Rechnung	Teilrechungen 19%
19%	        87	            8010	extern	externe Rechnung	Rechnung / Schlussrechnung / Teilschlussrechnung 19%
19%	        87	            8010	intern	interner Beleg	    interner Beleg für GS-Verfahren Kunde 19%
--
0%	        83	            3410	extern	externe Gutschrift	Gutschrift Nachunternehmer 0% (13b)
*/


insert into TAX_KEY(ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION,
                    NAME, INVOICE_TYPE, TAX_KEY, VAT, ACCOUNT)
values (TAX_KEY_SEQ.nextval, sysdate, sysdate, 'admin', 'admin', 'VALID', 0,
        'interne RE (0%)', 'INTERNAL_INVOICE', '99', 0, '9000');

insert into TAX_KEY(ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION,
                    NAME, INVOICE_TYPE, TAX_KEY, VAT, ACCOUNT)
values (TAX_KEY_SEQ.nextval, sysdate, sysdate, 'admin', 'admin', 'VALID', 0,
        'externe Teil-RE (0%) / 13b', 'PARTIAL_INVOICE', '78', 0, '1456');

insert into TAX_KEY(ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION,
                    NAME, INVOICE_TYPE, TAX_KEY, VAT, ACCOUNT)
values (TAX_KEY_SEQ.nextval, sysdate, sysdate, 'admin', 'admin', 'VALID', 0,
        'externe RE (0%) / 13b', 'INVOICE', '88', 0, '8069');

insert into TAX_KEY(ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION,
                    NAME, INVOICE_TYPE, TAX_KEY, VAT, ACCOUNT)
values (TAX_KEY_SEQ.nextval, sysdate, sysdate, 'admin', 'admin', 'VALID', 0,
        'externe RE (0%) / 13b', 'PARTIAL_FINAL_INVOICE', '88', 0, '8069');

insert into TAX_KEY(ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION,
                    NAME, INVOICE_TYPE, TAX_KEY, VAT, ACCOUNT)
values (TAX_KEY_SEQ.nextval, sysdate, sysdate, 'admin', 'admin', 'VALID', 0,
        'externe RE (0%) / 13b', 'FINAL_INVOICE', '88', 0, '8069');

-- 16%
insert into TAX_KEY(ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION,
                    NAME, INVOICE_TYPE, TAX_KEY, VAT, ACCOUNT)
values (TAX_KEY_SEQ.nextval, sysdate, sysdate, 'admin', 'admin', 'VALID', 0,
        'externe RE (16%)', 'PARTIAL_INVOICE', '79', 16, '1455');

insert into TAX_KEY(ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION,
                    NAME, INVOICE_TYPE, TAX_KEY, VAT, ACCOUNT)
values (TAX_KEY_SEQ.nextval, sysdate, sysdate, 'admin', 'admin', 'VALID', 0,
        'externe RE (16%)', 'INVOICE', '86', 16, '8000');

insert into TAX_KEY(ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION,
                    NAME, INVOICE_TYPE, TAX_KEY, VAT, ACCOUNT)
values (TAX_KEY_SEQ.nextval, sysdate, sysdate, 'admin', 'admin', 'VALID', 0,
        'externe RE (16%)', 'PARTIAL_FINAL_INVOICE', '86', 16, '8000');

insert into TAX_KEY(ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION,
                    NAME, INVOICE_TYPE, TAX_KEY, VAT, ACCOUNT)
values (TAX_KEY_SEQ.nextval, sysdate, sysdate, 'admin', 'admin', 'VALID', 0,
        'externe RE (16%)', 'FINAL_INVOICE', '86', 16, '8000');

insert into TAX_KEY(ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION,
                    NAME, INVOICE_TYPE, TAX_KEY, VAT, ACCOUNT)
values (TAX_KEY_SEQ.nextval, sysdate, sysdate, 'admin', 'admin', 'VALID', 0,
        'interner Beleg (16%)', 'INTERNAL_VOUCHER', '86', 16, '8000');

-- 19%
insert into TAX_KEY(ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION,
                    NAME, INVOICE_TYPE, TAX_KEY, VAT, ACCOUNT)
values (TAX_KEY_SEQ.nextval, sysdate, sysdate, 'admin', 'admin', 'VALID', 0,
        'externe RE (19%) / 77', 'INVOICE', '77', 19, '1454');

insert into TAX_KEY(ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION,
                    NAME, INVOICE_TYPE, TAX_KEY, VAT, ACCOUNT)
values (TAX_KEY_SEQ.nextval, sysdate, sysdate, 'admin', 'admin', 'VALID', 0,
        'externe RE (19%) / 87', 'PARTIAL_INVOICE', '87', 19, '8010');

insert into TAX_KEY(ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION,
                    NAME, INVOICE_TYPE, TAX_KEY, VAT, ACCOUNT)
values (TAX_KEY_SEQ.nextval, sysdate, sysdate, 'admin', 'admin', 'VALID', 0,
        'externe RE (19%)', 'PARTIAL_FINAL_INVOICE', '87', 19, '8010');

insert into TAX_KEY(ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION,
                    NAME, INVOICE_TYPE, TAX_KEY, VAT, ACCOUNT)
values (TAX_KEY_SEQ.nextval, sysdate, sysdate, 'admin', 'admin', 'VALID', 0,
        'externe RE (19%)', 'FINAL_INVOICE', '87', 19, '8010');

insert into TAX_KEY(ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION,
                    NAME, INVOICE_TYPE, TAX_KEY, VAT, ACCOUNT)
values (TAX_KEY_SEQ.nextval, sysdate, sysdate, 'admin', 'admin', 'VALID', 0,
        'interner Beleg (19%)', 'INTERNAL_VOUCHER', '87', 19, '8010');

-- externe GS (NU)
insert into TAX_KEY(ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION,
                    NAME, INVOICE_TYPE, TAX_KEY, VAT, ACCOUNT)
values (TAX_KEY_SEQ.nextval, sysdate, sysdate, 'admin', 'admin', 'VALID', 0,
        'externe Gutschrift/NU (0%)', 'CREDIT_VOUCHER', '83', 0, '3410');

--
select * from TAX_KEY;



-- TODO
--  import invoice data

-- adjust calculated data
create table TEMP_M_INTERNAL_WAGE as
select mp.MEASUREMENT_ID, sum(mp.INTERNAL_WAGE_AGG) as value
from MEASUREMENT_POSITION mp
group by mp.MEASUREMENT_ID;

create unique index TEMP_M_INTERNAL_WAGE_ID on TEMP_M_INTERNAL_WAGE(MEASUREMENT_ID);

create table TEMP_M_MAT_SELLING_PRICE as
select mp.MEASUREMENT_ID, sum(mp.MAT_SELLING_PRICE_AGG_DISCOUNT) as value
from MEASUREMENT_POSITION mp
group by mp.MEASUREMENT_ID;

create unique index TEMP_M_MAT_SELLING_PRICE_ID on TEMP_M_MAT_SELLING_PRICE(MEASUREMENT_ID);

update MEASUREMENT m
set INTERNAL_WAGE_OVERALL = (select value from TEMP_M_INTERNAL_WAGE where MEASUREMENT_ID = m.id),
    MAT_SELLING_PRICE_OVERALL = (select value from TEMP_M_MAT_SELLING_PRICE where MEASUREMENT_ID = m.id)
where id > 0;

drop table TEMP_M_MAT_SELLING_PRICE;
drop table TEMP_M_INTERNAL_WAGE;



-- fix/182829390-dashboard-mat-price-overall-on-measuremnet-head-wrong
select mat_purchase_inc_disc_per_unit,
       product,
       mat_purchase_inc_disc_agg,
       mat_purchase_inc_disc_per_unit * product                                            as matshould,
       round(abs(mat_purchase_inc_disc_per_unit * product - mat_purchase_inc_disc_agg), 2) as matdiff,

       company_wage_per_unit,
       product,
       company_wage_agg,
       company_wage_per_unit * product                                                     as compshould,
       round(abs(company_wage_per_unit * product - company_wage_agg), 2)                   as compdiff
from MEASUREMENT_POSITION
WHERE round(abs(mat_purchase_inc_disc_per_unit * product - mat_purchase_inc_disc_agg), 2) >= 0.01
   OR round(abs(company_wage_per_unit * product - company_wage_agg), 2) >= 0.01
order by id desc;

update MEASUREMENT_POSITION
set mat_purchase_inc_disc_agg = mat_purchase_inc_disc_per_unit * product,
    company_wage_agg          = company_wage_per_unit * product
WHERE round(abs(mat_purchase_inc_disc_per_unit * product - mat_purchase_inc_disc_agg), 2) >= 0.01
   OR round(abs(company_wage_per_unit * product - company_wage_agg), 2) >= 0.01
;


-- update calculated cols
update MEASUREMENT a
set a.COMPANY_WAGE_OVERALL = (select sum(b.COMPANY_WAGE_AGG) from MEASUREMENT_POSITION b where b.MEASUREMENT_ID = a.id)
where a.id > 0;

update MEASUREMENT a
set a.MAT_PURCHASE_PRICE_OVERALL = (select sum(b.MAT_PURCHASE_INC_DISC_AGG) from MEASUREMENT_POSITION b where b.MEASUREMENT_ID = a.id)
where a.id > 0;



-- invoice numbers
update invoice set internal_partial_number = 	1	where invoice_number = '21/02593';
update invoice set internal_partial_number = 	1	where invoice_number = '22/01644';
update invoice set internal_partial_number = 	2	where invoice_number = '22/02447';
update invoice set internal_partial_number = 	3	where invoice_number = '22/02569';
update invoice set internal_partial_number = 	1	where invoice_number = '22/01475';
update invoice set internal_partial_number = 	1	where invoice_number = '22/01783';
update invoice set internal_partial_number = 	4	where invoice_number = '20/00483';
update invoice set internal_partial_number = 	1	where invoice_number = '20/01500';
update invoice set internal_partial_number = 	5	where invoice_number = '21/02964';
update invoice set internal_partial_number = 	6	where invoice_number = '22/02062';
update invoice set internal_partial_number = 	1	where invoice_number = '21/00881';
update invoice set internal_partial_number = 	1	where invoice_number = '21/03836';
update invoice set internal_partial_number = 	1	where invoice_number = '21/03756';
update invoice set internal_partial_number = 	2	where invoice_number = '22/00886';
update invoice set internal_partial_number = 	3	where invoice_number = '22/01112';
update invoice set internal_partial_number = 	4	where invoice_number = '22/01114';
update invoice set internal_partial_number = 	5	where invoice_number = '22/01120';
update invoice set internal_partial_number = 	6	where invoice_number = '22/01422';
update invoice set internal_partial_number = 	7	where invoice_number = '22/01649';
update invoice set internal_partial_number = 	8	where invoice_number = '22/02119';
update invoice set internal_partial_number = 	9	where invoice_number = '22/02694';
update invoice set internal_partial_number = 	1	where invoice_number = '21/03998';
update invoice set internal_partial_number = 	2	where invoice_number = '22/02266';
update invoice set internal_partial_number = 	1	where invoice_number = '22/02262';
update invoice set internal_partial_number = 	1	where invoice_number = '22/00889';
update invoice set internal_partial_number = 	2	where invoice_number = '22/00890';
update invoice set internal_partial_number = 	3	where invoice_number = '22/00891';
update invoice set internal_partial_number = 	4	where invoice_number = '22/00986';
update invoice set internal_partial_number = 	5	where invoice_number = '22/00987';
update invoice set internal_partial_number = 	6	where invoice_number = '22/01077';
update invoice set internal_partial_number = 	7	where invoice_number = '22/01079';
update invoice set internal_partial_number = 	8	where invoice_number = '22/01078';
update invoice set internal_partial_number = 	9	where invoice_number = '22/01322';
update invoice set internal_partial_number = 	10	where invoice_number = '22/01323';
update invoice set internal_partial_number = 	11	where invoice_number = '22/01324';
update invoice set internal_partial_number = 	12	where invoice_number = '22/01325';
update invoice set internal_partial_number = 	13	where invoice_number = '22/01326';
update invoice set internal_partial_number = 	14	where invoice_number = '22/01327';
update invoice set internal_partial_number = 	15	where invoice_number = '22/01328';
update invoice set internal_partial_number = 	16	where invoice_number = '22/01408';
update invoice set internal_partial_number = 	17	where invoice_number = '22/01409';
update invoice set internal_partial_number = 	18	where invoice_number = '22/01410';
update invoice set internal_partial_number = 	19	where invoice_number = '22/01411';
update invoice set internal_partial_number = 	20	where invoice_number = '22/01412';
update invoice set internal_partial_number = 	21	where invoice_number = '22/01413';
update invoice set internal_partial_number = 	22	where invoice_number = '22/01551';
update invoice set internal_partial_number = 	23	where invoice_number = '22/01552';
update invoice set internal_partial_number = 	24	where invoice_number = '22/01573';
update invoice set internal_partial_number = 	25	where invoice_number = '22/02441';
update invoice set internal_partial_number = 	1	where invoice_number = '22/02850';
update invoice set internal_partial_number = 	2	where invoice_number = '22/02853';
update invoice set internal_partial_number = 	1	where invoice_number = '22/02355';
update invoice set internal_partial_number = 	2	where invoice_number = '22/02525';
update invoice set internal_partial_number = 	3	where invoice_number = '22/02836';
update invoice set internal_partial_number = 	1	where invoice_number = '22/02322';
update invoice set internal_partial_number = 	1	where invoice_number = '22/02320';
update invoice set internal_partial_number = 	1	where invoice_number = '22/02321';

-- manual
update invoice set internal_partial_number = 1 where invoice_number = '19/04165';
update invoice set internal_partial_number = 2 where invoice_number = '19/05394';
update invoice set internal_partial_number = 1, invoice_type = 'PARTIAL_FINAL_INVOICE' where invoice_number = '19/06117';

-- invoice numbers
-- select * from rg_numerierung where jahreszahl = 2022;
insert into INVOICE_NUMBER(ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION,
                           INVOICE_NUMBER_GROUP, invoice_year, invoice_number)
values (INVOICE_NUMBER_SEQ.nextval, sysdate, sysdate, 'import', 'import', 'VALID', 0,
        'EXTERNAL_INVOICE', 2022, 2981);