-- fix/182829390-dashboard-mat-price-overall-on-measuremnet-head-wrong
select mat_purchase_inc_disc_per_unit,
       product,
       mat_purchase_inc_disc_agg,
       mat_purchase_inc_disc_per_unit * product                                            as matshould,
       round(abs(mat_purchase_inc_disc_per_unit * product - mat_purchase_inc_disc_agg), 2) as matdiff,

       company_wage_per_unit,
       product,
       company_wage_agg,
       company_wage_per_unit * product                                                     as compshould,
       round(abs(company_wage_per_unit * product - company_wage_agg), 2)                   as compdiff
from MEASUREMENT_POSITION
WHERE round(abs(mat_purchase_inc_disc_per_unit * product - mat_purchase_inc_disc_agg), 2) >= 0.01
   OR round(abs(company_wage_per_unit * product - company_wage_agg), 2) >= 0.01
order by id desc;

update MEASUREMENT_POSITION
set mat_purchase_inc_disc_agg = mat_purchase_inc_disc_per_unit * product,
    company_wage_agg          = company_wage_per_unit * product
WHERE round(abs(mat_purchase_inc_disc_per_unit * product - mat_purchase_inc_disc_agg), 2) >= 0.01
   OR round(abs(company_wage_per_unit * product - company_wage_agg), 2) >= 0.01
;



-- update calculated cols
update MEASUREMENT a
set a.COMPANY_WAGE_OVERALL = (select sum(b.COMPANY_WAGE_AGG) from MEASUREMENT_POSITION b where b.MEASUREMENT_ID = a.id)
where a.id > 0;

update MEASUREMENT a
set a.MAT_PURCHASE_PRICE_OVERALL = (select sum(b.MAT_PURCHASE_INC_DISC_AGG) from MEASUREMENT_POSITION b where b.MEASUREMENT_ID = a.id)
where a.id > 0;