-- classpath:db/changelog/db.changelog-singularity.xml::1584977987017-22::xoo (generated) was: 8:adde2912eacb5a461b1d22e43aefc1bb but is now: 8:caf4b427a49fc8aac14520c0a15a7b86
alter table MEASUREMENT
    add SQUAD_WAGE_OVERALL NUMBER(10, 2) default 0;

update DATABASECHANGELOG
set MD5SUM = '8:caf4b427a49fc8aac14520c0a15a7b86'
where MD5SUM = '8:adde2912eacb5a461b1d22e43aefc1bb';
commit;

create table measurement_wage_update as (
    select m.id                         as measurement_id,
           nvl(WAGE_OVERALL, 0)         as current_wage,
           nvl(SQUAD_WAGE_OVERALL, 0)   as current_squad_wage,
           nvl(mp.mp_wage_agg, 0)       as should_wage,
           nvl(mp.mp_squad_wage_agg, 0) as should_squad_wage
    from MEASUREMENT m
             left join (
        select b.measurement_id,
               sum(b.INTERNAL_WAGE_AGG)       as mp_wage_agg,
               sum(b.INTERNAL_SQUAD_WAGE_AGG) as mp_squad_wage_agg
        from MEASUREMENT_POSITION b
        group by b.measurement_id
    ) mp on mp.MEASUREMENT_ID = m.id
);

MERGE INTO MEASUREMENT a
USING (select measurement_id, should_wage, should_squad_wage
       from measurement_wage_update) b
ON (a.id = b.measurement_id)
WHEN MATCHED THEN
    UPDATE
    SET a.WAGE_OVERALL       = b.should_wage,
        a.SQUAD_WAGE_OVERALL = b.should_squad_wage;


select nvl(WAGE_OVERALL, 0),
       nvl(SQUAD_WAGE_OVERALL, 0),
       nvl(mp.mp_wage_agg, 0),
       nvl(mp.mp_squad_wage_agg, 0)
from MEASUREMENT m
         left join (
    select b.measurement_id,
           sum(b.INTERNAL_WAGE_AGG)       as mp_wage_agg,
           sum(b.INTERNAL_SQUAD_WAGE_AGG) as mp_squad_wage_agg
    from MEASUREMENT_POSITION b
    group by b.measurement_id
) mp on mp.MEASUREMENT_ID = m.id
where nvl(WAGE_OVERALL, 0) != nvl(mp.mp_wage_agg, 0)
   OR nvl(SQUAD_WAGE_OVERALL, 0) != nvl(mp.mp_squad_wage_agg, 0);


select *
from MEASUREMENT
where WAGE_OVERALL IS NULL
   OR SQUAD_WAGE_OVERALL IS NULL;

update MEASUREMENT
set WAGE_OVERALL = 0
where WAGE_OVERALL IS NULL;

update MEASUREMENT
set SQUAD_WAGE_OVERALL = 0
where SQUAD_WAGE_OVERALL IS NULL;

commit;


drop table measurement_wage_update;