--------------------------------------------------------
--  Datei erstellt -Dienstag-August-25-2020   
--------------------------------------------------------
--------------------------------------------------------
--  DDL for Table BENUTZER
--------------------------------------------------------

CREATE TABLE "QFMTEST"."BENUTZER"
(
    "USERNAME"                 VARCHAR2(30 BYTE),
    "PASSWORT"                 VARCHAR2(20 BYTE),
    "ANZPOS"                   NUMBER,
    "GRPNAME"                  VARCHAR2(30 BYTE),
    "KZ_BENUTZER_INFO_ANZEIGE" NUMBER,
    "KURZZEICHEN"              VARCHAR2(20 BYTE),
    "TELEFON"                  VARCHAR2(20 BYTE),
    "TELEFAX"                  VARCHAR2(20 BYTE),
    "BAULEITER_KZ"             VARCHAR2(2 BYTE),
    "EMAIL"                    VARCHAR2(100 BYTE),
    "ANREDE"                   VARCHAR2(50 BYTE),
    "SITZ"                     VARCHAR2(250 BYTE),
    "NAME"                     VARCHAR2(30 BYTE),
    "VORNAME"                  VARCHAR2(30 BYTE),
    "TRUPP_KZ"                 NUMBER,
    "ROWVERSION"               NUMBER,
    "PERSONALNUMMER"           NUMBER
) PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
    STORAGE
(
    INITIAL 106496 NEXT 106496 MINEXTENTS 1 MAXEXTENTS 2147483645
    PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT
)
    TABLESPACE "QFMTEST";


COMMENT ON COLUMN "QFMTEST"."BENUTZER"."PERSONALNUMMER" IS 'Personalnummer des Benutzers';
--------------------------------------------------------
--  DDL for Table BENUTZERGRP
--------------------------------------------------------

CREATE TABLE "QFMTEST"."BENUTZERGRP"
(
    "USERNAME"   VARCHAR2(30 BYTE),
    "ANZPOS"     NUMBER,
    "ROWVERSION" NUMBER
) PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
    STORAGE
(
    INITIAL 106496 NEXT 106496 MINEXTENTS 1 MAXEXTENTS 2147483645
    PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT
)
    TABLESPACE "QFMTEST";
--------------------------------------------------------
--  DDL for Table HA_BAULEITER
--------------------------------------------------------

CREATE TABLE "QFMTEST"."HA_BAULEITER"
(
    "KZ"            VARCHAR2(2 BYTE),
    "NAME"          VARCHAR2(40 BYTE),
    "JAHRESVORTRAG" NUMBER(15, 2),
    "TELEFON"       VARCHAR2(20 BYTE),
    "MOBIL"         VARCHAR2(20 BYTE),
    "KOSTENSTELLE"  VARCHAR2(12 BYTE),
    "ROWVERSION"    NUMBER
) PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
    STORAGE
(
    INITIAL 106496 NEXT 106496 MINEXTENTS 1 MAXEXTENTS 2147483645
    PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT
)
    TABLESPACE "QFMTEST";


COMMENT ON COLUMN "QFMTEST"."HA_BAULEITER"."KOSTENSTELLE" IS 'Kostenstelle des Bauleiters';
--------------------------------------------------------
--  DDL for Table HA_BAUTRUPP
--------------------------------------------------------

CREATE TABLE "QFMTEST"."HA_BAUTRUPP"
(
    "TRUPP_KZ"      NUMBER,
    "NAME"          VARCHAR2(40 BYTE),
    "BAULEITER_KZ"  VARCHAR2(2 BYTE),
    "KOSTENSTELLE"  VARCHAR2(12 BYTE),
    "JAHRESVORTRAG" NUMBER(10, 2),
    "TELEFON"       VARCHAR2(20 BYTE),
    "MOBIL"         VARCHAR2(20 BYTE),
    "TARIFART"      VARCHAR2(50 BYTE),
    "ROWVERSION"    NUMBER,
    "SOZVERS_NR"    VARCHAR2(13 BYTE),
    "TRUPPFUEHRER"  NUMBER
) PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
    STORAGE
(
    INITIAL 106496 NEXT 106496 MINEXTENTS 1 MAXEXTENTS 2147483645
    PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT
)
    TABLESPACE "QFMTEST";
REM INSERTING into QFMTEST.BENUTZER
SET DEFINE OFF;
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('S_HERMEL', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Hermel', '- 0', '- 133', 'LE', 'sven.hermel@quantefm.de',
        'i. A.', 'Berlin', 'Hermel', 'Sven', null, '1460', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_SCHOLZ', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Scholz', '- 143', '- 133', 'DW', 'martin.scholz@qfm.eu',
        'Herr', 'Berlin', 'Scholz', 'Martin', null, '1644', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('K_MEI�NER', 'GESICHERT', '0', 'DEAKTIVIERT', '0', 'Hr. Mei�ner', '- 238', '- 173', 'KM',
        'kenny.meissner@qfm.eu', 'i. A.', 'Berlin', 'Mei�ner', 'Kenny', null, '2045', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_SAVRANOGLU', 'QFM2019', '79', 'BAULEITER', '0', null, null, null, null, 'ayhan.savranoglu', 'i. V.', null,
        'SAVRANOGLU', 'Ayhan', null, '2056', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('O_LOSERT', 'QUANTEFM', '7', 'MONTEUR', '0', 'Hr. Losert', null, null, 'BR', 'oliver.losert@qfm.eu', 'i. A.',
        null, 'Losert', 'Oliver', '1692', '2180', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('H_JANKE', 'QUANTEFM706', '7', 'MONTEUR', '0', 'Hr. Janke', null, null, 'CP', 'henry.janke@qfm.eu', 'i. A.',
        null, 'Janke', 'Henry', '1700', '1822', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_BIEREND', 'QUANTEFM', '0', 'ALLGEMEINE VERWALTUNG', '1', null, null, null, null, null, 'i. A.', null,
        'Bierend', 'Marco', null, '1848', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_MAGSUDLU', 'CICI27.7', '81', 'BAULEITER MIT MASCHINEN', '0', 'Hr. Magsudlu', '02022754040', '02022754088',
        null, 'aschkan.magsudlu@qfm.eu', 'i. A.', 'Wuppertal', 'Magsudlu', 'Aschkan', null, '2004', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('K_K�HN', 'ARCHITEKTUR1', '103', 'FAKTURIERUNG_MASCH', null, 'Fr. K�hn', '- 204', '- 123', null,
        'kathleen.kuehn@qfm.eu', 'i. A.', 'Berlin', 'K�hn', 'Kathleen', null, '1985', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('U_NAU', 'FLECKI15', '0', 'DEAKTIVIERT', null, 'Fr. Nau', '- 175', '- 123', null, 'ute.nau@qfm.eu', 'i. A.',
        'Berlin', 'Nau', 'Ute', null, '2088', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_NEHER', 'QUANTEFM', '79', 'BAULEITER', null, 'Hr. Neher', '- 172', '- 173', null, 'andre.neher@qfm.eu',
        'i. A.', 'Berlin', 'Neher', 'Andr�', null, '1991', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('D_CRUSE', 'SEPTEMBER18', '81', 'BAULEITER MIT MASCHINEN', null, 'Frau', '233', '173', null,
        'desiree.cruse@qfm.eu', 'i. A.', null, 'Cruse', 'Desiree', null, '2016', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('P_BERNHARDT', 'RUBY03', '68', 'ALLGEMEINE VERWALTUNG MA', null, 'Herr', '241', null, null,
        'pierre.bernhardt@qfm.eu', 'i. A.', null, 'Bernhardt', 'Pierre', null, '2050', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_ARIK', 'FURKAN', '81', 'BAULEITER MIT MASCHINEN', null, 'Hr. Arik', '- 148', '- 133', 'LE',
        'musa.arik@qfm.eu', 'i. V.', 'Berlin', 'Arik', 'Musa', null, '2032', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('J_WALTER', 'ROLLERW22', '79', 'BAULEITER', null, 'Herr Walter', null, null, 'LB', 'jean.walter@qfm.eu',
        'i. A.', 'Berlin', 'Walter', 'Jean', '462', '2147', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_BOULAHROUZ', 'AZZE1988', '81', 'BAULEITER MIT MASCHINEN', null, 'Herr Boulahrouz', null, null, null,
        'azzeddine.boulahrouz@qfm.eu', 'i. A.', 'Wuppertal', 'Boulahrouz', 'Azzeddine', null, '2162', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('S_YAKUT', 'AEEES1986', '81', 'BAULEITER MIT MASCHINEN', null, 'Herr Yakut', null, null, null,
        'salih.yakut@qfm.eu', 'i. A.', 'Wuppertal', 'Yakut', 'Salih', null, '2161', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('J_NAUMANN', 'QUANTEFM', '7', 'MONTEUR', null, 'Herr Naumann', null, null, 'RT', 'joerg.naumann@qfm.eu',
        'i. A.', 'Berlin', 'Naumann', 'J�rg', '358', '2165', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_TROBISCH', 'QWERTZ', '7', 'MONTEUR', '0', 'Hr. Trobisch', null, null, 'H�', null, 'i. A.', null, 'Trobisch',
        'Michael', '1100', '1878', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('T_ADAM', 'QUANTE5', '7', 'MONTEUR', '0', 'Hr. Adam', '- 205', '- 193', 'H�', 'torsten.adam@qfm.eu', 'i. A.',
        null, 'Adam', 'Torsten', '1142', '1873', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_HEFTER', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Hefter', null, null, 'DE', null, 'i. A.', null, 'Hefter',
        'Andre', '1039', '1265', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('R_GOLY', 'ELLA63', '7', 'MONTEUR', '0', 'Hr. Goly', null, null, 'H�', null, 'i. A.', null, 'Goly', 'Raimon',
        '1113', '1739', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('T_BECK', 'QUANTE', '5', 'MONTEUR', '0', 'Hr. Beck', null, null, 'H�', null, 'i. A.', null, 'Beck', 'Thomas',
        '100', '1064', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_ROGASCH', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Rogasch', null, null, 'DE', null, 'i. A.', null,
        'Rogasch', 'Andreas', '1019', '1433', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_GELESCHUS', 'QUANTEFM', '7', 'MONTEUR', '1', 'Hr. Geleschus', null, null, 'CS', null, 'i. A.', null,
        'Geleschus', 'Mario', '348', '1776', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('O_KIRCHER', 'NICK2005', '5', 'MONTEUR', '1', 'Hr. Kircher', null, null, 'LB', null, 'i. A.', null, 'Kircher',
        'Olaf', '410', '1067', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('K_BR�RING', 'QUANTE', '5', 'MONTEUR', '1', 'Hr. Br�ring', null, null, 'PI', null, 'i. A.', null, 'Br�ring',
        'Karl', '1152', '1068', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('D_SCHON', 'SANDDORN10', '5', 'MONTEUR', '1', 'Hr. Schon', null, null, 'LB', null, 'i. A.', null, 'Schon',
        'Dittmar', '107', '1069', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('F_FELSKE', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Felske', null, null, 'LB', null, 'i. A.', null, 'Felske',
        'Frank', '83', '1951', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('R_M�RZ', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Fr. M�rz', '74005 - 132', '74005 - 123', null,
        'rebecca.maerz@quantefm.de', 'i. A.', 'Berlin', 'M�rz', 'Rebecca', null, '1380', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_FRIED', 'ALFRED11', '6', 'MONTEUR', '1', 'Hr. Fried', null, null, 'JB', null, 'i. A.', null, 'Fried',
        'Alfred', '1153', '1198', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('SYSADMIN', 'TIMMI', '115', null, '0', null, null, null, null, null, null, null, null, null, null, '1073',
        null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('C_HOFFER', 'BLUME', '0', 'DEAKTIVIERT', '1', 'Fr. Hoffer', '- 126', '- 123', null, 'carola.hoffer@quantefm.de',
        'i. A.', 'Berlin', 'Hoffer', 'Carola', null, '1263', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_THEURER', 'QUANTE', '101', 'FAKTURIERUNG', '0', 'Fr. Theurer', '- 161', '- 173', null,
        'maren.theurer@qfm.eu', 'i. V.', 'Berlin', 'Theurer', 'Maren', null, '1547', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('C_HILPRECHT', 'PIMBOLI', '101', 'FAKTURIERUNG', '0', 'Fr. Hilprecht', '- 114', '- 133', null,
        'christiane.hilprecht@qfm.eu', 'i. A.', null, 'Hilprecht', 'Christiane', null, '1690', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('T_MENDE', 'QUANTEFM', '8', 'MASCH_VERWALTUNG', '0', 'Hr. Mende', '- 156', '- 123', null,
        'torsten.mende@qfm.eu', 'i. V.', 'Berlin', 'Mende', 'Torsten', null, '2037', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_FRUTH', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Fruth', null, null, 'PI', null, 'i. A.', null, 'Fruth',
        'Michael', '1659', '1438', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('L_GORDALLA', 'RAMBO66', '6', 'MONTEUR', '1', 'Hr. Gordalla', null, null, 'PI', null, 'i. A.', null, 'Gordalla',
        'Lothar', '1159', '1346', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('R_KENDLBACHER', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Kendlbacher', null, null, 'PI', null, 'i. A.', null,
        'Kendlbacher', 'Rudolph', '1660', '1441', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('H_OCHMANN', 'QUANTE', '5', 'MONTEUR', '1', 'Hr. Ochmann', null, null, 'PI', null, 'i. A.', null, 'Ochmann',
        'Heinrich', '1149', '1081', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('R_PIEPER', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Pieper', null, null, 'JB', null, 'i. A.', null, 'Pieper',
        'Rainer', '1154', '1427', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('S_QUANDT', 'SUSI1305', '5', 'MONTEUR', '0', 'Hr. Quandt', null, null, 'PI', null, 'i. A.', null, 'Quandt',
        'Sascha', '1157', '1083', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('K_RUHTZ', 'QUANTE', '5', 'MONTEUR', '1', 'Hr. Ruhtz', null, null, 'TR', null, 'i. A.', null, 'Ruhtz', 'Kevin',
        '1168', '1084', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('P_MAY', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. May', null, null, 'TR', null, 'i. A.', null, 'May', 'Paul',
        '1674', '1426', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('H_BUCHHOLZ', 'QUANTE', '7', 'MONTEUR', '1', 'Hr. Buchholz', null, null, 'LB', 'heiko.buchholz@qfm.eu', 'i. A.',
        null, 'Buchholz', 'Heiko', '191', '1524', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('O_BAUDACH', 'GESICHERT', '7', 'MONTEUR', '1', 'Hr. Baudach', null, null, 'MW', null, 'i. A.', null, 'Baudach',
        'Oliver', '1071', '1806', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_WAGNER', 'QUANTE', '79', 'BAULEITER', '0', 'Hr. Wagner', '- 168', '- 123', 'AW', 'alan.wagner@qfm.eu',
        'i. A.', null, 'Wagner', 'Alan', '311', '1503', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('R_KRAUSE', 'RAINER1965', '7', 'MONTEUR', '0', 'Hr. Krause', null, null, 'LB', null, 'i. A.', null, 'Krause',
        'Rainer', '112', '1816', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('R_SCHMIDT', 'PRE71LAU', '79', 'BAULEITER', '0', 'Hr. Schmidt', null, null, 'GR', null, 'i. A.', null,
        'Schmidt', 'Rainer', '403', '2042', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('I_�ST�NDAG', 'QUANTE', '6', 'MONTEUR', '1', 'Hr. �st�ndag', null, null, 'LB', null, 'i. A.', null, '�st�ndag',
        'Ismail', '157', '1124', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('T_G�TSCH', 'QUANTE', '5', 'MONTEUR', '1', 'Hr. G�tsch', null, null, 'LB', null, 'i. A.', null, 'G�tsch',
        'Torsten', '67', '1092', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('R_JAHNEL', 'PAUKER', '5', 'MONTEUR', '1', 'Hr. Jahnel', null, null, 'LB', null, 'i. A.', null, 'Jahnel',
        'Ralf', '55', '1093', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('L_KUNICK', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Kunick', null, null, 'CP', null, 'i. A.', null, 'Kunick',
        'Lars', '1665', '1437', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_GRAU', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Grau', null, null, 'CP', null, 'i. A.', null, 'Grau',
        'Marc', '1170', '1439', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('R_JERKE', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Jerke', '- 144', '- 173', 'RJ', 'ronny.jerke@quantefm.de',
        'i. A.', 'Berlin', 'Jerke', 'Ronny', null, '1296', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('N_JANZEN', 'QUANTE', '5', 'MONTEUR', '1', 'Hr. Janzen', null, null, 'LB', null, 'i. A.', null, 'Janzen',
        'Niels', '413', '1097', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('H_LORENZ', 'QUANTE', '5', 'MONTEUR', '1', 'Hr. Lrenz', null, null, 'LB', null, 'i. A.', null, 'Lorenz',
        'Henry', '215', '1098', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('F_FUHRIG', 'CADDY21', '78', 'BAULEITER', '0', 'Hr. Fuhrig', null, null, 'RB', null, 'i. A.', null, 'Fuhrig',
        'Frank', '1011', '1363', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('B_FARCHMIN', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Farchmin', null, null, 'MK', null, 'i. A.', null,
        'Farchmin', 'Bernd', '1107', '1682', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('C_SCHILLING', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Schilling', null, null, 'B�', null, 'i. A.', null,
        'Schilling', 'Christian', '1649', '1378', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('T_BAND', 'QUANTE', '5', 'MONTEUR', '1', 'Hr. Band', null, null, 'LB', null, 'i. A.', null, 'Band', 'Thomas',
        '414', '1102', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_SCHWEIZER', 'QUANTE2014', '7', 'MONTEUR', '0', 'Hr. Schweizer', null, null, 'MB', null, 'i. A.', null,
        'Schweizer', 'Maik', '1641', '1637', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('K_MERKEL', 'QUANTE', '5', 'MONTEUR', '1', 'Hr. Merkel', null, null, 'LB', null, 'i. A.', null, 'Merkel',
        'Klaus-Peter', '209', '1104', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('S_KUBLER', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Kubler', null, null, 'RB', null, 'i. A.', null, 'Kubler',
        'Swen', '1644', '1428', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('R_SCHULZ', 'QUANTE', '5', 'MONTEUR', '1', 'Hr. Schulz', null, null, 'LB', null, 'i. A.', null, 'Schulz',
        'Rainer', '110', '1106', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('PRUEFER', 'PRUEFER', '115', 'PRUEFER', '1', null, null, null, null, null, null, null, null, null, null, '1107',
        null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('R_BR�SEKE', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Br�seke', '- 141', '- 173', 'RB',
        'ralf.brueseke@quantefm.de', 'i. V.', 'Berlin', 'Br�seke', 'Ralf', null, '1281', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('T_B�SSOW', 'QUANTE', '5', 'MONTEUR', '1', 'Hr. B�ssow', null, null, 'LB', null, 'i. A.', null, 'B�ssow',
        'Torsten', '31', '1109', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('T_HOFFMANN', 'QUANTEFM', '5', 'MONTEUR', '1', 'Hr. Hoffmann', null, null, 'RT', null, 'i. A.', null,
        'Hoffmann', 'Thomas', '59', '1110', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_WALCH', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Fr. Walch', '- 0', '- 0', 'PS',
        'Annemarie.Hoiss@fw-muenchen.de', 'i. V.', 'M�nchen', 'Walch', 'Annemarie', null, '1603', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_KAHLERT', 'MICHEL', '7', 'MONTEUR', '0', 'Hr. Kahlert', null, null, 'H�', 'michael.kahlert@qfm.eu', 'i. A.',
        null, 'Kahlert', 'Michael', '1679', '1544', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_SCHLOSSER', 'RAUL', '101', 'FAKTURIERUNG', '0', 'Fr. Schlosser', '- 0', '- 173', null,
        'michele.schlosser@qfm.eu', 'i. A.', 'Berlin', 'Schlosser', 'Mich�le', null, '1626', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('H_GENTHE', 'QUANTE061281', '6', 'MONTEUR', '0', 'Hr. Genthe', null, null, 'H�', null, 'i. A.', null, 'Genthe',
        'Henry', '1669', '1336', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('D_WAGNER', 'UNREAL1017', '79', 'BAULEITER', '0', 'Hr. Wagner', '- 143', '- 133', null, 'dennis.wagner@qfm.eu',
        'ppa.', 'Berlin', 'Wagner', 'Dennis', null, '2135', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('K_GUDELIUS', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Fr. Gudelius', '0202 27540 15', '0202 27540 88', null,
        'katja.gudelius@quantefm.de', 'i. A.', 'Wuppertal', 'Gudelius', 'Katja', null, '1474', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_STOLL', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Stoll', '- 140', '- 123', 'PS',
        'andreas.stoll@quantefm.de', 'i. V.', 'Berlin', 'Stoll', 'Andreas', null, '1266', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('R_MAERZ', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Fr. M�rz', '74005 - 132', '74005 - 123', null,
        'rebecca.maerz@quantefm.de', 'i. A.', 'Berlin', 'M�rz', 'Rebecca', null, '1379', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_KOPPE', 'TARZAN', '81', 'BAULEITER MIT MASCHINEN', '0', 'Hr. Koppe', null, null, 'KO', 'mario.koppe@qfm.eu',
        'i. A.', null, 'Koppe', 'Mario', '417', '1998', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('B_M�LLER', 'GESICHERT', '0', 'DEAKTIVIERT', '0', 'Hr. M�ller', '- 142', '- 123', 'M�',
        'bjoern-o.mueller@qfm.eu', 'i. V.', 'Berlin', 'M�ller', 'Bj�rn-O.', null, '2006', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('B_KULLA', 'SILVERBACK88', '0', 'DEAKTIVIERT', '1', 'Hr. Kulla', null, null, 'MK', null, 'i. A.', null, 'Kulla',
        'Bejamin', '1681', '1717', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('C_SIEBKE', 'JJ229', '7', 'MONTEUR', '1', 'Hr. Siebke', null, null, 'MK', null, 'i. A.', null, 'Siebke',
        'Christian', '1712', '1607', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_F�RSTENBERG', 'HAMSTER007', '66', 'ALLGEMEINE VERWALTUNG', '0', 'Fr. F�rstenberg', '- 0', '- 133', null,
        'andrea.foerstenberg@qfm.eu', 'i. A.', null, 'F�rstenberg', 'Andrea', null, '2036', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_FRIEDRICH', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Friedrich', '- 163', '- 123', 'PS',
        'andreas.firedrich@qfm.eu', 'i. A.', 'Berlin', 'Friedrich', 'Andreas', null, '1494', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_GR�NEBERG', 'PHIL1990', '79', 'BAULEITER', '0', 'Fr. Gr�neberg', '- 205', '- 173', null,
        'annett.grueneberg@qfm.eu', 'i. A.', 'Berlin', 'Gr�neberg', 'Annett', null, '1676', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_GRELL', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Grell', '- 144', '- 173', 'MG', 'mike.grell@quantefm.de',
        'i. A.', null, 'Grell', 'Mike', '12194', '1457', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('S_WOLF', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Wolf', '- 281', '- 123', null, 'stephan.wolf@quantefm.de',
        'i. A.', 'Berlin', 'Wolf', 'Stephan', null, '1377', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('C_SCH�TT', 'GESICHERT', '79', 'DEAKTIVIERT', '1', 'Hr. Sch�tt', '- 152', '- 173', 'CS',
        'carsten.schuett@qfm.eu', 'i. A.', 'Berlin', 'Sch�tt', 'Carsten', null, '1510', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('D_GERKEN', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Gerken', '040 309817 35', '040 3098 17 38', 'DG',
        'dieter.gerken@quantefm.de', 'i. A.', 'Norderstedt', 'Gerken', 'Dieter', null, '1435', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_GEHRKE', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Gehrke', '- 162', '- 123', 'PS', 'andre.gehrke@qfm.eu',
        'i. A.', 'Berlin', 'Gehrke', 'Andr�', null, '1497', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_HEINRICH', 'QUANTEFM', '103', 'FAKTURIERUNG_MASCH', '0', 'Fr. Heinrich', '-', '- 193', null,
        'marita.heinrich@qfm.eu', 'i. A.', 'Berlin', 'Heinrich', 'Marita', null, '1567', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('T_MICHAELIS', 'DLIESUA1901G', '81', 'BAULEITER MIT MASCHINEN', '0', 'Fr. Michaelis', '- 164', '- 123', 'TM',
        'tanja.michaelis@qfm.eu', 'ppa.', 'Berlin', 'Michaelis', 'Tanja', null, '2015', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('C_KUJATH', 'CK.41HV!', '0', 'BAULEITER', '1', 'Hr. Kujath', '- 178', '- 173', 'CS', 'christian.kujath@qfm.eu',
        'i. A.', 'Berlin', 'Kujath', 'Christian', null, '1617', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('U_HOLTMANN', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Holtmann', '0202 27540 13', '0202 27540 88', 'GU',
        'uwe.holtmann@qfm.eu', 'i. V.', 'Wuppertal', 'Holtmann', 'Uwe', '12201', '1749', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_BUBLITZ', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Fr. Bublitz', '- 114', '- 133', null,
        'anett.bublitz@qfm.eu', 'i. A.', null, 'Bublitz', 'Annett', null, '1493', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('J_NICKEL', 'QUANTE', '101', 'FAKTURIERUNG', '0', 'Fr. Nickel', '- 132', '- 123', null, 'jasmin.nickel@qfm.eu',
        'i. A.', 'Berlin', 'Nickel', 'Jasmin', null, '2000', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('J_KUTTER', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Fr. Kutter', '- 0', '- 123', null,
        'jeannette.kutter@quantefm.de', 'i. A.', 'Berlin', 'Kutter', 'Jeannette', null, '1388', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('V_RYL', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Fr. Ryl', '-203', '-123', null, 'vanessa.ryl@qfm.eu', 'i. A.',
        'Berlin', 'Ryl', 'Vanessa', null, '1935', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('J_OLLIGESGEERS', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Olligesgeers', '- 0', '- 123', null,
        'jannik.olligesgeers@quantefm.de', 'i. A.', 'Berlin', 'Olligesgeers', 'Jannik', null, '1477', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('F_NAULAND', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Fr. Nauland', '74005 - 132', '74005 - 123', null,
        'franziska.nauland@quantefm.de', 'i. A.', 'Berlin', 'Nauland', 'Franziska', null, '1422', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('L_ENGELBRECHT', 'GESICHERT', '79', 'DEAKTIVIERT', '1', 'Hr. Engelbrecht', '- 126', '- 193', 'EL',
        'lutz.engelbrecht@qfm.eu', 'i. V.', null, 'Engelbrecht', 'Lutz', '12165', '1576', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('D_MIELICH', 'B!FFLUN45053', '79', 'BAULEITER', '0', 'Hr. Mielich', '- 134', '- 133', 'DM',
        'daniel.mielich@qfm.eu', 'i. V.', 'Berlin', 'Mielich', 'Daniel', null, '1953', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_M�LLER', 'QUANTEFM', '7', 'MONTEUR', '1', 'Hr. M�ller', null, null, 'OE', null, 'i. A.', null, 'M�ller',
        'Michael', '310', '1660', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('T_LIEBIG', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Liebig', '- 131', '- 123', null,
        'thorsten.liebig@qfm.eu', 'i. V.', 'Berlin', 'Liebig', 'Thorsten', null, '1745', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_WESEL', 'KOTVMN7Z', '79', 'BAULEITER', '0', 'Hr. Wesel', '- 200', '- 173', 'WM', 'matthias.wesel@qfm.eu',
        'i. V.', 'Berlin', 'Wesel', 'Matthias', null, '2057', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('O_EULITZ', 'GESICHERT', '79', 'DEAKTIVIERT', '1', 'Hr. Eulitz', '- 137', '- 173', 'OE', 'olaf.eulitz@qfm.eu',
        'i. A.', 'Berlin', 'Eulitz', 'Olaf', null, '1549', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('N_DOMOGALSKI', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Domogalski', null, null, 'OE', null, 'i. A.', null,
        'Domogalski', 'Norman', '400', '1709', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('N_REICHERT', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Reichert', '- 152', '- 123', 'LB',
        'nico.reichert@quantefm.de', 'i. A.', 'Berlin', 'Reichert', 'Nico', null, '1300', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('R_WOSTRACK', 'QUANTEFM', '6', 'MONTEUR', '1', 'Hr. Wostrack', null, null, 'LB', null, 'i. A.', null,
        'Wostrack', 'Robert', '405', '1302', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('H_DAUER', 'QUANTEFM', '6', 'MONTEUR', '1', 'Hr. Dauer', null, null, 'MK', null, 'i. A.', null, 'Dauer',
        'Henry', '65', '1304', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('F_KANZLER', 'F9618', '7', 'MONTEUR', '0', 'Hr. Kanzler', null, null, 'MW', null, 'i. A.', null, 'Kanzler',
        'Frank', '1725', '1696', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_WILKE', 'GARTENZWERG', '7', 'MONTEUR', '1', 'Hr. Wilke', null, null, 'RJ', null, 'i. A.', null, 'Wilke',
        'Andreas', '1666', '1912', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('D_STOLTMANN', 'DAVE181181_QUANTE', '6', 'MONTEUR', '0', 'Hr. Stoltmann', null, null, 'H�', null, 'i. A.', null,
        'Stoltmann', 'David', '1668', '1337', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_VIOLA', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Viola', '0202 27540 12', '0202 27540 88', null,
        'manfred.viola@quantefm.de', 'i. V.', 'Wuppertal', 'Viola', 'Manfred', null, '1343', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('J_ALBRECHT', 'QUANTE', '6', 'MONTEUR', '1', 'Hr. Albrecht', null, null, 'LB', null, 'i. A.', null, 'Albrecht',
        'J�rg', '289', '1185', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('D_MARTENS', 'DETTI', '6', 'MONTEUR', '0', 'Hr. Martens', null, null, 'MK', null, 'i. A.', null, 'Martens',
        'Detlef', '1702', '1291', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_BLOSZYK', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Bloszyk', '- 178', '- 123', null,
        'alexander.bloszyk@qfm.eu', 'i. A.', 'Berlin', 'Bloszyk', 'Alexander', null, '1492', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('S_PIETZUCH', 'ALIAERNST', '6', 'MONTEUR', '1', 'Hr. Pietzuch', null, null, 'LB', null, 'i. A.', null,
        'Pietzuch', 'Steffen', '416', '1216', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_RENKER', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Fr. Renker', '- 114', '- 133', null,
        'annemarie.renker@qfm.eu', 'i. A.', null, 'Renker', 'Annemarie', null, '1502', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_GRAFFENBERG', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Graffenberg', null, null, 'MK', null, 'i. A.', null,
        'Graffenberg', 'Matthias', '1719', '1425', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('I_PURDY', 'GESICHERT', '103', 'DEAKTIVIERT', '1', 'Fr. Purdy', '- 115', '- 123', null, 'ina.purdy@qfm.eu',
        'i. A.', 'Berlin', 'Purdy', 'Ina', null, '1527', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('R_STAHL', 'QUANTEFM', '7', 'MONTEUR', '0', 'Hr. Stahl', null, null, 'CP', null, 'i. A.', null, 'Stahl', 'Ralf',
        '1729', '1371', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('R_BUNTSCHUH', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Buntschuh', null, null, 'MG',
        'ronny.buntschuh@qfm.eu', 'i. A.', null, 'Buntschuh', 'Ronny', '376', '1850', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_B�RBOCK', 'BRATZI11', '81', 'BAULEITER MIT MASCHINEN', '0', 'Hr. B�rbock', '040 309817 35', '040 3098 17 38',
        'MB', 'michael.baerbock@qfm.eu', 'i. V.', 'Norderstedt', 'B�rbock', 'Michael', null, '1597', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_KUNZ', 'GESICHER', '0', 'DEAKTIVIERT', '1', 'Hr. Kunz', null, null, 'MV', null, 'i. A.', null, 'Kunz',
        'Andre', '1145', '1431', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('N_ENGELKE', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Fr. Engelke', null, null, null,
        'nadine.engelke@quantefm.de', 'i. A.', 'Berlin', 'Engelke', 'Nadine', null, '1273', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_WEDEMEYER', 'DDONLINE9', '79', 'BAULEITER', '0', 'Hr. Wedemeyer', '- 140', '- 173', 'MW',
        'martin.wedemeyer@qfm.eu', 'i. V.', 'Berlin', 'Wedemeyer', 'Martin', null, '1805', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('S_KIERSCHKE', 'QUANTE', '9', 'MASCH_VERWALTUNG_PRUEFDAT', '0', 'Hr. Kierschke', '- 155', '- 123', null,
        'stephan.kierschke@qfm.eu', 'i. A.', 'Berlin', 'Kierschke', 'Stephan', null, '1555', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('T_K�LLGEN', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. K�llgen', null, null, 'MV', null, 'i. A.', null,
        'K�llgen', 'Tobias', '1156', '1429', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('T_SCHWAB', 'SAFIRE84', '79', 'BAULEITER', '0', 'Hr. Schwab', null, null, 'TR', null, 'i. A.', null, 'Schwab',
        'Thomas', null, '2130', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('I_EICHLER', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Fr. Eichler', '74005 - 132', '74005 - 123', null,
        'ines.eichler@quantefm.de', 'i. A.', 'Berlin', 'Eichler', 'Ines', null, '1424', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('C_F�CHSEL', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. F�chsel', '- 281', '- 123', 'GA',
        'christian.fuechsel@quantefm.de', 'i. A.', 'Berlin', 'F�chsel', 'Christian', null, '1409', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('T_SCHULZE', 'QUANTEFM', '7', 'MONTEUR', '1', 'Hr. Schulze', null, null, 'TR', null, 'i. A.', null, 'Schulze',
        'Tom', '1714', '1794', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('B_MATTHIAS', 'ISABEL!2910', '6', 'MONTEUR', '0', 'Hr. Matthias', null, null, 'MK', null, 'i. A.', null,
        'Matthias', 'Burkhard', '1706', '1224', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('S_MURRER', 'S.379MJ.', '7', 'MONTEUR', '1', 'Hr. Murrer', null, null, 'MV', 'soeren.murrer@qfm.eu', 'i. A.',
        'Wuppertal', 'Murrer', 'S�ren', '1185', '1711', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('K_DWORSCHAK', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Dworschak', '- 148', '- 123', null,
        'karl.dworschwak@qfm.eu', 'i. V.', 'Berlin', 'Dworschak', 'Karl', null, '1934', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('D_DURAIN', 'LEIF1606�', '7', 'MONTEUR', '0', 'Hr. Durain', null, null, 'CP', null, 'i. A.', null, 'Durain',
        'David', '1675', '1727', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_LINDE', 'SCHWEDT', '0', 'DEAKTIVIERT', '1', 'Fr. Linde', '- 122', '- 123', null, 'andrea.linde@qfm.eu',
        'i. V.', 'Berlin', 'Linde', 'Andrea', null, '1500', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_KULESZA', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Fr. Kulesza', '- 111', '- 133', null,
        'angela.kulesza@qfm.eu', 'i. A.', 'Berlin', 'Kulesza', 'Angela', null, '1499', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_UTER', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Uter', '- 172', '- 123', 'UT', 'andreas.uter@quantefm.de',
        'i. V.', 'Berlin', 'Uter', 'Andreas', null, '1262', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('C_PEJGA', 'QUANTE', '79', 'BAULEITER', '0', 'Hr. Pejga', '- 171', '- 123', 'CP', 'christian.pejga@qfm.eu',
        'i. A.', 'Berlin', 'Pejga', 'Christian', '1077', '1509', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('I_LUKOWSKI', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Lukowski', '- 144', '- 173', 'IL',
        'ingo.lukowski@quantefm.de', 'i. V.', 'Berlin', 'Lukowski', 'Ingo', null, '1276', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('D_LINKE', 'QUANTE', '100', 'FAKTURIERUNG_SIG', '1', 'Hr. Linke', '- 149', '- 123', null,
        'dietmar.linke@qfm.eu', 'ppa.', 'Berlin', 'Linke', 'Dietmar', null, '1514', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('G_GUDEHUS', 'TIMMI', '143', 'SYSA', '1', 'Gudehus', '- 135', '- 123', 'GU', 'gerfried.gudehus@qfm.eu', null,
        'Berlin', 'Gudehus', 'Gerfried', null, '1523', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('H_POBEL', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Fr. Pobel', '74005-132', '74005-123', null,
        'heike.pobel@qfm.eu', 'i. A.', 'Berlin', 'Pobel', 'Heike', null, '1828', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('D_PORKERT', 'QUANTE', '9', 'MASCH_VERWALTUNG_PRUEFDAT', '0', 'Hr. Porkert', '- 155', '- 123', null,
        'dietmar.porkert@qfm.eu', 'i. V.', 'Berlin', 'Porkert', 'Dietmar', null, '1516', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('H_WIEDECKE', 'QUANTE', '5', 'MONTEUR', '1', 'Hr. Wiedecke', null, null, 'LB', null, 'i. A.', null, 'Wiedecke',
        'Horst', '312', '1009', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('P_GROESCHKE', 'QUANTE', '101', 'FAKTURIERUNG', '0', 'Fr. Gr�schke', '- 111', '- 173', null,
        'petra.groeschke@qfm.eu', 'i. A.', 'Berlin', 'Gr�schke', 'Petra', null, '1550', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('K_TANEV', 'QUANTE', '81', 'BAULEITER MIT MASCHINEN', '0', 'Fr. Tanev', '- 124', '- 123', null,
        'katrin.tanev@qfm.eu', 'i. V.', 'Berlin', 'Tanev', 'Katrin', null, '1535', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('I_BOEHM', 'GESICHERT', '79', 'DEAKTIVIERT', '1', 'Hr. B�hm', '- 167', '- 123', 'B�', 'ingo.boehm@qfm.eu',
        'i. V.', 'Berlin', 'B�hm', 'Ingo', null, '1526', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('J_LENIUS', 'MAUER1', '81', 'BAULEITER MIT MASCHINEN', '1', 'Hr. Lenius', '- 176', '- 123', 'LE',
        'joerg.lenius@qfm.eu', null, 'Berlin', 'Lenius', 'J�rg', null, '1720', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('O_WOBICK', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Wobick', '- 154', '- 123', null,
        'oliver.wobick@quantefm.de', 'i. V.', 'Berlin', 'Wobick', 'Oliver', null, '1393', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('U_PIOTROWSKY', 'SCHNUTE', '108', 'FAKTURIERUNG MIT ELK', '0', 'Hr. Piotrowsky', '- 127', '- 123', null,
        'uwe.piotrowsky@qfm.eu', 'i. V.', 'Berlin', 'Piotrowsky', 'Uwe', null, '1564', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('P_SCHNEEWEISS', 'SCHNURZEL', '143', 'SYSA', '0', 'Hr. Schneeweiss', '- 185', '- 8 185', 'PS',
        'peer.schneeweiss@qfm.eu', 'ppa.', 'Berlin', 'Schneeweiss', 'Peer', '12020', '1552', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('B_BRENNENSTUHL', 'SCOTTIE', '79', 'BAULEITER', '1', 'Hr. Brennenstuhl', '- 134', '- 173', 'BR',
        'bernd.brennenstuhl@qfm.eu', 'i. V.', 'Berlin', 'Brennenstuhl', 'Bernd', null, '1505', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('F_LIEBREICH', 'HLX7PAO1G', '79', 'BAULEITER', '0', 'Hr. Liebreich', '- 166', '- 173', 'LB',
        'frank.liebreich@qfm.eu', 'i. V.', 'Berlin', 'Liebreich', 'Frank', null, '1521', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('W_GRABOWSKI', 'GABRIELE', '79', 'BAULEITER', '1', 'Hr. Grabowski', '- 147', '- 173', 'GR',
        'wolfgang.grabowski@qfm.eu', 'i. V.', 'Berlin', 'Grabowski', 'Wolfgang', null, '1566', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('S_RADDATZ', '150563', '66', 'ALLGEMEINE VERWALTUNG', '1', 'Fr. Raddatz', '- 177', '- 123', null,
        'sabine.raddatz@qfm.eu', 'i. A.', 'Berlin', 'Raddatz', 'Sabine', null, '1557', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('K_FROEHNER', 'QUANTE', '7', 'MONTEUR', '0', 'Hr. Fr�hner', null, null, 'WM', null, 'i. A.', null, 'Froehner',
        'Karsten', '1080', '1797', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('D_BINDER', 'QUANTE', '108', 'FAKTURIERUNG MIT ELK', '0', 'Fr. Binder', null, null, null,
        'denise.binder@qfm.eu', 'i. V.', 'Berlin', 'Binder', 'Denise', null, '1511', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('E_BULEVICIUS', 'QUANTE', '67', 'ALLGEMEINE VERWALTUNG MO', '0', 'Fr. Bulevicius', '07031 73254 22',
        '07031 73254 11', null, 'elfriede.bulevicius@qfm.eu', 'i. A.', 'Sindelfingen', 'Bulevicius', 'Elfriede', null,
        '1640', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('F_LUX', 'PSION', '81', 'BAULEITER MIT MASCHINEN', '0', 'Hr. Lux', '07031 73254 21', '07031 73254 11', 'LU',
        'franz.lux@qfm.eu', 'i. V.', 'Sindelfingen', 'Lux', 'Franz', null, '1522', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('B_BRAND', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Fr. Brand', '040 309817 39', '040 309817 38', null,
        'bettina.brand@quantefm.de', 'i. A.', 'Norderstedt', 'Brand', 'Bettina', null, '1267', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('K_JABLONOWSKI', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Jablonowski', '0202 27540 13', '0202 27540 88',
        'JB', 'klaus.jablonowski@quantefm.de', 'i. V.', 'Wuppertal', 'Jablonowski', 'Klaus', null, '1275', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_HERWEGEN', 'MAURICE', '81', 'BAULEITER MIT MASCHINEN', '0', 'Hr. Herwegen', '07031 73254 26',
        '07031 73254 11', 'HE', 'maurice.herwegen@qfm.eu', 'i. V.', 'Sindelfingen', 'Herwegen', 'Maurice', null, '1541',
        null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('S_THUENCHEN', 'BNSUNLN', '68', 'ALLGEMEINE VERWALTUNG MA', '0', 'Fr. Th�nchen', '0202 27540 0',
        '0202 27540 88', null, 'silvia.thuenchen@qfm.eu', 'i. A.', 'Wuppertal', 'Th�nchen', 'Silvia', null, '1558',
        null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('B_OLMA', 'SCHEIBEN', '8', 'MASCH_VERWALTUNG', '0', 'Hr. Olma', '0202 292 26 88', '0202 705 22 62', 'SC', null,
        'i. A.', 'Wuppertal', 'Olma', 'Bernhard', null, '1232', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('J_MACKIOL', 'Q29NTO1', '7', 'MONTEUR', '1', 'Hr. Mackiol', null, null, 'MW', null, 'i. A.', null, 'Mackiol',
        'J�rgen', '1642', '1813', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('G_HAETTASCH', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. H�ttasch', '- 162', '- 123', 'H�',
        'gunter.haettasch@quantefm.de', 'i. V.', 'Berlin', 'H�ttasch', 'Gunter', null, '1278', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('H_HARTKOPF', 'GUSTAV', '0', 'DEAKTIVIERT', '1', 'Fr. Hartkopf', '0202 27540 16', '0202 70522 62', null,
        'helga.hartkopf@quantefm.de', 'i. V.', 'Wuppertal', 'Hartkopf', 'Helga', null, '1277', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_ARNDT', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Arndt', '- 140', '- 123', 'AR', 'andreas.arndt@qfm.eu',
        'i. V.', 'Berlin', 'Arndt', 'Andreas', null, '1491', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('N_TAVLI', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Fr. Tavli', '- 111', '- 173', null, 'nuray.tavli@quantefm.de',
        'i. A.', 'Berlin', 'Tavli', 'Nuray', null, '1271', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('C_WULFF', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Wulff', '- 145', '- 123', 'WU',
        'christian.wulff@quantefm.de', 'i. A.', 'Berlin', 'Wulff', 'Christian', null, '1434', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_TIETZ', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Fr. Tietz', '- 150', '- 123', null,
        'annett.tietz@quantefm.de', 'i. A.', 'Berlin', 'Tietz', 'Annett', null, '1261', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('J_VONTR�MBACH', 'BERGEN', '79', 'BAULEITER', '0', 'Hr. von Tr�mbach', '- 170', '- 173', 'TR',
        'jens.vontruembach@qfm.eu', 'i. V.', 'Berlin', 'von Tr�mbach', 'Jens', null, '1532', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('J_VITENSE', 'GESICHERT', '108', 'DEAKTIVIERT', '0', 'Fr. Vitense', '- 178', '- 123', null,
        'jana.vitense@qfm.eu', 'i. V.', 'Berlin', 'Vitense', 'Jana', null, '1573', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('D_PIETRONIETZ', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Pietronietz', '0202 27540 12', '0202 27540 88',
        'SC', 'darius.pietronietz@quantefm.de', 'i. V.', 'Wuppertal', 'Pietronietz', 'Darius', null, '1269', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('N_PEGGAU', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Fr. Peggau', '- 111', '- 123', null,
        'nora-kim.peggau@quantefm.de', 'i. A.', 'Berlin', 'Peggau', 'Nora-Kim', null, '1272', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('W_KRONE', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Krone', '040 309817 35', '040 3098 17 38', 'ME',
        'waldemar.krone@quantefm.de', 'i. V.', 'Norderstedt', 'Krone', 'Waldemar', null, '1270', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_H�RDLER', 'MICHELLE', '79', 'BAULEITER', '0', 'Hr. H�rdler', '- 182', '- 173', 'H�',
        'michael.huerdler@qfm.eu', 'i. V.', 'Berlin', 'H�rdler', 'Michael', null, '1542', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_GEBHARDT', 'ANDREAS64', '7', 'MONTEUR', '0', 'Hr. Gebhardt', null, null, 'H�', null, 'i. A.', null,
        'Gebhardt', 'Andreas', '1002', '1766', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('R_TONDORYS', 'RORIRU', '79', 'BAULEITER', '0', 'Hr. Tondorys', '- 158', '- 133', 'RT', 'ralf.tondorys@qfm.eu',
        'i. V.', null, 'Tondorys', 'Ralf', null, '2129', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_BUCHELT', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Buchelt', '- 111', '- 133', null,
        'martin.buchelt@quantefm.de', 'i. A.', 'Berlin', 'Buchelt', 'Martin', null, '1274', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('L_DEMBNY', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Dembny', '- 146', '- 123', 'DE',
        'lutz.dembny@quantefm.de', 'i. V.', 'Berlin', 'Dembny', 'Lutz', null, '1436', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_GAMRADT', 'R�SSELTIER', '143', 'SYSA', '0', 'Hr. Gamradt', '- 181', '- 123', null, 'mario.gamradt@qfm.eu',
        'i. V.', 'Berlin', 'Gamradt', 'Mario', null, '1539', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('T_LEIDINGER', 'MIKELE', '7', 'MONTEUR', '0', 'Hr. Leidinger', null, null, 'WM', null, 'i. A.', null,
        'Leidinger', 'Thomas', '1008', '1889', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('L_SCHUBERT', 'QUANTE', '6', 'MONTEUR', '1', 'Hr. Schubert', null, null, 'EL', null, 'i. A.', null, 'Schubert',
        'Lutz', '1009', '1294', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_K�HLER', 'DARKANGEL', '79', 'BAULEITER', '0', 'Hr. K�hler', '- 126', '- 193', 'MK', 'mike.kaehler@qfm.eu',
        'i. V.', null, 'K�hler', 'Mike', '1092', '1577', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('T_KRAUSE', 'TANG1LANG', '5', 'MONTEUR', '0', 'Hr. Krause', null, null, 'B�', null, 'i. A.', null, 'Krause',
        'Thomas', '1083', '1051', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('W_SCHWARZ', 'GESICHERT', '7', 'DEAKTIVIERT', '1', 'Hr. Schwarz', null, null, 'WM', null, 'i. A.', null,
        'Schwarz', 'Wolfgang', '1078', '1795', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('S_GECK', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Geck', null, null, 'WM', null, 'i. A.', null, 'Geck',
        'Sebastian', '1049', '1798', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('R_VOGT', '4505', '79', 'BAULEITER', '0', 'Hr. Vogt', null, null, 'WM', null, 'i. A.', null, 'Vogt', 'Rinaldo',
        '1126', '1969', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('H_KRETHLOW', 'QFM123', '7', 'MONTEUR', '0', 'Hr. Krethlow', null, null, 'BR', null, 'i. A.', null, 'Krethlow',
        'Holger', '1006', '2166', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('H_FRENZEL', 'QUANTE', '0', 'DEAKTIVIERT', '1', 'Hr. Frenzel', null, null, 'EL', null, 'i. A.', null, 'Frenzel',
        'Holger', '1073', '2182', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('G_DITTMAR', 'DOMINO', '7', 'MONTEUR', '0', 'Hr. Dittmar', null, null, 'H�', null, 'i. A.', null, 'Dittmar',
        'Gregor', '1067', '1483', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_F�RCHAU', 'QUANTE', '5', 'MONTEUR', '1', 'Hr. F�rchau', null, null, 'H�', null, 'i. A.', null, 'F�rchau',
        'Markus', '1088', '1058', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('D_SEILER', 'KYOCERA1', '7', 'MONTEUR', '0', 'Hr. Seiler', null, null, 'H�', null, 'i. A.', null, 'Seiler',
        'Daniel', '1139', '1832', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('C_WAGNER', 'QUANTEFM', '7', 'MONTEUR', '1', 'Hr. Wagner', null, null, 'MK', null, 'i. A.', null, 'Wagner',
        'Christoph', '1736', '1417', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('J_NEUBERT', 'QWERT', '7', 'MONTEUR', '1', 'Hr. Neubert', null, null, 'MK', null, 'i. A.', null, 'Neubert',
        'Jan', '1735', '1419', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('B_Y�ZG�LEC', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Y�zg�lec', '- 216', '- 123', null,
        'berkay.yuezguelec@qfm.eu', 'i. A.', 'Berlin', 'Y�zg�lec', 'Berkay', null, '1834', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_MISCHKEWITZ', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Mischkewitz', '- 238', '- 173', null,
        'Alexander.Mischkewitz@qfm.eu', 'i. A.', 'Berlin', 'Mischkewitz', 'Alexander', null, '1666', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_PFITZNER', 'QUANTEFM', '79', 'BAULEITER', '1', 'Hr. Pfitzner', '- 175', '- 173', 'CS',
        'andreas.pfitzner@qfm.eu', 'i. A.', 'Berlin', 'Pfitzner', 'Andreas', null, '1643', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('T_RENTSCH', 'TONI8267', '7', 'MONTEUR', '1', 'Hr. Rentsch', null, null, 'MW', null, 'i. A.', null, 'Rentsch',
        'Toni', '1742', '1715', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('R_HANKE', 'QUANTEFM', '0', 'DEAKTIVIERT', '0', 'Hr. Hanke', null, null, 'MW', null, 'i. A.', null, 'Hanke',
        'Ryk', '1721', '2181', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_KR�MER', 'QUANTEFM', '7', 'MONTEUR', '1', 'Hr. Kr�mer', null, null, 'CS', null, 'i. A.', null, 'Kr�mer',
        'Manuel', '344', '1625', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('R_TIEGS', '75B3758', '7', 'MONTEUR', '0', 'Hr. Tiegs', null, null, 'MW', null, 'i. A.', null, 'Tiegs', 'Ronny',
        '1747', '1737', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_BACHMANN', 'BLADE', '79', 'BAULEITER', '0', 'Hr. Bachmann', '- 137', '- 123', 'H�', 'marco.bachmann@qfm.eu',
        'i. A.', 'Berlin', 'Bachmann', 'Marco', '12225', '1862', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('J_BAUER', 'LUMA', '0', 'FAKTURIERUNG_MASCH', '1', 'Fr. Bauer', '- 115', '- 123', null, 'juliane.bauer@qfm.eu',
        'i. A.', 'Berlin', 'Bauer', 'Juliane', null, '1678', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('C_BOEDER', 'QUANTEFM', '101', 'FAKTURIERUNG', '0', 'Fr. Boeder', '030 74005 240', '030 74005 123', null,
        'cerstin.boeder@qfm.eu', 'i. A.', 'Berlin', 'Boeder', 'Cerstin', null, '1758', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('N_WEGENER', 'QUANTEFM', '79', 'BAULEITER', '1', 'Hr. Wegener', null, '- 123', 'KM', null, 'i. A.', 'Berlin',
        'Wegener', 'Norman', '30', '1761', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('D_LOVRINCEVIC', 'CIW3ZHOU8', '79', 'BAULEITER', '0', 'Hr. Lovrincevic', '- 238', '- 173', 'DI',
        'dino.lovrincevic@qfm.eu', 'i. A.', 'Berlin', 'Lovrincevic', 'Dino', null, '2063', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('B_RIESEBECK', '1340311A', '79', 'BAULEITER', '0', 'Hr. Riesebeck', '- 130', '- 123', null,
        'bjoern.riesebeck@qfm.eu', 'i. A.', 'Berlin', 'Riesebeck', 'Bj�rn', null, '1821', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('R_LIERS', 'GESICHERT', '0', 'DEAKTIVIERT', '0', 'Hr. Liers', '- 238', '- 173', 'KM', 'rouven.liers@qfm.eu',
        'i. A.', 'Berlin', 'Liers', 'Rouven', null, '1994', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('B_HERRLING', 'QUANTEFM', '81', 'BAULEITER MIT MASCHINEN', '1', 'Hr. Herrling', '- 234', '- 173', null,
        'benjamin.herrling@qfm.eu', 'i. A.', 'Berlin', 'Herrling', 'Benjamin', null, '1903', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('T_R�TZ', 'QUANTEFM', '7', 'MONTEUR', '1', 'Hr. R�tz', '0', '173', 'WM', 'thomas.ruetz@qfm.eu', 'i. A.',
        'Berlin', 'R�tz', 'Thomas', null, '1901', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('N_MARISTANY', 'GESICHERT', '0', 'DEAKTIVIERT', '0', 'Hr. Maristany', '- 236', '- 173', null,
        'nils.maristany@qfm.eu', 'i. A.', 'Berlin', 'Maristany', 'Nils', null, '2046', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('S_ROCH', 'GESICHERT', '0', 'DEAKTIVIERT', null, 'Herr', '- 156', '- 173', null, 'stefan.roch@qfm.eu', 'i. A.',
        'Berlin', 'Roch', 'Stefan', null, '2023', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_HABO', 'QUANTEFM', '7', 'MONTEUR', null, 'Herr', '-0', '-123', 'MA', 'arnhold.habo@qfm.eu', 'i. A.', null,
        'Habo', 'Arnhold', null, '1941', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('H_ARNHOLD', 'GESICHERT', '0', 'DEAKTIVIERT', null, 'Herr', null, null, 'MA', 'habo.arnhold@qfm.eu', 'i. A.',
        null, 'Arnhold', 'Habo', '305', '2091', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('P_KARASACLI', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. Karasacli', '- 0', '- 123', null,
        'phillip.karasacli@qfm.eu', 'i. A.', 'Berlin', 'Karasacli', 'Phillip', null, '1864', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('W_STARKE', 'DENISE88', '7', 'MONTEUR', '0', 'Hr. Starke', null, null, 'MW', null, 'i. A.', null, 'Starke',
        'Werner', '1743', '1608', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_FUERCHAU', 'MAYA2005', '7', 'MONTEUR', '0', 'Hr. F�rchau', null, null, 'H�', null, 'i. A.', null, 'F�rchau',
        'Markus', '1088', '1840', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('T_GRAF', 'QUANTEFM', '8', 'MASCH_VERWALTUNG', '0', 'Hr. Graf', '- 256', '- 173', null, 'thomas.graf@qfm.eu',
        'i. A.', 'Berlin', 'Graf', 'Thomas', null, '1928', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_NAGEL', 'GESUCHERT', '0', 'DEAKTIVIERT', null, 'Fr. Nagel', '- 123', '- 123', null, 'anita.nagel@qfm.eu',
        'Frau', 'Berlin', 'Nagel', 'Anita', null, '1931', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_BLANK', 'QUANTEFM', '81', 'BAULEITER MIT MASCHINEN', null, 'Herr', '-234', '-173', null,
        'andreas.blank@qfm.eu', 'i. A.', null, 'Blank', 'Andreas', null, '1925', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_FISCHER', 'AF', '100', 'FAKTURIERUNG_SIG', null, 'Hr. Fischer', '- 148', '- 123', null,
        'andre.fischer@qfm.eu', 'Herr', 'Berlin', 'Fischer', 'Andr�', null, '1964', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('T_SALZMANN', 'QUANTEFM', '66', 'ALLGEMEINE VERWALTUNG', null, 'Frau', '-195', '-173', null,
        'tanja.salzmann@qfm.eu', 'i. A.', 'Berlin', 'Salzmann', 'Tanja Diana', null, '1973', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('T_PIETSCH', 'GESICHERT', '0', 'DEAKTIVIERT', null, 'Hr. Pietsch', null, null, null, 'thomas.pietsch@qfm.eu',
        'i. A.', 'Berlin', 'Pietsch', 'Thomas', null, '2025', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_SCHWARZ', 'GESICHERT', '0', 'DEAKTIVIERT', null, 'Hr. Schwarz', '-239', '-123', null,
        'matthias.schwarz@qfm.eu', 'i. A.', 'Berlin', 'Schwarz', 'Matthias', null, '2086', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('S_RITTER', 'GESICHERT', '0', 'DEAKTIVIERT', null, 'Hr. Ritter', null, null, null, 'siegfried.ritter@qfm.eu',
        'i. A.', null, 'Ritter', 'Siegfried', null, '2024', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('R_DINO', 'START', '101', 'FAKTURIERUNG', null, 'Hr. Dino', null, null, null, null, 'i. A.', null, 'Dino',
        'Raphael', null, '2007', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('I_GRAH', 'QUANTEFM', '66', 'ALLGEMEINE VERWALTUNG', null, 'Frau', null, null, null, 'ivonne.grah@qfm.eu',
        'i. A.', 'Wuppertal', 'Grah', 'Ivonne', null, '2008', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('T_HARM', 'PULLERMANNPOINT84', '7', 'MONTEUR NUR AUFMASS', null, 'Herr Harm', null, null, 'H�',
        'tobias.harm@qfm.eu', 'i. A.', null, 'Harm', 'Tobias', '52', '2190', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_SOMMER', 'LUISA96!', '87', 'AZUBI FAKTURIERUNG', null, 'Frau', '211', '173', null,
        'anne-luisa.sommer@qfm.eu', 'i. A.', 'Berlin', 'Sommer', 'Anne-Luisa', null, '2030', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_KIELING', 'BRE14', '87', 'AZUBI FAKTURIERUNG', null, 'Frau', '213', '173', null, 'michelle.kieling@qfm.eu',
        'i. A.', 'Berlin', 'Kieling', 'Michelle', null, '2044', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_JACOB', 'PHIL3103', '103', 'FAKTURIERUNG_MASCH', null, 'Fr. Jacob', '- 204', '- 123', null,
        'mario.jacob@qfm.eu', 'i. A.', 'Berlin', 'Jacob', 'Maria', null, '2021', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('Y_ESSALEH', 'ESSA071426', '66', 'ALLGEMEINE VERWALTUNG', null, 'Herr', '-0', '-173', null,
        'yassine.essaleh@qfm.eu', 'i. A.', 'Berlin', 'Essaleh', 'Yassine', null, '2040', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('T_URBAN', 'TORTI69', '0', 'DEAKTIVIERT', null, 'Herr', null, null, 'MA', 'thorsten.urban@qfm.eu', 'i. A.',
        'Wuppertal', 'Urban', 'Thorsten', '1193', '2183', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('V_HANKE', 'SOPHIE1#', '81', 'BAULEITER MIT MASCHINEN', null, 'Frau', '152', '123', null, 'verena.hanke@qfm.eu',
        'i. A.', 'Berlin', 'Hanke', 'Verena', null, '2065', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('S_SORA-M�LLER', 'OSMAN1939$', '108', 'FAKTURIERUNG MIT ELK', null, 'Frau', '- 191', '- 173', null,
        'seniha.sora-mueller@qfm.eu', 'i. A.', 'Berlin', 'Sora-M�ller', 'Seniha', null, '2080', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('Y_AL-TAIE', 'QUANTEFM', '81', 'BAULEITER MIT MASCHINEN', null, 'Herr Al-Taie', null, null, null,
        'yaser.al-taie@qfm.eu', 'i. A.', 'Berlin', 'Al-Taie', 'Yaser', null, '2174', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('L_K�HNE', '187STRASSENBANDE', '7', 'MONTEUR', null, 'Hr. K�hne', null, null, 'H�', null, 'i. A.', null,
        'K�hne', 'Leif-Erik', '1784', '2093', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_ANTICEVIC', '4F3D2S1A', '103', 'FAKTURIERUNG_MASCH', null, 'Fr. Anticevic', '212', '123', 'DI',
        'matea.anticevic@qfm.eu', 'i. A.', 'Berlin', 'Anticevic', 'Matea', null, '2148', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('C_BORMANN', 'QUANTEFM', '7', 'MONTEUR', null, 'Herr', null, null, 'MA', 'carsten.bormann@qfm.eu', 'i. A.',
        'Wuppertal', 'Bormann', 'Carsten', '1794', '2116', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('P_JANUS', 'CARMEN123', '7', 'MONTEUR', null, 'Herr Janus', null, null, 'MW', 'phillip.janus@qfm.eu', 'i. A.',
        null, 'Janus', 'Phillip', '1769', '2156', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('E_RUNGE', 'S!OMMER12', '7', 'MONTEUR', null, 'Hr. Runge', null, null, 'RT', 'enrico.runge@qfm.eu', 'i. A.',
        null, 'Runge', 'Enrico', '419', '2140', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('T_PLISCHKA', 'QUANTEFM', '7', 'MONTEUR', null, 'Hr. plischka', null, null, 'RT', 'torsten.plischka@qfm.eu',
        'i. A.', null, 'Plischka', 'Torsten', '381', '2141', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('F_FRITZ', 'QUANTEFM', '7', 'MONTEUR', null, 'Herr Fritz', '0', '123', 'DM', 'franz-philipp.fritz@qfm.eu',
        'i. A.', 'Berlin', 'Fritz', 'Franz-Philipp', '307', '2160', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('S_BREIER', 'QUANTEFM', '101', 'FAKTURIERUNG', null, 'Frau Breier', '147', '123', null,
        'stefanie.breier@qfm.eu', 'i. A.', 'Berlin', 'Breier', 'Stefanie', null, '2172', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_MUELLER', 'VERGESSEN_1', '66', 'ALLGEMEINE VERWALTUNG', null, 'Herr M�ller', null, null, null,
        'alexander.mueller@qfm.eu', 'i. A.', 'Wuppertal', 'M�ller', 'Alexander', null, '2177', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('L_LEHMANN', 'GESICHERT', '0', 'DEAKTIVIERT', '0', 'Hr. Lehmann', '74005-132', '74005-123', null,
        'lars.lehmann@qfm.eu', 'i. A.', 'Berlin', 'Lehmann', 'Lars', null, '1930', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('R_KOHL', 'JUMBO123', '0', 'BAULEITER', '1', 'Hr. Kohl', '- 322', '- 173', 'CS', 'rainhard.kohl@qfm.eu',
        'i. A.', 'Berlin', 'Kohl', 'Rainhard', null, '1663', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('TH_SCHULZE', '1234', '0', 'BAULEITER', '1', 'Hr. Schulze', '- 321', '- 173', 'CS', 'thomas.schulze@qfm.eu',
        'i. A.', 'Berlin', 'Schulze', 'Thomas', null, '1664', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_CAS', 'QUANTE&FM2', '79', 'BAULEITER', '0', 'Hr. Cas', '- 12', '- 88', null, 'alexander.cas@qfm.eu', 'i. A.',
        null, 'Cas', 'Alexander', null, '1855', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('I_VOIGT', 'ALEXSANDER23', '81', 'BAULEITER MIT MASCHINEN', '1', 'Hr. Voigt', '- 236', '- 173', null,
        'ingo.voigt@qfm.eu', 'i. A.', 'Berlin', 'Voigt', 'Ingo', null, '1825', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_SCHUBERT', 'QUANTEFM', '81', 'BAULEITER MIT MASCHINEN', '0', 'Hr. Schubert', '- 237', '- 173', null,
        'michael.schubert@qfm.eu', 'i. A.', 'Berlin', 'Schubert', 'Michael', null, '1826', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_KASPERSKI', 'QUANTEFM', '101', 'FAKTURIERUNG', '1', 'Fr. Kasperski', '-0', '-123', null,
        'anne.kasperski@qfm.eu', 'i. A.', 'Berlin', 'Kasperski', 'Anne', null, '1823', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_ERSTFELD', 'QUANTEFM', '7', 'MONTEUR', '1', 'Hr. Erstfeld', '0202 27540 0', '0202 705 22 88', null,
        'marc.erstfeld@qfm.eu', 'i. A.', 'Wuppertal', 'Erstfeld', 'Marc', null, '1839', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('W_RYL', 'QUANTEFMWIBI', '87', 'AZUBI FAKTURIERUNG', '1', 'Frau', '213', null, null, 'wiebke.ryl@qfm.eu',
        'i. A.', null, 'Ryl', 'Wiebke', null, '1881', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('S_WINTER', '!FEIYAN1991', '87', 'AZUBI FAKTURIERUNG', '0', 'Frau', '215', '123', null, 'sandra.winter@qfm.eu',
        'i. A.', null, 'Winter', 'Sandra', null, '1851', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_LEHMANN', 'GESICHERT', '0', 'DEAKTIVIERT', '0', 'Herr', '212', '123', null, 'andre.lehmann@qfm.eu', 'i. A.',
        null, 'Lehmann', 'Andr�', null, '2103', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('F_H�MER', 'QUANTEFM', '7', 'MONTEUR', '1', 'Herr', null, null, null, 'frank.haemer@qfm.eu', 'i. A.', null,
        'H�mer', 'Frank', null, '1844', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('E_EVREN', 'INCELER20%', '103', 'FAKTURIERUNG_MASCH', null, 'Frau', '-190', '-173', null, 'eylem.evren@qfm.eu',
        'i. A.', 'Berlin', 'Evren', 'Eylem', null, '1947', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('C_L�W', 'QUANTEFM', '79', 'BAULEITER', null, 'Herr', null, null, null, 'caius.loew@qfm.eu', 'i. A.', 'Berlin',
        'L�w', 'Caius', null, '1970', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('T_KRAATZ', 'ANTON17', '68', 'ALLGEMEINE VERWALTUNG MA', null, 'Herr', '- 0', '- 173', null,
        'thomas.kraatz@qfm.eu', 'i. A.', null, 'Kraatz', 'Thomas', null, '2049', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_MANGRAVITI', 'QUANTEFM', '7', 'MONTEUR', null, 'Herr', null, null, 'SM', null, 'i. A.', null, 'Mangraviti',
        'Marko', null, '2068', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_SCHARTNER', '141285S72520', '79', 'BAULEITER', null, 'Hr. Schartner', '-183', '-193', 'MW',
        'maik.schartner@qfm.eu', 'i. A.', 'Berlin', 'Schartner', 'Maik', null, '2121', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('L_KNYRIM', '18WK.LEON', '7', 'MONTEUR', null, 'Herr Knyrim', '-0', '-123', 'SR', 'leon.knyrim@qfm.eu', 'i. A.',
        'Berlin', 'Knyrim', 'Leon', '1777', '2168', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('N_AMIN', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Fr. Amin', '74005 - 132', '74005 - 123', null,
        'nassrim.amin@quantefm.de', 'i. A.', 'Berlin', 'Amin', 'Nassrin', null, '1486', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('D_SCHOLZ', '62726972', '103', 'FAKTURIERUNG_MASCH', '1', 'Hr. Scholz', null, '- 173', null,
        'dennis.scholz@qfm.eu', 'i. A.', null, 'Scholz', 'Dennis', null, '1781', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('D_KALENSEE', 'DKQFM2015', '143', 'SYSA', '0', 'Hr. Kalensee', '030 74005 281', null, 'GA',
        'denny.kalensee@qfm.eu', 'i. A.', 'Berlin', 'Kalensee', 'Denny', null, '1513', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_HANKE', 'RUNDMC1980', '0', 'ALLGEMEINE VERWALTUNG', '0', 'Hr. Hanke', '- 141', '- 123', null,
        'michael.hanke@qfm.eu', 'i. A.', null, 'Hanke', 'Michael', null, '1582', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('C_SCHNEEWEISS', '1807BYRBF91', '66', 'ALLGEMEINE VERWALTUNG', '1', null, null, null, null, null, 'i. A.', null,
        'Schneeweiss', 'Charly', null, '1847', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_BUSCH', 'ZAUN10', '108', 'FAKTURIERUNG MIT ELK', '0', 'Fr. Busch', '- 146', '- 173', null,
        'mandy.busch@qfm.eu', 'i. A.', null, 'Busch', 'Mandy', null, '1875', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('S_KUSCHKE', 'QUANTEFM', '66', 'ALLGEMEINE VERWALTUNG', '1', null, null, null, null, null, 'i. A.', null, null,
        null, null, '1650', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_K�NITZ', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Hr. K�nitz', '- 167', '- 193', 'K�', 'marcus.koenitz@qfm.eu',
        'i. A.', 'Berlin', 'K�nitz', 'Marcus', null, '1856', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('P_STAPEL', 'PAUL17', '79', 'BAULEITER', '0', 'Hr. Stapel', '- 236', '- 173', 'SP', 'paul.stapel@qfm.eu',
        'i. A.', 'Berlin', 'Stapel', 'Paul', null, '2072', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('E_RIESEBECK', 'RIESE112+', '79', 'BAULEITER', '0', 'Herr', '0', '123', 'MA', null, 'i. A.', 'Berlin',
        'Riesebeck', 'Eick', '359', '2017', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('K_M�LLER', 'GESICHERT', '0', 'DEAKTIVIERT', null, 'Hr. K. M�ller', '- 180', '- 173', null,
        'karsten.mueller@qfm.eu', 'i. A.', 'Berlin', 'M�ller', 'Karsten', null, '2146', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('S_FENGELS', 'QUANTEFM', '7', 'MONTEUR', null, 'Herr', '- 0', '- 88', null, 'sascha.fengels@qfm.eu', 'i. A.',
        'Wuppertal', 'Fengels', 'Sascha', null, '1917', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('G_DIECKMANN', 'CH3-COOH', '66', 'ALLGEMEINE VERWALTUNG', null, 'Frau', '- 163', '- 173', null,
        'gabriela.dieckmann@qfm.eu', 'i. A.', 'Berlin', 'Dieckmann', 'Gabriela', null, '1919', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('D_BAJA', 'QUANTEFM', '101', 'FAKTURIERUNG', null, 'Fr. Baja', '- 121', '- 173', null, 'diana.baja@qfm.eu',
        'i. A.', 'Berlin', 'Baja', 'Diana Lara', null, '1946', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('E_MAKARA', 'KUBULINO.24', '108', 'FAKTURIERUNG MIT ELK', null, 'Frau', null, null, null, 'ewa.makara@qfm.eu',
        'i. A.', 'Berlin', 'Makara', 'Ewa', null, '1938', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('V_JAWORSKI', 'VIKUSIK', '66', 'ALLGEMEINE VERWALTUNG', null, 'Frau', '- 162', '- 173', null,
        'viktoria.jaworski@qfm.eu', 'i. A.', 'Berlin', 'Jaworski', 'Viktoria', null, '2058', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_KOPARAN', 'RENNER.12', '68', 'ALLGEMEINE VERWALTUNG MA', null, 'Herr', null, null, null,
        'Ali-Erdem.Koparan@qfm.eu', 'i. A.', null, 'Koparan', 'Ali-Erdem', null, '2083', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_JAFARI', 'FIRST!JAFARI1234', '7', 'MONTEUR', null, 'Herr', null, null, null, 'abdul.jafari@qfm.eu', 'i. A.',
        'Wuppertal', 'Jafari', 'Abdul Azim', null, '2084', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_FROTSCHER', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Fr. Frotscher', '- 206', '- 123', null,
        'michelle.frotscher@qfm.eu', 'i. A.', 'Berlin', 'Frotscher', 'Michelle', null, '1836', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('S_PETTELKAU', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Fr. Pettelkau', '74005-122', '74005-123', null,
        'susanne.pettelkau@qfm.eu', 'i. A.', 'Berlin', 'Pettelkau', 'Susanne', null, '1616', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('S_PATZER', 'SP.71PD-', '7', 'MONTEUR', '0', 'Hr. Patzer', null, null, 'B�', null, 'i. A.', null, 'Patzer',
        'Sven-Torsten', '1095', '1604', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_JANNICKE', 'BUDSPENCER94', '101', 'FAKTURIERUNG', '0', 'Hr. Jannicke', '-', null, null,
        'marvin.jannicke@qfm.eu', 'i. A.', 'Berlin', 'Jannicke', 'Marvin', null, '1808', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('R_WERNER', 'QUANTE081577', '7', 'MONTEUR', '0', 'Hr. Werner', null, null, 'WM', null, 'i. A.', null, 'Werner',
        'Rudolf', '1754', '2169', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('J_BERNHARDT', 'QUANTEFM', '81', 'BAULEITER MIT MASCHINEN', '0', 'Fr. Bernhardt', '- 235', '- 173', null,
        'juliane.bernhardt@qfm.eu', 'i. A.', 'Berlin', 'Bernhardt', 'Juliane', null, '1854', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_DREWINSKE', 'QUANTEFM', '7', 'MONTEUR', '1', 'Herr', '0', '173', null, 'mirco.drewinske@qfm.eu', 'i. A.',
        null, 'Drewinske', 'Mirco', null, '1857', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_MEI�NER', 'QUANTEFM', '7', 'MONTEUR', '1', 'Herr', '0', '173', null, 'martin.meissner@qfm.eu', 'i. A.', null,
        'Mei�ner', 'Martin', null, '1858', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('MA_SCHMIDT', 'AUDIA316', '7', 'MONTEUR NUR AUFMASS', '0', 'Hr. Schmidt', '0', '123', 'MA',
        'manuel.schmidt@qfm.eu', 'i. A.', 'Berlin', 'Schmidt', 'Manuel', '394', '1896', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('R_BERKHOLZ', 'QUANTEFM', '7', 'MONTEUR', null, 'Herr', '- 0', '-', null, 'ronny.berkholz@qfm.eu', 'i. A.',
        null, 'Berkholz', 'Ronny', null, '1911', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('S_PODSCHUN', 'S101914', '7', 'MONTEUR', null, 'Herr', '- 0', '- 123', 'WM', 'sebastian.podschun@qfm.eu',
        'i. A.', 'Berlin', 'Podschun', 'Sebastian', '1753', '1914', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_ZAPKE', 'PAX200207', '103', 'FAKTURIERUNG_MASCH', null, 'Frau Zapke', '-202', '-173', null,
        'melanie.zapke@qfm.eu', 'i. A.', 'Berlin', 'Zapke', 'Melanie', null, '1990', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_REICHENEDER', 'BAYERN45!', '103', 'FAKTURIERUNG_MASCH', null, 'Herr', '175', '123', null,
        'marc.reicheneder@qfm.eu', 'i. A.', 'Berlin', 'Reicheneder', 'Marc', null, '2089', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_SCHNEEWEISS', 'QUANTEFM', '66', 'ALLGEMEINE VERWALTUNG', null, 'Frau', null, null, null, null, 'i. A.', null,
        'Schneeweiss', 'Annabell', null, '2136', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('R_FRITZ', 'ANTENNE#01#', '7', 'MONTEUR', null, 'Herr Fritz', null, null, 'H�', null, 'i. A.', null, 'Fritz',
        'Robert', '1786', '2138', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('C_BLOCH', 'QUANTEFM', '7', 'MONTEUR', null, 'Hr. Bloch', null, null, 'H�', 'christian.bloch@qfm.eu', 'i. A.',
        'Berlin', 'Bloch', 'Christian', '1140', '2144', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('D_JURGA', '(MAYDAY77)', '103', 'FAKTURIERUNG_MASCH', null, 'Frau Jurga', '148', null, null,
        'daniela.jurga@qfm.eu', 'i. A.', 'Berlin', 'Jurga', 'Daniela', null, '2154', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('F_MARSCHEL', 'LANGE_WEILE112', '144', 'SYSA', null, 'Herr Marschel', null, null, null,
        'fabian.marschel@qfm.eu', 'i. A.', null, 'Marschel', 'Fabian', null, '2173', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_IZGEC', 'SCHMITTY7', '7', 'MONTEUR', '0', 'Hr. Izgec', null, null, 'MB', null, 'i. A.', null, 'Izgec',
        'Mesut', '1704', '1595', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('V_KIESEL', 'QUANTEFM', '0', 'FAKTURIERUNG_MASCH', '0', 'Fr. Kiesel', '- 204', '- 123', null,
        'viola.kiesel@qfm.eu', 'i. A.', 'Berlin', 'Kiesel', 'Viola', null, '1849', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('S_JERMIES', 'QUANTEFM', '66', 'ALLGEMEINE VERWALTUNG', '0', null, '(040) 309817-40', null, null,
        'susanne.ermies@qfm.eu', 'Frau', null, 'Jermies', 'Susanne', null, '1695', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('G_DIX', 'REDFREDQFM89', '66', 'ALLGEMEINE VERWALTUNG', '1', 'Hr. Dix', '030 74005 0', '030 74005 123', null,
        'guido.dix@qfm.eu', 'i. A.', 'Berlin', 'Dix', 'Guido', null, '1741', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_OTT', 'QUANTEFM', '101', 'FAKTURIERUNG', '0', 'Fr. Ott', null, '-123', null, null, 'i. A.', 'Berlin', 'Ott',
        'Marie', null, '1920', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('F_LOSENSKE', 'QUANTEFM', '79', 'BAULEITER', null, 'Hr. Losenske', '- 0', '- 406', 'RT',
        'frank.losenske@qfm.eu', 'i. A.', null, 'Losenske', 'Frank', null, '2132', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_GR�NBOLDT', 'ITSCHI13691!', '8', 'MASCH_VERWALTUNG', null, 'Herr', '201', '123', null,
        'marvin.groenboldt@qfm.eu', 'i. A.', 'Berlin', 'Gr�nboldt', 'Marvin', null, '2101', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('E_TAT', 'QUANTEFM', '81', 'BAULEITER MIT MASCHINEN', null, 'Herr', null, null, null, 'ediz.tat@qfm.eu',
        'i. A.', 'Wuppertal', 'Tat', 'Ediz', null, '2003', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('P_FIFIELSKI', 'QUANTEFM', '7', 'MONTEUR', null, 'Hr. Fifielski', null, null, 'MB', 'pawel.fifielski@qfm.eu',
        'i. A.', 'Hamburg', 'Fifielski', 'Pawel', '1069', '2145', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_AL-TAIE', 'YASERANMAR1', '66', 'ALLGEMEINE VERWALTUNG', null, 'Herr Al-Taie', '0', '173', null,
        'anmar.al-taie@qfm.eu', 'i. A.', 'Berlin', 'Al-Taie', 'Anmar', null, '2149', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('F_GRELL', 'F_GRELL', '7', 'MONTEUR', '1', 'Hr. Grell', null, null, 'PS', null, 'i. A.', null, 'Grell', 'Falk',
        '1739', '1496', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('L_GUDEHUS', 'QUANTEFM', '63', 'AZUBI ALLGEMEINE VERWALTUNG', '1', 'LG', '215', '123', null,
        'lucas.gudehus@qfm.eu', 'Herr', null, 'Gudehus', 'Lucas', null, '1674', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_SCHMIDT', 'QUANTEFM', '7', 'MONTEUR', '1', 'Hr. Schmidt', null, null, 'KM', null, 'i. A.', null, 'Schmidt',
        'Manuel', '394', '1688', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_LYSKO', 'JAPANCAR2288', '101', 'FAKTURIERUNG', '1', 'Fr. Lysko', '74005-159', '74005-123', null,
        'aneta.lysko@qfm.eu', 'Frau', 'Berlin', 'Lysko', 'Aneta', null, '1694', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('S_GUTSCH', 'QUANTEFM', '108', 'FAKTURIERUNG MIT ELK', '1', 'Hr. Gutsch', '- 0', '- 123', null,
        'sebastian.gutsch@qfm.eu', 'i. V.', null, 'Gutsch', 'Sebastian', null, '1708', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_SKALLA', 'GESICHERT', '0', 'DEAKTIVIERT', '1', 'Fr. Skalla', '- 207', '- 123', null,
        'michelle.skalla@qfm.eu', 'i. A.', 'Berlin', 'Skalla', 'Michelle', null, '1967', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_G�TZ', 'EINSTEIN0710', '66', 'ALLGEMEINE VERWALTUNG', '0', 'Fr. G�tz', '030 74005 122', '030 74005 123',
        null, 'adriana.goetz@qfm.eu', 'i. A.', 'Berlin', 'G�tz', 'Adriana', null, '1918', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('R_H�SKE', 'QUANTEFM', '7', 'MONTEUR', '1', 'Hr. H�ske', null, null, 'MW', 'ralf.hoeske@qfm.eu', 'i. A.', null,
        'H�ske', 'Ralf', null, '1765', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('A_MEI�NER', 'BUBBEL', '0', 'MASCH_VERWALTUNG', '1', 'Hr. Mei�ner', '- 256', '- 123', null,
        'andreas.meissner@qfm.eu', 'i. V.', 'Berlin', 'Mei�ner', 'Andreas', null, '1817', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('S_FRUNZEK', 'CANUBIS643L', '7', 'MONTEUR', null, 'Herr', '0', '123', 'BR', 'sebastian.frunzek@qfm.eu', 'i. A.',
        null, 'Frunzek', 'Sebastian', '1766', '1923', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('R_BLOCH', 'QUANTEFM', '7', 'MONTEUR', null, 'Herr', '0', '123', 'BR', 'rene.bloch@qfm.eu', 'i. A.', 'Berlin',
        'Bloch', 'Ren�', '1136', '1926', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('K_SCHEPPEL', 'QUANTEFM', '0', 'DEAKTIVIERT', null, 'Hr. Scheppel', '-0', null, 'MW', 'kevin.scheppel@qfm.eu',
        'i. A.', 'Berlin', 'Scheppel', 'Kevin', '1772', '2184', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('D_GRUENEBERG', 'QUANTEFM', '8', 'MASCH_VERWALTUNG', null, 'Herr', null, null, null, 'danyel.grueneberg@qfm.eu',
        'i. A.', null, 'Gr�neberg', 'Danyel', null, '2052', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('L_TAHA', 'LAILA788', '66', 'ALLGEMEINE VERWALTUNG', null, 'Frau', null, null, null, 'layal.taha@qfm.eu',
        'i. A.', null, 'Taha', 'Layal', null, '2076', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('O_LUNDIE', 'MARZAHN30!', '66', 'ALLGEMEINE VERWALTUNG', null, 'Herr', null, null, null, 'ole.lundie@qfm.eu',
        'i. A.', null, 'Lundie', 'Ole', null, '2062', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('T_PATSCHKE', 'GESICHERT', '0', 'DEAKTIVIERT', null, 'Hr. Patschke', '- 149', '- 123', null,
        'thomas.patschke@qfm.eu', 'ppa.', 'Berlin', 'Patschke', 'Thomas', null, '2143', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('M_ADOLFO', 'MWENE@DOLFO21', '81', 'BAULEITER MIT MASCHINEN', null, 'Herr', null, '123', null,
        'm.adolfo@qfm.eu', 'i. A.', 'Berlin', 'Adolfo', 'Mwene', null, '2111', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('T_TAS', 'SARICAYIR38', '64', 'AZUBI ALLGEMEINE VERWALTUNG', null, 'Fr. Tas', '207', '123', null,
        'tugce.tas@qfm.eu', 'i. A.', 'Berlin', 'Tas', 'Tugce', null, '2120', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('C_SCHMIDT', 'QUANTEFM91', '10', 'MASCH_VERWALTUNG_PRUEFDAT', null, 'Herr Schmidt', '162', '173', null,
        'christopher.schmidt@qfm.eu', 'i. A.', 'Berlin', 'Schmidt', 'Christopher', null, '2192', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('T_ARENS', 'QUANTEFM', '79', 'BAULEITER', null, 'Herr Arens', null, null, null, 'torben.arens@qfm.eu', 'i. A.',
        null, 'Arens', 'Torben', null, '2175', null);
Insert into QFMTEST.BENUTZER (USERNAME, PASSWORT, ANZPOS, GRPNAME, KZ_BENUTZER_INFO_ANZEIGE, KURZZEICHEN, TELEFON,
                              TELEFAX, BAULEITER_KZ, EMAIL, ANREDE, SITZ, NAME, VORNAME, TRUPP_KZ, ROWVERSION,
                              PERSONALNUMMER)
values ('T_ALSLEBEN', 'QUANTEFM', '8', 'MASCH_VERWALTUNG', null, null, null, null, null, null, null, null, null, null,
        null, '2176', null);
REM INSERTING into QFMTEST.BENUTZERGRP
SET DEFINE OFF;
Insert into QFMTEST.BENUTZERGRP (USERNAME, ANZPOS, ROWVERSION)
values ('FAKTURIERUNG MIT ELK', '108', '1095');
Insert into QFMTEST.BENUTZERGRP (USERNAME, ANZPOS, ROWVERSION)
values ('DEAKTIVIERT', '0', '1054');
Insert into QFMTEST.BENUTZERGRP (USERNAME, ANZPOS, ROWVERSION)
values ('DEMBNY', '25', '1043');
Insert into QFMTEST.BENUTZERGRP (USERNAME, ANZPOS, ROWVERSION)
values ('MONTEUR NUR AUFMASS', '7', '1078');
Insert into QFMTEST.BENUTZERGRP (USERNAME, ANZPOS, ROWVERSION)
values ('BAULEITER', '79', '1104');
Insert into QFMTEST.BENUTZERGRP (USERNAME, ANZPOS, ROWVERSION)
values ('AZUBI FAKTURIERUNG', '87', '1108');
Insert into QFMTEST.BENUTZERGRP (USERNAME, ANZPOS, ROWVERSION)
values ('BAULEITER HAUSANSCHL�SSE', '70', '1030');
Insert into QFMTEST.BENUTZERGRP (USERNAME, ANZPOS, ROWVERSION)
values ('BAULEITER FERNMELDEMONTAGEN', '76', '1105');
Insert into QFMTEST.BENUTZERGRP (USERNAME, ANZPOS, ROWVERSION)
values ('ALLGEMEINE VERWALTUNG', '66', '1024');
Insert into QFMTEST.BENUTZERGRP (USERNAME, ANZPOS, ROWVERSION)
values ('FAKTURIERUNG', '101', '1113');
Insert into QFMTEST.BENUTZERGRP (USERNAME, ANZPOS, ROWVERSION)
values ('SYSA', '144', '1115');
Insert into QFMTEST.BENUTZERGRP (USERNAME, ANZPOS, ROWVERSION)
values ('MONTEUR', '7', '1071');
Insert into QFMTEST.BENUTZERGRP (USERNAME, ANZPOS, ROWVERSION)
values ('MASCH_VERWALTUNG', '8', '1034');
Insert into QFMTEST.BENUTZERGRP (USERNAME, ANZPOS, ROWVERSION)
values ('BAULEITER MIT MASCHINEN', '81', '1106');
Insert into QFMTEST.BENUTZERGRP (USERNAME, ANZPOS, ROWVERSION)
values ('AZUBI MASCH_VERWALTUNG', '8', '1028');
Insert into QFMTEST.BENUTZERGRP (USERNAME, ANZPOS, ROWVERSION)
values ('PRUEFER', '116', '1036');
Insert into QFMTEST.BENUTZERGRP (USERNAME, ANZPOS, ROWVERSION)
values ('AZUBI ALLGEMEINE VERWALTUNG', '64', '1120');
Insert into QFMTEST.BENUTZERGRP (USERNAME, ANZPOS, ROWVERSION)
values ('ALLGEMEINE VERWALTUNG MA', '68', '1050');
Insert into QFMTEST.BENUTZERGRP (USERNAME, ANZPOS, ROWVERSION)
values ('FAKTURIERUNG_SIG', '100', '1111');
Insert into QFMTEST.BENUTZERGRP (USERNAME, ANZPOS, ROWVERSION)
values ('CONTROLLING', '100', '1110');
Insert into QFMTEST.BENUTZERGRP (USERNAME, ANZPOS, ROWVERSION)
values ('ALLGEMEINE VERWALTUNG MO', '68', '1119');
Insert into QFMTEST.BENUTZERGRP (USERNAME, ANZPOS, ROWVERSION)
values ('FAKTURIERUNG_MASCH', '103', '1114');
Insert into QFMTEST.BENUTZERGRP (USERNAME, ANZPOS, ROWVERSION)
values ('MASCH_VERWALTUNG_LESEN', '8', '1122');
Insert into QFMTEST.BENUTZERGRP (USERNAME, ANZPOS, ROWVERSION)
values ('MASCH_VERWALTUNG_PRUEFDAT', '10', '1116');
REM INSERTING into QFMTEST.HA_BAULEITER
SET DEFINE OFF;
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('MA', 'Magsudlu, Aschkan', null, '02022754040', '015114577040', '610', '1178');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('DL', 'Linke, Dietmar', null, '030 74005 149', '0151 14577 149', '820', '1145');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('RJ', 'Jerke, Ronny', null, null, null, '250', '1139');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('MV', 'Viola, Manfred', null, null, null, '610', '1165');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('ST', 'Stoll, Andreas', null, null, null, '100', '1034');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('MB', 'B�rbock, Michael', null, '040 309817 35', '0151 14577 061', '510', '1191');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('DM', 'Mielich, Daniel', null, '030 74005 134', '0151 14577 134', '220', '1150');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('UH', 'Holtmann, Uwe', null, null, null, '610', '1136');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('MK', 'K�hler, Mike', null, '030 74005 126', '0151 14577 126', '140', '1141');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('DW', 'Wagner, Dennis', null, '030 74005 143', '0151 14577 143', '210', '1167');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('MG', 'Grell, Mike', null, null, null, '250', '1098');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('TM', 'Michaelis, Tanja', null, '030 74005 164', '0170 27227 02', '300', '1149');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('EL', 'Engelbrecht, Lutz', null, null, null, '140', '1130');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('OE', 'Eulitz, Olaf', null, null, null, '360', '1131');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('DG', 'Gerken, Dieter', null, null, null, null, '1053');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('MT', 'Theurer, Maren', null, '030 74005 161', null, '890', '1162');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('GA', 'Gamradt, Mario', null, '030 74005 181', '0151 14577 181', '870', '1132');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('CS', 'Sch�tt, Carsten', null, null, null, '350', '1096');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('GR', 'Grabowski, Wolfgang', null, '030 74005 147', '0151 14577 147', '210', '1133');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('BR', 'Riesebeck, Bj�rn', null, '030 74005 130', '0151 14577 130', null, '1157');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('LI', 'Linde, Andrea', null, null, null, null, '1144');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('LE', 'Lenius, J�rg', '-6368,91', '030 74005 176', '0151 14577 176', null, '1142');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('UT', 'Uter, Andreas', null, null, null, '130', '1164');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('PO', 'Porkert, Dietmar', null, '030 74005 155', '0151 14755 155', null, '1156');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('GU', 'Gudehus, Gerfried', null, '030 74005 135', '0151 5544 700', null, '1134');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('PS', 'Schneeweis, Peer', null, '030 74005 185', '0151 14577 185', '100', '1159');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('B�', 'B�hm, Ingo', null, null, null, '140', '1127');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('LB', 'Liebreich, Frank', '2014', '030 74005 166', '0151 14577 166', '340', '1143');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('WU', 'Wulff, Christian', null, null, null, null, '1170');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('AR', 'Arndt, Andreas', null, null, null, '300', '1123');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('LU', 'Lux, Franz', null, '07031 73254 21', '0151 14577 002', null, '1147');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('HE', 'Herwegen, Maurice', null, '07031 73254 26', '0151 14577 001', null, '1135');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('JB', 'Jablonowski, Klaus', null, null, null, null, '1110');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('H�', 'H�ttasch, Gunter', null, null, null, '101', '1137');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('TR', 'von Tr�mbach, Jens', null, '030 74005 170', '0151 14577 170', '250', '1171');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('IL', 'Lukowski, Ingo', null, null, null, '260', '1111');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('WK', 'Krone, Waldemar', null, null, null, '510', '1140');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('H�', 'H�rdler, Michael', null, '030 74005 182', '0151 14577 182', '160', '1138');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('DE', 'Dembny, Lutz', null, null, null, '320', '1129');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('PI', 'Pietronietz, Darius', null, null, null, '610', '1155');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('NN', 'nicht benutzen', null, null, null, null, '1022');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('WA', 'Walch, Annemarie', null, null, null, '910', '1023');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('RT', 'Tondorys, Ralf', null, '030 74005 158', '0151 14577 158', '230', '1163');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('CP', 'Pejga, Christian', null, '030 74005 171', '0151 14577 171', '110', '1153');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('AW', 'Wagner, Alan', null, '030 74005 168', '0151 14577 168', '240', '1166');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('RB', 'Br�seke, Ralf', null, null, null, '100', '1124');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('M�', 'M�ller, Bj�rn-O.', null, null, null, '610', '1151');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('NR', 'Reichert, Nico', null, null, null, '160', '1101');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('AF', 'Friedrich, Andreas', null, null, null, '110', '1095');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('AM', 'Mischkewitz, Alexander', null, null, null, '350', '1082');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('SK', 'Stephan, Kierschke', null, '030 74005 157', null, '711', '1161');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('NM', 'Maristany Klose, Nils', null, '030 74005 236', '0151 14577 236', '370', '1174');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('AS', 'Ayhan Savranoglu', null, null, null, '305', '1186');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('KM', 'Mei�ner, Kenny', null, '030 74005 238', '0151 14577 238', '350', '1109');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('AP', 'Pfitzner, Andreas', null, '030 74005 178', '0151 14577 178', '360', '1154');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('LD', 'Lovrincevic, Dino', null, null, null, '300', '1184');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('CA', 'Cas, Alexander', null, '0202 27540 10', '0151 14577 040', '610', '1128');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('SR', 'Schartner, Maik', null, null, null, '140', '1190');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('BM', 'M�ller, Bj�rn-Olaf', null, null, null, '830', '1152');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('DI', 'Lovrincevic, Dino', null, null, null, '350', '1146');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('MW', 'Wedemeyer, Martin', null, '030 74005 140', '0151 14577 140', '170', '1168');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('K�', 'K�nitz, Marcus', null, null, null, '130', '1108');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('YA', 'Al-Taie, Yaser', null, null, null, '240', '1194');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('BU', 'Buntschuh, Ronny', null, null, null, '235', '1081');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('TS', 'Schulze, Thomas', null, '030 74005 241', '0151 14577 241', '370', '1160');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('MS', 'Schubert, Michael', null, '030 74005 237', '0151 14577 237', '305', '1115');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('RL', 'Rouven Liers', null, '030 74005 239', '0151 14577 239', '180', '1173');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('MR', 'M�ller, Karsten', null, null, null, '190', '1175');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('WM', 'Wesel, Matthias', null, '030 74005 200', '0151 14577 200', '140', '1169');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('IV', 'Voigt, Ingo', null, null, null, '300', '1114');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('KO', 'Koppe, Mario', null, null, null, '260', '1177');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('ET', 'Ediz Tat', null, '+49 (0)30 74005 180', '+49 (0) 151 14577 05', '210', '1193');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('SP', 'Stapel, Paul', null, null, null, '370', '1185');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('SM', 'Schwarz, Matthias', null, null, null, '180', '1176');
Insert into QFMTEST.HA_BAULEITER (KZ, NAME, JAHRESVORTRAG, TELEFON, MOBIL, KOSTENSTELLE, ROWVERSION)
values ('AK', 'Arik, Musa', null, '030 74005 148', '0151 14577 148', '360', '1187');
REM INSERTING into QFMTEST.HA_BAUTRUPP
SET DEFINE OFF;
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1737', 'Neubauer, Stefan', 'MK', null, null, null, '01797843679', null, '2989', '10280277N000', '1737');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('352', 'Giesau, Steffen (352)', 'TR', null, null, null, '015114577326', null, '3023', '02130779G019', '352');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('350', 'Pritschow, Raik', 'TR', null, null, null, '015114577368', null, '2852', '04281070P002', '350');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('372', 'Scherner, Detlef', 'RT', null, null, null, '015114577375', null, '2871', '25031155S066', '372');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1007', 'Lovrincevic, Jurica', 'CS', null, null, null, null, null, '2009', '65140788L019', '12204');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12043', 'Piotrowsky, Uwe', 'DL', null, null, null, null, null, '2045', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1633', 'Schneeweiss, Charly', 'PS', null, null, null, null, null, '2276', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1523', 'Damas, Lucas Danilo', 'PO', null, null, null, null, null, '2338', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1750', 'Jermies, Susanne', 'MB', null, null, null, null, null, '2354', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('998350', 'Nachunternehmer Kst.350', 'KM', null, null, null, null, null, '2401', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('11', 'Brenner, Piet (alt)', 'TS', null, null, null, '015203043631', null, '3398', '04230786B017', '23');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1050', 'Berretta, Guiseppe', 'LU', null, null, null, '015752875757', null, '3413', null, '12050');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12235', 'Savranoglu, Ayhan (NUR Q3)', 'AS', null, null, null, null, null, '4022', null, '12235');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('434', 'Laurenz, Felix', 'LE', null, null, null, null, null, '2508', '25121092L004', '12001');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('24', 'Quandt, Tino', 'SP', null, null, null, null, null, '3997', '25090281Q007', '24');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12246', 'Lovrincevic, Dino (alt)', 'TM', null, null, null, null, null, '3663', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12247', 'H�rdler, Jens', 'LE', null, null, null, null, null, '2663', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1761', 'Paitz, Florian', 'MW', null, null, null, null, null, '2966', null, '1761');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12254', 'Cas, Alexander', 'CA', null, null, null, null, null, '3008', null, '12254');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12255', 'Mei�ner, Andreas', 'GU', null, null, null, null, null, '2974', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12263', 'Ehrke, Lukas', 'LB', null, null, null, null, null, '3068', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12269', 'Ristow, Myron', 'LB', null, null, null, null, null, '3071', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('441', 'Maute, Nico', 'IV', null, null, null, null, null, '3079', '23191191M012', null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1764', 'Salomo, Marco', 'MB', null, null, null, null, null, '3382', '25080185S018', '12185');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12270', 'Magsudlu, Aschkan', 'MA', null, null, '02022754040', '015114577040', null, '3530', null, '12270');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12262', 'K�nig, Markus Paul (alt)', 'LB', null, null, null, null, null, '3862', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1187', 'Grosch, Marvin', 'MA', null, null, null, null, null, '3477', null, '1187');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1519', 'Szymczak, Maik', 'PO', null, null, null, null, null, '3163', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('10162', 'St�rreserve Berlin', 'PS', null, null, null, null, null, '3238', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1191', 'Sowik, Sandro', 'MK', null, null, null, null, null, '3409', '65020893S033', '1736');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12286', 'Neumann, Daniel', 'PS', null, null, null, null, null, '3292', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12287', 'Klinnert, Johann', 'PS', null, null, null, null, null, '3293', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12288', 'Willuweit, Mike', 'PS', null, null, null, null, null, '3294', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('332', 'Voigt, Philip', 'LB', null, null, null, null, null, '4036', '65080782V015', '440');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12292', 'Theurer, Lisa', 'GU', null, null, null, null, null, '3323', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12293', 'Fischer, Andr�', 'GU', null, null, null, null, null, '3324', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12294', 'L�w, Caius', 'TM', null, null, null, null, null, '3325', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12295', 'Nickel, Jasmin', 'DL', null, null, null, null, null, '3327', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('465', 'Petroschka, Florian', 'LB', null, null, null, null, null, '3626', '65210294P011', '256');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12304', 'Zapke, Melanie', 'PS', null, null, null, null, null, '3424', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12305', 'Wiesner, Brian', 'LE', null, null, null, null, null, '3425', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1177', 'Yurt, Onur', 'MA', null, null, null, null, null, '3514', null, '12270');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('19014', 'Grah, Ivonne', 'MA', null, null, null, null, null, '3546', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12311', 'Lovrincevic, Dino (alt)', 'TM', null, null, null, null, null, '3664', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12313', 'B�hm, Konstantin', 'PS', null, null, null, null, null, '3551', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12314', 'Fauth, Aron', 'PS', null, null, null, null, null, '3552', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12315', 'Fiebig, Gerome', 'PS', null, null, null, null, null, '3553', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12334', 'Riesebeck, Eick', 'LE', null, null, null, null, null, '3687', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12317', 'Nehls, Marvin Ole Pascal', 'PS', null, null, null, null, null, '3555', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12318', 'Peinowski, Paul', 'PS', null, null, null, null, null, '3556', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12319', 'Schulz, Dominik', 'PS', null, null, null, null, null, '3557', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12320', 'Siebdrath, Josua', 'PS', null, null, null, null, null, '3558', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12321', 'Kieling, Michelle Nadine', 'MT', null, null, null, null, null, '3559', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12322', 'Sommer, Anne-Luisa', 'MT', null, null, null, null, null, '3562', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1051', 'Siris, Mohammed Fadi', 'HE', null, null, null, null, null, '3605', null, '12049');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12323', 'Drewinske, Benjamin', 'PS', null, null, null, null, null, '3568', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('484', 'Wohlrab, Dennis', 'AK', null, null, null, null, null, '3649', '04110291W000', '394');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('489', 'Koch, Daniel', 'RT', null, null, null, null, null, '3620', '04291079K012', '489');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1785', 'Westmark, Pascal (neu)', 'MK', null, null, null, null, null, '3690', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12337', 'Essaleh, Yassine', 'TM', null, null, null, null, null, '3705', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1789', 'Thornton, Derome', 'HE', null, null, null, null, null, '3753', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1068', 'Bansee, Marvin', 'WM', null, null, null, null, null, '3794', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12345', 'Uka, Joshua Julius', 'PS', null, null, null, null, null, '3804', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12349', 'Adolfo, Mwene Kassay Mande', 'DW', null, null, null, null, null, '3832', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('267', 'Kieschke, J�rg (NUR Q3)', 'AS', null, null, null, null, null, '4027', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('993793', 'Nachunternehmer Kst. 370 (Manuel Struck)', 'SP', null, null, null, null, null, '3909', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('269', 'Titze, Kevin-Tommy (nur Q3)', 'AS', null, null, null, null, null, '4038', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('270', 'S�r�c�, Mikail Kadir (NUR Q3)', 'AS', null, null, null, null, null, '4029', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('871', 'EDV Allgemein im Hause', 'GU', '870', null, '030 74005 181', null, null, '1128', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('5', 'Zweigniederlassung Wuppertal', 'GU', '500', null, null, null, null, '1129', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('994299', 'Nachunternehmer (420)', 'LU', null, null, null, null, null, '1130', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('994300', 'Leiharbeitnehmer (430)', 'LU', null, null, null, null, null, '1131', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('996100', 'Leiharbeitnehmer (610)', 'MA', null, null, null, null, null, '3481', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('995100', 'Leiharbeitnehmer (510)', 'WK', null, null, null, null, null, '1133', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('994200', 'Leiharbeitnehmer (420)', 'HE', null, null, null, null, null, '1134', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('995101', 'NU MUP (510)', 'WK', null, null, null, null, null, '1135', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('7', 'Masche, Klaus-Peter', 'LB', '620', null, null, '0179 133 5911', 'IG Bau Bln.', '1136', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12097', 'v. Tr�mbach, Jens (12097)', 'TR', null, '-1864,38', '03074005170', '0173 6380 170', 'CGM Bln.',
        '2209', null, '12097');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('31', 'B�ssow, Torsten', 'LB', '620', null, null, '015114577312', 'IG Bau Bln.', '2744', '03161269B045', '31');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('17454', 'Dietrich, Xaver', 'WA', null, null, null, null, null, '1139', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('261', 'Sebik, Cemal', 'RT', null, null, null, '015114577385', 'IG Bau Bln.', '2889', '25080868S036', '261');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('17361', 'Christerer, Erich', 'WA', null, null, null, null, null, '1141', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1113', 'Goly, Raimon', 'H�', '620', '0', null, '015114577327', 'IGM Bln.', '2774', '44210965G005', '1113');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('6610', 'Materiallieferung', 'MA', null, null, null, null, 'IGM NRW', '3479', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1674', 'May, Paul (1674)', 'RT', null, null, null, null, 'CGM Bln.', '2162', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('17355', 'Baumeister, Peter', 'WA', null, null, null, null, null, '1145', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('17351', 'Applis, Peter', 'WA', null, null, null, null, null, '1146', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('17356', 'B�hm, Klaus', 'WA', null, null, null, null, null, '1147', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('17471', 'Frimmel, Bruno', 'WA', null, null, null, null, null, '1148', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('17718', 'Bocale, Francesco', 'WA', null, null, null, null, null, '1149', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('17358', 'Burkhart, Manfred', 'WA', null, null, null, null, null, '1150', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('18045', 'Kugler, Josef', 'WA', null, null, null, null, null, '1151', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('17589', 'Ludwig, Helmut', 'WA', null, null, null, null, null, '1152', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('17586', 'Hummel, Gabriele', 'WA', null, null, null, null, null, '1153', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('17604', 'Neumeier, Christoph', 'WA', null, null, null, null, null, '1154', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('17426', 'Pilz, Thomas', 'WA', null, null, null, null, null, '1155', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('17598', 'Mayer, Gerhard', 'WA', null, null, null, null, null, '1156', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('17601', 'Merkle, Christian', 'WA', null, null, null, null, null, '1157', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('17479', 'H�usler, Korbinian', 'WA', null, null, null, null, null, '1158', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('17489', 'Hermann, Horst', 'WA', null, null, null, null, null, '1159', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('17609', 'Nicolaysen, Helmut', 'WA', null, null, null, null, null, '1160', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('17721', 'Kavalci, Hakan', 'WA', null, null, null, null, null, '1161', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('17588', 'Klemke, Michael', 'WA', null, null, null, null, null, '1162', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('17628', 'Richter, Andreas', 'WA', null, null, null, null, null, '1163', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('17440', 'Gvozden, Zeljko', 'WA', null, null, null, null, null, '1164', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('17446', 'Susic, Senahid', 'WA', null, null, null, null, null, '1165', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('18069', 'Walch, Annemarie', 'WA', null, null, null, null, null, '1166', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('17696', 'Weghofer, Peter', 'WA', null, null, null, null, null, '1167', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('17641', 'Schr�der, Helmut', 'WA', null, null, null, null, null, '1168', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12115', 'Mende, Torsten (12115)', 'PO', null, null, null, null, 'IGM Bln.', '2182', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('17638', 'Schreck, Burkhard', 'WA', null, null, null, null, null, '1170', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('17701', 'Wiedenmann, Thomas', 'WA', null, null, null, null, null, '1171', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('17684', 'Seb�k, Zoltan', 'WA', null, null, null, null, null, '1172', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1675', 'Durain, David', 'CP', null, null, null, '015114577315', 'CGM Bln.', '2752', '65030683D004', '1675');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('17710', 'Zauner, Michaela', 'WA', null, null, null, null, null, '1174', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('17687', 'Steiner, Thomas', 'WA', null, null, null, null, null, '1175', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('17712', 'Zenger, Wolfgang', 'WA', null, null, null, null, null, '1176', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('17714', 'Ziegler, Georg', 'WA', null, null, null, null, null, '1177', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('17645', 'Schulz, Wilhelm', 'WA', null, null, null, null, null, '1178', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1679', 'Kahlert, Michael (1679)', 'H�', null, null, null, '015114577338', 'CGM Bln.', '2793', '65081181K001',
        '1679');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1680', 'Schauties CGM', 'DM', null, null, null, null, 'CGM Bln.', '1890', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('413', 'Janzen, Nils (413)', 'LD', null, null, null, '015114577336', 'IG Bau Bln.', '3937', '25030888J000',
        '413');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1046', 'Sandau, Marko', 'B�', null, null, null, null, null, '1182', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12138', 'Reich, Marcus (12138)', 'LB', null, null, null, null, 'IG Bau Bln.', '2173', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12143', 'Pejga, Christian (12143)', 'CP', null, null, '030 / 74 005 171', '0173 / 63 80 104', 'IGM Bln.',
        '2239', null, '12143');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12142', 'Jerke, Ronny', 'LE', null, null, null, '0173 6380 144', 'CGM Bln.', '1185', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('9', 'Pejga - Norderstedt (9 alt)', 'GU', null, null, null, null, null, '2175', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12071', 'Linke, Dietmar', 'NN', null, null, null, null, null, '1187', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1678', 'Stange CGM', 'RT', null, null, null, null, 'CGM Bln.', '1786', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('994199', 'Nachunternehmer (410)', 'LU', null, null, null, null, null, '1189', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1676', 'Gillmeister, Florian', 'B�', null, null, null, null, 'CGM Bln.', '1190', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1682', 'Billerbeck, Tobias', 'TR', null, null, null, null, 'CGM Bln.', '1191', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('734', 'Pr�fmittellager', 'PO', null, null, '- 155', null, 'CGM Bln.', '1192', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12045', 'Liebreich, Frank', 'LB', '240', null, '030 74005166', '0173 6380 166', 'CGM Bln.', '1756', null,
        '12045');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('872', 'EDV Lager', 'GU', null, null, '030 74005 181', null, 'CGM Bln.', '1194', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('10736', 'Pr�fmittel Lager', 'PO', null, null, null, null, 'CGM Bln.', '1195', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('414', 'Band, Thomas (414)', 'LD', null, null, null, '015114577304', 'IG Bau Bln.', '3933', '25020970B040',
        '414');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1169', 'Hohner, Andr� (1169)', 'RT', null, null, null, null, 'CGM Bln.', '2129', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1681', 'Kulla, Benjamin', 'MW', null, null, null, '01736380230', 'CGM Bln.', '2233', '65200388K003', '1681');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('415', 'Schwinzer, Thomas (415)', 'LB', null, null, null, '01744017770', 'IG Bau Bln.', '3264', '04030376S038',
        '415');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1683', 'Wesel, Matthias (1683 alt)', 'CP', null, null, null, null, 'CGM Bln.', '2220', '04040686W002', '1683');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('735', 'Defekte Maschinen', 'PO', null, null, '- 155', null, 'CGM Bln.', '1201', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12144', 'Schlosser, Mich�le', 'LI', null, null, null, null, 'CGM Bln.', '1202', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12145', 'Br�seke, Ralf', 'PS', null, null, '-141', '0173/6380141', 'CGM Bln.', '1944', null, '12145');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12148', 'Onescheit, Christian', 'B�', null, null, null, null, 'CGM Bln.', '1204', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12147', 'Goldschmidt, Paul', 'EL', null, null, null, null, 'CGM Bln.', '1582', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1685', 'Golbs, Ren�', 'LB', null, null, null, null, 'CGM Bln.', '1206', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1687', 'Reinhold CGM', 'MG', null, null, null, null, 'CGM Bln.', '1887', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1151', 'Gudelius, Katja', 'JB', null, null, null, null, 'IGM NRW', '1208', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('991500', 'Leiharbeitnehmer (150)', 'CP', null, null, null, null, null, '1209', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1686', 'Koppe, Mario (1686 alt)', 'RJ', null, null, null, null, 'CGM Bln.', '2141', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12149', 'Rehnisch, Steffen (12149)', 'LB', null, null, null, null, 'IG Bau Bln.', '2161', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1688', 'Neumann, Matthias (1688)', 'B�', null, null, null, null, 'CGM Bln.', '2134', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1095', 'Patzer, Sven-Torsten', 'WM', '140', null, null, '015114577363', 'CGM Bln.', '2845', '04100469P000',
        '1095');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1684', 'May, Paul (1684)', 'RJ', null, null, null, null, 'CGM Bln.', '2163', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('10716', 'Verkauft', 'PO', '720', null, null, null, null, '1215', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12150', 'M�rz, Rebecca', 'GU', null, null, null, null, 'CGM Bln.', '1216', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1690', 'R��ler, Philipp', 'DW', null, null, null, null, 'CGM Bln.', '1565', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12036', 'Boehm, Ingo', 'PS', '140', null, '030 / 74 005 167', '0173 / 63 80 167', 'IGM Bln.', '1875', null,
        '12036');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1689', 'Oestereich, Thomas', 'DM', null, null, null, null, 'CGM Bln.', '1765', '25210755O008', '1689');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12039', 'Tietz,Thomas', 'NN', '825', null, null, null, 'IGM Bln.', '1220', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12010', 'Uter, Andreas', 'PS', '130', null, '74005172', null, 'IGM Bln.', '1221', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12019', 'Taeniges, Barbara', 'LI', '705', null, null, null, 'CGM Bln.', '1222', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1088', 'Fuerchau, Markus', 'H�', '150', null, null, '015114577321', 'IGM Bln.', '2766', '02280571F007',
        '1088');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1138', 'H�rdler, Michael (1138 alt)', 'PS', '150', null, null, null, 'CGM Bln.', '2372', null, '1138');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('65', 'Dauer, Henry', 'MK', '230', null, null, '015114577313', 'IG Bau Bln.', '2747', '25100162D023', '65');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('67', 'Goetsch, Torsten', 'LB', '230', null, null, '0173 6380 225', 'IG Bau Bln.', '1226', '04080969G006',
        '67');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1142', 'Adam, Torsten', 'H�', null, null, '2814864', '015114577301', 'CGM Bln.', '2724', '25030262A014',
        '1142');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12011', 'Porkert, Dietmar', 'PO', null, null, null, null, 'IGM Bln.', '1228', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12077', 'Gamradt, Mario', 'GU', null, null, null, null, 'CGM Bln.', '1229', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('800', 'Gudehus', 'GU', null, null, null, null, null, '1230', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12085', 'Jablonowski, Klaus', 'JB', null, null, null, null, 'IGM NRW', '1231', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12082', 'Sch�ler, Rainer', 'NN', null, null, null, null, 'IGM NRW', '1232', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1137', 'Schwinzer, Thomas (1137 alt)', 'LB', null, null, null, '0174 4667927', 'CGM Bln.', '2150', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1001', 'Dettmann, Peter', 'LU', null, null, '07031 1699', null, 'IGM Baden-W�rttembg.', '2748', '23291268D004',
        '12050');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1014', 'Kopetz, Thomas', 'LU', null, null, null, '015116325809', 'IGM Baden-W�rttembg.', '2804',
        '23141255K021', '12050');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1022', 'Weigend, Lutz', 'HE', null, null, null, '015116325807', 'IGM Baden-W�rttembg.', '2912', '63150370W011',
        '12049');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1074', 'Wirsum, Hugo', 'LU', null, null, null, '015114577013', 'IGM Baden-W�rttembg.', '2918', '13190253W101',
        '12050');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1094', 'Kimmich, Hans', 'LU', null, null, null, null, 'IGM Baden-W�rttembg.', '1238', '23160953K042', '1094');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1127', 'Seiser, Erwin', 'LU', null, null, null, '015114577012', 'IGM Baden-W�rttembg.', '3759', '23020366S056',
        '12049');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1139', 'Seiler, Daniel', 'H�', null, null, null, '015114577387', 'CGM Bln.', '2891', '04220173S076', '1139');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12084', 'Hartkopf, Helga', 'JB', null, null, null, null, 'IGM NRW', '1241', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1110', 'Magnin, Daniele', 'HE', null, null, null, '015114577011', 'IGM Baden-W�rttembg.', '2822', null,
        '12049');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1150', 'Olma, Bernhard (alt)', 'CA', null, null, null, null, 'EH NRW', '3958', '13231254O028', '12201');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1152', 'Br�ring, Karl', 'UH', null, null, null, null, 'EH NRW', '1835', '13050461B013', null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1153', 'Fried, Alfred', 'MA', null, null, null, '015116325816', 'EH NRW', '3471', '13190378F019', '1153');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1154', 'Pieper, Rainer', 'PI', null, null, null, null, 'EH NRW', '1341', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1157', 'Quandt, Sascha', 'MA', null, null, null, '015114577045', 'EH NRW', '3472', '13130573Q005', '1157');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1159', 'Gordalla, Lothar', 'MA', null, null, null, '015114577041', 'EH NRW', '3473', '13170768G044', '1159');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1144', 'Liberi, Evagelia', 'JB', null, null, null, null, 'EH NRW', '1249', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1149', 'Ochmann, Heinrich', 'MA', null, null, null, '015116325802', 'EH NRW', '3470', '53140865O001', '1149');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('59', 'Hoffmann, Thomas', 'ET', null, null, null, '015114577334', 'IG Bau Bln.', '4086', '25130470H015', '59');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('60', 'Borowski, Gerd', 'TR', null, null, '030/47756628', '015114577308', 'IG Bau Bln.', '3122', '25091165B039',
        '60');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12050', 'Lux, Franz', 'LU', null, null, null, null, 'IGM Baden-W�rttembg.', '1828', null, '12050');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12049', 'Herwegen, Maurice', 'HE', null, null, null, null, 'IGM Baden-W�rttembg.', '1829', null, '12049');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('229995', 'Lager Elektro', 'MA', null, null, null, null, null, '3480', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('229994', 'Werkstatt LWL', 'JB', null, null, null, null, null, '1256', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12089', 'Th�nchen, Silvia', 'JB', null, null, null, null, 'EH NRW', '1257', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('55', 'Jahnel, Ralf', 'LB', null, null, null, '015114577335', 'IG Bau Bln.', '3588', '04280567J009', '12045');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1641', 'Schweizer, Maik', 'MB', null, null, '040/32528551', '015114577071', 'CGM Schleswig-Holst.', '2887',
        '04220971S038', '1641');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1642', 'Mackiol, J�rgen', 'MW', null, null, null, '015114577351', 'CGM Bln.', '2821', '25110358M003', '1642');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('10717', 'Ware zur�ck an Lieferant', 'PO', null, null, null, null, 'CGM Bln.', '1261', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1643', 'Wetterling, Robert', 'DE', null, null, null, null, 'CGM Bln.', '1262', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12067', 'Fischer, Tino', 'B�', null, null, null, null, 'CGM Bln.', '1263', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12068', 'Mende, Dennis', 'UT', null, null, null, null, 'CGM Bln.', '1264', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12095', 'H�ttasch, Gunter', 'H�', null, null, null, '0171 41 43 246', null, '1265', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1644', 'Kubler, Swen', 'CP', null, null, null, '0176 223 16 709', 'CGM Bln.', '1670', '25141171K011', '1644');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1647', 'Runge, Enrico (1647 alt)', 'TR', null, null, null, '0173 2387162', 'CGM Bln.', '2169', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1648', 'Rockel CGM', 'RT', null, null, null, '0173 2170322', 'CGM Bln.', '1894', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12101', 'Neumann, Matthias (12101)', 'B�', null, null, null, null, 'CGM Bln.', '2133', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12102', 'Wesel, Matthias (12102 alt)', 'B�', null, null, null, null, 'CGM Bln.', '2132', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12103', 'Kahlert, Michael (12103 alt)', 'UT', null, null, null, null, 'CGM Bln.', '2165', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1649', 'Schilling, Christian', 'B�', null, null, null, null, 'CGM Bln.', '1272', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1167', 'Ruprecht CGM', 'RT', null, null, null, '0173 6380 137', 'CGM Bln.', '1783', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1165', 'Seidler CGM', 'MG', null, null, null, '0173 6380 136', 'CGM Bln.', '1795', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1168', 'Ruhtz CGM (Alt)', 'MG', null, null, null, '0178 1450516', 'CGM Bln.', '4065', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1170', 'Grau, Mark-Andr�', 'CP', null, null, null, null, 'CGM Schleswig-Holst.', '1276', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1012', 'Sawall CGM', 'DW', null, null, null, null, 'CGM Bln.', '1774', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1017', 'P�schel, Oliver', 'BR', null, null, null, '+49 1736213067', 'CGM Bln.', '1278', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1021', 'Sievers, Mike', 'TR', null, null, null, null, 'CGM Bln.', '1279', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1018', 'Schmidt, M. CGM', 'DW', null, null, null, null, 'CGM Bln.', '1895', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1652', 'Wesphal, Peter', 'TR', null, null, null, null, 'CGM Bln.', '1281', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1651', 'Nguyen, Kieu Dong', 'CP', null, null, null, null, 'CGM Schleswig-Holst.', '1282', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1096', 'Band, Thomas (1096 alt)', 'LB', null, null, null, null, 'CGM Bln.', '2128', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('9999', 'Ortung', 'PO', null, null, null, null, null, '1284', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('99990', 'Daten', 'PO', null, null, null, null, null, '1285', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1172', 'Lutz, Silvio', 'GR', null, null, null, null, 'CGM Bln.', '1286', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12116', 'Lukowski, Ingo', 'LE', null, null, null, null, 'CGM Bln.', '1287', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12117', 'Sauer, Rocky', 'H�', null, null, null, null, 'CGM Bln.', '1288', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12118', 'Altmann, Dennis (12118)', 'B�', null, null, null, null, 'CGM Bln.', '2167', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12119', 'Losert, Oliver (12119)', 'B�', null, null, null, null, 'CGM Bln.', '2178', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12122', 'Arndt, Andreas', 'AR', null, null, null, null, 'CGM Bln.', '1291', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12123', 'Wulff, Christian', 'AR', null, null, null, null, 'CGM Bln.', '1292', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1655', 'Michalak CGM (Alt)', 'MG', null, null, null, null, 'CGM Bln.', '4067', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1656', 'Losenske CGM (alt)', 'RT', null, null, null, null, 'CGM Bln.', '3309', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1657', 'Damm, Sebastian', 'TR', null, null, null, null, 'CGM Bln.', '1295', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12111', 'Dworschak, Karl-Heinz', 'LE', null, null, null, null, 'CGM Bln.', '1296', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1659', 'Fruth, Michael', 'PI', null, null, null, null, 'IGM NRW', '1344', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1660', 'Kendlbacher, Rudolf', 'PI', null, null, null, null, 'IGM NRW', '1345', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('8', 'Zweigniederlassung Norderstedt', 'GU', null, null, null, null, null, '1299', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('992499', 'Nachunternehmer (240)', 'LB', null, null, null, null, null, '1300', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('996199', 'Nachunternehmer (610)', 'MA', null, null, null, null, null, '3482', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('992199', 'Nachunternehmer (210)', 'GR', null, null, null, null, null, '1302', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('992399', 'Nachunternehmer (230)', 'NN', null, null, null, null, null, '3107', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('993199', 'Nachunternehmer (110)', 'CP', null, null, null, null, null, '1691', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('995199', 'Nachunternehmer (510)', 'WK', null, null, null, null, null, '1305', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1664', 'Sachse, Gregor', 'UT', null, null, null, null, 'CGM Bln.', '1306', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('994399', 'Nachunternehmer (430)', 'HE', null, null, null, null, null, '1307', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1667', 'Pietzuch, Steffen (1667 alt)', 'LB', null, null, null, null, 'CGM Bln.', '2184', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1665', 'Kunick, Lars', 'CP', null, null, null, null, 'CGM Schleswig-Holst.', '1309', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12046', 'Philipp, Reinhard', 'NN', null, null, null, null, 'IGM Bln.', '1310', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1669', 'Genthe, Henry', 'H�', null, null, null, '015114577325', 'CGM Bln.', '2770', '04061281G012', '1669');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1668', 'Stoltmann, David', 'BR', null, null, null, '015114577393', 'CGM Bln.', '3930', '04181181S030', '1668');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('40', 'Kresse, Heiko', 'DM', null, null, null, null, 'IG Bau Bln.', '1857', '25040467K053', '40');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('249', 'Handekli, Asef', 'IL', null, null, null, null, 'IG Bau Bln.', '1314', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1048', 'Krause, Wilhelm', 'LU', null, null, null, null, 'IGM Baden-W�rttembg.', '1315', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1120', 'Schlepel, Dorothea', 'LU', null, null, null, null, 'IGM Baden-W�rttembg.', '2304', null, '12050');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1171', 'Gutheil, Patrick', 'UT', null, null, null, null, 'CGM Bln.', '1317', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1525', 'Brosig, Frank', 'PO', null, null, null, null, 'CGM Bln.', '1711', '08050884B028', '1525');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12136', 'Dembny, Lutz', 'PS', null, null, null, null, 'CGM Bln.', '1335', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1666', 'Wilke, Andreas', 'CP', null, null, null, '015114577403', 'CGM Bln.', '2917', '25110766W032', '1666');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12131', 'Buchelt, Martin', 'LI', null, null, null, null, null, '1321', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1671', 'Biering, Wolfgang', 'WU', null, null, null, null, 'CGM Bln.', '1322', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1673', 'Grabowski, Michel', 'TR', null, null, null, null, 'CGM Bln.', '1323', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1663', 'Nevin, Stefan', 'WK', null, null, null, null, 'CGM Schleswig-Holst.', '1324', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('111', 'Jahns, Henry', 'TR', null, null, '03301/532117', '01718743908', 'IG Bau Bln.', '3123', '38010765J028',
        '60');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('416', 'Pietzuch, Steffen (416)', 'LD', null, null, null, '015114577365', 'IG Bau Bln.', '3941', '25210184P020',
        '416');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1692', 'Losert, Oliver (1692)', 'BR', null, null, null, '015775078138', 'CGM Bln.', '4042', '65181188L001',
        '1700');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12156', 'Viola, Manfred', 'MV', null, null, null, null, 'IGM NRW', '1386', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1696', 'Linke, Gerald', 'MK', null, null, null, null, 'CGM Bln.', '1496', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12164', 'M�ller, Bj�rn-Olaf', 'M�', null, null, null, null, 'CGM Bln.', '1967', null, '12164');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12165', 'Engelbrecht, Lutz', 'PS', null, null, '030 / 74 005 172', '0173 / 63 80 172', 'CGM Bln.', '1871',
        null, '12165');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12176', 'Nowak, Florian', 'LB', null, null, null, null, 'IG Bau Bln.', '1498', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12173', 'Wostrack, Mario (alt)', 'AM', null, null, null, null, 'IG Bau Bln.', '2313', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('44444', 'Lager Sifi', 'LU', null, null, null, null, null, '1459', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12175', 'Deniz, Fikri', 'EL', null, null, null, null, 'CGM Bln.', '1501', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12177', 'Lukas, Chris', 'B�', null, null, null, null, 'CGM Bln.', '1502', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12174', 'Werner, Rudolf (alt)', 'MK', null, null, null, '015114577402', 'CGM Bln.', '2913', null, '1008');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1713', 'Bienasch CGM', 'DM', null, null, null, null, 'CGM Bln.', '1889', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1712', 'Siebke, Christian', 'MK', null, null, null, '01723160517', null, '2893', '04271179S021', '1712');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('404', 'Fritsch, Andreas', 'LB', null, null, null, '01749362836', 'IG Bau Bln.', '3583', '44300383F007', '107');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1714', 'Schulze, Tom (alt)', 'TR', null, null, null, '01748507302', 'CGM Bln.', '2972', '44210290S003',
        '1714');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1147', 'Roubyou, Said', 'MA', null, null, null, '015116325818', 'IGM NRW', '3868', '153170872R021', '1157');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1023', '�ttl, Frank', 'DW', null, null, null, null, 'CGM Bln.', '1574', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1721', 'Hanke, Rayk', 'MW', null, null, null, '015114577332', 'CGM Bln.', '2777', '04140290K046', '1721');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1720', 'Freund, Marcel', 'MK', null, null, null, '015114577318', 'CGM Bln.', '2760', '25020888F009', '1720');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('380', 'Schulz, Kai', 'OE', null, null, null, null, 'IG Bau Bln.', '1577', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('422', 'M�ller, Peter', 'YA', null, null, null, '015114577359', 'IG Bau Bln.', '4102', '25301261M003', '422');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1726', 'Linthe, Martin', 'MK', null, null, null, '01751671131', 'CGM Bln.', '2816', '44250886L088', '1702');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1727', 'B�rbock, Uwe', 'MB', null, null, null, null, 'CGM Schleswig-Holst.', '1602', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12194', 'Grell, Mike', 'LE', null, null, null, null, 'CGM Bln.', '1819', null, '12194');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1530', 'Buntschuh CGM (1530 alt)', 'DW', null, null, null, null, 'CGM Bln.', '2137', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1531', 'Hermel, Steve (ehem. Sebekow)', 'DM', null, null, null, null, 'CGM Bln.', '1916', '25140483S031',
        '1531');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1532', 'Kremser CGM', 'MG', null, null, null, null, 'CGM Bln.', '1790', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1533', 'Plischka CGM', 'DW', null, null, null, null, 'CGM Bln.', '1948', null, '1533');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1534', 'Schmidt, Reinhard', 'TR', null, null, null, null, 'CGM Bln.', '1612', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1535', 'Scherner CGM', 'RT', null, null, null, null, 'CGM Bln.', '1785', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1536', 'Burghoff CGM (alt)', 'RT', null, null, null, null, 'CGM Bln.', '2396', '25030966B038', '1536');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1537', 'Schwab CGM (alt)', 'DW', null, null, null, null, 'CGM Bln.', '3670', null, '1537');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1542', 'Ulbricht CGM', 'DM', null, null, null, null, 'CGM Bln.', '1885', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('390', 'L�ck, Peter', 'RT', null, null, null, '01622388732', 'IG Bau Bln.', '3673', '04160761L026', '390');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('391', 'Lemke, Mario', 'RT', null, null, null, null, 'IG Bau Bln.', '1623', '04260670L006', '368');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('392', 'Kilian, Bernd', 'DM', null, null, null, '01621881286', 'IG Bau Bln.', '3775', '04230565K044', '392');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('393', 'Heimlich, Maik', 'AM', null, null, null, null, 'IG Bau Bln.', '2100', '04060583H000', '59');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1543', 'Titze, Horst', 'LE', null, null, null, null, 'CGM Bln.', '1621', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('95', 'Patzlaff, Peter (95)', 'TR', null, null, null, null, 'IG Bau Bln.', '2147', '25040151P002', '95');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('394', 'Schmidt, Manuel', 'ET', null, null, null, '015114577378', 'IG Bau Bln.', '4085', '44260781S005', '394');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('384', 'Schmidt, J�rg', 'KM', null, null, null, '015114577377', 'IG Bau Bln.', '2874', '04010159S034', '384');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('354', 'Schmidt, Attila', 'YA', null, null, null, '015114577376', 'IG Bau Bln.', '4072', '44170587S002', '305');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1706', 'Matthias, Burkhard', 'MK', null, null, null, '015114577353', 'CGM Bln.', '2824', '04280566M001',
        '1706');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('910', 'M�nchen Gudehus Allgemein', 'GU', null, null, '03074005135', '01787405135', null, '1457', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1723', 'Runschke, Tom', 'B�', null, null, null, null, 'CGM Bln.', '1585', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('310', 'M�ller, Michael', 'MK', null, null, null, '015114577358', 'CGM Bln.', '2834', '04211063M012', '310');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1722', 'Maurer, Torsten', 'B�', null, null, null, null, 'CGM Bln.', '1587', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1729', 'Stahl, Ralf', 'CP', null, null, null, '015114577391', 'CGM Bln.', '2897', '04220966S031', '1729');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1736', 'Wagner, Christoph', 'MK', null, null, null, '01733822791', 'CGM Bln.', '3206', '04310189W009', '1736');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1529', 'B�cker, Waldemar', 'PO', null, null, null, null, 'IGM Bln.', '1710', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12166', 'Eulitz, Olaf', 'LE', null, null, null, null, 'CGM Bln.', '1815', null, '12166');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1704', 'Izgec, Mesut', 'MB', null, null, null, '015114577070', 'CGM Bln.', '2787', '26250390I002', '1704');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1703', 'Vogel CGM', 'RT', null, null, null, null, 'CGM Bln.', '1787', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('407', 'Adam, Dennis', 'DW', null, null, null, null, 'IG Bau Bln.', '1560', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1705', 'Riesebeck, Eick (CGM alt)', 'MG', null, null, null, null, 'CGM Bln.', '3688', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12168', 'Bloszyk, Alexander', 'GU', null, null, null, null, 'CGM Bln.', '1451', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12169', 'Wagner, Dennis', 'DW', null, null, null, null, 'CGM Bln.', '1921', null, '12169');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12141', 'K�hler, Mike (12141)', 'PS', null, null, '030 / 74 005 126', '0173 / 63 80 126', 'CGM Bln.', '2157',
        null, '12141');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12181', 'Heinrich, Marita', 'PS', null, null, null, null, 'CGM Bln.', '1497', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('421', 'Glowalla, Dennis', 'LB', null, null, null, '01721797872', 'IG Bau Bln.', '2773', '65190289G004', '421');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('399', 'Rehnisch, Steffen (399)', 'OE', null, null, null, null, 'IG Bau Bln.', '2160', '65080392R017', '399');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12189', 'May Maximilian', 'CP', null, null, null, '01721744280', 'CGM Bln.', '2825', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12191', 'Kandler, Matthias (alt)', 'CP', null, null, null, null, 'CGM Bln.', '3720', null, '12143');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12196', 'Gr�neberg, Annett', 'LE', null, null, null, null, 'CGM Bln.', '3139', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1731', 'Boss CGM', 'DM', null, null, null, null, 'CGM Bln.', '1891', null, '212');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1732', 'Giesau, Steffen (1732 alt)', 'MG', null, null, null, null, 'CGM Bln.', '2158', '02130779G019', '1732');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1733', 'Walterschen, Andreas', 'MB', null, null, null, null, 'CGM Bln.', '1940', '16040970W001', '1733');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('388', 'Willmann, Ingolf', 'MG', null, null, null, null, 'IG Bau Bln.', '1910', '04030558W001', '388');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('387', 'Milhardt, Ren�', 'RT', null, null, null, '015205400338', 'IG Bau Bln.', '2830', '04210986M022', '419');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12202', 'Alva Diaz, Fernando (alt)', 'KM', null, null, null, '017621916028', 'IG Bau Bln.', '3153', null,
        '12045');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12199', 'Frotscher, Michelle', 'MT', null, null, null, null, 'CGM Bln.', '2465', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12203', 'Mischkewitz, Alexander', 'AM', null, null, null, null, 'CGM Bln.', '1928', '25301062M024', '12203');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('356', 'Burghoff, Jens Uwe', 'TR', null, null, null, '015114577311', 'IG Bau Bln.', '4084', '25030966B038',
        '356');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('357', 'Kr�ber, Thomas', 'ET', null, null, null, '015114577348', 'IG Bau Bln.', '4089', '25030863K068', '357');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('359', 'Riesebeck, Eick (alt)', 'AK', null, null, null, '01715647927', 'IG Bau Bln.', '3686', '44171287R005',
        '359');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('360', 'Sawall, Marko', 'RT', null, null, null, '017680174362', 'IG Bau Bln.', '4035', '49091084S005', '360');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('361', 'Swarra, Christian', 'DW', null, null, null, '015114577394', 'IG Bau Bln.', '2902', '65290386S019',
        '361');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('362', 'Ulbricht, Udo', 'ET', null, null, null, '015114577397', 'IG Bau Bln.', '4090', '04170361U006', '362');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('363', 'Michalak, Toralf', 'ET', null, null, null, '015114577356', 'IG Bau Bln.', '4068', '04280365M008',
        '365');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('364', 'Reinhold, Enrico', 'YA', null, null, null, '015114577369', 'IG Bau Bln.', '4079', '04290875R005',
        '364');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('365', 'Ruhtz, Kevin', 'ET', null, null, null, '015114577372', 'IG Bau Bln.', '4066', '25050284R010', '365');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('366', 'Schwab, Thomas (alt)', 'TR', null, null, null, '015114577383', 'IG Bau Bln.', '3669', '25150884S019',
        '366');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('367', 'Hauck, Christian (ehem. Bienasch)', 'DM', null, null, null, '015114577307', 'IG Bau Bln.', '2778',
        '44231187B017', '367');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('368', 'Katzor, Benjamin', 'TR', null, null, null, '015114577340', 'IG Bau Bln.', '3346', '04061182K018',
        '368');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('369', 'Ruprecht, Steffen', 'ET', null, null, null, '015114577374', 'IG Bau Bln.', '4087', '25100162R052',
        '369');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('371', 'Schauties, Robert', 'DM', null, null, null, null, 'IG Bau Bln.', '2263', '25100179S007', '371');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('373', 'Stange, Roland', 'YA', null, null, null, '017659829329', 'IG Bau Bln.', '4074', '25110186S045', '237');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('374', 'Vogel, Thomas', 'RT', null, null, null, '01733913173', 'IG Bau Bln.', '4093', '09061182V005', '419');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('375', 'Boss, Ewald', 'DM', null, null, null, '015114577309', 'IG Bau Bln.', '3066', '25010461E029', '375');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('376', 'Buntschuh, Ronny (376 alt)', 'DW', null, null, null, null, 'IG Bau Bln.', '2136', '25100484B019',
        '376');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('377', 'Kremser, Mike', 'YA', null, null, null, '015114577346', 'IG Bau Bln.', '4080', '25291167K047', '364');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('378', 'Losenske, Frank (alt)', 'RT', null, null, null, '01723021502', 'IG Bau Bln.', '3308', '25210374L015',
        '378');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('381', 'Plischka, Torsten', 'YA', null, null, null, '015114577366', 'IG Bau Bln.', '4075', '25120371P021',
        '381');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('382', 'Rockel, Silvio', 'RT', null, null, null, '015114577371', 'IG Bau Bln.', '2863', '04180871R015', '382');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('383', 'Schmidt, Martin', 'TR', null, null, null, '01797889504', 'IG Bau Bln.', '4099', '65131081S013', '356');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('353', 'Seidler, Wilfried', 'TR', null, null, null, '015114577386', 'IG Bau Bln.', '2890', '25220262S080',
        '353');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12110', 'Theurer, Maren', 'PS', null, null, null, null, 'CGM Bln.', '1442', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('420', 'R�hlmann, Steven', 'LB', null, null, null, null, 'IG Bau Bln.', '1412', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1710', 'Below, Martin', 'RT', null, null, null, null, 'CGM Bln.', '1476', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('405', 'Wostrack, Robert (405)', 'RT', null, null, null, '01725881529', 'IG Bau Bln.', '3344', '25060289W018',
        '405');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12070', 'Gr�schke, Petra', 'GU', null, null, null, null, 'CGM Bln.', '1532', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('313', 'Wiedecke, Horst (313)', 'LB', null, null, null, null, 'CGM Bln.', '2153', '25160946W004', '313');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1185', 'Murrer, S�ren', 'MA', null, null, null, '015114577042', 'IGM NRW', '3476', '25220384M003', '1185');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1719', 'Graffenberger, Matthias', 'MK', null, null, null, null, 'CGM Bln.', '1544', '65051084G011', '1719');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1526', 'Dittrich, Ronny Nils', 'PO', null, null, null, null, 'CGM Bln.', '1595', '25120889D011', '1526');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12195', 'Gr�neberg, Danyel', 'LE', null, null, null, null, 'CGM Bln.', '1643', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1735', 'Neubert, Jan', 'MK', null, null, null, '015114577360', 'CGM Bln.', '2841', '04030488N016', '1735');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('397', 'Batke, Sebastian', 'AM', null, null, null, null, 'IG Bau Bln.', '2249', '04290977B011', '397');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('396', 'Janke, Frank', 'LD', null, null, null, '01749280536', 'IG Bau Bln.', '4009', '25230466J015', '30');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1734', 'R�tz, Thomas', 'WM', null, null, null, '01749755870', 'CGM Bln.', '2869', '44100986R028', '1734');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('389', 'Heinrich, Pierre', 'TR', null, null, null, '01723261459', 'IG Bau Bln.', '4097', '25090372B011', '438');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('355', 'Greczycho, Przemyslaw', 'DW', null, null, null, null, 'IG Bau Bln.', '1699', '25230384G022', '355');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1700', 'Janke, Henry', 'BR', null, null, null, '01739305869', 'CGM Bln.', '3010', '04070685J013', '1700');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1701', 'Fr�hner, Oliver', 'RB', null, null, null, null, 'CGM Bln.', '1397', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('408', 'Br�ll, Stephan', 'AM', null, null, null, null, 'IG Bau Bln.', '2337', '12050188B010', '309');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12167', 'Kittlitz, Steven', 'PS', null, null, null, null, 'CGM Bln.', '1445', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1156', 'K�llgen, Tobias', 'MV', null, null, null, null, 'IGM NRW', '1460', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('406', 'Werner, Frank', 'OE', null, null, null, null, 'IG Bau Bln.', '1589', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1708', 'Katz, Bernhard', 'LU', null, null, null, null, 'IGM Baden-W�rttembg.', '1462', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1709', 'Knorr, Frank', 'LU', null, null, null, '015114577010', 'IGM Baden-W�rttembg.', '3760', '04150980K013',
        '12049');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12170', 'Gehrke, Andr�', 'PS', null, null, null, null, 'CGM Bln.', '1464', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12171', 'Sowitzki, Daniel', 'PS', null, null, null, null, 'CGM Bln.', '1465', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12172', 'Podschun, Sebastian (alt)', 'B�', null, null, null, null, 'CGM Bln.', '3865', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1718', 'Jankowiak, Martin', 'EL', null, null, null, null, 'CGM Bln.', '1528', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1717', 'Gille, Wolfgang', 'MK', null, null, null, '015112731287', 'CGM Bln.', '2772', '25020958G016', '1735');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1716', 'Riedle, Martin (ehem. Borchert)', 'MK', null, null, null, null, 'CGM Bln.', '3585', '25060988B019',
        '1716');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('400', 'Domogalski, Norman', 'KM', null, null, null, null, 'IG Bau Bln.', '2454', '25181065D004', '400');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12184', 'Fleck, Fabian', 'WM', null, null, null, null, 'CGM Bln.', '2227', null, '12218');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('398', 'Hentschel, Andreas', 'LB', null, null, null, '015785976729', 'IG Bau Bln.', '2782', '25291170H003',
        '209');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1145', 'Kunz, Andr�', 'MV', null, null, null, null, 'IGM NRW', '1552', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12185', 'B�rbock, Michael', 'PS', null, null, null, null, 'CGM Bln.', '1830', null, '12185');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12187', 'Friedrich, Andreas', 'PS', null, null, null, null, 'CGM Bln.', '1583', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12188', 'Reichert, Nico', 'PS', null, null, null, null, 'CGM Bln.', '1584', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1738', 'B�rnicke, Christoph', 'MK', null, null, null, null, 'CGM Bln.', '1713', '04020468B057', '1738');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1702', 'Martens, Detlef', 'MK', null, null, null, '015114577352', 'CGM Bln.', '2823', '25250860M028', '1702');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1155', '�zt�rk, Muhammet Vehbi', 'UH', null, null, null, null, 'IGM NRW', '1933', '58240180O011', '1155');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('419', 'Runge, Enrico (419)', 'RT', null, null, null, '015114577373', 'IG Bau Bln.', '2867', '44130882R018',
        '419');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12182', 'Kuschke, Sascha', 'LE', null, null, null, null, 'CGM Bln.', '1521', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12183', 'Wedemeyer, Martin', 'PS', null, null, '030 / 74 005 140', '0173 / 63 80 140', 'CGM Bln.', '1876',
        null, '12183');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12127', 'Vitense, Jana', 'DL', null, null, null, null, 'CGM Bln.', '1666', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12198', 'F�chsel, Christian', 'GU', null, null, null, null, 'CGM Bln.', '1694', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('385', 'Skalla, Andreas', 'MW', null, null, null, '015114577388', 'IG Bau Bln.', '4106', '11280266S149', '385');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1694', 'Wostrack, Robert (1694 alt)', 'LB', null, null, null, null, 'CGM Bln.', '2180', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('418', 'M�ller, Torsten', 'KM', null, null, null, '015781617935', 'IG Bau Bln.', '3384', '25300676M007', '418');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1715', 'Andres, Tony', 'MK', null, null, null, null, 'CGM Bln.', '1524', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12192', 'Mielich, Daniel (12192 alt)', 'LE', null, null, null, null, 'CGM Bln.', '2154', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12186', 'F�rstenberg, Andrea', 'MT', null, null, null, null, 'CGM Bln.', '1658', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12201', 'Holtmann, Uwe', 'UH', null, null, null, null, 'IGM NRW', '2020', null, '12201');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12204', 'Sch�tt, Carsten', 'TM', null, null, null, null, 'CGM Bln.', '1816', null, '12204');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1693', 'Nolte, Hilmar', 'RT', null, null, null, null, 'CGM Bln.', '1381', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1691', 'Katzor CGM', 'RT', null, null, null, null, 'CGM Bln.', '1782', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('60000', 'NL_Wuppertal', 'GU', null, null, null, null, null, '1353', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('50000', 'NL_Hamburg', 'GU', null, null, null, null, null, '1354', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('40000', 'NL_Sindelfingen', 'GU', null, null, null, null, null, '1355', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1173', 'Hohner, Andr� (1173)', 'GR', null, null, null, null, null, '2130', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('417', 'Koppe, Mario (417)', 'DM', null, null, null, '015114577343', 'IG Bau Bln.', '3140', '04311270K013',
        '417');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1697', 'Reich, Marcus (1697)', 'OE', null, null, null, null, 'CGM Bln.', '2172', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1698', 'Altmann, Dennis (1698)', 'EL', null, null, null, null, 'CGM Bln.', '2166', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1699', 'Wellnitz, Raymond (1699)', 'MK', null, null, null, null, 'CGM Bln.', '2138', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12160', 'Stoll, Andreas', 'PS', null, null, null, null, 'CGM Bln.', '1393', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12163', 'Gerken, Dieter', 'PS', null, null, null, null, 'CGM Bln.', '1394', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12128', 'Tondorys, Ralf (12128)', 'RT', null, null, null, null, 'CGM Bln.', '2149', null, '12128');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1707', 'Schleicher, Michael', 'CP', null, null, null, null, 'CGM Schleswig-Holst.', '2238', '04100988S001',
        '1707');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1695', 'Dix, Guido', 'CS', null, null, null, null, 'CGM Bln.', '2008', '65210989D006', '12204');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('401', 'Mix, Christian', 'LB', null, null, null, '017664761594', 'IG Bau Bln.', '3808', '04070475M001', '256');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('402', 'W�st, Ricardo', 'OE', null, null, null, null, 'IG Bau Bln.', '1536', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1711', 'Mehnert, Daniel', 'BR', null, null, null, '015114577354', 'CGM Bln.', '4040', '04180590M010', '1700');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1724', 'Kr�ber, Thomas CGM (Alt)', 'DM', null, null, null, null, 'CGM Bln.', '4069', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('425', 'P�pke, Michael', 'CS', null, null, null, null, 'IG Bau Bln.', '1964', '25150882P003', '425');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('423', 'Kr�ger, Thomas', 'OE', null, null, null, null, 'IG Bau Bln.', '1604', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('424', 'Mittelst�dt, J�rn', 'KM', null, null, null, '015114577357', 'IG Bau Bln.', '2967', '04060869M046',
        '424');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1728', 'Swarra CGM', 'DW', null, null, null, null, 'CGM Bln.', '1775', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1730', 'Herm, Marcus', 'MB', null, null, null, null, 'CGM Schleswig-Holst.', '1939', '04300186H013', '1730');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('11000', 'Michaelis, Tanja', 'GU', null, null, null, null, null, '1652', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12190', 'Wagner, Marc', 'LB', null, null, null, null, 'IG Bau Bln.', '1653', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12197', 'Mielich, Daniel (12197)', 'DM', null, null, null, null, 'CGM Bln.', '2155', null, '12197');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('244', 'Wostrack, Ralf', 'RT', '210', '3296,88', null, '015114577405', 'IG Bau Bln.', '3131', '25080161W005',
        '244');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('13', 'Gens, Rainer', 'TR', '210', '2659,3', '0331713708', '015114577324', 'IG Bau Bln.', '2769',
        '44131061G008', '13');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('107', 'Schon, Dittmar', 'LB', '210', '387', '4718641', '015114577380', 'IG Bau Bln.', '3189', '25181157S079',
        '107');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('150', 'Eidam, J�rg', 'DM', '210', '1783,96', null, '015114577316', 'IG Bau Bln.', '3138', '25240360E017',
        '150');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('255', 'Mehlhose, Mario', 'LB', '210', '-860,96', '03329611592', '0172/3253907', 'IG Bau Bln.', '3602',
        '25080261M026', '255');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('297', 'Gericke, Bernd', 'NN', '210', '13,44', '7112472', '0172/8026202', 'IG Bau Bln.', '3103', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1528', 'Kr�mer, Sebastian', 'PO', null, null, null, null, 'CGM Bln.', '1006', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1658', 'Oestreich, Stefan', 'TR', null, null, null, null, 'CGM Bln.', '1365', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1628', 'Hube, Hartmut', 'PO', null, null, null, null, 'IGM Bln.', '1008', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1672', 'Metzler, Uwe', 'WU', null, null, null, null, 'CGM Bln.', '1009', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1527', 'Kierschke, Stephan (alt)', 'PO', null, null, null, null, 'CGM Bln.', '3864', '25190984K003', '1527');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1002', 'Gebhardt, Andreas', 'H�', '150', null, null, '015114577322', 'IGM Bln.', '2767', '25240464G116',
        '1002');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1107', 'Farchmin, Bernd', 'MK', '150', '3008,46', null, null, 'IGM Bln.', '1580', '51270252F027', '1107');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('191', 'Buchholz, Heiko', 'LD', '220', null, null, '0173 6380139', 'IG Bau Bln.', '3934', '25290860B049',
        '416');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12109', 'Hilprecht, Christiane', 'LE', null, null, null, null, 'CGM Bln.', '1410', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12112', 'Hoffer, Carola', 'LI', null, null, null, null, 'CGM Bln.', '1015', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12104', 'Janzen, Nils (12104 alt)', 'LB', null, null, null, null, 'IG Bau Bln.', '2170', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12005', 'Bulevicius, Elfriede', 'LU', null, null, null, null, 'IGM Baden-W�rttembg.', '1017', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12088', 'Brand, Bettina', 'WK', null, null, null, null, 'CGM Schleswig-Holst.', '1018', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('212', 'Werner, Ralf-Peter', 'DM', '210', '563,21', null, '015114577401', 'IG Bau Bln.', '3137', '25081256W028',
        '212');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1006', 'Krethlow, Holger', 'BR', '110', null, null, '015114577347', 'IGM Bln.', '3011', '10080372K065',
        '1006');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1019', 'Rogasch, Andreas', 'DE', '160', '14100,21', null, null, 'IGM Bln.', '1021', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1118', 'Muschack, Guido', 'B�', '160', '-6516,24', null, '0163 2597318', 'IGM Bln.', '1022', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('348', 'Geleschus, Mario', 'MK', '220', '13171,91', null, '015114577323', 'IG Bau Bln.', '3062', '23011264G038',
        '348');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('237', 'Kunzke, Udo', 'YA', '210', null, '4719293', '0171 4433609', 'IG Bau Bln.', '4071', '65050760K020',
        '237');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1055', 'Kiekebusch, Wilfried', 'MK', '130', '-1616,72', null, '015114577341', 'IGM Bln.', '2992',
        '89090955K003', '1737');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1076', 'Ulrich, Torsten', 'WM', '160', null, null, '0174 4709937', 'IGM Bln.', '2633', '25240962U015', '1076');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1011', 'Fuhrig, Frank', 'WM', '160', null, null, '015114577320', 'IGM Bln.', '3426', '23100265F050', '1011');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('135', 'Katowski, Udo', 'IL', '620', '0', '0173 6380 171', null, 'IG Bau Bln.', '1028', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1', 'Grabowski, Wolfgang (1 alt)', 'GR', '210', null, '740050', null, null, '2185', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('370', 'Nasaroff, Jan', 'GR', '210', '5881,76', null, '0171/1832291', 'IG Bau Bln.', '1030', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1067', 'Dittmar, Gregor', 'H�', '150', null, null, '015114577314', 'IGM Bln.', '2751', '25190871D008', '1067');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1072', 'Schmidt, Olaf', 'MW', '120', null, null, '0172 3123475', 'IGM Bln.', '2315', '04180261S018', '1073');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1073', 'Frenzel, Holger', 'MW', '120', '586,38', null, '01739962447', 'IGM Bln.', '2759', '04180563F007',
        '1073');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1078', 'Schwarz, Wolfgang', 'WM', '120', null, null, '015114577384', 'IGM Bln.', '2886', '04041058S014',
        '1078');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('134', 'Hartmann, Andreas', 'DW', '210', '1802,81', null, '0162 5689289', 'IG Bau Bln.', '1851', '25150664P043',
        '134');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('711', 'Werkstatt', 'PO', '711', null, '- 155', null, null, '1036', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('730', 'Lager', 'PO', '730', null, '- 156', null, null, '1037', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('312', 'Wiedecke, Horst (312 alt)', 'LB', '310', '-7859,35', null, '015785283706', 'IG Bau Bln.', '2916', null,
        null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1083', 'Krause, Thomas', 'CP', '150', null, null, '015114577345', 'IGM Bln.', '3708', '38150369K023', '1083');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1092', 'K�hler, Mike (1092 alt)', 'PS', '130', null, '030 74 005 126', '0173 6380 126', 'IGM Bln.', '2156',
        null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('66', 'Geisler, Bernd', 'GR', '210', null, null, null, 'IG Bau Bln.', '1041', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('121', 'Bensch, Hans-J�rgen', 'RT', '210', null, '7539874', null, 'IG Bau Bln.', '1370', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('142', 'Jokiel, Peer', 'GR', '210', '4795,89', '03339876145', '0173 6380187', 'IG Bau Bln.', '1043', null,
        null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('223', 'Neumann, Heinz', 'RT', '210', '381,32', null, '0173 6380189', 'IG Bau Bln.', '1371', '25240352N007',
        '223');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('256', 'Kutsch, Michael', 'LB', '210', null, null, '01727419248', 'IG Bau Bln.', '3624', '04270963K026', '256');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('386', 'Tondorys, Ralf (386 alt)', 'GR', '210', '1965,21', null, '0173/6380158', 'IG Bau Bln.', '2148', null,
        null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12023', 'Grabowski, Wolfgang (12023)', 'GR', '210', null, null, null, 'IGM Bln.', '2186', null, '12023');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('289', 'Albrecht, J�rg', 'DM', '210', '210,21', null, '015114577302', 'IG Bau Bln.', '4091', '25170861A035',
        '307');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12001', 'Lenius, J�rg', 'LE', '220', null, null, null, 'IGM Bln.', '1049', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1071', 'Baudach, Oliver', 'MW', '150', null, null, '015114577329', 'CGM Schleswig-Holst.', '2729', null,
        '1071');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12003', 'Brennenstuhl, Bernd', 'LE', '230', null, null, '0173 6380 134', 'IGM Bln.', '3108', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('209', 'Merkel, Klaus-Peter', 'LB', '310', null, null, '015114577355', 'IG Bau Bln.', '3290', '25260855M027',
        '31');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('311', 'Wagner, Alan', 'LB', '310', '1230,78', null, '01736380112', 'IG Bau Bln.', '2011', '25140861W002',
        '12045');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('308', 'Desteguel, Muzaffer', 'LB', '210', null, null, null, 'IG Bau Bln.', '2312', '25191257D012', '157');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('83', 'Felske, Frank', 'KM', '310', '5111,69', null, '015114577317', 'IG Bau Bln.', '2757', '04120156F012',
        '83');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('112', 'Krause, Rainer', 'LB', '620', '0', null, '015114577344', 'IG Bau Bln.', '2808', '25010265K085', '112');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1081', 'Janoschka, Andreas', 'MK', '120', null, null, '0179 3958524', 'IGM Bln.', '2394', '25270960J016',
        '1706');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('379', 'Kaynar, Ali', 'ET', '210', null, null, '015774583799', 'IG Bau Bln.', '4088', '25010662K100', '369');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('157', '�st�ndag, Ismail', 'LB', '210', '-1127,87', null, '0151/12608288', 'IG Bau Bln.', '2021',
        '25250359U008', '157');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('295', 'Koeksal, Hueseyin', 'NN', '220', null, null, null, 'IG Bau Bln.', '3102', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('412', 'Koenig, Mike', 'LB', '310', null, null, '01639144448', 'IG Bau Bln.', '2803', '25150669K054', '31');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('36', 'Heine, Willi', 'GR', '310', '0', null, '0173 1328 390', 'IG Bau Bln.', '1062', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('78', 'Spiegel, Michael', 'RT', '310', '-9221,89', null, '015114577390', 'IG Bau Bln.', '2896', '25170761S012',
        '78');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('88', 'Reiff, Klaus-Dieter', 'TR', '210', '830,29', null, '0171 68 38 187', 'IG Bau Bln.', '2119',
        '25191251R001', '88');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('94', 'Patzlaff, Peter (94 alt)', 'LE', '210', '724,44', '7453884', '0160 95631622', 'IG Bau Bln.', '2146',
        null, '12166');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('335', 'Schm�decke, Klaus', 'GR', '210', '267,61', '8175445', '01711953162', 'IG Bau Bln.', '1066', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('82', 'Naujoks, Hans-J.', 'GR', '210', '-1590,88', null, '0171/1832291', 'IG Bau Bln.', '1067', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('154', 'Suckrow, Uwe', 'LB', '310', '2384,11', null, '0173 6380 208', 'IG Bau Bln.', '1068', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('215', 'Lorenz, Henry', 'LB', '620', '0', null, '015114577355', 'IG Bau Bln.', '3810', '65111060L009', '112');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1005', 'Anlauf, Manfred', 'H�', '620', '0', null, '015114577303', 'IGM Bln.', '2727', '25101240A010', '1005');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1112', 'Mende, Torsten (1112 alt)', 'PO', '620', '-579,2', null, null, 'IGM Bln.', '2181', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('100', 'Beck, Thomas', 'H�', '620', '0', null, '015114577306', 'IG Bau Bln.', '2730', '25230962B016', '100');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12121', 'Scholtz, Kevin', 'LB', null, null, null, null, 'IG Bau Bln.', '1073', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12132', 'Peggau, Nora-Kim', 'LI', null, null, null, null, null, '1074', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12134', 'Wellnitz, Raymond (12134)', 'AR', null, null, null, null, 'CGM Bln.', '2139', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12133', 'Fischer, Christopher-John', 'B�', null, null, null, null, null, '1076', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('358', 'J�rgens, Michel', 'RT', '210', '-580,32', null, '015114577337', 'IG Bau Bln.', '2792', '25171169J001',
        '358');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12135', 'Pietronietz, Dariusz', 'JB', null, null, null, null, 'IGM NRW', '1078', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12120', 'Tavli, Nuray', 'LI', null, null, null, null, 'CGM Bln.', '1079', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('403', 'Schmidt, Rainer (alt)', 'DM', '210', '1570', '5104913', '015114577379', 'IG Bau Bln.', '3667',
        '25100569S098', '403');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1080', 'Fr�hner, Karsten', 'WM', '120', null, null, '015114577319', 'IGM Bln.', '2764', '25301163F027',
        '1080');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1004', 'Grabianowski, Klaus', 'MK', '120', null, null, '0173 2033623', 'IGM Bln.', '1417', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1079', 'K�nnecke, Herbert', 'B�', '120', null, null, null, 'IGM Bln.', '1083', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1102', 'Hecht, Mario', 'MB', '120', null, null, '015114577333', 'IGM Bln.', '2924', '65061166H006', '1102');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1082', 'Neumann, J�rgen', 'CP', '120', null, null, '01736380127', 'IGM Bln.', '1668', '23010657N035', '1082');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1126', 'Vogt, Rinaldo', 'WM', '120', null, null, '015114577399', 'CGM Bln.', '2907', '04100973V009', '1126');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1049', 'Geck, Sebastian', 'WM', '170', null, null, '0173 6380 128', 'CGM Bln.', '2940', '25281073G021',
        '1049');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1020', 'Reiche, Marco', 'UT', '110', null, null, '0172 3043483', 'IGM Bln.', '1088', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1123', 'Pritschow CGM', 'TR', '110', null, null, '0174 4275165', 'IGM Bln.', '1924', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('410', 'Kircher , Olaf', 'LB', '310', '-7586,83', null, '015114577342', 'IG Bau Bln.', '2800', '25301264K026',
        '410');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('70', 'v. Tr�mbach, Jens (70 alt)', 'GR', '210', '-1864,38', '03074005170', '0173 6380 170', 'IG Bau Bln.',
        '2144', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('411', 'Schultz, Tonio', 'RT', '210', '418,26', '6410651', '015114577382', 'IG Bau Bln.', '2882',
        '25210562S087', '411');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1008', 'Leidinger, Thomas', 'WM', '130', null, null, '015114577294', 'IGM Bln.', '3118', '25100469L023',
        '1008');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1035', 'Marin, Rainer', 'RT', '130', null, null, '0177 3436454', 'IGM Bln.', '1495', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1634', 'M�tzlitz, Reno', 'MK', '130', null, null, null, 'IGM Bln.', '1425', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1009', 'Schubert, Lutz', 'WM', '130', null, null, '015114577381', 'IGM Bln.', '3867', '89120364S011', '1126');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('110', 'Schulz, Rainer', 'TR', '310', null, null, '01742409578', 'IG Bau Bln.', '4098', '25220365S062', '356');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1100', 'Trobisch, Michael', 'H�', '150', null, null, '015114577396', 'CGM Bln.', '2904', '04200370T000',
        '1100');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('4', 'Zweigniederlassung Sindelfingen', 'GU', '400', null, null, null, null, '1099', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('10715', 'Gestohlen', 'PO', '715', null, null, null, null, '1100', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('10714', 'Verschrottet', 'PO', '714', null, null, null, null, '1101', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('10713', 'Reserve', 'PO', '713', null, null, null, null, '1102', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('10712', 'KFZ - Werkstatt', 'PO', '712', null, null, null, null, '1103', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12009', 'Linde, Andrea', 'LI', '800', null, '74005122', null, 'IGM Bln.', '1104', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12020', 'Schneeweiss Peer', 'PS', '140', null, '030 74005185', '0151/14577185', 'CGM Bln.', '2679', null,
        '12020');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1039', 'Hefter, Andre', 'DE', '110', null, null, '0173 6380 125', 'IGM Bln.', '1106', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('870', 'Gudehus Allgemein', 'GU', '870', null, '03074005135', '01787405135', null, '1107', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('3', 'Teaniges, Barbara', 'LI', '705', null, null, null, null, '1108', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12137', 'Kiekebusch, Ronny', 'RB', null, null, null, null, 'CGM Bln.', '1406', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('991400', 'Leiharbeitnehmer (140)', 'WM', null, null, null, null, null, '2938', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('991499', 'Nachunternehmer (140)', 'WM', null, null, null, null, null, '2939', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('991600', 'Leiharbeitnehmer (160)', 'H�', null, null, null, null, null, '1112', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('992100', 'Leiharbeitnehmer (210)', 'GR', null, null, null, null, null, '1113', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('991399', 'Nachunternehmer (130)', 'UT', null, null, null, null, null, '1114', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('992305', 'NU Schneider (320)', 'NN', null, null, null, null, null, '3105', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('992300', 'Leiharbeitnehmer (230)', 'NN', null, null, null, null, null, '3104', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('992201', 'EFM Elektro Fernmelde Montagen (NU 360)', 'MA', null, null, null, null, null, '3164', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('991699', 'Nachunternehmer (160)', 'H�', null, null, null, null, null, '1118', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('992101', 'NU Eichholz (210)', 'GR', null, null, null, null, null, '1119', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('991300', 'Leiharbeitnehmer (130)', 'UT', null, null, null, null, null, '1120', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('992400', 'Leiharbeitnehmer (240)', 'LB', null, null, null, null, null, '1121', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('992402', 'NU MUP (240)', 'LI', null, null, null, null, null, '1122', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('992306', 'NU Schultze Netzwerke (230)', 'NN', null, null, null, null, null, '3106', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('992600', 'Leiharbeitnehmer (260)', 'IL', null, null, null, null, null, '1124', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('993100', 'Leiharbeitnehmer (110)', 'CP', null, null, null, null, null, '1689', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1077', 'Pejga, Christian (1077 alt)', 'CP', '150', null, null, '01787405104', 'IGM Bln.', '2174', null,
        '1077');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('992699', 'Nachunternehmer (360)', 'AP', null, null, null, null, null, '2544', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('10744', 'Pr�fmittelsperrlager 400', 'PO', null, null, null, null, null, '1766', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('10755', 'Pr�fmittelsperrlager 500', 'PO', null, null, null, null, null, '1767', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('10766', 'Pr�fmittelsperrlager 600', 'PO', null, null, null, null, null, '1768', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('10777', 'Pr�fmittelsperrlager 700', 'PO', null, null, null, null, null, '1769', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('10900', 'Pr�fmittelsperrlager 900', 'PO', null, null, null, null, null, '1770', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('426', 'Piske, Markus', 'LB', null, null, null, null, null, '1943', '44180684P003', '418');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1030', 'Scholz, Dennis', 'LE', null, null, null, null, null, '2956', null, '12001');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('349', 'Pohl, Markus', 'DM', null, null, null, '015114577367', null, '2851', '25110770P006', '349');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('351', 'Michaelis, Christoph', 'LD', null, null, null, '01743150731', null, '3939', '04090791M038', '351');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('346', 'Beyer, Vincent', 'KM', null, null, null, null, null, '2452', '04060290B022', '414');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('427', 'B�hring, Rico', 'DM', null, null, null, '015203169885', null, '3095', '04021192B017', '427');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1741', 'Buchholz, Henning', 'MK', null, null, null, '01776509655', null, '3047', '25240978B009', '1741');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('428', 'Brauer, Andrej', 'DM', null, null, null, null, null, '2098', '25270387B011', '417');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('992599', 'Nachunternehmer (340)', 'LB', null, null, null, null, null, '2051', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1161', 'Swierczyna, Michael', 'UH', null, null, null, null, null, '2070', null, '1157');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1743', 'Starke, Werner', 'MW', null, null, null, '015114577392', null, '2900', '04201285S044', '1743');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1742', 'Rentsch, Toni', 'MW', null, null, null, '015114577370', null, '2858', '04130590R006', '1742');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12215', 'Scholz, Martin', 'MT', null, null, null, null, null, '2064', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('993499', 'Nachunternehmer (340) ab 2014', 'LB', null, null, null, null, null, '2189', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('210', 'Werk, Daniel', 'AM', null, null, null, null, null, '2071', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('10160', 'LWL Lager GroKie', 'H�', null, null, null, null, null, '3616', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('10161', 'LWL Stahlschrank Berlin', 'H�', null, null, null, null, null, '3617', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('10737', 'Lagerplatz Rhinstra�e', 'PO', null, null, null, null, 'CGM Bln.', '2487', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('10738', 'Lagerplatz M�nsterberger Weg', 'PO', null, null, null, null, 'CGM Bln.', '2192', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12217', 'Lehmann, Lars', 'MT', null, null, null, null, null, '2194', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12216', 'Hanke, Michael', 'MT', null, null, null, null, null, '2195', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('345', 'John, Manfred', 'AM', null, null, null, null, null, '2237', '38230463J006', '345');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1745', 'Fritz, Franz-Philipp (alt)', 'DM', null, null, null, '01733120284', null, '3774', null, '352');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('315', 'Reschke, Andy', 'DM', null, null, null, null, null, '2676', '04090988R018', '315');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('334', 'Ristow, Myron', 'AM', null, null, null, null, null, '2258', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('342', 'Zerbian, Mario', 'DM', null, null, null, '01739979320', null, '3823', '25250584Z006', '342');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1746', 'M�ller, Tore', 'MB', null, null, null, '017692609513', null, '3381', '66121094M018', '12185');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12222', 'H�bner, Sascha (alt 12222)', 'LB', null, null, null, '017670781813', null, '3606', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12225', 'Bachmann, Marco', 'PS', null, null, null, null, null, '3828', null, '12020');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('343', 'Kijewski, Martin', 'KM', null, null, null, null, null, '2445', '44161188K014', '343');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1747', 'Malcharek, Ronny (ehm. Tiegs)', 'MW', null, null, null, '015114577395', null, '3376', '44030281M036',
        '1747');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1183', 'Neiner, Klaus', 'MA', null, null, null, '015114577043', null, '3475', null, '1183');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1184', 'Sonar, Andreas', 'UH', null, null, null, null, null, '2327', null, '1184');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1629', 'Bezouska, Michal', 'MB', null, null, null, null, null, '2333', null, '1629');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12233', 'Aneta Lysko', 'MT', null, null, null, null, null, '2496', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('339', 'Wagner, Steffen', 'YA', null, null, null, '01637793140', null, '4083', '25090264W037', '381');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12224', 'Walter, Jean (alt)', 'LB', null, null, null, '01743058860', null, '3273', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1751', 'M�ller, Andre', 'MW', null, null, null, '01723828212', null, '2833', null, '1751');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1028', 'J�hrendt, Florian', 'PO', null, null, null, null, null, '2370', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1753', 'Podschun, Sebastian', 'WM', null, null, null, '015774740611', null, '3373', '04061190P002', '1753');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('432', 'Dietrich, Jens', 'DM', null, null, null, '01778357762', null, '3707', '25220494D005', '432');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1754', 'Werner, Rudolf', 'WM', null, null, null, null, null, '3854', '25240791W009', '1754');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('993498', 'NU Lindermann Kst. 340', 'LB', null, null, null, null, null, '2402', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('993598', 'NU Lindermann Kst. 350', 'KM', null, null, null, null, null, '2403', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('993698', 'NU Lindermann Kst. 360', 'AP', null, null, null, null, null, '2404', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12234', 'Jannicke, Marvin (alt)', 'LE', null, null, null, null, null, '3538', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('992202', 'IBW Fernmeldemont.-Tiefbau GbR (NU 360)', 'MA', null, null, null, null, null, '3165', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('992203', 'Ewald Stra�enbau u Kabelverleg. (NU 360)', 'MA', null, null, null, null, null, '3166', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('993799', 'Nachunternehmer Lindemann (370)', 'TS', null, null, null, null, null, '2548', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('19010', 'Gutsch, Sebastian', 'DL', null, null, null, null, null, '2549', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('436', 'Kraatz, Thomas', 'LD', null, null, null, '01736112774', null, '3938', '44200785K008', '436');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('435', 'von Sierakowski, Christian', 'RT', null, null, null, '01577340369', null, '2894', '25160886S017',
        '435');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12239', 'Bolor-Erdene, Murun', 'PS', null, null, null, '017663438421', null, '2736', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12238', 'Boeder, Cerstin (neu)', 'TM', null, null, null, null, null, '2655', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12240', 'Skalla, Michelle', 'MT', null, null, null, null, null, '2573', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12241', 'Westmark, Pascal (alt)', 'CP', null, null, null, '015204465083', null, '3691', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12242', 'Behrens, Fabian', 'PS', null, null, null, '01634391818', null, '2731', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1040', 'Haase, Marc', 'MB', null, null, null, null, null, '3380', '66070790H001', '12185');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12243', 'Dittewig, Larissa', 'SK', null, null, null, null, null, '2574', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1755', 'Rudyk, Valentyn', 'LU', null, null, null, '015736109767', null, '2865', null, '12050');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12213', 'Buntschuh, Ronny', 'BU', null, null, null, null, null, '1985', '25100484B019', '12213');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12065', 'Binder, Denise', 'DL', null, null, null, null, null, '2046', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12193', 'Purdy, Ina', 'DL', null, null, null, null, null, '2047', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12221', 'Pfitzner, Andreas', 'TM', null, null, null, null, null, '2359', null, '12221');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('999350', 'Nachunternehmer Kst. 350 (Putbrese)', 'CS', null, null, null, null, null, '2346', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('999360', 'Nachunternehmer Kst. 360 (Putbrese)', 'CS', null, null, null, null, null, '2347', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12232', 'Bauer, Juliane', 'DL', null, null, null, null, null, '2407', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('993798', 'Nachunternehmer Kst. 370 (Fa. Schonack)', 'TS', null, null, null, null, null, '2581', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('993797', 'Nachunternehmer Kst. (Fa. TKKB)', 'TS', null, null, null, null, null, '2580', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1756', 'Turek, Lukas', 'MB', null, null, null, null, null, '3081', null, '12185');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1043', 'Kohl, Rainhard (neu)', 'TM', null, null, null, null, null, '2652', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('34', 'Kobelev, Vaceslav', 'TR', null, null, null, '017684154395', null, '2802', '25180491K002', '34');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12249', 'G�tz, Adriana', 'GU', null, null, null, null, null, '2706', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('45', 'Hamburg, Artur', 'DM', null, null, null, null, null, '2711', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('37', 'H�ske, Ralf', 'MW', null, null, null, '01736487247', null, '3360', '04110666H026', '37');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1520', 'Kaba, Saibou', 'PO', null, null, null, null, null, '3984', '65051174K050', null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12251', 'Schubert, Michael', 'MS', null, null, null, null, null, '2960', null, '12251');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12146', 'Kasperski, Anne', 'MT', null, null, null, null, null, '2928', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1521', 'Kroek Gordon', 'PO', null, null, null, null, null, '3986', '44200586K018', null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1758', 'May, Maximilian', 'BR', null, null, null, null, null, '4041', '44261293L004', '1700');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1760', 'Richter, Frank (alt)', 'MS', null, null, null, null, null, '3229', null, '1759');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1759', 'Smolibowski, Mario (alt)', 'MS', null, null, null, null, null, '3228', null, '1759');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1029', 'Dammer, Klaus', 'LE', null, null, null, null, null, '2964', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1070', 'Wirsum, Hugo (neu)', 'LU', null, null, null, null, null, '3411', null, '12050');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12022', 'Grabowski, Wolfgang', 'LE', null, null, null, null, null, '2978', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1626', 'Schneeweiss, Charly (neu Stud. Aushilfe)', 'PS', null, null, null, null, null, '3846', null, '12020');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12256', 'M�ller, Fabian', 'PS', null, null, null, null, null, '2996', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('440', 'H�bner, Sascha', 'LB', null, null, null, null, null, '3898', '65230698H009', '440');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1033', 'Ristow, Mykel', 'KM', null, null, null, null, null, '3020', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1034', 'Ristow, Myron', 'KM', null, null, null, null, null, '3021', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('307', 'Fritz, Franz-Philipp', 'DM', null, null, null, '+49 (0173) 3120284', null, '3817', '04290692F000',
        '307');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1762', 'H�mer, Frank', 'BR', null, null, null, null, null, '4039', '25130478H013', '1006');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('333', 'Naumann, J�rg', 'RT', null, null, null, null, null, '4096', '25120585J001', '358');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12267', 'Bernhardt, Juliane', 'TM', null, null, null, null, null, '3044', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12258', 'Reichmann, Jean (alt)', 'BR', null, null, null, null, null, '3615', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1053', 'Drewinske, Mirco', 'MK', null, null, null, '017624441256', null, '3364', '25031275D008', '1741');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12268', 'Franke, Manuel', 'PO', null, null, null, null, null, '3070', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('306', 'Kurtzke, Martin', 'TR', null, null, null, null, null, '3170', '65230788K014', '405');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12272', 'Graf, Thomas', 'LE', null, null, null, null, null, '3150', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('443', 'Alva Diaz, Fernando (neu)', 'KM', null, null, null, null, null, '3152', '25051096A009', '12231');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12273', 'Fuhrig, Frank', 'PS', null, null, null, null, null, '3159', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('444', 'Schilling, Niklas', 'RL', null, null, null, null, null, '3214', '65160796S017', '457');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1188', 'Feragotti, Roberto', 'WM', null, null, null, null, null, '3168', null, '1126');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('445', 'Cholewa, Christopher', 'KM', null, null, null, null, null, '3172', '25020787C015', '445');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('451', 'Richter, Frank (NUR Q3)', 'MS', null, null, null, null, null, '4017', '04160179R026', '451');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('455', 'Woiwode, Tino', 'LD', null, null, null, null, null, '3945', '89070888W015', '455');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('456', 'G�gel, Sven', 'LD', null, null, null, null, null, '3935', '44201184G035', '455');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('457', 'Ludewig, Gregor', 'RL', null, null, null, null, null, '3213', '04160583L008', '457');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('458', 'Tietz, Heiko', 'LD', null, null, null, null, null, '3942', '04020179T004', '458');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12276', 'Maristany Klose, Nils', 'NM', null, null, null, null, null, '3329', null, '12276');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('453', 'Neumann, Dennis', 'LB', null, null, null, null, null, '3220', '04181193N006', '421');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('454', 'Zunker, Danny Lutz (NUR Q3)', 'MS', null, null, null, null, null, '4019', '04070495Z000', '454');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1190', 'Paun, Cosmin Stefan', 'LU', null, null, null, null, null, '3241', null, '12050');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('452', 'Smolibowski, Mario (NUR Q3)', 'MS', null, null, null, null, null, '4018', '04270759S015', '452');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('461', 'Gottschlich, Patrick', 'RT', null, null, null, null, null, '4095', '25290687M041', '360');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1766', 'Frunzek, Sebastian', 'BR', null, null, null, null, null, '3369', '25160776F019', '1766');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('993898', 'Nachunternehmer Royal Bau (180) ab 04/17', 'SM', null, null, null, null, null, '3421', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('993899', 'Nachunternehmer Blobelt (380) ab 04/17', 'RL', null, null, null, null, null, '3260', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12277', 'Blank, Andreas (NUR Q3)', 'MS', null, null, null, null, null, '4023', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1125', 'Weidenbach, Marcel', 'CA', null, null, null, null, null, '3263', null, '1125');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1136', 'Bloch, Ren�', 'BR', null, null, null, null, null, '3368', '65110584B047', '1136');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12290', 'Losenske, Frank (neu)', 'LE', null, null, null, null, null, '3307', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12278', 'Jarugski, Olga', 'GU', null, null, null, null, null, '3270', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12279', 'Roch, Stefan', 'LE', null, null, null, null, null, '3275', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('462', 'Walter, Jean', 'LB', null, null, null, null, null, '3900', '89260394W006', '12045');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('463', 'Wenzko, Matthias', 'DM', null, null, null, null, null, '3297', '44210880W003', '463');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12281', 'Beeres, Ilze', 'TM', null, null, null, null, null, '3281', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12282', 'Makara, Ewa', 'DL', null, null, null, null, null, '3283', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12283', 'Patowsky, Marc-William', 'KM', null, null, null, null, null, '3284', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('305', 'Arnhold, Habo', 'RT', null, null, null, null, null, '3957', '04110666H026', '305');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12285', 'Meinke, Danny', 'KM', null, null, null, null, null, '3291', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1768', 'Rux, Benedict', 'WM', null, null, null, null, null, '3509', '25240296R024', '1753');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12291', 'Evren, Eylem', 'TM', null, null, null, null, null, '3317', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('464', 'Plaichaiyaphum, Harry', 'SM', null, null, null, null, null, '3594', '65070992P004', '12302');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('873', 'EDV Sperrlager', 'GU', null, null, '030 74005 181', null, 'CGM Bln.', '3330', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('466', 'Frank, Christian', 'AK', null, null, null, null, null, '3642', '25190693F015', '394');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1776', 'Hitzke, Manfred Wieland', 'MR', null, null, null, null, null, '3582', '65090659H012', '1769');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12296', 'Salzmann, Tanja', 'TM', null, null, null, null, null, '3362', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12297', 'Pietsch, Thomas', 'LE', null, null, null, null, null, '3595', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('467', 'Paulig, Stephan', 'MS', null, null, null, null, null, '3379', '04160281P029', null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12298', 'Neher, Andr�', 'TM', null, null, null, null, null, '3383', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12299', 'K�hn, Kathleen', 'DL', null, null, null, null, null, '3385', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12300', 'Schwab, Thomas', 'LE', null, null, null, null, null, '3386', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('468', 'Kosmowski, Florian', 'DM', null, null, null, null, null, '3674', '65290591K010', '468');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1770', 'Pinto, Andr� Felipe', 'MB', null, null, null, null, null, '3414', null, '12185');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12301', 'Nau, Ute', 'DL', null, null, null, null, null, '3393', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12302', 'Schwarz, Matthias', 'PS', null, null, null, null, null, '3623', null, '12302');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('38', 'Brenner, Piet', 'SP', null, null, null, null, null, '3992', '04230786B017', '23');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1771', 'Oesterling, Finn', 'MK', null, null, null, null, null, '3410', null, '1720');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1773', 'G�rtner, Nick', 'MK', null, null, null, null, null, '3693', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1774', 'Kirsch, Michel Roman', 'WM', null, null, null, null, null, '3508', '25101086K026', '1008');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12007', 'Jungrichter, Dean', 'PO', null, null, null, null, null, '3444', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('482', 'M�ller, Daniel', 'TR', null, null, null, null, null, '3532', '25170483M008', '480');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12307', 'Fiebig, Gerome (alt)', 'PS', null, null, null, null, null, '3561', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1777', 'Knyrim, Leon', 'WM', null, null, null, null, null, '3894', '44040893K007', '1777');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12310', 'Cruse, Desiree', 'TM', null, null, null, null, null, '3544', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1518', 'Schmidt, Christopher', 'PO', null, null, null, null, null, '3548', '44171291S002', null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12325', 'Bernhardt, Pierre', 'TM', null, null, null, null, null, '3590', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1778', 'B�ttche, Bastian', 'MK', null, null, null, null, null, '3610', '04210795B006', '1736');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1178', 'Schwarzer, Markus', 'MA', null, null, null, null, null, '3581', '53231279S008', '1178');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1179', 'Al-Omari, Samih', 'MA', null, null, null, null, null, '3609', null, '1179');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('331', 'Troschka, Alexander', 'DM', null, null, null, null, null, '3821', '04121085T011', '331');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12324', 'Neidick, Steffen', 'PS', null, null, null, null, null, '3586', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12328', 'Hanke, Verena', 'DL', null, null, null, null, null, '3676', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1192', 'Geiser, Herve Michael', 'MA', null, null, null, null, null, '3611', null, '1185');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('486', 'Paschos, J�rgen', 'DM', null, null, null, null, null, '4082', '18120972P007', '468');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12336', 'Sora-M�ller, Seniha', 'MT', null, null, null, null, null, '3701', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12335', 'Al-Taie, Yaser', 'YA', null, null, null, null, null, '4077', null, '12335');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1725', 'Kanzler, Frank', 'MW', null, null, null, '015114577339', 'CGM Bln.', '2795', '38230172P011', '1725');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1181', 'Fr�hauf, Holger', 'MA', null, null, null, null, null, '3656', null, '1178');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1780', 'Georgalas, Panagiotis', 'MA', null, null, null, null, null, '3696', null, '1179');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12329', 'Lovrincevic, Dino', 'TM', null, null, null, null, null, '3692', null, '12329');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1781', 'Graupner, Paul', 'BR', null, null, null, null, null, '4044', '73068439523', '1668');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1782', 'Cammalleri, Calogero', 'MA', null, null, null, null, null, '3697', null, '1178');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('492', 'Kubath, Bernd', 'LB', null, null, null, null, null, '3785', '04270485K050', '492');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12008', 'Hausemann, Oskar', 'LE', null, null, null, null, null, '3736', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1786', 'Fritz, Robert', 'H�', null, null, null, null, null, '3824', null, '1786');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('496', 'Wundersee, Carsten', 'SM', null, null, null, null, null, '3741', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('497', 'Franke, Tobias', 'AK', null, null, null, null, null, '3884', '25220598F002', '12334');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1787', 'Maletin, Marjan', 'TM', null, null, null, null, null, '3743', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1788', 'Meyer, Dane', 'TM', null, null, null, null, null, '3744', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1790', 'Schmidt, Jens', 'MA', null, null, null, null, null, '3769', null, '1179');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12062', 'Pobel, Heike', 'MT', null, null, null, null, null, '1952', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('429', 'Kohlmeyer, David', 'LB', null, null, null, null, null, '2499', '02051287K005', '421');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12218', 'Wesel, Matthias', 'PS', null, null, '030 / 74 005 200', '0173 / 63 80 200', null, '2219', null,
        '12218');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12220', 'Pettelkau, Susanne', 'GU', null, null, null, null, null, '2211', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12158', 'Nickel, Jasmin', 'MT', null, null, null, null, null, '2212', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('993599', 'Nachunternehmer Kst. 350 (Schonack)', 'CS', null, null, null, null, null, '2342', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('991299', 'Nachunternehmer (120)', 'MK', null, null, null, null, null, '2343', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('19000', 'Boeder, Cerstin (Michaelis Tiefbau GmbH)', 'TM', null, null, null, null, null, '2362', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('19001', 'Schulze, Thomas (Michaelis Tiefbau GmbH)', 'TM', null, null, null, null, null, '2363', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('19002', 'Kohl, Rainhard (Michaelis Tiefbau GmbH)', 'TM', null, null, null, null, null, '2364', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('19003', 'Keuthe, Manuela (Michaelis Tiefbau GmbH)', 'TM', null, null, null, null, null, '2365', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('19004', 'Lindermann, Dietmar (Michaelis TB GmbH)', 'TM', null, null, null, null, null, '2366', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('19008', 'Schmidt, Mario (MT)', 'TM', null, null, null, null, null, '2612', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('19009', 'Ritzmann, Uwe (MT)', 'TM', null, null, null, null, null, '2611', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('26', 'Boeder, Cerstin (alt)', 'TM', null, null, null, null, null, '2656', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('15', 'Boeder, Wolfgang', 'TS', null, null, null, '01778236498', null, '2734', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('14', 'Bolduan, Robert', 'TS', null, null, null, '015114577406', null, '2735', '25010892B027', '14');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('17', 'Bredereck, Michael', 'SP', null, null, null, '015114577407', null, '3973', '18290567B033', '17');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('16', 'Dilly, Michael', 'TS', null, null, null, '015114577408', null, '2750', '25110874D007', '16');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('28', 'Faack, Michael', 'SP', null, null, null, '017641572545', null, '3947', '26050167F015', '28');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('2', 'G�lpack, Baris', 'SP', null, null, null, null, null, '3994', '25220275G003', '2');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12', 'Kynast, Bernd', 'MS', null, null, null, '015229746294', null, '3054', '25050157K008', '1759');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('19', 'Michaelis, Tanja', 'TM', null, null, null, null, null, '2474', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('20', 'Pepke, Kai', 'TS', null, null, null, '017679736200', null, '2846', '25260593P001', '6');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('33', 'Quandt, Ronny', 'SP', null, null, null, '01738733089', null, '3996', '25290178Q005', '23');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('10', 'Quegwer, Mike', 'SP', null, null, null, '015114577410', null, '3998', '16151264Q002', '10');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('18', 'Mangraviti, Marko (ehem. Rei�mann)', 'YA', null, null, null, '015114577411', null, '4070',
        '25030671R007', '18');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('22', 'Ritzmann, J�rg-Peter', 'TS', null, null, null, '017648335132', null, '2861', '25220358R028', '10');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('6', 'Ritzmann, Uwe', 'SP', null, null, null, '015114577412', null, '3999', '25090366R011', '6');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('32', 'Schmidt, Dirk', 'SM', null, null, null, '015114577414', null, '3417', '38261269S014', '32');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('21', 'Schmidt, Mario', 'SP', null, null, null, '015114577413', null, '4000', '25050177S000', '21');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('23', 'Sch�nner, Ronny', 'SP', null, null, null, '015114577415', null, '4001', '25270967S045', '23');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('25', 'Schulze, Thomas (alt)', 'TM', null, null, null, null, null, '2653', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('35', 'Stapel, Paul (alt)', 'TS', null, null, null, '015114577416', null, '3683', '04040287S003', '35');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('433', 'Dellinger, Dennis', 'RT', null, null, null, null, null, '2570', '44180990D000', '433');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('993795', 'Bohrservice Berlin', 'TS', null, null, null, null, null, '2934', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('993794', 'Putbrese', 'TS', null, null, null, null, null, '2935', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('438', 'Schulze, Tom (neu)', 'TR', null, null, null, '01748507302', null, '2973', '44210290S003', '438');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1186', 'Erstfeld, Marc', 'CA', null, null, null, null, null, '3016', null, '12254');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12257', 'Litschko, Karl Sebastian', 'PS', null, null, null, null, null, '3034', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12265', 'Yalcin, Anke', 'GU', null, null, null, null, null, '3061', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1141', 'Fengels, Sascha Heinrich', 'CA', null, null, null, null, null, '3243', null, '1141');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1189', 'Sofia, Ioan Lucian', 'MA', null, null, null, null, null, '3768', null, '1174');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('460', 'Klemt, Matthias', 'KM', null, null, null, null, null, '3357', '49111169K007', '460');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12280', 'Lorenz, Diana Lara (ehem. Baja)', 'MT', null, null, null, null, null, '3861', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1769', 'Janus, Phillip', 'MW', null, null, null, null, null, '3781', null, '1769');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('483', 'Schultz, Thomas', 'NM', null, null, null, null, null, '3527', '44230687S047', '2');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12306', 'Jannicke, Marvin', 'RT', null, null, null, null, null, '3535', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1779', 'Reichmann, Jean', 'BR', null, null, null, null, null, '3630', '25140697D009', '1700');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('493', 'Kahlert, Tommy-Lee', 'DM', null, null, null, null, null, '4104', '44270299K029', '493');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('494', 'Mattner, Tobias', 'RT', null, null, null, null, null, '3770', null, '12128');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1791', 'Koparan, Ali-Erdem', 'MA', null, null, null, null, null, '3755', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('498', 'Kunde, Jeremy', 'RT', null, null, null, null, null, '3882', '44070497K003', '498');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1792', 'Wellmann, Heinz', 'MB', null, null, null, null, null, '3858', null, '12185');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12338', 'Reicheneder, Marc', 'DL', null, null, null, null, null, '3776', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1794', 'Bormann, Carsten', 'MA', null, null, null, null, null, '3815', null, '1794');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1038', 'Kopetz, Thomas Peter (neu)', 'LU', null, null, null, null, null, '3833', null, '12050');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12341', 'Patschke, Thomas', 'GU', null, null, null, null, null, '3798', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12342', 'Kupper, Justen Brian', 'PS', null, null, null, null, null, '3799', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12343', 'Kromat, Louis', 'PS', null, null, null, null, null, '3800', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12344', 'Wellnitz, Richard', 'PS', null, null, null, null, null, '3801', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('43', 'Bahlke, Sven', 'LB', null, null, null, null, null, '3907', '08110493B003', '440');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('44', 'Fernahl, Nils', 'DM', null, null, null, null, null, '4105', '25190496F005', '44');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12346', 'Gr�nboldt, Marvin', 'GU', null, null, null, null, null, '3805', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12347', 'Seydel, Leon', 'TM', null, null, null, null, null, '3806', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12348', 'Oertwig, Paul', 'TM', null, null, null, null, null, '3807', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('46', 'Koenig, Markus Paul (NEU)', 'LB', null, null, null, null, null, '3814', '04270100W004', '46');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12350', 'Reitzenstein, Sebastian', 'PS', null, null, null, null, null, '3826', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12351', 'Anticevic, Matea (NEU)', 'MT', null, null, null, null, null, '3827', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12352', 'Tas, Tugce', 'MT', null, null, null, null, null, '3830', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12214', 'Kierschke, Stephan', 'PO', null, null, null, null, null, '3863', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1054', 'Blarr, Jan-Philipp', 'MA', null, null, null, null, null, '3841', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1056', 'Al-Omari, Ahmad', 'MA', null, null, null, null, null, '3860', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('47', 'Elwalwal, Riyadh', 'DM', null, null, null, null, null, '3880', '25010587E019', '47');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12353', 'Heymann, Jan', 'PS', null, null, null, null, null, '3849', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1069', 'Fifielski, Pawel', 'MB', null, null, null, null, null, '3904', '13181292F029', '12185');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12354', 'Randel, Monika', 'LE', null, null, null, null, null, '3875', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1044', 'SPERRNUMMER!', 'GU', null, null, null, null, null, '3893', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1059', 'Pape, Dennis', 'MA', null, null, null, null, null, '4050', null, '1185');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12030', 'Alsleben, Thorsten', 'LE', null, null, null, null, null, '4014', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1099', 'Malgrab, Michael', 'MB', null, null, null, null, null, '4057', null, '12185');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1057', 'Hartwig, Markus', 'MA', null, null, null, null, null, '3903', '81110899H010', null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12357', 'Al-Taie, Anmar', 'TM', null, null, null, null, null, '3889', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1058', 'SPERRNUMMER!', 'GU', null, null, null, null, null, '3890', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1129', 'SPERRNUMMER!', 'GU', null, null, null, null, null, '3891', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('50', 'Riedel, Thomas', 'LB', null, null, null, null, null, '4007', null, '12045');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12358', 'Yakut, Salih', 'MA', null, null, null, null, null, '3895', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('49', 'Steinberg, Heiko', 'RT', null, null, null, null, null, '4094', '04201078S032', '419');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1045', 'Strohschen, Dirk Ingo', 'BR', null, null, null, null, null, '4033', '25150482S002', '1700');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('201', 'Bereitschaft Kst. 201', 'DW', null, null, null, null, null, '3911', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('257', 'Tyka, Christian (NUR Q3)', 'AS', null, null, null, null, null, '4030', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('52', 'Harm, Tobias (NEU)', 'H�', null, null, null, null, null, '4005', '04220784H005', '52');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1060', 'Nikke, Patryk', 'BR', null, null, null, null, null, '4012', null, '1700');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1041', 'Franke, Manuel', 'PO', null, null, null, null, null, '3989', '65210788F016', null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1064', 'Litschko, Karl Sebastian (NEU)', 'BR', null, null, null, null, null, '4046', null, '1668');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1075', 'Facciola, Luciano', 'BR', null, null, null, null, null, '4047', null, '1668');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('495', 'Algaber, Alaa', 'LD', null, null, null, null, null, '4052', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1098', 'Bier, Martin', 'MB', null, null, null, null, null, '4058', null, '12185');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1795', 'M�ller, Alexander', 'MA', null, null, null, null, null, '4059', null, '12270');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('258', 'Rakk, Evgenij (NUR Q3)', 'AS', null, null, null, null, null, '4103', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12124', 'H�rdler, Michael (12124)', 'PS', null, null, '030 / 74 005 182', '0173 / 63 80 182', null, '2143',
        null, '12124');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12211', 'Kalensee, Denny', 'GU', null, null, null, null, null, '1974', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('347', 'Richau, Sven', 'AM', null, null, null, null, null, '2240', '04240992R011', '397');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('0', 'AAA - unbekannter Truppf�hrer', 'LE', null, null, null, null, null, '2126', null, '0');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('340', 'Kujath, Christian', 'AM', null, null, null, null, null, '2243', '13070977K074', '12203');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('344', 'Kr�mer, Manuel', 'DM', null, null, null, '017661752675', null, '2807', '44281189K007', '344');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('320', 'Listing, Enrico', 'DW', null, null, null, null, null, '2292', '65250178L018', '381');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('341', 'Wostrack, Mario (neu)', 'RT', null, null, null, '015114577404', null, '3529', '25170894W029', '341');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1748', 'Ziemann, Daniel', 'B�', null, null, null, null, null, '2318', null, '1748');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12063', 'Raddatz, Sabine', 'MT', null, null, null, null, null, '2319', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12179', 'Ryl, Vanessa', 'MT', null, null, null, null, null, '2320', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12200', 'Liebig, Thorsten', 'DL', null, null, null, null, null, '2321', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12219', 'Scholz, Dennis', 'MT', null, null, null, null, null, '2322', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12208', 'Karasacli, Phillip', 'DL', null, null, null, null, null, '3067', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12206', 'Y�zg�lec, Berkay', 'MT', null, null, null, null, null, '2324', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('431', 'Riepelsiep, Bastian', 'RT', null, null, null, '01723471117', null, '3345', '25260589R029', '405');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1026', 'Henk, Henry', 'KM', null, null, null, null, null, '2456', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('993597', 'NU Kst. 350', 'KM', null, null, null, null, null, '2490', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12237', 'Schulze, Thomas (neu)', 'TS', null, null, null, null, null, '2654', null, '12237');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('27', 'Greitsch, Ralf', 'SP', null, '0', null, null, null, '3993', '38110971G003', '21');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12236', 'Linke, Konrad', 'DL', null, null, null, null, null, '2539', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1032', 'Neumann, Heinz', 'TM', null, null, null, null, null, '2540', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('30', 'Wegener, Normen', 'LD', null, null, null, '015114577400', null, '3944', '04260977W009', '30');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('338', 'Wiench, Jens', 'KM', null, null, null, null, null, '2948', null, '416');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('19011', 'Karrenf�hr, Domenick (Lindermann)', 'TM', null, null, null, null, null, '2981', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12271', 'Herrling, Benjamin', 'TM', null, null, null, null, null, '3142', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1097', 'Freiberg, Uwe', 'MT', null, null, null, null, null, '3146', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('450', 'Sedlak, Stephan (NUR Q3)', 'MS', null, null, null, null, null, '4016', '25270265S080', '450');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('471', 'Widder, Roland', 'KO', null, null, null, null, null, '3521', '66150364W016', '305');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('447', 'Gla�, Sven', 'RL', null, null, null, null, null, '3183', '25190578G005', '447');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('446', 'Erdem, Ali', 'TS', null, null, null, null, null, '3180', '25160882E006', '446');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1128', 'Ta Quang, Binh', 'LU', null, null, null, null, null, '3287', null, '12050');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12284', 'Schulz, Lars S�ren', 'SK', null, null, null, null, null, '3288', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('448', 'Suslik, Tim', 'MA', null, null, null, null, null, '3359', '44200994S009', null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('19013', 'Heese Julian', 'GU', null, null, null, null, null, '3378', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('472', 'Urbanczyk, Oskar', 'SP', null, null, null, null, null, '4002', '25210294U008', '473');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('473', 'Wendler, Detlef', 'AK', null, null, null, null, null, '3646', '04300465W010', '473');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('474', 'Vorbeck, Gerd', 'MK', null, null, null, null, null, '3541', '04130668V005', '305');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('475', 'Kotula, Michal Jozef', 'SP', null, null, null, null, null, '3995', '65080792K036', '478');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('476', 'R�sner, Henry', 'AK', null, null, null, null, null, '3647', '25191264R039', '479');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('477', 'Bielecki, Artur', 'SP', null, null, null, null, null, '3991', '26100871B086', '478');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('478', 'Urbanczyk, Waldemar', 'SP', null, null, null, null, null, '4003', '26190864U034', '478');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('479', 'Schauer, Bernd', 'AK', null, null, null, null, null, '3648', '23190266S168', '479');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('480', 'Reich, Nico', 'TR', null, null, null, null, null, '3533', '65210581R000', '480');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1174', 'Belmadani, Mohammed', 'MA', null, null, null, null, null, '3767', null, '1174');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1175', 'Ritter, Siegfried', 'MA', null, null, null, null, null, '3487', null, '12270');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1176', 'Jafari, Abdul Azim', 'MA', null, null, null, null, null, '3869', null, '1794');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12309', 'Kindsvater, Kristina', 'GU', null, null, null, null, null, '3584', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12326', 'Arik, Musa', 'LE', null, null, null, null, null, '3636', null, '12326');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12327', 'Essaleh, Yassine (alt)', 'TM', null, null, null, null, null, '3706', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12330', 'Schmidt, Rainer', 'DM', null, null, null, null, null, '3668', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12332', 'Lundie, Ole (NUR Q3)', 'TM', null, null, null, null, null, '4025', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12333', 'Taha, Layal (NUR Q3)', 'TM', null, null, null, null, null, '4026', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1784', 'K�hne, Leif-Erik', 'H�', null, null, null, null, null, '3739', null, '1784');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('499', 'Schaefer, Maximilian', 'AK', null, null, null, null, null, '3788', null, '12334');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1047', 'Vranic, Goran', 'HE', null, null, null, null, null, '3795', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12339', 'Ertel, Martin', 'PS', null, null, null, null, null, '3796', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12340', 'Schartner, Maik', 'WM', null, null, null, null, null, '4049', null, '12340');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('19015', 'Karrenf�hr, Lana (Lindermann)', 'TM', null, null, null, null, null, '3835', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12359', 'Boulahrouz, Azzeddine', 'MA', null, null, null, null, null, '3908', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12025', 'Jurga, Daniela', 'LE', null, null, null, null, null, '3917', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12029', 'Breier, Stefanie', 'LE', null, null, null, null, null, '4011', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('51', 'Meinke, Danny (NEU)', 'LD', null, null, null, null, null, '4008', '65100601H005', '12329');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1062', 'Maksimov, Andrej', 'MB', null, null, null, null, null, '4051', null, '12185');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1063', 'Scholz, Elia David', 'MB', null, null, null, null, null, '3979', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('48', 'Vieira da Costa, Marcel', 'SP', null, null, null, null, null, '4062', '25281195B023', '48');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('500', 'Becker, Rene', 'DM', null, null, null, null, null, '4055', null, '500');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12362', 'Giese, Fabrice', 'PS', null, null, null, null, null, '4114', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12363', 'Hauch, Niklas', 'PS', null, null, null, null, null, '4115', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12364', 'Lorenz, Sean Louis', 'TM', null, null, null, null, null, '4116', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12365', 'L�ngsfeld, Lars', 'TM', null, null, null, null, null, '4117', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12366', 'Diallo, Mamadou Saidou', 'TM', null, null, null, null, null, '4118', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12367', 'Alkan, Leonie Derya', 'MT', null, null, null, null, null, '4119', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('502', 'Pfeifer, Tom-Maikel', 'DM', null, null, null, null, null, '4120', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12207', 'Feragotti, Roberto', 'WM', null, null, null, '015781899453', null, '2758', null, '12036');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1739', 'Grell, Falk', 'MW', null, null, null, '015114577330', null, '2776', '04230477G007', '1739');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12212', 'Dieckmann, Gabriela', 'GU', null, null, null, null, null, '2012', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1744', 'Hollmann, Daniel', 'MB', null, null, null, '017663489357', null, '3080', '68140290H015', '12185');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('430', 'Obschernikat, Candy', 'LD', null, null, null, '015114577361', null, '3940', '25270178O024', '430');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12013', 'Tanev, Katrin', 'DL', null, null, null, null, null, '2317', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12231', 'Mei�ner, Kenny', 'KM', null, null, null, null, null, '2511', null, '12231');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('19006', 'Dittewig, Larissa (MT)', 'TM', null, null, null, null, null, '2614', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('19007', 'Lovrincevic, Dino (MT)', 'TM', null, null, null, null, null, '2613', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1752', 'Stelle, Norman', 'TM', null, null, null, null, null, '2377', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1180', 'Biskup, Matthias', 'MA', null, null, null, '01704131946', null, '3474', null, '1180');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1522', 'Albrecht, Thorsten', 'PO', null, null, null, null, null, '2590', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('437', 'Erxleben, Oliver', 'TR', null, null, null, '017684527696', null, '3126', '65030694E008', '437');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12244', 'K�nitz, Marcus', 'PS', null, null, null, null, null, '2592', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('993796', 'Nachunternehmer Kst. 370 (EFM)', 'TS', null, null, null, null, null, '2595', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('29', 'Cheff, Alex', 'DM', null, null, null, '01738255004', null, '2746', '25190890S019', '29');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12250', 'Voigt, Ingo', 'TM', null, null, null, null, null, '2923', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12260', 'Ryl, Wiebke', 'MT', null, null, null, null, null, '3048', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12261', 'Lehmann, Andre', 'MT', null, null, null, null, null, '3049', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12259', 'Winter, Sandra', 'MT', null, null, null, null, null, '3050', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12266', 'Liers, Rouven', 'PS', null, null, null, null, null, '3280', null, '12266');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('442', 'Langenick, Mike', 'RL', null, null, null, null, null, '3199', '65300593L005', '18');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1763', 'Bofinger, Maik', 'BR', null, null, null, null, null, '3089', null, '1763');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1037', 'Bruhnke, Rainer', 'MA', null, null, null, null, null, '3469', null, '12254');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1036', 'Bruhnke, Margit', 'MA', null, null, null, null, null, '3468', null, '12254');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12274', 'M�ller, Karsten', 'PS', null, null, null, null, null, '3195', null, '12274');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12275', 'Nagel, Anita', 'DL', null, null, null, null, null, '3201', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1140', 'Bloch, Christian', 'H�', null, null, null, null, null, '3878', '25110584B015', '1140');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('459', 'Berkholz, Ronny', 'KM', null, null, null, null, null, '3252', null, '459');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('160160', 'LWL Gro�beerenstr', 'H�', null, null, null, null, null, '3302', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('337', 'Sch�tt, Michael', 'SM', null, null, null, null, null, '3419', '25120187S042', '18');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12289', 'Jaworski, Viktoria', 'TM', null, null, null, null, null, '3318', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1767', 'De Vo�, Oliver', 'MK', null, null, null, null, null, '3306', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1061', 'Cule, Boris', 'HE', null, null, null, null, null, '4024', null, '12049');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12308', 'Jacob, Maria', 'DL', null, null, null, null, null, '3539', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1772', 'Scheppel, Kevin', 'MW', null, null, null, null, null, '3836', null, '1772');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12303', 'Tat, Ediz', 'ET', null, null, null, null, null, '4100', null, '12303');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('469', 'Ziemann, Steffen', 'KO', null, null, null, null, null, '3644', '04010685Z007', '469');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('470', 'Bork, Bj�rn', 'RT', null, null, null, null, null, '3926', '04260983B035', '305');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('481', 'Waschlewski, Sascha', 'LD', null, null, null, null, null, '4010', '25270986W011', '351');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12312', 'Harm, Tobias', 'GU', null, null, null, null, null, '3579', '04220784H005', null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1193', 'Urban, Thorsten', 'MA', null, null, null, null, null, '3870', null, '1794');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12331', 'Stapel, Paul', 'TM', null, null, null, null, null, '3972', null, '12331');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1121', 'Olma, Bernhard', 'MA', null, null, null, null, null, '3694', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1122', 'Yurt, Onur', 'MA', null, null, null, null, null, '3695', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1793', 'May, Maurice Oliver', 'WM', null, null, null, null, null, '3931', '44291195M013', '1753');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12027', 'Heinrich, Dieter', 'LU', null, null, null, null, null, '3980', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1042', 'Werner, G�r�me', 'BR', null, null, null, null, null, '4043', null, '1668');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('41', 'Timm, Sebastian', 'TR', null, null, null, null, null, '3871', '65020490T006', '41');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12028', 'Marschel, Fabian', 'LE', null, null, null, null, null, '3982', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1084', 'F�hring, Rainer', 'MA', null, null, null, null, null, '4107', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1796', 'Deuster, Florian', 'MA', null, null, null, null, null, '4109', null, '1796');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('501', 'Faust, Lukas', 'LB', null, null, null, null, null, '4111', null, '501');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1797', 'Urban, David', 'MB', null, null, null, null, null, '4112', null, '12185');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1798', 'Petersen, Stefan', 'MB', null, null, null, null, null, '4113', null, '12185');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('309', 'Dunkel, Andreas', 'AM', null, null, null, null, null, '2316', '04011173D009', '309');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1524', 'Ehrlich, Alexander', 'PO', null, null, null, '01739989152', null, '2753', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12226', 'Busch, Mandy (NUR Q3)', 'MT', null, null, null, null, null, '4021', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12227', 'Heidenreich, Marc', 'WM', null, null, null, '015227972454', null, '2780', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12228', 'Petras, Tommy', 'BR', null, null, null, '017627000868', null, '3015', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12229', 'Oesterling, Finn (ALT)', 'MK', null, null, null, '015123456550', null, '3400', null, '1008');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('19005', 'Stapel, Paul (Michaelis Tiefbau GmbH)', 'TM', null, null, null, null, null, '2368', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1182', 'Cas, Alexander', 'UH', null, null, null, '015114577040', null, '2745', null, '1182');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12205', 'Bierend, Marco', 'MT', null, null, null, null, null, '2554', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12075', 'Ott, Marie', 'MT', null, null, null, null, null, '2555', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12076', 'Krause, Xenia', 'MT', null, null, null, null, null, '2556', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1757', 'Kandler, Matthias', 'BR', null, null, null, '01751592030', null, '3719', '25240383K056', '1757');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('490', 'Schulz, Thomas (NUR Q3)', 'MS', null, null, null, null, null, '4020', null, '452');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12253', 'Hamada, Ihab', 'LU', null, null, null, null, null, '2955', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('10739', 'Lagerplatz Gro� Kienitz', 'PO', null, null, null, null, null, '2952', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12252', 'Riesebeck, Bj�rn', 'BR', null, null, null, null, null, '3158', null, '12252');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('19012', 'J�hrig, Caroline (Lindemann)', 'TM', null, null, null, null, null, '2982', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('439', 'Teuber, Kevin', 'RL', null, null, null, null, null, '3198', '25171289T008', '32');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12264', 'Kiesel, Viola', 'DL', null, null, null, null, null, '3041', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1052', 'Mei�ner, Martin', 'MK', null, null, null, null, null, '3366', '49260484M048', '1737');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1093', 'Kimmich, Hans (neu)', 'LU', null, null, null, null, null, '3412', null, '12050');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1765', 'Schmidt, Ingo', 'BR', null, null, null, null, null, '3113', null, '1765');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1539', 'Viehmann, Dirk', 'PO', null, null, null, null, null, '3985', '10060766V029', null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1783', 'Blarr, Ulrich', 'MA', null, null, null, null, null, '3710', null, '1178');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('491', 'Mangraviti, Massimo', 'SM', null, null, null, null, null, '3699', null, '18');
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12024', 'Riesebeck, Nicole', 'PS', null, null, null, null, null, '3793', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('12026', 'Arens, Torben Dieter', 'MB', null, null, null, null, null, '3975', null, null);
Insert into QFMTEST.HA_BAUTRUPP (TRUPP_KZ, NAME, BAULEITER_KZ, KOSTENSTELLE, JAHRESVORTRAG, TELEFON, MOBIL, TARIFART,
                                 ROWVERSION, SOZVERS_NR, TRUPPFUEHRER)
values ('1065', 'Luchowski, Axel', 'BR', null, null, null, null, null, '4045', null, '1668');
--------------------------------------------------------
--  DDL for Index QST103039
--------------------------------------------------------

CREATE UNIQUE INDEX "QFMTEST"."QST103039" ON "QFMTEST"."BENUTZER" ("USERNAME")
    PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
    STORAGE (INITIAL 106496 NEXT 106496 MINEXTENTS 1 MAXEXTENTS 2147483645
    PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)
    TABLESPACE "QFMTEST";
--------------------------------------------------------
--  DDL for Index QST3211849
--------------------------------------------------------

CREATE UNIQUE INDEX "QFMTEST"."QST3211849" ON "QFMTEST"."HA_BAULEITER" ("KZ")
    PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
    STORAGE (INITIAL 106496 NEXT 106496 MINEXTENTS 1 MAXEXTENTS 2147483645
    PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)
    TABLESPACE "QFMTEST";
--------------------------------------------------------
--  DDL for Index QST3389476
--------------------------------------------------------

CREATE UNIQUE INDEX "QFMTEST"."QST3389476" ON "QFMTEST"."HA_BAUTRUPP" ("TRUPP_KZ")
    PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
    STORAGE (INITIAL 106496 NEXT 106496 MINEXTENTS 1 MAXEXTENTS 2147483645
    PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)
    TABLESPACE "QFMTEST";
--------------------------------------------------------
--  Constraints for Table BENUTZER
--------------------------------------------------------

ALTER TABLE "QFMTEST"."BENUTZER"
    MODIFY ("USERNAME" NOT NULL ENABLE);

ALTER TABLE "QFMTEST"."BENUTZER"
    MODIFY ("PASSWORT" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table BENUTZERGRP
--------------------------------------------------------

ALTER TABLE "QFMTEST"."BENUTZERGRP"
    MODIFY ("USERNAME" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table HA_BAULEITER
--------------------------------------------------------

ALTER TABLE "QFMTEST"."HA_BAULEITER"
    MODIFY ("KZ" NOT NULL ENABLE);

ALTER TABLE "QFMTEST"."HA_BAULEITER"
    MODIFY ("NAME" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table HA_BAUTRUPP
--------------------------------------------------------

ALTER TABLE "QFMTEST"."HA_BAUTRUPP"
    MODIFY ("TRUPP_KZ" NOT NULL ENABLE);

ALTER TABLE "QFMTEST"."HA_BAUTRUPP"
    MODIFY ("NAME" NOT NULL ENABLE);

ALTER TABLE "QFMTEST"."HA_BAUTRUPP"
    MODIFY ("BAULEITER_KZ" NOT NULL ENABLE);
