select 'insert into invoice(
 ID, CREATED_ON, UPDATED_ON, DELETED_ON, CREATED_BY, UPDATED_BY, DELETED_BY, ENTITY_STATE, ROW_VERSION, NAME, STATE,
 INVOICE_TYPE, INVOICE_TYPE_COMMENT,
 QUOTATION_ID, INVOICE_NUMBER, COMMISSION_NUMBER,
 INTERNAL_NUMBER, INTERNAL_PARTIAL_NUMBER, CUMULATIVE_NUMBER,
 COST_CENTER, CONSTRUCTION_PERIOD_START_ON, CONSTRUCTION_PERIOD_END_ON,
 INVOICE_CUSTOMER_ID, invoice_name_1,invoice_name_2,invoice_street,invoice_zip,invoice_city,invoice_country,
 INVOICE_REF_CUSTOMER_ID, invoice_ref_name_1,invoice_ref_name_2,invoice_ref_street,invoice_ref_zip,invoice_ref_city,invoice_ref_country,
 REFERENCE_ID, INVOICE_STATE, PAYMENT_CONDITIONS,
 PRIMARY_RESPONSIBLE_USER_ID, ACCOUNTED_BY_USER_ID, PRINTED_BY_USER_ID, ASSIGNED_SQUAD_ID,
 INVOICE_DATE, POSTING_DATE, ORDER_NUMBER, ORDER_DATE,
 CONSTRUCTION_SITE, PROJECT_EXECUTION_START_DATE, PROJECT_EXECUTION_END_DATE,
 ADDITIONAL_INFO_HEADER_1, ADDITIONAL_INFO_DETAIL_1, ADDITIONAL_INFO_HEADER_2, ADDITIONAL_INFO_DETAIL_2, ADDITIONAL_INFO_HEADER_3, ADDITIONAL_INFO_DETAIL_3,
 ATTACHMENTS, FOOTER_TEXT, finance_vat, finance_value_overall_net, finance_value_overall_vat, finance_value_overall_gross, finance_value_security_ret_net, finance_value_discount_net
)
values(invoice_seq.nextval, sysdate, sysdate, null, ''import'', ''import'', null, ''VALID'', 0, ''name'', ''status'',
 decode(''' || kz_rg_art || ''',
 ''SCHLRG'', ''FINAL_INVOICE'',
 ''KUMSCHLRG'', ''FINAL_INVOICE'',
 ''TLRG'', ''PARTIAL_INVOICE'',
 ''KUMTSCHLRG'', ''PARTIAL_FINAL_INVOICE'',
 ''KUMTLRG'', ''PARTIAL_INVOICE'',
 ''TLSCHLRG'', ''PARTIAL_FINAL_INVOICE'',
 ''INVOICE'' ), ''' || rg_art_bez || ''',
 (select max(id) from quotation where quotation_number = ''' || a.angebotsnr || '''), ''' || lfd_rg_nr || ''', ''' ||
       a.kommissionsnr || ''',
 ''' || a.fi_belegnr_int || ''', 0, ' || kumulationsnr || ',
 ''' || kst || ''', ' ||
       'to_date(''' || to_char(ausfuehrung_von, 'dd.mm.yyyy') || ''', ''dd.mm.yyyy'') ' || ', ' ||
       'to_date(''' || to_char(ausfuehrung_bis, 'dd.mm.yyyy') || ''', ''dd.mm.yyyy'') ' || ', null, ''' ||
       rg_name1 || ''', ''' || rg_name2 || ''' , ''' ||
       rg_strasse || ''', ''' || rg_plz || ''', ''' ||
       rg_ort || ''', '''' ,
 null, ''' || ueber_rg_name1 || ''', ''' || ueber_rg_name2 || ''' , ''' ||
       ueber_rg_strasse || ''', ''' || ueber_rg_plz || ''', ''' ||
       ueber_rg_ort || ''', '''' ,
 ''' || kommissionsnr || '/' || rg_nr || ''', ''ACCOUNTED'', ''' || fi_faelligkeit || ''',
 null, null, null,
 nvl((select id from sys_user where personal_number like ''' || zusatztext4 || '''), 324), ' ||
       'to_date(''' || to_char(rg_datum, 'dd.mm.yyyy') || ''', ''dd.mm.yyyy'') ' || ', ' ||
       'to_date(''' || to_char(fibu_datum, 'dd.mm.yyyy') || ''', ''dd.mm.yyyy'') ' || ', ''' ||
       bestellnr || ''', ' ||
       'to_date(''' || to_char(bestelldatum, 'dd.mm.yyyy') || ''', ''dd.mm.yyyy'') ' || ', ''' || baustelle || ''', ' ||
       'to_date(''' || to_char(ausfuehrung_von, 'dd.mm.yyyy') || ''', ''dd.mm.yyyy'') ' || ', ' ||
       'to_date(''' || to_char(ausfuehrung_bis, 'dd.mm.yyyy') || ''', ''dd.mm.yyyy'') ' || ', ''' ||
       titel_zusatztext1 || ''', ''' || replace(zusatztext1, '''', '') || ''', ''' ||
       titel_zusatztext2 || ''', ''' || replace(zusatztext2, '''', '') || ''', ''' ||
       titel_zusatztext3 || ''', ''' || replace(zusatztext3, '''', '') || ''', ''' || fusstext || ''', ''' || fusstext || ''', ' ||
       to_char(nvl2(mwst, mwst, 0) * 100, 'FM9999990.00') || ', ' ||
       to_char(nvl2(gesamt_netto, gesamt_netto, 0), 'FM9999990.00') || ', ' ||
       to_char(nvl2(gesamt_brutto, gesamt_brutto, 0) - nvl2(gesamt_netto, gesamt_netto, 0), 'FM9999990.00') || ', ' ||
       to_char(nvl2(gesamt_brutto, gesamt_brutto, 0), 'FM9999990.00') || ', ' ||
       '0.00' || ', ' ||
       to_char(nvl2(gesamt_preis_rab, gesamt_preis_rab, 0) - nvl2(gesamt_netto, gesamt_netto, 0), 'FM9999990.00') ||
       ');'
from fr_aufmass a
;


-- apply invoice_ids to measurement
create table temp_invoice_measurement as (select m.id                                           as measurement_id,
                                                 q.commission_number || '/' || m.invoice_number as measurement_invoice_number,
                                                 i.id                                           as invoice_id
                                          from measurement m
                                                   left join quotation q on m.quotation_id = q.id
                                                   left join invoice i
                                                             on  i.reference_id = q.commission_number || '/' || m.invoice_number);

select *
From temp_invoice_measurement;
create unique index UIDX_T_M_I on temp_invoice_measurement (measurement_id);

update measurement m
set m.invoice_id = (select t.invoice_id from temp_invoice_measurement t where t.measurement_id = m.id);

drop table temp_invoice_measurement;

-- apply calculated measurementnumbers to invoice
update invoice i
set i.calculated_measurement_numbers =
        (select LISTAGG(m.measurement_number, ', ') WITHIN GROUP (ORDER BY measurement_number)
         from measurement m
         where m.invoice_id = i.id)
;

-- create measurement reference(s)
insert into INVOICE_MEASUREMENT (id, created_by, created_on, updated_by, updated_on, entity_state, row_version,
                                 invoice_id, measurement_id)
    (select INVOICE_MEASUREMENT_SEQ.nextval,
            'import',
            sysdate,
            'import',
            sysdate,
            'VALID',
            0,
            invoice_id,
            id
     from measurement);

delete From INVOICE_MEASUREMENT where invoice_id IS NULL or measurement_id IS NULL;


insert into INVOICE_POSITION(ID, CREATED_ON, CREATED_BY, UPDATED_ON, UPDATED_BY, ENTITY_STATE, ROW_VERSION,
                             INVOICE_POSITION_TYPE,
                             INVOICE_ID, MEASUREMENT_POSITION_ID, SEQUENCE_NUMBER,
                             POSITION_NUMBER, AMOUNT, factor_1, factor_2, factor_3, PRODUCT, UNIT, short_text, remarks,
                             mat_purchase_price_per_unit, mat_purchase_price_agg, mat_selling_price_per_unit,
                             mat_selling_price_agg,
                             material_factor, price_per_unit, price_aggregated,
                             addendum_number, discount, discount_value_aggregated, price_aggregated_with_discount)
    (select INVOICE_POSITION_SEQ.nextval,
            sysdate,
            'import',
            sysdate,
            'import',
            'VALID',
            0,
            'MEASUREMENT_POSITION',
            m.invoice_id,
            mp.id,
            mp.SEQ_NUMBER_MEASURE_STANDARD,
            mp.SURROGATE_POSITION_NUMBER,
            mp.AMOUNT,
            mp.FACTOR_1,
            mp.FACTOR_2,
            mp.FACTOR_3,
            mp.PRODUCT,
            mp.unit,
            mp.short_text,
            mp.remarks,
            mp.MAT_PURCHASE_INC_DISC_PER_UNIT,
            mp.MAT_PURCHASE_INC_DISC_AGG,
            mp.mat_selling_price_per_unit,
            mp.mat_selling_price_agg,
            mp.material_factor,
            mp.price_per_unit,
            mp.price_aggregated,
            mp.addendum_number,
            null,
            null,
            null
     from measurement_position mp
              left join MEASUREMENT m on mp.MEASUREMENT_ID = m.id);


delete from INVOICE_POSITION where invoice_id IS NULL;


select *
From fr_aufmass
where teilrg_nr = '999999';
select fi_belegnr_int, count(*)
From fr_aufmass
group by fi_belegnr_int
having count(*) > 1;

select teilrg_nr
from fr_aufmass
where fi_belegnr_int = '4158/300-00152';


select 'update invoice set
 finance_vat = ' || to_char(nvl2(mwst, mwst, 0) * 100, 'FM9999990.00') || ',
 finance_value_overall_net = ' || to_char(nvl2(gesamt_netto, gesamt_netto, 0), 'FM9999990.00') || ',
 finance_value_overall_vat = ' ||
       to_char(nvl2(gesamt_brutto, gesamt_brutto, 0) - nvl2(gesamt_netto, gesamt_netto, 0), 'FM9999990.00') || ',
 finance_value_overall_gross = ' || to_char(nvl2(gesamt_brutto, gesamt_brutto, 0), 'FM9999990.00') || ',
 finance_value_security_ret_net = 0.00,
 finance_value_discount_net = ' ||
       to_char(nvl2(gesamt_preis_rab, gesamt_preis_rab, 0) - nvl2(gesamt_netto, gesamt_netto, 0), 'FM9999990.00') || '
 where invoice_number = ''' || lfd_rg_nr || ''';'
from fr_aufmass a
WHERE lfd_rg_nr IS NOT NULL AND length(lfd_rg_nr) > 0;

select 'update invoice set
 finance_cost_unit = ' || FI_KOSTENTRAEGER || ',
 finance_value_overall_net = ' || to_char(nvl2(gesamt_netto, gesamt_netto, 0), 'FM9999990.00') || ',
 finance_value_material_wsp = ' || to_char(nvl2(gesamt_mat_ek, gesamt_mat_ek, 0), 'FM9999990.00') || ',
 finance_cash_discount_time_1 = ' || to_char(nvl2(FI_SKONTOFRIST1, FI_SKONTOFRIST1, 0), 'FM9999990.00') || ',
 finance_cash_discount_1 = ' || to_char(100 * nvl2(FI_SKONTOPROZ1, FI_SKONTOPROZ1, 0), 'FM9999990.00') || ',
 finance_cash_discount_time_2 = ' || to_char(nvl2(FI_SKONTOFRIST2, FI_SKONTOFRIST2, 0), 'FM9999990.00') || ',
 finance_cash_discount_2 = ' || to_char(100 * nvl2(FI_SKONTOPROZ2, FI_SKONTOPROZ2, 0), 'FM9999990.00') || '
 where invoice_number = ''' || lfd_rg_nr || ''';'
from fr_aufmass a
WHERE lfd_rg_nr IS NOT NULL AND length(lfd_rg_nr) > 0;

