/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.validator.user;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.common.request.user.EmployeeContractModificationItem;
import de.qfm.erp.common.request.user.UserCostCenterModificationItem;
import de.qfm.erp.common.request.user.UserUpdateRequest;
import de.qfm.erp.service.model.exception.request.DuplicationException;
import de.qfm.erp.service.model.exception.request.RequestValidationException;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.validator.user.UserUpdateRequestValidator;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import org.springframework.stereotype.Service;

@Service
public class UserUpdateDateOverlappingRequestValidator
extends UserUpdateRequestValidator {
    private static final Joiner J = Joiner.on((String)",").skipNulls();

    public boolean validate(@NonNull User user, @NonNull UserUpdateRequest userUpdateRequest) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (userUpdateRequest == null) {
            throw new NullPointerException("userUpdateRequest is marked non-null but is null");
        }
        List userCostCenters = (List)MoreObjects.firstNonNull((Object)userUpdateRequest.getUserCostCenters(), (Object)ImmutableList.of());
        List userCostCenterValidFromDates = (List)userCostCenters.stream().map(UserCostCenterModificationItem::getValidBegin).collect(ImmutableList.toImmutableList());
        Iterable duplicateCostCenterDates = this.findDuplicates((Iterable)userCostCenterValidFromDates);
        if (!Iterables.isEmpty((Iterable)duplicateCostCenterDates)) {
            String duplicateDatesAsString = this.duplicatesAsString(duplicateCostCenterDates);
            String msg = String.format("Cost Center Duplicate Date(s): %s", duplicateDatesAsString);
            throw new DuplicationException(msg, List.of(RequestValidationException.Detail.of((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.USER__COST_CENTER__VALID_BEGIN), (Object)duplicateDatesAsString, (String)msg, (Message)Message.of((EMessageKey)EMessageKey.DUPLICATE_USER_COST_CENTER__VALID_BEGIN, (String)duplicateDatesAsString), List.of())));
        }
        List employeeContracts = (List)MoreObjects.firstNonNull((Object)userUpdateRequest.getEmployeeContracts(), (Object)ImmutableList.of());
        List userContractsValidBeginDates = (List)employeeContracts.stream().map(EmployeeContractModificationItem::getValidBegin).collect(ImmutableList.toImmutableList());
        Iterable duplicateContractDates = this.findDuplicates((Iterable)userContractsValidBeginDates);
        if (!Iterables.isEmpty((Iterable)duplicateContractDates)) {
            String duplicateDatesAsString = this.duplicatesAsString(duplicateCostCenterDates);
            String msg = String.format("Contract Duplicate Date(s): %s", duplicateDatesAsString);
            throw new DuplicationException(msg, List.of(RequestValidationException.Detail.of((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.USER__EMPLOYEE_CONTRACTS__VALID_BEGIN), (Object)duplicateDatesAsString, (String)msg, (Message)Message.of((EMessageKey)EMessageKey.DUPLICATE_EMPLOYEE_CONTRACT__VALID_BEGIN, (String)duplicateDatesAsString), List.of())));
        }
        return true;
    }

    @NonNull
    private String duplicatesAsString(@NonNull Iterable<LocalDate> duplicateCostCenterDates) {
        if (duplicateCostCenterDates == null) {
            throw new NullPointerException("duplicateCostCenterDates is marked non-null but is null");
        }
        return J.join((Iterable)Streams.stream(duplicateCostCenterDates).filter(Objects::nonNull).map(DateTimeHelper::toIsoDate).collect(ImmutableSet.toImmutableSet()));
    }

    @NonNull
    public Iterable<LocalDate> findDuplicates(@NonNull Iterable<LocalDate> candidates) {
        if (candidates == null) {
            throw new NullPointerException("candidates is marked non-null but is null");
        }
        ImmutableSet.Builder duplicatesBuilder = ImmutableSet.builder();
        HashSet<LocalDate> temp = new HashSet<LocalDate>();
        for (LocalDate candidate : candidates) {
            if (temp.add(candidate)) continue;
            duplicatesBuilder.add((Object)candidate);
        }
        return duplicatesBuilder.build();
    }
}

