/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.validator.payroll;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import de.qfm.erp.service.model.exception.request.UpdateRejectException;
import de.qfm.erp.service.model.internal.employee.StageWage;
import de.qfm.erp.service.model.internal.employee.payroll.PayrollStateChangeBucket;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.model.jpa.employee.payroll.EPayrollMonthState;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.service.service.MessageService;
import de.qfm.erp.service.service.validator.payroll.PayrollBeforeStateChangeValidator;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.NonNull;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=100)
public class PayrollStateChangeQuotationAmountNegativeValidator
extends PayrollBeforeStateChangeValidator {
    private static final Joiner.MapJoiner QUOTATION_WAGES_JOINER = Joiner.on((String)", ").withKeyValueSeparator(": ");
    private final MessageService messageService;

    public boolean validate(@NonNull PayrollStateChangeBucket stateChangeBucket) {
        Iterable stageWages;
        Map availableStageWages;
        Map stageWagesWithNegativeAmount;
        EPayrollMonthState stateOld;
        if (stateChangeBucket == null) {
            throw new NullPointerException("stateChangeBucket is marked non-null but is null");
        }
        PayrollMonth payrollMonth = stateChangeBucket.getPayrollMonth();
        EPayrollMonthState stateNew = stateChangeBucket.getPayrollMonthStateNew();
        if (!Objects.equals(stateNew, stateOld = payrollMonth.getPayrollMonthState()) && !(stageWagesWithNegativeAmount = Maps.filterValues((Map)(availableStageWages = (Map)Streams.stream((Iterable)(stageWages = stateChangeBucket.getStageWages())).collect(ImmutableMap.toImmutableMap(StageWage::getQuotationNumber, StageWage::getWageAvailableOverallSum))), item -> item.compareTo(BigDecimal.ZERO) < 0)).isEmpty()) {
            String stageWithNegativeAmountString = QUOTATION_WAGES_JOINER.join(stageWagesWithNegativeAmount);
            String stateOldTranslated = this.messageService.getDE((Translatable)stateOld, new Object[0]);
            String stateNewTranslated = this.messageService.getDE((Translatable)stateNew, new Object[0]);
            throw new UpdateRejectException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PAYROLL_MONTH__STATE), (Object)stateNew, String.format("Payroll Month State cannot be changed from: %s to %s, the Stage with negative available Money: %s", stateOld, stateNew, stageWithNegativeAmountString), Message.of((EMessageKey)EMessageKey.RULE_PAYROLL_MONTH_STATE_CHANGE__QUOTATION_WITH_NEGATIVE_WAGE, (List)ImmutableList.of((Object)stateOldTranslated, (Object)stateNewTranslated, (Object)stageWithNegativeAmountString)));
        }
        return true;
    }

    public PayrollStateChangeQuotationAmountNegativeValidator(MessageService messageService) {
        this.messageService = messageService;
    }
}

