/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.validator.payroll;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.qfm.erp.common.request.employee.payroll.PayrollItemUpdateItem;
import de.qfm.erp.service.helper.BigDecimalHelper;
import de.qfm.erp.service.model.exception.request.UpdateRejectException;
import de.qfm.erp.service.model.internal.employee.payroll.PayrollMonthItemUpdateBucket;
import de.qfm.erp.service.model.internal.employee.payroll.PayrollMonthUpdateBucket;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonthItem;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.validator.payroll.PayrollBeforeMergeValidator;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=5)
public class PayrollOverChargeIncentivePayrollItemValidator
extends PayrollBeforeMergeValidator {
    public boolean validate(@NonNull PayrollMonthUpdateBucket updateBucket) {
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        PayrollMonth payrollMonth = updateBucket.getPayrollMonth();
        User user = payrollMonth.getUser();
        Iterable wageAccountItemsUpdateBuckets = updateBucket.getWageAccountItemsUpdateBuckets();
        Iterable incentivePayrollItemsBuckets = updateBucket.getIncentivePayrollItemsBuckets();
        Iterable allIncentivePayments = updateBucket.getIncentivePaymentsAssignedToPayroll();
        ImmutableList receivedIncentives = (ImmutableList)Streams.stream((Iterable)allIncentivePayments).filter(item -> !item.getSender().equals((Object)user)).collect(ImmutableList.toImmutableList());
        ImmutableListMultimap receivedIncentivesByStage = Multimaps.index((Iterable)receivedIncentives, PayrollMonthItem::getQuotation);
        HashMap wageAccountOpsByStage = Maps.newHashMap();
        for (Object wageAccountItemsUpdateBucket : wageAccountItemsUpdateBuckets) {
            BigDecimal valueInReceived;
            Quotation stage = wageAccountItemsUpdateBucket.getQuotation();
            PayrollItemUpdateItem payrollItemUpdateItem = wageAccountItemsUpdateBucket.getPayrollItemUpdateItem();
            BigDecimal value = (BigDecimal)MoreObjects.firstNonNull((Object)payrollItemUpdateItem.getValue(), (Object)BigDecimal.ZERO);
            BigDecimal valueOverall = value.add(valueInReceived = receivedIncentivesByStage.get((Object)stage).stream().map(PayrollMonthItem::getValue).reduce(BigDecimal.ZERO, BigDecimal::add));
            if (valueOverall.compareTo(BigDecimal.ZERO) >= 0) continue;
            BigDecimal existing = wageAccountOpsByStage.getOrDefault(stage, BigDecimal.ZERO);
            wageAccountOpsByStage.put(stage, existing.add(valueOverall.negate()));
        }
        HashMap incentiveByStageId = Maps.newHashMap();
        for (PayrollMonthItemUpdateBucket bucket : incentivePayrollItemsBuckets) {
            Quotation stage = bucket.getQuotation();
            PayrollItemUpdateItem payrollItemUpdateItem = bucket.getPayrollItemUpdateItem();
            BigDecimal value = (BigDecimal)MoreObjects.firstNonNull((Object)payrollItemUpdateItem.getValue(), (Object)BigDecimal.ZERO);
            BigDecimal existing = incentiveByStageId.getOrDefault(stage, BigDecimal.ZERO);
            incentiveByStageId.put(stage, existing.add(value));
        }
        HashSet underChargedStages = Sets.newHashSet();
        Set wageAccountStages = wageAccountOpsByStage.keySet();
        for (Quotation stage : wageAccountStages) {
            BigDecimal incentiveValue;
            BigDecimal wageAccountValue = wageAccountOpsByStage.getOrDefault(stage, BigDecimal.ZERO);
            if (wageAccountValue.compareTo(incentiveValue = incentiveByStageId.getOrDefault(stage, BigDecimal.ZERO)) <= 0) continue;
            underChargedStages.add(Triple.of((Object)stage, (Object)wageAccountValue, (Object)incentiveValue));
        }
        if (!underChargedStages.isEmpty()) {
            ImmutableList collect = (ImmutableList)underChargedStages.stream().map(item -> String.format("%s: %s", ((Quotation)item.getLeft()).getQuotationNumber(), BigDecimalHelper.asString((BigDecimal)((BigDecimal)item.getMiddle())))).collect(ImmutableList.toImmutableList());
            String messageDetail = StringUtils.join((Iterable)collect, (String)"; ");
            throw new UpdateRejectException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PAYROLL_MONTH_ITEM__WAGE_ACCOUNT__VALUE), (Object)"", String.format("Rule Validation Error: Payroll Month cannot be updated, the payout(s): %s exceeds available amount", messageDetail), Message.of((EMessageKey)EMessageKey.RULE_PAYROLL_MONTH__WAGE_ACCOUNT__ABOVE_AVAILABLE_IN_STAGE, (List)ImmutableList.of((Object)messageDetail)));
        }
        return true;
    }
}

