/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.validator.payroll;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import de.qfm.erp.common.request.employee.payroll.PayrollItemUpdateItem;
import de.qfm.erp.service.model.exception.request.UpdateRejectException;
import de.qfm.erp.service.model.internal.employee.payroll.PayrollMonthItemUpdateBucket;
import de.qfm.erp.service.model.internal.employee.payroll.PayrollMonthUpdateBucket;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollItemType;
import de.qfm.erp.service.model.jpa.generic.DictionaryItem;
import de.qfm.erp.service.model.jpa.history.type.EEntityClass;
import de.qfm.erp.service.service.handler.DictionaryItemHandler;
import de.qfm.erp.service.service.validator.payroll.PayrollBeforeMergeValidator;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=1)
public class PayrollMonthAuxiliaryWageRemarkMandatoryValidator
extends PayrollBeforeMergeValidator {
    public static final Joiner MESSAGE_JOINER = Joiner.on((char)',').skipNulls();
    private final DictionaryItemHandler dictionaryItemHandler;

    public boolean validate(@NonNull PayrollMonthUpdateBucket updateBucket) {
        String payrollItemTypesMissingNamesJoined;
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        Iterable auxiliaryWagePayrollItemsBuckets = updateBucket.getAuxiliaryWagePayrollItemsBuckets();
        ImmutableList.Builder payrollItemRemarksMissingBuilder = ImmutableList.builder();
        ImmutableList.Builder payrollItemRemarksNotInDictionaryBuilder = ImmutableList.builder();
        for (PayrollMonthItemUpdateBucket auxiliaryWagePayrollItemsBucket : auxiliaryWagePayrollItemsBuckets) {
            PayrollItemType payrollItemType = auxiliaryWagePayrollItemsBucket.getPayrollItemType();
            PayrollItemUpdateItem payrollItemUpdateItem = auxiliaryWagePayrollItemsBucket.getPayrollItemUpdateItem();
            String remarks = payrollItemUpdateItem.getRemarks();
            if (null == payrollItemType) continue;
            boolean remarksMandatory = Objects.equals(payrollItemType.getFlagRemarksMandatory(), Boolean.TRUE);
            boolean remarksFromDictionary = Objects.equals(payrollItemType.getFlagRemarksFromDictionary(), Boolean.TRUE);
            boolean remarkIsBlank = StringUtils.isBlank((CharSequence)remarks);
            if (remarksFromDictionary && !remarkIsBlank) {
                Long id = payrollItemType.getId();
                Iterable dictionaryItems = this.dictionaryItemHandler.allForEntity(EEntityClass.PAYROLL_ITEM_TYPE, id.longValue(), "", false);
                ImmutableSet availableValues = (ImmutableSet)Streams.stream((Iterable)dictionaryItems).map(DictionaryItem::getName).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
                if (availableValues.contains((Object)remarks)) continue;
                payrollItemRemarksNotInDictionaryBuilder.add((Object)Pair.of((Object)payrollItemType, (Object)remarks));
                continue;
            }
            if (!remarksMandatory || !remarkIsBlank) continue;
            payrollItemRemarksMissingBuilder.add((Object)payrollItemType);
        }
        ImmutableList payrollItemTypesMissingRemark = payrollItemRemarksMissingBuilder.build();
        ImmutableList payrollItemRemarksNotInDictionary = payrollItemRemarksNotInDictionaryBuilder.build();
        if (!payrollItemTypesMissingRemark.isEmpty()) {
            ImmutableSet payrollItemTypesMissingNames = (ImmutableSet)payrollItemTypesMissingRemark.stream().map(PayrollItemType::getName).collect(ImmutableSet.toImmutableSet());
            payrollItemTypesMissingNamesJoined = MESSAGE_JOINER.join((Iterable)payrollItemTypesMissingNames);
            throw new UpdateRejectException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PAYROLL_MONTH_ITEM__AUXILIARY_WAGE__REMARK), (Object)payrollItemTypesMissingNamesJoined, String.format("Payroll Month cannot be updated, auxiliary wages require a remark set for: %s", payrollItemTypesMissingNamesJoined), Message.of((EMessageKey)EMessageKey.RULE_PAYROLL_MONTH_AUXILIARY_WAGE_MISSING_REMARK, (List)ImmutableList.of((Object)payrollItemTypesMissingNamesJoined)));
        }
        if (!payrollItemRemarksNotInDictionary.isEmpty()) {
            ImmutableSet payrollItemTypesNotInDictionaryNames = (ImmutableSet)payrollItemRemarksNotInDictionary.stream().map(item -> {
                PayrollItemType payrollItemType = (PayrollItemType)item.getLeft();
                String remarkInUpdate = (String)item.getRight();
                return String.format("%s: %s", payrollItemType.getName(), remarkInUpdate);
            }).collect(ImmutableSet.toImmutableSet());
            payrollItemTypesMissingNamesJoined = MESSAGE_JOINER.join((Iterable)payrollItemTypesNotInDictionaryNames);
            throw new UpdateRejectException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PAYROLL_MONTH_ITEM__AUXILIARY_WAGE__REMARK), (Object)payrollItemTypesMissingNamesJoined, String.format("Payroll Month cannot be updated, auxiliary wages require a remark from Dictionary: %s", payrollItemTypesMissingNamesJoined), Message.of((EMessageKey)EMessageKey.RULE_PAYROLL_MONTH_AUXILIARY_WAGE_REMARK_NOT_IN_DICTIONARY, (List)ImmutableList.of((Object)payrollItemTypesMissingNamesJoined)));
        }
        return true;
    }

    public PayrollMonthAuxiliaryWageRemarkMandatoryValidator(DictionaryItemHandler dictionaryItemHandler) {
        this.dictionaryItemHandler = dictionaryItemHandler;
    }
}

