/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.validator.payroll;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import de.qfm.erp.service.model.exception.request.UpdateRejectException;
import de.qfm.erp.service.model.internal.employee.payroll.PayrollMonthUpdateBucket;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.service.validator.payroll.PayrollBeforeMergeValidator;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=0)
public class PayrollIncentiveWageAllowedValidator
extends PayrollBeforeMergeValidator {
    private static final Joiner QUOTATION_NUMBER_JOINER = Joiner.on((char)',').skipNulls();

    public boolean validate(@NonNull PayrollMonthUpdateBucket updateBucket) {
        ImmutableSet quotationNumbersAvailable;
        Sets.SetView quotationNumbersNotPresent;
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        ImmutableSet incentivePaymentQuotationNumbers = ImmutableSet.copyOf((Iterable)updateBucket.getIncentiveQuotationNumbers());
        if (!Iterables.isEmpty((Iterable)incentivePaymentQuotationNumbers) && !Iterables.isEmpty((Iterable)(quotationNumbersNotPresent = Sets.difference((Set)incentivePaymentQuotationNumbers, (Set)(quotationNumbersAvailable = ImmutableSet.copyOf((Iterable)updateBucket.getAvailableQuotationNumbers())))))) {
            String quotationNumbersNotPresentJoined = QUOTATION_NUMBER_JOINER.join((Iterable)quotationNumbersNotPresent);
            throw new UpdateRejectException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PAYROLL_MONTH_ITEM__QUOTATION_NUMBER), (Object)quotationNumbersNotPresentJoined, String.format("Payroll Month cannot be updated, you assign incentive wage on quotation(s), you do not have measurements for: %s", quotationNumbersNotPresentJoined), Message.of((EMessageKey)EMessageKey.RULE_PAYROLL_MONTH_UPDATE_NO_QUOTATION_NUMBER_AVAILABLE, (List)ImmutableList.of((Object)quotationNumbersNotPresentJoined)));
        }
        return true;
    }
}

