/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.validator.payroll;

import com.google.common.collect.ImmutableList;
import de.qfm.erp.common.request.employee.attendance.AttendanceUpdateItem;
import de.qfm.erp.service.model.exception.request.UpdateRejectException;
import de.qfm.erp.service.model.internal.employee.payroll.AttendanceUpdateBucket;
import de.qfm.erp.service.model.internal.employee.payroll.PayrollMonthUpdateBucket;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.model.jpa.employee.attendance.EAttendanceDayType;
import de.qfm.erp.service.service.calculator.attendance.AttendanceBadWeatherDurationCalculator;
import de.qfm.erp.service.service.validator.payroll.PayrollBeforeMergeValidator;
import java.time.Duration;
import java.time.LocalTime;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=-1)
public class PayrollBadWeatherMandatoryValuesValidator
extends PayrollBeforeMergeValidator {
    public static final Duration MINIMUM_BAD_WEATHER_DURATION = Duration.ofHours(1L);
    private final AttendanceBadWeatherDurationCalculator attendanceBadWeatherDurationCalculator;

    public boolean validate(@NonNull PayrollMonthUpdateBucket updateBucket) {
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        Iterable attendanceUpdateBuckets = updateBucket.getAttendanceUpdateBuckets();
        for (AttendanceUpdateBucket attendanceUpdateBucket : attendanceUpdateBuckets) {
            Duration breakDuration;
            LocalTime workEnd;
            LocalTime workStart;
            AttendanceUpdateItem attendanceUpdateItem = attendanceUpdateBucket.getAttendanceUpdateItem();
            Attendance attendance = attendanceUpdateBucket.getAttendance();
            EAttendanceDayType attendanceDayType = attendanceUpdateBucket.getAttendanceDayType();
            if (EAttendanceDayType.BAD_WEATHER != attendanceDayType && EAttendanceDayType.BAD_WEATHER_SICK != attendanceDayType) continue;
            int dayOfMonth = attendance.getDayOfMonth();
            boolean constructionSiteInvalid = StringUtils.isBlank((CharSequence)attendanceUpdateItem.getConstructionSite());
            if (constructionSiteInvalid) {
                throw new UpdateRejectException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PAYROLL_MONTH__ATTENDANCE__CONSTRUCTION_SITE), (Object)"", String.format("Rule Validation Error: Payroll Month cannot be updated, the Bad Weather Attendance on day: %s need to have a construction site set", dayOfMonth), Message.of((EMessageKey)EMessageKey.RULE_PAYROLL_MONTH__ATTENDANCE__BAD_WEATHER_NO_CONSTRUCTION_SITE, (List)ImmutableList.of((Object)dayOfMonth)));
            }
            Duration contractualWorkTimeDuration = attendance.getContractualWorkTimeDuration();
            Optional calculate = this.attendanceBadWeatherDurationCalculator.calculate(attendanceDayType, contractualWorkTimeDuration, workStart = attendanceUpdateItem.getWorkStart(), workEnd = attendanceUpdateItem.getWorkEnd(), breakDuration = attendanceUpdateItem.getBreakDuration());
            boolean badWeatherTimeIsInvalid = calculate.isPresent() && ((Duration)calculate.get()).compareTo(MINIMUM_BAD_WEATHER_DURATION) < 0;
            if (!badWeatherTimeIsInvalid) continue;
            throw new UpdateRejectException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PAYROLL_MONTH__ATTENDANCE__BAD_WEATHER_DURATION), (Object)"", String.format("Rule Validation Error: Rule: Payroll Month cannot be updated, the Bad Weather Attendance on day: %s need to have Bad Weather Hours >= %s", MINIMUM_BAD_WEATHER_DURATION, dayOfMonth), Message.of((EMessageKey)EMessageKey.RULE_PAYROLL_MONTH__ATTENDANCE__BAD_WEATHER_NO_BAD_WEATHER_DURATION, (List)ImmutableList.of((Object)MINIMUM_BAD_WEATHER_DURATION, (Object)dayOfMonth)));
        }
        return true;
    }

    public PayrollBadWeatherMandatoryValuesValidator(AttendanceBadWeatherDurationCalculator attendanceBadWeatherDurationCalculator) {
        this.attendanceBadWeatherDurationCalculator = attendanceBadWeatherDurationCalculator;
    }
}

