/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.validator.payroll;

import com.google.common.collect.ImmutableList;
import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.service.model.exception.request.UpdateRejectException;
import de.qfm.erp.service.model.internal.employee.payroll.AttendanceUpdateBucket;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.model.jpa.employee.attendance.EAttendanceOrigin;
import de.qfm.erp.service.model.jpa.employee.payroll.EPayrollMonthState;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.service.validator.payroll.AttendanceBeforeMergeValidator;
import java.time.LocalDate;
import java.util.List;
import lombok.NonNull;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=0)
public class AttendanceUpdatePayrollMonthReleasedPostEditDisallowedValidator
extends AttendanceBeforeMergeValidator {
    public boolean validate(@NonNull Iterable<AttendanceUpdateBucket> updateBuckets) {
        if (updateBuckets == null) {
            throw new NullPointerException("updateBuckets is marked non-null but is null");
        }
        for (AttendanceUpdateBucket updateBucket : updateBuckets) {
            this.validate(updateBucket);
        }
        return true;
    }

    public boolean validate(@NonNull AttendanceUpdateBucket updateBucket) {
        boolean payrollMonthIsReleased;
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        Attendance attendance = updateBucket.getAttendance();
        PayrollMonth payrollMonth = attendance.getPayrollMonth();
        EAttendanceOrigin lastOrigin = attendance.getLastOrigin();
        EPayrollMonthState payrollMonthState = payrollMonth.getPayrollMonthState();
        boolean bl = payrollMonthIsReleased = EPayrollMonthState.RELEASED == payrollMonthState;
        if (payrollMonthIsReleased) {
            String dateAsString = DateTimeHelper.toIsoDate((LocalDate)attendance.getDate());
            String lastOriginName = lastOrigin.name();
            throw new UpdateRejectException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PAYROLL_MONTH__STATE), (Object)lastOriginName, "Attendance cannot be Updated, you try to reset / delete an Attendance from a RELEASED Payroll Month", Message.of((EMessageKey)EMessageKey.RULE_ATTENDANCE_RESET_PAYROLL_MONTH_RELEASED, (List)ImmutableList.of((Object)dateAsString)));
        }
        return true;
    }
}

