/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.validator.measurement;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import de.qfm.erp.service.model.exception.request.BusinessRuleValidationException;
import de.qfm.erp.service.model.exception.request.RequestValidationException;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.fieldname.SimpleFieldName;
import de.qfm.erp.service.model.internal.measurement.MeasurementChangeBucket;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.MeasurementState;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementState;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementType;
import de.qfm.erp.service.service.service.MessageService;
import de.qfm.erp.service.service.validator.measurement.MeasurementBeforeStateChangeValidator;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=1)
public class MeasurementStateChangeMeasurementTypesOkValidator
extends MeasurementBeforeStateChangeValidator {
    public static final Joiner MEASUREMENT_NUMBER_JOINER = Joiner.on((String)", ");
    private final MessageService messageService;

    public boolean validate(@NonNull MeasurementChangeBucket updateBucket) {
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        Measurement measurement = updateBucket.getMeasurement();
        Iterable measurementsWithSamePSSRO = updateBucket.getMeasurementsWithSamePSSRO();
        EMeasurementType measurementType = measurement.getMeasurementType();
        if (!Iterables.isEmpty((Iterable)measurementsWithSamePSSRO) && measurementType == EMeasurementType.MAIN) {
            EMeasurementState stateNew = updateBucket.getMeasurementStateNew();
            MeasurementState stateOld = measurement.getMeasurementState();
            EMeasurementState eStateOld = stateOld.getMeasurementState();
            if (Objects.equals(eStateOld, EMeasurementState.TEMPORARY) && Objects.equals(stateNew, EMeasurementState.APPROVED)) {
                String stateOldTranslated = this.messageService.getDE((Translatable)eStateOld, new Object[0]);
                String stateNewTranslated = this.messageService.getDE((Translatable)stateNew, new Object[0]);
                if (!Iterables.isEmpty((Iterable)measurementsWithSamePSSRO)) {
                    String measurementPartialNumbersNotApproved = MEASUREMENT_NUMBER_JOINER.join((Iterable)Streams.stream((Iterable)measurementsWithSamePSSRO).map(Measurement::getMeasurementNumber).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet()));
                    String measurementTypeTranslated = this.messageService.getDE((Translatable)EMeasurementType.PARTIAL, new Object[0]);
                    String messageText = String.format("Measurement State cannot be changed from: '%s' to '%s', the measurements '%s' in state '%s'", eStateOld, stateNew, measurementPartialNumbersNotApproved, EMeasurementType.PARTIAL);
                    Message message = Message.of((EMessageKey)EMessageKey.RULE_MEASUREMENT__STATE_TO_APPROVED_MISSING_PARTIAL_IN_APPROVED, (List)ImmutableList.of((Object)stateOldTranslated, (Object)stateNewTranslated, (Object)measurementPartialNumbersNotApproved, (Object)measurementTypeTranslated));
                    SimpleFieldName fieldName = FieldNamesFactory.simpleFieldName((EField)EField.MEASUREMENT_STATE);
                    ImmutableList details = ImmutableList.of((Object)RequestValidationException.Detail.of((FieldName)fieldName, (Object)stateNewTranslated, (String)messageText, (Message)message, (List)ImmutableList.of()));
                    throw new BusinessRuleValidationException("Business Rules Validation Error", (List)details);
                }
            }
        }
        return true;
    }

    public MeasurementStateChangeMeasurementTypesOkValidator(MessageService messageService) {
        this.messageService = messageService;
    }
}

