/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.validator.measurement;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import de.qfm.erp.common.request.measurement.MeasurementPositionUpdateItem;
import de.qfm.erp.common.request.measurement.MeasurementUpdateRequest;
import de.qfm.erp.service.helper.QuotationHelper;
import de.qfm.erp.service.model.exception.request.UpdateRejectException;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.measurement.MeasurementUpdateBucket;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.quotation.QuotationPosition;
import de.qfm.erp.service.service.service.MessageService;
import de.qfm.erp.service.service.validator.measurement.MeasurementBeforeMergeValidator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=0)
public class MeasurementCommissionBeforeMergeValidator
extends MeasurementBeforeMergeValidator {
    private static final Joiner SPN_JOINER = Joiner.on((char)',').skipNulls();
    private final MessageService messageService;

    public boolean validate(@NonNull MeasurementUpdateBucket measurementUpdateBucket) {
        if (measurementUpdateBucket == null) {
            throw new NullPointerException("measurementUpdateBucket is marked non-null but is null");
        }
        Quotation stage = measurementUpdateBucket.getQuotation();
        Iterable stages = measurementUpdateBucket.getQuotations();
        if (measurementUpdateBucket.getRequest() instanceof MeasurementUpdateRequest) {
            long quotationFailingCount;
            String qNumber = stage.getQNumber();
            MeasurementUpdateRequest measurementUpdateRequest = (MeasurementUpdateRequest)measurementUpdateBucket.getRequest();
            List measurementPositions = measurementUpdateRequest.getMeasurementPositions();
            Iterable quotationPositions = measurementUpdateBucket.getQuotationPositions();
            if (measurementPositions.isEmpty() && (quotationFailingCount = Streams.stream((Iterable)stages).filter(QuotationHelper::isNotAllowedToWriteMeasurement).count()) == (long)Iterables.size((Iterable)stages)) {
                String collect = Streams.stream((Iterable)stages).map(Quotation::getStageState).map(x$0 -> this.messageService.get(x$0, new Object[0])).collect(Collectors.joining(","));
                throw new UpdateRejectException((FieldName)FieldNamesFactory.stageState(), (Object)collect, String.format("Rule: Measurement cannot be Created or Updated, Stage '%s' is not allowed (e.g. wrong stage state).", qNumber), Message.of((EMessageKey)EMessageKey.RULE_STAGE_NOT_USABLE_IN_MEASUREMENT, (List)ImmutableList.of((Object)qNumber)));
            }
            ImmutableSet surrogatePositionNumbers = ImmutableSet.copyOf(measurementPositions.stream().map(MeasurementPositionUpdateItem::getSurrogatePositionNumber).iterator());
            ImmutableSet quotationPositionsFailing = ImmutableSet.copyOf(Streams.stream((Iterable)quotationPositions).filter(item -> QuotationHelper.isNotAllowedToWriteMeasurement((Quotation)item.getQuotation())).filter(arg_0 -> MeasurementCommissionBeforeMergeValidator.lambda$validate$2((Set)surrogatePositionNumbers, arg_0)).iterator());
            if (!quotationPositionsFailing.isEmpty()) {
                ImmutableSet positionNumbersFailing = ImmutableSet.copyOf(quotationPositionsFailing.stream().map(QuotationPosition::getSurrogatePositionNumber).iterator());
                String rejectedValue = SPN_JOINER.join((Iterable)positionNumbersFailing);
                throw new UpdateRejectException((FieldName)FieldNamesFactory.stageState(), (Object)rejectedValue, String.format("Rule: Measurement cannot be Created or Updated, Position: '%s' of Stage '%s' is not allowed (e.g. wrong stage state).", rejectedValue, qNumber), Message.of((EMessageKey)EMessageKey.RULE_STAGE_POSITION_NOT_USABLE_IN_MEASUREMENT, (List)ImmutableList.of((Object)rejectedValue, (Object)qNumber)));
            }
        }
        return false;
    }

    public MeasurementCommissionBeforeMergeValidator(MessageService messageService) {
        this.messageService = messageService;
    }

    private static /* synthetic */ boolean lambda$validate$2(Set surrogatePositionNumbers, QuotationPosition item) {
        return surrogatePositionNumbers.contains(item.getSurrogatePositionNumber());
    }
}

