/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.xls;

import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.model.internal.quotation.BillOfQuantitiesMeasurementExport;
import de.qfm.erp.service.service.service.MessageService;
import de.qfm.erp.service.service.service.xls.AbstractXlsExportService;
import de.qfm.erp.service.service.service.xls.BillOfQuantitiesMeasurementXlsExportService;
import java.math.BigDecimal;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class BillOfQuantitiesMeasurementXlsExportService
extends AbstractXlsExportService {
    private static final Logger log = LogManager.getLogger(BillOfQuantitiesMeasurementXlsExportService.class);
    private final MessageService messageService;

    @Nonnull
    public XSSFWorkbook detailXLS(@NonNull XSSFWorkbook workbook, @NonNull String companyName, @NonNull String measurementSheetName, @NonNull String positionSheetName, @NonNull String quotationNumber, @NonNull String stageAlias, @NonNull Stream<BillOfQuantitiesMeasurementExport> billOfQuantitiesMeasurementExportStream) {
        if (workbook == null) {
            throw new NullPointerException("workbook is marked non-null but is null");
        }
        if (companyName == null) {
            throw new NullPointerException("companyName is marked non-null but is null");
        }
        if (measurementSheetName == null) {
            throw new NullPointerException("measurementSheetName is marked non-null but is null");
        }
        if (positionSheetName == null) {
            throw new NullPointerException("positionSheetName is marked non-null but is null");
        }
        if (quotationNumber == null) {
            throw new NullPointerException("quotationNumber is marked non-null but is null");
        }
        if (stageAlias == null) {
            throw new NullPointerException("stageAlias is marked non-null but is null");
        }
        if (billOfQuantitiesMeasurementExportStream == null) {
            throw new NullPointerException("billOfQuantitiesMeasurementExportStream is marked non-null but is null");
        }
        XSSFSheet measurementSheet = workbook.getSheet(measurementSheetName);
        CellAddress cellAddressCompanyName = new CellAddress("A2");
        CellAddress cellAddressStageNumber = new CellAddress("R6");
        CellAddress cellAddressStageAlias = new CellAddress("R8");
        XSSFRow rowR2 = measurementSheet.getRow(cellAddressCompanyName.getRow());
        XSSFRow rowR6 = measurementSheet.getRow(cellAddressStageNumber.getRow());
        XSSFRow rowR8 = measurementSheet.getRow(cellAddressStageAlias.getRow());
        BillOfQuantitiesMeasurementXlsExportService.updateText((String)companyName, (XSSFRow)rowR2, (int)cellAddressCompanyName.getColumn());
        BillOfQuantitiesMeasurementXlsExportService.updateText((String)quotationNumber, (XSSFRow)rowR6, (int)cellAddressStageNumber.getColumn());
        BillOfQuantitiesMeasurementXlsExportService.updateText((String)stageAlias, (XSSFRow)rowR8, (int)cellAddressStageAlias.getColumn());
        XSSFSheet positionSheet = workbook.getSheet(positionSheetName);
        CellAddress cellAddressA1 = new CellAddress("A1");
        XSSFRow rowA1 = positionSheet.getRow(cellAddressA1.getRow());
        BillOfQuantitiesMeasurementXlsExportService.updateText((String)quotationNumber, (XSSFRow)rowA1, (int)cellAddressA1.getColumn());
        AtomicInteger rowNum = new AtomicInteger(3);
        billOfQuantitiesMeasurementExportStream.forEach(exportItem -> {
            XSSFRow detailRow = positionSheet.getRow(rowNum.getAndIncrement());
            block4: for (BoQColumn boQColumn : BoQColumn.values()) {
                BoQColumnType boQColumnType = boQColumn.getBoQColumnType();
                Object value = boQColumn.getFn().apply(exportItem);
                Object valueToUse = value instanceof Translatable ? this.messageService.getDE((Translatable)value, new Object[0]) : value;
                switch (boQColumnType.ordinal()) {
                    case 1: {
                        BigDecimal bdValue = valueToUse instanceof BigDecimal ? (BigDecimal)valueToUse : BigDecimal.ZERO;
                        BillOfQuantitiesMeasurementXlsExportService.updateNumber((BigDecimal)bdValue, (XSSFRow)detailRow, (int)boQColumn.index);
                        continue block4;
                    }
                    case 0: 
                    case 2: 
                    case 3: {
                        String stringValue = valueToUse instanceof String ? (String)valueToUse : "";
                        BillOfQuantitiesMeasurementXlsExportService.updateText((String)stringValue, (XSSFRow)detailRow, (int)boQColumn.index);
                    }
                }
            }
        });
        positionSheet.setDisplayGridlines(true);
        return workbook;
    }

    @Autowired
    public BillOfQuantitiesMeasurementXlsExportService(MessageService messageService) {
        this.messageService = messageService;
    }
}

