/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.xls;

import com.google.common.base.CharMatcher;
import de.qfm.erp.service.model.internal.xlsx.CellStyles;
import de.qfm.erp.service.service.service.AbstractDocumentOutputService;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class AbstractXlsExportService
extends AbstractDocumentOutputService {
    protected static final DecimalFormat NUMBER_FORMAT;
    protected static final DateTimeFormatter GERMAN_FULL_DATE;
    protected static final DateTimeFormatter GERMAN_MM_YYYY;
    protected static final CharMatcher INT;
    protected static final CharMatcher STR_TECH;
    protected static final CharMatcher STR_FULL;
    protected static final CharMatcher DEC;

    @Nonnull
    protected static SXSSFRow newRow(@NonNull SXSSFSheet sheet, @NonNull AtomicInteger rowNum) {
        if (sheet == null) {
            throw new NullPointerException("sheet is marked non-null but is null");
        }
        if (rowNum == null) {
            throw new NullPointerException("rowNum is marked non-null but is null");
        }
        return sheet.createRow(rowNum.getAndIncrement());
    }

    @Nonnull
    protected static SXSSFCell createNumber(@NonNull CellStyles cellStyles, @Nullable BigDecimal value, @NonNull SXSSFRow row, int colIndex) {
        if (cellStyles == null) {
            throw new NullPointerException("cellStyles is marked non-null but is null");
        }
        if (row == null) {
            throw new NullPointerException("row is marked non-null but is null");
        }
        SXSSFCell cell = row.createCell(colIndex, CellType.NUMERIC);
        if (null != value) {
            cell.setCellValue(value.doubleValue());
        } else {
            cell.setBlank();
        }
        cell.setCellStyle(cellStyles.getDecimal2());
        return cell;
    }

    @Nonnull
    protected static SXSSFCell createNumber(@NonNull CellStyles cellStyles, @Nullable Integer value, @NonNull SXSSFRow row, int colIndex) {
        if (cellStyles == null) {
            throw new NullPointerException("cellStyles is marked non-null but is null");
        }
        if (row == null) {
            throw new NullPointerException("row is marked non-null but is null");
        }
        SXSSFCell cell = row.createCell(colIndex, CellType.NUMERIC);
        if (null != value) {
            cell.setCellValue((double)value.intValue());
        } else {
            cell.setBlank();
        }
        cell.setCellStyle(cellStyles.getDecimal0());
        return cell;
    }

    @Nonnull
    protected static SXSSFCell numericFormula(@NonNull CellStyles cellStyles, @NonNull String formula, @NonNull SXSSFRow row, int colIndex) {
        if (cellStyles == null) {
            throw new NullPointerException("cellStyles is marked non-null but is null");
        }
        if (formula == null) {
            throw new NullPointerException("formula is marked non-null but is null");
        }
        if (row == null) {
            throw new NullPointerException("row is marked non-null but is null");
        }
        SXSSFCell cell = row.createCell(colIndex, CellType.FORMULA);
        cell.setCellFormula(formula);
        cell.setCellStyle(cellStyles.getFormula());
        return cell;
    }

    @Nonnull
    protected static XSSFCell updateNumber(@Nullable BigDecimal value, @NonNull XSSFSheet sheet, CellAddress cellAddress) {
        if (sheet == null) {
            throw new NullPointerException("sheet is marked non-null but is null");
        }
        return AbstractXlsExportService.updateNumber((BigDecimal)value, (XSSFRow)sheet.getRow(cellAddress.getRow()), (int)cellAddress.getColumn());
    }

    @Nonnull
    protected static XSSFCell updateNumber(@Nullable BigDecimal value, @NonNull XSSFRow row, int colIndex) {
        XSSFCell cell;
        if (row == null) {
            throw new NullPointerException("row is marked non-null but is null");
        }
        XSSFCell candidate = row.getCell(colIndex);
        XSSFCell xSSFCell = cell = null != candidate ? candidate : row.createCell(colIndex, CellType.NUMERIC);
        if (null != value) {
            cell.setCellValue(value.doubleValue());
        } else {
            cell.setBlank();
        }
        return cell;
    }

    @Nonnull
    protected static SXSSFCell createText(@NonNull CellStyle style, @NonNull String text, @NonNull SXSSFRow row, int colIndex) {
        if (style == null) {
            throw new NullPointerException("style is marked non-null but is null");
        }
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (row == null) {
            throw new NullPointerException("row is marked non-null but is null");
        }
        SXSSFCell cell = row.createCell(colIndex, CellType.STRING);
        cell.setCellValue(text);
        cell.setCellStyle(style);
        return cell;
    }

    @Nonnull
    protected static XSSFCell updateText(@NonNull String value, @NonNull XSSFSheet sheet, CellAddress cellAddress) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (sheet == null) {
            throw new NullPointerException("sheet is marked non-null but is null");
        }
        return AbstractXlsExportService.updateText((String)value, (XSSFRow)sheet.getRow(cellAddress.getRow()), (int)cellAddress.getColumn());
    }

    @Nonnull
    protected static XSSFCell updateText(@NonNull String text, @NonNull XSSFRow row, int colIndex) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (row == null) {
            throw new NullPointerException("row is marked non-null but is null");
        }
        XSSFCell cell = row.getCell(colIndex, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
        cell.setCellValue(text);
        return cell;
    }

    static {
        DecimalFormat decimalFormat = new DecimalFormat("#,##0.00");
        decimalFormat.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.GERMAN));
        decimalFormat.setGroupingUsed(false);
        decimalFormat.setMinimumFractionDigits(2);
        decimalFormat.setMaximumFractionDigits(2);
        NUMBER_FORMAT = decimalFormat;
        GERMAN_FULL_DATE = DateTimeFormatter.ofPattern("dd.MM.yyyy");
        GERMAN_MM_YYYY = DateTimeFormatter.ofPattern("MM/yyyy");
        INT = CharMatcher.inRange((char)'0', (char)'9');
        STR_TECH = CharMatcher.ascii().or(CharMatcher.anyOf((CharSequence)"\u00e4\u00f6\u00fc\u00df\u00c4\u00d6\u00dc\u00b2\u00b3")).and(CharMatcher.anyOf((CharSequence)"\n\r").negate()).and(CharMatcher.isNot((char)';')).and(CharMatcher.isNot((char)'\"')).precomputed();
        STR_FULL = CharMatcher.ascii().or(CharMatcher.anyOf((CharSequence)"\u00e4\u00f6\u00fc\u00df\u00c4\u00d6\u00dc\u00b2\u00b3")).and(CharMatcher.anyOf((CharSequence)"\n\r").negate()).precomputed();
        DEC = CharMatcher.inRange((char)'0', (char)'9').or(CharMatcher.anyOf((CharSequence)",")).precomputed();
    }
}

