/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.socket;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.user.UserCommon;
import de.qfm.erp.common.websocket.request.RequestMessage;
import de.qfm.erp.common.websocket.request.StageRequestMessage;
import de.qfm.erp.common.websocket.response.StageResponseMessage;
import de.qfm.erp.common.websocket.response.StageStatusResponseMessage;
import de.qfm.erp.service.configuration.ApplicationConfig;
import de.qfm.erp.service.model.exception.request.JwtTokenException;
import de.qfm.erp.service.model.internal.eventbus.QStageChangeMessage;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.mapper.UserMapper;
import de.qfm.erp.service.service.security.JwtTokenProvider;
import de.qfm.erp.service.service.security.UserService;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Service;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.SubProtocolCapable;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class StageWebSocketHandler
extends TextWebSocketHandler
implements SubProtocolCapable,
ApplicationListener<QStageChangeMessage> {
    private static final Logger log = LogManager.getLogger(StageWebSocketHandler.class);
    private static final Set<WebSocketSession> SESSIONS = new CopyOnWriteArraySet();
    private static final HashBasedTable<Long, String, UserCommon> VIEWERS = HashBasedTable.create();
    private final ApplicationConfig applicationConfig;
    private final ObjectMapper objectMapper;
    private final UserMapper userMapper;
    private final UserService userService;
    private final JwtTokenProvider jwtTokenProvider;

    public boolean remove(long stageId) {
        log.debug("ServerAdmin remove StageViewStatus of StageId: {}", (Object)stageId);
        User authenticatedUser = this.userService.authenticatedUser();
        UserCommon userCommon = this.userMapper.mapUser(authenticatedUser);
        VIEWERS.row((Object)stageId).clear();
        this.sendViewStatus(Long.valueOf(stageId), userCommon);
        return true;
    }

    public void afterConnectionEstablished(@NonNull WebSocketSession session) {
        if (session == null) {
            throw new NullPointerException("session is marked non-null but is null");
        }
        log.debug("Server connection opened: adding Session: {}", (Object)session.getId());
        SESSIONS.add(session);
        this.sendToSession(session, (Object)"connected to APPQ/Stages");
    }

    public void afterConnectionClosed(@NonNull WebSocketSession session, @NonNull CloseStatus status) {
        if (session == null) {
            throw new NullPointerException("session is marked non-null but is null");
        }
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        log.debug("Server connection CLOSED: {}, removing Session: {}", (Object)status, (Object)session.getId());
        String sessionId = session.getId();
        ImmutableMap stagesAndAffectedUsers = ImmutableMap.copyOf((Map)VIEWERS.column((Object)sessionId));
        ImmutableSet usersAssociatedWithSession = ImmutableSet.copyOf(VIEWERS.column((Object)sessionId).values());
        UserCommon user = Iterables.isEmpty((Iterable)usersAssociatedWithSession) ? new UserCommon() : (UserCommon)usersAssociatedWithSession.iterator().next();
        StageWebSocketHandler.remove((WebSocketSession)session);
        log.debug("Affected Stages/Users by CLOSED: {}", (Object)stagesAndAffectedUsers);
        log.debug("Users associated with CLOSED: {}", (Object)usersAssociatedWithSession);
        Set stageIdsAffected = stagesAndAffectedUsers.keySet();
        for (Long stageId : stageIdsAffected) {
            this.sendViewStatus(stageId, user);
        }
    }

    private static void remove(WebSocketSession session) {
        SESSIONS.remove(session);
        VIEWERS.column((Object)session.getId()).clear();
    }

    public void handleTextMessage(@NonNull WebSocketSession session, @NonNull TextMessage message) {
        if (session == null) {
            throw new NullPointerException("session is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        String request = (String)message.getPayload();
        log.debug("Server received: {}", (Object)request);
        Optional stageRequestMessageCandidate = this.unserialize(StageRequestMessage.class, request);
        if (stageRequestMessageCandidate.isPresent()) {
            StageRequestMessage stageRequestMessage = (StageRequestMessage)stageRequestMessageCandidate.get();
            try {
                this.jwtTokenProvider.authenticate((RequestMessage)stageRequestMessage);
            }
            catch (JwtTokenException jwtTokenException) {
                TextMessage errorMessage = new TextMessage((CharSequence)String.format("Error: %s", jwtTokenException.getMessage()));
                this.sendToSession(session, (Object)errorMessage);
            }
            User authenticatedUser = this.userService.authenticatedUser();
            long stageId = stageRequestMessage.getStageId();
            String action = stageRequestMessage.getAction();
            StageWebSocketHandler.logSessions((String)"Before", (WebSocketSession)session, (long)stageId, (User)authenticatedUser);
            if (action.equals("view_begin")) {
                UserCommon userMapped = this.userMapper.mapUser(authenticatedUser);
                VIEWERS.put((Object)stageId, (Object)session.getId(), (Object)userMapped);
                StageResponseMessage stageResponseMessage = new StageResponseMessage();
                stageResponseMessage.setStageId(stageId);
                stageResponseMessage.setAction(action);
                stageResponseMessage.setSender(userMapped);
                this.sendToAffectedSessions(stageId, (Object)stageResponseMessage, (Iterable)ImmutableList.of());
                this.sendViewStatus(Long.valueOf(stageId), userMapped);
            } else if (action.equals("view_end")) {
                VIEWERS.remove((Object)stageId, (Object)session.getId());
                StageResponseMessage stageResponseMessage = new StageResponseMessage();
                stageResponseMessage.setStageId(stageId);
                stageResponseMessage.setAction(action);
                stageResponseMessage.setSender(this.userMapper.mapUser(authenticatedUser));
                this.sendToAffectedSessions(stageId, (Object)stageResponseMessage, (Iterable)ImmutableList.of());
                this.sendViewStatus(Long.valueOf(stageId), this.userMapper.mapUser(authenticatedUser));
            } else {
                StageResponseMessage stageResponseMessage = new StageResponseMessage();
                stageResponseMessage.setStageId(stageId);
                stageResponseMessage.setAction(action);
                stageResponseMessage.setSender(this.userMapper.mapUser(authenticatedUser));
                String serialize = this.serialize((Object)stageResponseMessage);
                this.sendToAllSessions((Object)serialize, (Iterable)ImmutableSet.of((Object)session));
            }
            StageWebSocketHandler.logSessions((String)"After", (WebSocketSession)session, (long)stageId, (User)authenticatedUser);
        }
    }

    private void sendToSession(@NonNull WebSocketSession session, @NonNull Object object) {
        if (session == null) {
            throw new NullPointerException("session is marked non-null but is null");
        }
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        try {
            String serialize = this.serialize(object);
            TextMessage webSocketMessage = new TextMessage((CharSequence)serialize);
            log.debug("Server sends: {}", (Object)webSocketMessage);
            if (session.isOpen()) {
                session.sendMessage((WebSocketMessage)webSocketMessage);
            } else {
                StageWebSocketHandler.remove((WebSocketSession)session);
            }
        }
        catch (IOException ioe) {
            log.error("Error Sending Messages: {}", (Object)ioe.getMessage(), (Object)ioe);
        }
    }

    public void handleTransportError(@NonNull WebSocketSession session, @NonNull Throwable exception) {
        if (session == null) {
            throw new NullPointerException("session is marked non-null but is null");
        }
        if (exception == null) {
            throw new NullPointerException("exception is marked non-null but is null");
        }
        log.debug("Server transport error: {}", (Object)exception.getMessage());
        if (!session.isOpen()) {
            StageWebSocketHandler.warnAndRemove((WebSocketSession)session);
        }
    }

    public List<String> getSubProtocols() {
        return Collections.singletonList("appq.stages.websocket");
    }

    public void onApplicationEvent(@NonNull QStageChangeMessage stageChangeMessage) {
        if (stageChangeMessage == null) {
            throw new NullPointerException("stageChangeMessage is marked non-null but is null");
        }
        Quotation stage = (Quotation)stageChangeMessage.getEntity();
        Long stageId = stage.getId();
        int rowVersion = stage.getRowVersion();
        try {
            User user = this.userService.authenticatedUser();
            UserCommon sender = this.userMapper.mapUser(user);
            StageResponseMessage wsMessage = new StageResponseMessage();
            wsMessage.setStageId(stageId.longValue());
            wsMessage.setAction("updated");
            wsMessage.setRowVersion(rowVersion);
            wsMessage.setSender(sender);
            this.sendToAffectedSessions(stageId.longValue(), (Object)wsMessage, (Iterable)ImmutableSet.of());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nonnull
    private String serialize(@NonNull Object message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        try {
            return this.objectMapper.writeValueAsString(message);
        }
        catch (Exception e) {
            log.error("Error Serializing: {}", message, (Object)e);
            return "";
        }
    }

    @Nonnull
    private <T> Optional<T> unserialize(@NonNull Class<T> clazz, @NonNull String json) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        try {
            return Optional.of(this.objectMapper.readValue(json, clazz));
        }
        catch (Exception e) {
            log.error("Error De-Serializing: {}", (Object)json, (Object)e);
            return Optional.empty();
        }
    }

    private void sendToAllSessions(@NonNull Object object, @NonNull Iterable<WebSocketSession> exclude) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (exclude == null) {
            throw new NullPointerException("exclude is marked non-null but is null");
        }
        String messageBody = this.serialize(object);
        for (WebSocketSession session : SESSIONS) {
            if (Iterables.contains(exclude, (Object)session)) continue;
            if (session.isOpen()) {
                try {
                    log.debug("Server sends: {}", (Object)messageBody);
                    session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)messageBody));
                }
                catch (IOException ioe) {
                    log.error("Could not send Message: {} to Session: {}", (Object)messageBody, (Object)session);
                }
                continue;
            }
            StageWebSocketHandler.warnAndRemove((WebSocketSession)session);
        }
    }

    private void sendToAffectedSessions(long stageId, @NonNull Object object, @NonNull Iterable<WebSocketSession> exclude) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (exclude == null) {
            throw new NullPointerException("exclude is marked non-null but is null");
        }
        String messageBody = this.serialize(object);
        for (WebSocketSession session : SESSIONS) {
            if (Iterables.contains(exclude, (Object)session) || !session.isOpen()) continue;
            String id = session.getId();
            if (!VIEWERS.contains((Object)stageId, (Object)id)) continue;
            if (session.isOpen()) {
                try {
                    log.debug("Server sends: {}", (Object)messageBody);
                    session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)messageBody));
                }
                catch (IOException ioe) {
                    log.error("Could not send Message: {} to Session: {}", (Object)messageBody, (Object)session);
                }
                continue;
            }
            StageWebSocketHandler.warnAndRemove((WebSocketSession)session);
        }
    }

    private static void warnAndRemove(WebSocketSession session) {
        log.warn("Session is NOT open: {}, removing", (Object)session);
        StageWebSocketHandler.remove((WebSocketSession)session);
    }

    private void sendCurrentStatusToAllAffectedSessions(long stageId, @NonNull UserCommon sender, @NonNull Iterable<WebSocketSession> exclude) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        if (exclude == null) {
            throw new NullPointerException("exclude is marked non-null but is null");
        }
        for (WebSocketSession session : SESSIONS) {
            if (Iterables.contains(exclude, (Object)session) || !session.isOpen()) continue;
            String id = session.getId();
            ImmutableList allUsersOnStage = StageWebSocketHandler.usersOnStage((Long)stageId);
            UserCommon self = (UserCommon)VIEWERS.get((Object)stageId, (Object)id);
            if (null == self) continue;
            List localUserOnStage = this.filteredUsersOnStage(self, (List)allUsersOnStage);
            StageStatusResponseMessage stageStatusResponseMessage = new StageStatusResponseMessage();
            stageStatusResponseMessage.setAction("view_status");
            stageStatusResponseMessage.setSender(sender);
            stageStatusResponseMessage.setViewers(localUserOnStage);
            String messageBody = this.serialize((Object)stageStatusResponseMessage);
            if (!VIEWERS.contains((Object)stageId, (Object)id)) continue;
            try {
                log.debug("Server sends: {}", (Object)messageBody);
                session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)messageBody));
            }
            catch (IOException ioe) {
                log.error("Could not send Message: {} to Session: {}", (Object)messageBody, (Object)session);
            }
        }
    }

    private static void logSessions(@NonNull String debug, @NonNull WebSocketSession session, long stageId, @NonNull User authenticatedUser) {
        if (debug == null) {
            throw new NullPointerException("debug is marked non-null but is null");
        }
        if (session == null) {
            throw new NullPointerException("session is marked non-null but is null");
        }
        if (authenticatedUser == null) {
            throw new NullPointerException("authenticatedUser is marked non-null but is null");
        }
        Set sessionIds = VIEWERS.columnKeySet();
        Set stageIds = VIEWERS.rowKeySet();
        Collection userIds = (Collection)VIEWERS.values().stream().map(EntityBaseCommon::getId).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
        log.debug("StageId: {}, Action: {}, User: {}", (Object)stageId, (Object)session.getId(), (Object)authenticatedUser.getId());
        log.debug("AllSessionIds: {}", (Object)sessionIds);
        log.debug("AllStageIds: {}", (Object)stageIds);
        log.debug("AllUserIds: {}", (Object)userIds);
    }

    @VisibleForTesting
    void sendViewStatus(@NonNull Long stageId, @NonNull UserCommon authenticatedUser) {
        if (stageId == null) {
            throw new NullPointerException("stageId is marked non-null but is null");
        }
        if (authenticatedUser == null) {
            throw new NullPointerException("authenticatedUser is marked non-null but is null");
        }
        this.sendCurrentStatusToAllAffectedSessions(stageId.longValue(), authenticatedUser, (Iterable)ImmutableSet.of());
    }

    private static ImmutableList<UserCommon> usersOnStage(Long stageId) {
        return ImmutableList.copyOf(VIEWERS.row((Object)stageId).values());
    }

    @VisibleForTesting
    List<UserCommon> filteredUsersOnStage(@NonNull UserCommon authenticatedUser, @NonNull List<UserCommon> usersOnStage) {
        if (authenticatedUser == null) {
            throw new NullPointerException("authenticatedUser is marked non-null but is null");
        }
        if (usersOnStage == null) {
            throw new NullPointerException("usersOnStage is marked non-null but is null");
        }
        boolean stageWebSocketFilterMyself = this.applicationConfig.isStageWebSocketFilterMyself();
        boolean stageWebSocketFilterMyselfDuplicate = this.applicationConfig.isStageWebSocketFilterMyselfDuplicate();
        boolean stageWebSocketFilterDuplicate = this.applicationConfig.isStageWebSocketFilterDuplicate();
        boolean skipMe = stageWebSocketFilterMyself;
        HashSet userIdsAdded = Sets.newHashSet();
        ImmutableList.Builder usersOnStageFilteredBuilder = ImmutableList.builder();
        for (UserCommon userOnStage : usersOnStage) {
            Long userIdOnStage = userOnStage.getId();
            Long authenticatedUserId = authenticatedUser.getId();
            if (skipMe && userIdOnStage.equals(authenticatedUserId)) {
                skipMe = stageWebSocketFilterMyselfDuplicate;
                continue;
            }
            if (stageWebSocketFilterDuplicate) {
                if (userIdsAdded.contains(userIdOnStage)) continue;
                userIdsAdded.add(userIdOnStage);
                usersOnStageFilteredBuilder.add((Object)userOnStage);
                continue;
            }
            userIdsAdded.add(userIdOnStage);
            usersOnStageFilteredBuilder.add((Object)userOnStage);
        }
        return usersOnStageFilteredBuilder.build();
    }

    public StageWebSocketHandler(ApplicationConfig applicationConfig, ObjectMapper objectMapper, UserMapper userMapper, UserService userService, JwtTokenProvider jwtTokenProvider) {
        this.applicationConfig = applicationConfig;
        this.objectMapper = objectMapper;
        this.userMapper = userMapper;
        this.userService = userService;
        this.jwtTokenProvider = jwtTokenProvider;
    }
}

