/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.search;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementState;
import de.qfm.erp.service.model.search.EMeasurementIndexField;
import de.qfm.erp.service.model.search.IndexDocument;
import de.qfm.erp.service.model.search.IndexField;
import de.qfm.erp.service.model.search.IndexResult;
import de.qfm.erp.service.model.search.InternalSearchRequest;
import de.qfm.erp.service.model.search.MeasurementIndexEntry;
import de.qfm.erp.service.model.search.MeasurementIndexSearchResult;
import de.qfm.erp.service.model.search.PreparedQuery;
import de.qfm.erp.service.service.mapper.MeasurementSearchMapper;
import de.qfm.erp.service.service.mapper.search.DomainQueryHelper;
import de.qfm.erp.service.service.mapper.search.InternalQueryHelper;
import de.qfm.erp.service.service.service.search.IndexService;
import de.qfm.erp.service.service.service.search.MeasurementIndexSearchService;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Query;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MeasurementIndexSearchService {
    private static final Logger log = LogManager.getLogger(MeasurementIndexSearchService.class);
    private final DomainQueryHelper domainQueryHelper;
    private final IndexService indexService;
    private final MeasurementSearchMapper mapper;

    @Nonnull
    public MeasurementIndexSearchResult search(@Nonnull String query, boolean includeDeleted, int page, int size) throws IOException {
        Set measurementStates = includeDeleted ? EMeasurementState.ALL_VALID : EMeasurementState.ALL_NON_DELETED;
        PreparedQuery preparedQuery = this.domainQueryHelper.measurements(query, (Iterable)measurementStates);
        String queryString = InternalQueryHelper.prettyPrint((Query)preparedQuery.getQuery());
        log.info("Executing Query: {}", (Object)queryString);
        return this.indexService.measurements(InternalSearchRequest.of((PreparedQuery)preparedQuery, (int)page, (int)size));
    }

    public long remove(@NonNull String documentId) throws IOException {
        if (documentId == null) {
            throw new NullPointerException("documentId is marked non-null but is null");
        }
        return this.indexService.deleteFromIndex((Query)InternalQueryHelper.termQuery((IndexField)EMeasurementIndexField._ID, (String)documentId));
    }

    @Nonnull
    public IndexResult index(@NonNull MeasurementIndexEntry measurementIndexRequest) throws IOException {
        if (measurementIndexRequest == null) {
            throw new NullPointerException("measurementIndexRequest is marked non-null but is null");
        }
        IndexDocument indexDocument = this.mapper.mapToDocument(measurementIndexRequest);
        return this.indexService.updateIndex(indexDocument);
    }

    @Nonnull
    public Iterable<IndexResult> index(@NonNull Iterable<MeasurementIndexEntry> measurementIndexEntries) throws IOException {
        if (measurementIndexEntries == null) {
            throw new NullPointerException("measurementIndexEntries is marked non-null but is null");
        }
        return (Iterable)Streams.stream(measurementIndexEntries).map(MeasurementIndexSearchService.wrap(arg_0 -> ((MeasurementSearchMapper)this.mapper).mapToDocument(arg_0))).map(MeasurementIndexSearchService.wrap(arg_0 -> ((IndexService)this.indexService).updateIndex(arg_0))).collect(ImmutableList.toImmutableList());
    }

    public static <T, R> Function<T, R> wrap(@NonNull CheckedFunction<T, R> checkedFunction) {
        if (checkedFunction == null) {
            throw new NullPointerException("checkedFunction is marked non-null but is null");
        }
        return t -> {
            try {
                return checkedFunction.apply(t);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    @Nonnull
    private List<Pair<Document, Float>> document(@NonNull String documentId) throws IOException {
        if (documentId == null) {
            throw new NullPointerException("documentId is marked non-null but is null");
        }
        return this.indexService.document(documentId);
    }

    public MeasurementIndexSearchService(DomainQueryHelper domainQueryHelper, IndexService indexService, MeasurementSearchMapper mapper) {
        this.domainQueryHelper = domainQueryHelper;
        this.indexService = indexService;
        this.mapper = mapper;
    }
}

