/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.search;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import de.qfm.erp.service.configuration.search.SearchConfiguration;
import de.qfm.erp.service.helper.search.IndexAccessHelper;
import de.qfm.erp.service.model.exception.search.IndexNotAccessibleException;
import de.qfm.erp.service.model.search.CustomerIndexEntry;
import de.qfm.erp.service.model.search.CustomerIndexSearchResult;
import de.qfm.erp.service.model.search.CustomerSearchResultItem;
import de.qfm.erp.service.model.search.ECustomerIndexField;
import de.qfm.erp.service.model.search.EEntityIndexField;
import de.qfm.erp.service.model.search.EInvoiceIndexField;
import de.qfm.erp.service.model.search.EMeasurementIndexField;
import de.qfm.erp.service.model.search.EStageIndexField;
import de.qfm.erp.service.model.search.ESubProjectIndexField;
import de.qfm.erp.service.model.search.EUserIndexField;
import de.qfm.erp.service.model.search.EntityIndexEntry;
import de.qfm.erp.service.model.search.EntityIndexSearchResult;
import de.qfm.erp.service.model.search.EntitySearchResultItem;
import de.qfm.erp.service.model.search.IndexDocument;
import de.qfm.erp.service.model.search.IndexField;
import de.qfm.erp.service.model.search.IndexResult;
import de.qfm.erp.service.model.search.InternalSearchRequest;
import de.qfm.erp.service.model.search.InvoiceIndexEntry;
import de.qfm.erp.service.model.search.InvoiceIndexSearchResult;
import de.qfm.erp.service.model.search.InvoiceSearchResultItem;
import de.qfm.erp.service.model.search.MeasurementIndexEntry;
import de.qfm.erp.service.model.search.MeasurementIndexSearchResult;
import de.qfm.erp.service.model.search.MeasurementSearchResultItem;
import de.qfm.erp.service.model.search.StageIndexEntry;
import de.qfm.erp.service.model.search.StageIndexSearchResult;
import de.qfm.erp.service.model.search.StageSearchResultItem;
import de.qfm.erp.service.model.search.SubProjectIndexEntry;
import de.qfm.erp.service.model.search.SubProjectIndexSearchResult;
import de.qfm.erp.service.model.search.SubProjectSearchResultItem;
import de.qfm.erp.service.model.search.UserIndexEntry;
import de.qfm.erp.service.model.search.UserIndexSearchResult;
import de.qfm.erp.service.model.search.UserSearchResultItem;
import de.qfm.erp.service.model.search.timing.Timing;
import de.qfm.erp.service.model.search.timing.TimingResult;
import de.qfm.erp.service.service.mapper.search.CustomerIndexEntrySerializer;
import de.qfm.erp.service.service.mapper.search.EntityIndexEntrySerializer;
import de.qfm.erp.service.service.mapper.search.InternalQueryHelper;
import de.qfm.erp.service.service.mapper.search.InvoiceIndexEntrySerializer;
import de.qfm.erp.service.service.mapper.search.MeasurementIndexEntrySerializer;
import de.qfm.erp.service.service.mapper.search.StageIndexEntrySerializer;
import de.qfm.erp.service.service.mapper.search.SubProjectIndexEntrySerializer;
import de.qfm.erp.service.service.mapper.search.UserIndexEntrySerializer;
import de.qfm.erp.service.service.service.search.IndexService;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class IndexServiceImpl
implements IndexService {
    private static final Logger log = LogManager.getLogger(IndexServiceImpl.class);
    private final SearchConfiguration searchConfiguration;
    private final IndexWriter indexWriter;
    private final SearcherManager searcherManager;
    private final CustomerIndexEntrySerializer customerIndexEntrySerializer;
    private final EntityIndexEntrySerializer entityIndexEntrySerializer;
    private final InvoiceIndexEntrySerializer invoiceIndexEntrySerializer;
    private final MeasurementIndexEntrySerializer measurementIndexEntrySerializer;
    private final StageIndexEntrySerializer stageIndexEntrySerializer;
    private final UserIndexEntrySerializer userIndexEntrySerializer;
    private final SubProjectIndexEntrySerializer subProjectIndexEntrySerializer;

    public IndexServiceImpl(SearchConfiguration searchConfiguration, @Qualifier(value="indexWriter") IndexWriter indexWriter, @Qualifier(value="searcherManager") SearcherManager searcherManager, CustomerIndexEntrySerializer customerIndexEntrySerializer, EntityIndexEntrySerializer entityIndexEntrySerializer, InvoiceIndexEntrySerializer invoiceIndexEntrySerializer, MeasurementIndexEntrySerializer measurementIndexEntrySerializer, StageIndexEntrySerializer stageIndexEntrySerializer, UserIndexEntrySerializer userIndexEntrySerializer, SubProjectIndexEntrySerializer subProjectIndexEntrySerializer) {
        this.searchConfiguration = searchConfiguration;
        this.indexWriter = indexWriter;
        this.searcherManager = searcherManager;
        this.customerIndexEntrySerializer = customerIndexEntrySerializer;
        this.entityIndexEntrySerializer = entityIndexEntrySerializer;
        this.invoiceIndexEntrySerializer = invoiceIndexEntrySerializer;
        this.measurementIndexEntrySerializer = measurementIndexEntrySerializer;
        this.stageIndexEntrySerializer = stageIndexEntrySerializer;
        this.userIndexEntrySerializer = userIndexEntrySerializer;
        this.subProjectIndexEntrySerializer = subProjectIndexEntrySerializer;
    }

    @Nonnull
    public IndexResult updateIndex(@NonNull IndexDocument indexDocument) throws IOException {
        if (indexDocument == null) {
            throw new NullPointerException("indexDocument is marked non-null but is null");
        }
        Iterable indexResults = this.updateIndex((Iterable)ImmutableList.of((Object)indexDocument));
        return (IndexResult)Iterables.getFirst((Iterable)indexResults, (Object)IndexResult.EMPTY);
    }

    @Nonnull
    public Iterable<IndexResult> updateIndex(@NonNull Iterable<IndexDocument> indexDocuments) throws IOException {
        if (indexDocuments == null) {
            throw new NullPointerException("indexDocuments is marked non-null but is null");
        }
        ImmutableList.Builder indexResultBuilder = ImmutableList.builder();
        Iterable documentIDsToAdd = (Iterable)Streams.stream(indexDocuments).map(IndexDocument::getId).collect(ImmutableList.toImmutableList());
        Iterable documentsToAdd = (Iterable)Streams.stream(indexDocuments).map(IndexDocument::getDocument).collect(ImmutableList.toImmutableList());
        ImmutableList termsToDelete = (ImmutableList)Streams.stream(indexDocuments).map(item -> new Term(EMeasurementIndexField._ID.fieldName(), item.getId())).collect(ImmutableList.toImmutableList());
        log.info("Adding Document IDs: {}", (Object)documentIDsToAdd);
        ImmutableList indexResults = indexResultBuilder.build();
        this.indexWriter.deleteDocuments((Term[])Iterables.toArray((Iterable)termsToDelete, Term.class));
        this.indexWriter.addDocuments(documentsToAdd);
        if (this.searchConfiguration.isSearchIndexerImmediateCommitEnabled()) {
            this.commitAndRefreshIndex();
        }
        return indexResults;
    }

    @Nonnull
    public CustomerIndexSearchResult customers(@NonNull InternalSearchRequest internalSearchRequest) throws IOException {
        if (internalSearchRequest == null) {
            throw new NullPointerException("internalSearchRequest is marked non-null but is null");
        }
        Timing timing = Timing.createStarted();
        IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
        try {
            IndexReader indexReader = searcher.getIndexReader();
            Query query = internalSearchRequest.getPreparedQuery().getQuery();
            int page = internalSearchRequest.getPage();
            int documentAmountToFetch = internalSearchRequest.getSize();
            timing.finishIndexPrepare();
            Sort sort = new Sort(new SortField[]{new SortedNumericSortField(ECustomerIndexField.SORT_CUSTOMER__CREATED_ON.fieldName(), SortField.Type.LONG, true)});
            int documentAmountToSkip = page * documentAmountToFetch;
            TopFieldDocs topDocs = searcher.search(query, documentAmountToSkip + documentAmountToFetch, sort);
            int totalHitsCount = searcher.count(query);
            int totalPages = IndexAccessHelper.totalPages((int)documentAmountToFetch, (long)totalHitsCount);
            timing.finishIndexSearch();
            List documents = IndexAccessHelper.documents((IndexReader)indexReader, (TopDocs)topDocs, (int)documentAmountToSkip);
            timing.finishIndexDocumentFetch();
            List searchResultItems = this.customerSearchResultItems(documents);
            timing.finishHighLight();
            TimingResult timingResult = timing.build();
            CustomerIndexSearchResult customerIndexSearchResult = CustomerIndexSearchResult.of((InternalSearchRequest)internalSearchRequest, (long)totalHitsCount, (int)totalPages, (List)searchResultItems, (TimingResult)timingResult);
            return customerIndexSearchResult;
        }
        catch (IOException ioe) {
            throw new IndexNotAccessibleException(String.format("Cannot execute Search %s, reason: %s", internalSearchRequest, ioe.getMessage()));
        }
        finally {
            if (null != searcher) {
                this.searcherManager.release((Object)searcher);
            }
        }
    }

    @Nonnull
    public EntityIndexSearchResult entities(@NonNull InternalSearchRequest internalSearchRequest) throws IOException {
        if (internalSearchRequest == null) {
            throw new NullPointerException("internalSearchRequest is marked non-null but is null");
        }
        Timing timing = Timing.createStarted();
        IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
        try {
            IndexReader indexReader = searcher.getIndexReader();
            Query query = internalSearchRequest.getPreparedQuery().getQuery();
            int page = internalSearchRequest.getPage();
            int documentAmountToFetch = internalSearchRequest.getSize();
            timing.finishIndexPrepare();
            Sort sort = new Sort(new SortField[]{new SortedNumericSortField(EEntityIndexField.SORT_ENTITY__CREATED_ON.fieldName(), SortField.Type.LONG, true)});
            int documentAmountToSkip = page * documentAmountToFetch;
            TopFieldDocs topDocs = searcher.search(query, documentAmountToSkip + documentAmountToFetch, sort);
            int totalHitsCount = searcher.count(query);
            int totalPages = IndexAccessHelper.totalPages((int)documentAmountToFetch, (long)totalHitsCount);
            timing.finishIndexSearch();
            List documents = IndexAccessHelper.documents((IndexReader)indexReader, (TopDocs)topDocs, (int)documentAmountToSkip);
            timing.finishIndexDocumentFetch();
            List searchResultItems = this.entitySearchResultItems(documents);
            timing.finishHighLight();
            TimingResult timingResult = timing.build();
            EntityIndexSearchResult entityIndexSearchResult = EntityIndexSearchResult.of((InternalSearchRequest)internalSearchRequest, (long)totalHitsCount, (int)totalPages, (List)searchResultItems, (TimingResult)timingResult);
            return entityIndexSearchResult;
        }
        catch (IOException ioe) {
            throw new IndexNotAccessibleException(String.format("Cannot execute Search %s, reason: %s", internalSearchRequest, ioe.getMessage()));
        }
        finally {
            if (null != searcher) {
                this.searcherManager.release((Object)searcher);
            }
        }
    }

    @Nonnull
    public InvoiceIndexSearchResult invoices(@NonNull InternalSearchRequest internalSearchRequest) throws IOException {
        if (internalSearchRequest == null) {
            throw new NullPointerException("internalSearchRequest is marked non-null but is null");
        }
        Timing timing = Timing.createStarted();
        IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
        try {
            IndexReader indexReader = searcher.getIndexReader();
            Query query = internalSearchRequest.getPreparedQuery().getQuery();
            int page = internalSearchRequest.getPage();
            int documentAmountToFetch = internalSearchRequest.getSize();
            timing.finishIndexPrepare();
            Sort sort = new Sort(new SortField[]{new SortedNumericSortField(EInvoiceIndexField.SORT_INVOICE__CREATED_ON.fieldName(), SortField.Type.LONG, true)});
            int documentAmountToSkip = page * documentAmountToFetch;
            TopFieldDocs topDocs = searcher.search(query, documentAmountToSkip + documentAmountToFetch, sort);
            int totalHitsCount = searcher.count(query);
            int totalPages = IndexAccessHelper.totalPages((int)documentAmountToFetch, (long)totalHitsCount);
            timing.finishIndexSearch();
            List documents = IndexAccessHelper.documents((IndexReader)indexReader, (TopDocs)topDocs, (int)documentAmountToSkip);
            timing.finishIndexDocumentFetch();
            List searchResultItems = this.invoiceSearchResultItems(documents);
            timing.finishHighLight();
            TimingResult timingResult = timing.build();
            InvoiceIndexSearchResult invoiceIndexSearchResult = InvoiceIndexSearchResult.of((InternalSearchRequest)internalSearchRequest, (long)totalHitsCount, (int)totalPages, (List)searchResultItems, (TimingResult)timingResult);
            return invoiceIndexSearchResult;
        }
        catch (IOException ioe) {
            throw new IndexNotAccessibleException(String.format("Cannot execute Search %s, reason: %s", internalSearchRequest, ioe.getMessage()));
        }
        finally {
            if (null != searcher) {
                this.searcherManager.release((Object)searcher);
            }
        }
    }

    @Nonnull
    public StageIndexSearchResult stages(@NonNull InternalSearchRequest internalSearchRequest) throws IOException {
        if (internalSearchRequest == null) {
            throw new NullPointerException("internalSearchRequest is marked non-null but is null");
        }
        Timing timing = Timing.createStarted();
        IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
        try {
            IndexReader indexReader = searcher.getIndexReader();
            Query query = internalSearchRequest.getPreparedQuery().getQuery();
            int page = internalSearchRequest.getPage();
            int documentAmountToFetch = internalSearchRequest.getSize();
            timing.finishIndexPrepare();
            Sort sort = new Sort(new SortField[]{new SortedNumericSortField(EStageIndexField.SORT_STAGE__PRIORITY.fieldName(), SortField.Type.LONG, false)});
            int documentAmountToSkip = page * documentAmountToFetch;
            TopFieldDocs topDocs = searcher.search(query, documentAmountToSkip + documentAmountToFetch, sort);
            int totalHitsCount = searcher.count(query);
            int totalPages = IndexAccessHelper.totalPages((int)documentAmountToFetch, (long)totalHitsCount);
            timing.finishIndexSearch();
            List documents = IndexAccessHelper.documents((IndexReader)indexReader, (TopDocs)topDocs, (int)documentAmountToSkip);
            timing.finishIndexDocumentFetch();
            List searchResultItems = this.stageSearchResultItems(documents);
            timing.finishHighLight();
            TimingResult timingResult = timing.build();
            StageIndexSearchResult stageIndexSearchResult = StageIndexSearchResult.of((InternalSearchRequest)internalSearchRequest, (long)totalHitsCount, (int)totalPages, (List)searchResultItems, (TimingResult)timingResult);
            return stageIndexSearchResult;
        }
        catch (IOException ioe) {
            throw new IndexNotAccessibleException(String.format("Cannot execute Search %s, reason: %s", internalSearchRequest, ioe.getMessage()));
        }
        finally {
            if (null != searcher) {
                this.searcherManager.release((Object)searcher);
            }
        }
    }

    @Nonnull
    public SubProjectIndexSearchResult subProjects(@NonNull InternalSearchRequest internalSearchRequest) throws IOException {
        if (internalSearchRequest == null) {
            throw new NullPointerException("internalSearchRequest is marked non-null but is null");
        }
        Timing timing = Timing.createStarted();
        IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
        try {
            IndexReader indexReader = searcher.getIndexReader();
            Query query = internalSearchRequest.getPreparedQuery().getQuery();
            int page = internalSearchRequest.getPage();
            int documentAmountToFetch = internalSearchRequest.getSize();
            timing.finishIndexPrepare();
            Sort sort = new Sort(new SortField[]{new SortField(ESubProjectIndexField.SORT_SUB_PROJECT__NAME.fieldName(), SortField.Type.STRING, false)});
            int documentAmountToSkip = page * documentAmountToFetch;
            TopFieldDocs topDocs = searcher.search(query, documentAmountToSkip + documentAmountToFetch, sort);
            int totalHitsCount = searcher.count(query);
            int totalPages = IndexAccessHelper.totalPages((int)documentAmountToFetch, (long)totalHitsCount);
            timing.finishIndexSearch();
            List documents = IndexAccessHelper.documents((IndexReader)indexReader, (TopDocs)topDocs, (int)documentAmountToSkip);
            timing.finishIndexDocumentFetch();
            List searchResultItems = this.subProjectSearchResultItems(documents);
            timing.finishHighLight();
            TimingResult timingResult = timing.build();
            SubProjectIndexSearchResult subProjectIndexSearchResult = SubProjectIndexSearchResult.of((InternalSearchRequest)internalSearchRequest, (long)totalHitsCount, (int)totalPages, (List)searchResultItems, (TimingResult)timingResult);
            return subProjectIndexSearchResult;
        }
        catch (IOException ioe) {
            throw new IndexNotAccessibleException(String.format("Cannot execute Search %s, reason: %s", internalSearchRequest, ioe.getMessage()));
        }
        finally {
            if (null != searcher) {
                this.searcherManager.release((Object)searcher);
            }
        }
    }

    @Nonnull
    public UserIndexSearchResult users(@NonNull InternalSearchRequest internalSearchRequest) throws IOException {
        if (internalSearchRequest == null) {
            throw new NullPointerException("internalSearchRequest is marked non-null but is null");
        }
        Timing timing = Timing.createStarted();
        IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
        try {
            IndexReader indexReader = searcher.getIndexReader();
            Query query = internalSearchRequest.getPreparedQuery().getQuery();
            int page = internalSearchRequest.getPage();
            int documentAmountToFetch = internalSearchRequest.getSize();
            timing.finishIndexPrepare();
            Sort sort = new Sort(new SortField[]{new SortedNumericSortField(EUserIndexField.SORT_USER__CREATED_ON.fieldName(), SortField.Type.LONG, true)});
            int documentAmountToSkip = page * documentAmountToFetch;
            TopFieldDocs topDocs = searcher.search(query, documentAmountToSkip + documentAmountToFetch, sort);
            int totalHitsCount = searcher.count(query);
            int totalPages = IndexAccessHelper.totalPages((int)documentAmountToFetch, (long)totalHitsCount);
            timing.finishIndexSearch();
            List documents = IndexAccessHelper.documents((IndexReader)indexReader, (TopDocs)topDocs, (int)documentAmountToSkip);
            timing.finishIndexDocumentFetch();
            List searchResultItems = this.userSearchResultItems(documents);
            timing.finishHighLight();
            TimingResult timingResult = timing.build();
            UserIndexSearchResult userIndexSearchResult = UserIndexSearchResult.of((InternalSearchRequest)internalSearchRequest, (long)totalHitsCount, (int)totalPages, (List)searchResultItems, (TimingResult)timingResult);
            return userIndexSearchResult;
        }
        catch (IOException ioe) {
            throw new IndexNotAccessibleException(String.format("Cannot execute Search %s, reason: %s", internalSearchRequest, ioe.getMessage()));
        }
        finally {
            if (null != searcher) {
                this.searcherManager.release((Object)searcher);
            }
        }
    }

    @Nonnull
    public MeasurementIndexSearchResult measurements(@NonNull InternalSearchRequest internalSearchRequest) throws IOException {
        if (internalSearchRequest == null) {
            throw new NullPointerException("internalSearchRequest is marked non-null but is null");
        }
        Timing timing = Timing.createStarted();
        IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
        try {
            IndexReader indexReader = searcher.getIndexReader();
            Query query = internalSearchRequest.getPreparedQuery().getQuery();
            int page = internalSearchRequest.getPage();
            int documentAmountToFetch = internalSearchRequest.getSize();
            timing.finishIndexPrepare();
            Sort sort = new Sort(new SortField[]{new SortedNumericSortField(EMeasurementIndexField.SORT_MEASUREMENT__CREATED_ON.fieldName(), SortField.Type.LONG, true)});
            int documentAmountToSkip = page * documentAmountToFetch;
            log.info("documentAmountToSkip: {}", (Object)documentAmountToSkip);
            TopFieldDocs topDocs = searcher.search(query, documentAmountToSkip + documentAmountToFetch, sort);
            log.info("Fetched {} documents", (Object)topDocs.scoreDocs.length);
            int totalHitsCount = searcher.count(query);
            log.info("totalHitsCount: {}", (Object)totalHitsCount);
            int totalPages = IndexAccessHelper.totalPages((int)documentAmountToFetch, (long)totalHitsCount);
            log.info("totalPages: {}", (Object)totalPages);
            timing.finishIndexSearch();
            List documents = IndexAccessHelper.documents((IndexReader)indexReader, (TopDocs)topDocs, (int)documentAmountToSkip);
            log.info("Fetched {} documents", (Object)documents.size());
            timing.finishIndexDocumentFetch();
            List searchResultItems = this.measurementSearchResultItems(documents);
            log.info("Fetched {} search result items", (Object)searchResultItems.size());
            timing.finishHighLight();
            TimingResult timingResult = timing.build();
            MeasurementIndexSearchResult measurementIndexSearchResult = MeasurementIndexSearchResult.of((InternalSearchRequest)internalSearchRequest, (long)totalHitsCount, (int)totalPages, (List)searchResultItems, (TimingResult)timingResult);
            return measurementIndexSearchResult;
        }
        catch (IOException ioe) {
            throw new IndexNotAccessibleException(String.format("Cannot execute Search %s, reason: %s", internalSearchRequest, ioe.getMessage()));
        }
        finally {
            if (null != searcher) {
                this.searcherManager.release((Object)searcher);
            }
        }
    }

    @Nonnull
    private List<CustomerSearchResultItem> customerSearchResultItems(@NonNull List<Pair<Document, Float>> documents) {
        if (documents == null) {
            throw new NullPointerException("documents is marked non-null but is null");
        }
        ImmutableList.Builder scoreDocumentBuilder = ImmutableList.builder();
        for (Pair<Document, Float> documentPair : documents) {
            Document document = (Document)documentPair.getLeft();
            Float score = (Float)documentPair.getRight();
            String source = document.get(ECustomerIndexField._SOURCE.fieldName());
            Optional customerIndexEntryCandidate = this.customerIndexEntrySerializer.unSerialize(source);
            customerIndexEntryCandidate.ifPresent(customerIndexEntry -> scoreDocumentBuilder.add((Object)CustomerSearchResultItem.of((Document)document, (Float)score, (CustomerIndexEntry)customerIndexEntry)));
        }
        return scoreDocumentBuilder.build();
    }

    @Nonnull
    private List<EntitySearchResultItem> entitySearchResultItems(@NonNull List<Pair<Document, Float>> documents) {
        if (documents == null) {
            throw new NullPointerException("documents is marked non-null but is null");
        }
        ImmutableList.Builder scoreDocumentBuilder = ImmutableList.builder();
        for (Pair<Document, Float> documentPair : documents) {
            Document document = (Document)documentPair.getLeft();
            Float score = (Float)documentPair.getRight();
            String source = document.get(EUserIndexField._SOURCE.fieldName());
            Optional indexEntryCandidate = this.entityIndexEntrySerializer.unSerialize(source);
            indexEntryCandidate.ifPresent(indexEntry -> scoreDocumentBuilder.add((Object)EntitySearchResultItem.of((Document)document, (Float)score, (EntityIndexEntry)indexEntry)));
        }
        return scoreDocumentBuilder.build();
    }

    @Nonnull
    private List<InvoiceSearchResultItem> invoiceSearchResultItems(@NonNull List<Pair<Document, Float>> documents) {
        if (documents == null) {
            throw new NullPointerException("documents is marked non-null but is null");
        }
        ImmutableList.Builder scoreDocumentBuilder = ImmutableList.builder();
        for (Pair<Document, Float> documentPair : documents) {
            Document document = (Document)documentPair.getLeft();
            Float score = (Float)documentPair.getRight();
            String source = document.get(EInvoiceIndexField._SOURCE.fieldName());
            Optional invoiceIndexEntryCandidate = this.invoiceIndexEntrySerializer.unSerialize(source);
            invoiceIndexEntryCandidate.ifPresent(invoiceIndexEntry -> scoreDocumentBuilder.add((Object)InvoiceSearchResultItem.of((Document)document, (Float)score, (InvoiceIndexEntry)invoiceIndexEntry)));
        }
        return scoreDocumentBuilder.build();
    }

    @Nonnull
    private List<StageSearchResultItem> stageSearchResultItems(@NonNull List<Pair<Document, Float>> documents) {
        if (documents == null) {
            throw new NullPointerException("documents is marked non-null but is null");
        }
        ImmutableList.Builder scoreDocumentBuilder = ImmutableList.builder();
        for (Pair<Document, Float> documentPair : documents) {
            Document document = (Document)documentPair.getLeft();
            Float score = (Float)documentPair.getRight();
            String source = document.get(EStageIndexField._SOURCE.fieldName());
            Optional indexEntryCandidate = this.stageIndexEntrySerializer.unSerialize(source);
            indexEntryCandidate.ifPresent(indexEntry -> scoreDocumentBuilder.add((Object)StageSearchResultItem.of((Document)document, (Float)score, (StageIndexEntry)indexEntry)));
        }
        return scoreDocumentBuilder.build();
    }

    @Nonnull
    private List<SubProjectSearchResultItem> subProjectSearchResultItems(@NonNull List<Pair<Document, Float>> documents) {
        if (documents == null) {
            throw new NullPointerException("documents is marked non-null but is null");
        }
        ImmutableList.Builder scoreDocumentBuilder = ImmutableList.builder();
        for (Pair<Document, Float> documentPair : documents) {
            Document document = (Document)documentPair.getLeft();
            Float score = (Float)documentPair.getRight();
            String source = document.get(EStageIndexField._SOURCE.fieldName());
            Optional indexEntryCandidate = this.subProjectIndexEntrySerializer.unSerialize(source);
            indexEntryCandidate.ifPresent(indexEntry -> scoreDocumentBuilder.add((Object)SubProjectSearchResultItem.of((Document)document, (Float)score, (SubProjectIndexEntry)indexEntry)));
        }
        return scoreDocumentBuilder.build();
    }

    @Nonnull
    private List<UserSearchResultItem> userSearchResultItems(@NonNull List<Pair<Document, Float>> documents) {
        if (documents == null) {
            throw new NullPointerException("documents is marked non-null but is null");
        }
        ImmutableList.Builder scoreDocumentBuilder = ImmutableList.builder();
        for (Pair<Document, Float> documentPair : documents) {
            Document document = (Document)documentPair.getLeft();
            Float score = (Float)documentPair.getRight();
            String source = document.get(EUserIndexField._SOURCE.fieldName());
            Optional indexEntryCandidate = this.userIndexEntrySerializer.unSerialize(source);
            indexEntryCandidate.ifPresent(invoiceIndexEntry -> scoreDocumentBuilder.add((Object)UserSearchResultItem.of((Document)document, (Float)score, (UserIndexEntry)invoiceIndexEntry)));
        }
        return scoreDocumentBuilder.build();
    }

    @Nonnull
    private List<MeasurementSearchResultItem> measurementSearchResultItems(@NonNull List<Pair<Document, Float>> documents) {
        if (documents == null) {
            throw new NullPointerException("documents is marked non-null but is null");
        }
        ImmutableList.Builder scoreDocumentBuilder = ImmutableList.builder();
        for (Pair<Document, Float> documentPair : documents) {
            Document document = (Document)documentPair.getLeft();
            Float score = (Float)documentPair.getRight();
            String source = document.get(EMeasurementIndexField._SOURCE.fieldName());
            Optional measurementIndexEntryCandidate = this.measurementIndexEntrySerializer.unSerialize(source);
            measurementIndexEntryCandidate.ifPresent(measurementIndexEntry -> scoreDocumentBuilder.add((Object)MeasurementSearchResultItem.of((Document)document, (Float)score, (MeasurementIndexEntry)measurementIndexEntry)));
        }
        return scoreDocumentBuilder.build();
    }

    public long deleteFromIndex(@NonNull Query query) throws IOException {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        long seqNo = this.indexWriter.deleteDocuments(new Query[]{query});
        this.searcherManager.maybeRefresh();
        return seqNo;
    }

    @Nonnull
    public List<Pair<Document, Float>> document(@NonNull String documentId) throws IOException {
        if (documentId == null) {
            throw new NullPointerException("documentId is marked non-null but is null");
        }
        IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
        try {
            IndexReader indexReader = searcher.getIndexReader();
            TermQuery query = InternalQueryHelper.termQuery((IndexField)EMeasurementIndexField._ID, (String)documentId);
            TopDocs topDocs = searcher.search((Query)query, 10);
            List list = IndexAccessHelper.documents((IndexReader)indexReader, (TopDocs)topDocs);
            return list;
        }
        catch (IOException ioe) {
            throw new IndexNotAccessibleException(String.format("Cannot extract Document %s, reason: %s", documentId, ioe.getMessage()));
        }
        finally {
            if (null != searcher) {
                this.searcherManager.release((Object)searcher);
            }
        }
    }

    @Nonnull
    public List<Pair<Document, Float>> search(@NonNull Query query) throws IOException {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
        try {
            IndexReader indexReader = searcher.getIndexReader();
            TopDocs topDocs = searcher.search(query, 10);
            List list = IndexAccessHelper.documents((IndexReader)indexReader, (TopDocs)topDocs);
            return list;
        }
        catch (IOException ioe) {
            throw new IndexNotAccessibleException(String.format("Cannot fetch Document, reason: %s", ioe.getMessage()));
        }
        finally {
            if (null != searcher) {
                this.searcherManager.release((Object)searcher);
            }
        }
    }

    public boolean commitAndRefreshIndex() {
        try {
            long indexVersion = this.indexWriter.commit();
            if (this.searchConfiguration.isBlockingRefresh()) {
                this.searcherManager.maybeRefreshBlocking();
            } else {
                this.searcherManager.maybeRefresh();
            }
            log.debug("Committing / Refreshing Index finished");
            return true;
        }
        catch (IOException ioe) {
            log.error("Error Committing / Refreshing Index: {}", (Object)ioe.getMessage(), (Object)ioe);
            return false;
        }
    }
}

