/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.search;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.model.search.EMeasurementIndexField;
import de.qfm.erp.service.model.search.IndexDocument;
import de.qfm.erp.service.model.search.IndexField;
import de.qfm.erp.service.service.mapper.search.InternalQueryHelper;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherManager;

public abstract class AbstractIndexServiceImpl<T> {
    private final IndexWriter indexWriter;
    private final SearcherManager searcherManager;

    @Nonnull
    public Map<String, IndexDocument> update(@NonNull IndexDocument document) throws IOException {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        return this.update((Iterable)ImmutableSet.of((Object)document));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Map<String, IndexDocument> update(@NonNull Iterable<IndexDocument> documents) throws IOException {
        if (documents == null) {
            throw new NullPointerException("documents is marked non-null but is null");
        }
        ImmutableMap.Builder map = ImmutableMap.builder();
        try {
            int count = 0;
            for (IndexDocument entry : documents) {
                String id = entry.getId();
                Document document = entry.getDocument();
                this.indexWriter.updateDocument(new Term(EMeasurementIndexField._ID.fieldName(), id), (Iterable)document);
                map.put((Object)id, (Object)entry);
                if (++count % 50 != 0) continue;
                this.indexWriter.commit();
            }
        }
        finally {
            this.indexWriter.commit();
            this.searcherManager.maybeRefresh();
        }
        return map.build();
    }

    public long delete(@NonNull Query query) throws IOException {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        long seqNo = this.indexWriter.deleteDocuments(new Query[]{query});
        this.searcherManager.maybeRefresh();
        return seqNo;
    }

    public long delete(@NonNull String documentId) throws IOException {
        if (documentId == null) {
            throw new NullPointerException("documentId is marked non-null but is null");
        }
        return this.indexWriter.deleteDocuments(new Query[]{InternalQueryHelper.termQuery((IndexField)EMeasurementIndexField._ID, (String)documentId)});
    }

    protected AbstractIndexServiceImpl(IndexWriter indexWriter, SearcherManager searcherManager) {
        this.indexWriter = indexWriter;
        this.searcherManager = searcherManager;
    }
}

