/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.print;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import de.leancoders.common.helper.IterableHelper;
import de.qfm.erp.service.configuration.PrintLayoutConfig;
import de.qfm.erp.service.model.internal.pdfbox.EValueSource;
import de.qfm.erp.service.model.internal.print.EPrintFontSize;
import de.qfm.erp.service.model.internal.print.PrintConfiguration;
import de.qfm.erp.service.model.internal.print.PrintFonts;
import de.qfm.erp.service.model.internal.print.PrintInfo;
import de.qfm.erp.service.model.internal.print.PrintSetup;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementGroupedPrintConfiguration;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementPositionTransposedPrintGroup;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementPrintConfiguration;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementPrintGrouped;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementPrintInfo;
import de.qfm.erp.service.model.internal.print.measurement.TransposedItem;
import de.qfm.erp.service.model.jpa.configuration.ConfigurationCompany;
import de.qfm.erp.service.service.route.impl.PrintHelper;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.service.DateTimeHelperService;
import de.qfm.erp.service.service.service.print.MeasurementGroupedPrintService;
import de.qfm.erp.service.service.service.print.MeasurementPrintService;
import de.qfm.erp.service.service.service.print.PrintColumn;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.springframework.stereotype.Service;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MeasurementGroupedPrintService
extends MeasurementPrintService<MeasurementPrintGrouped, MeasurementGroupedPrintConfiguration> {
    private final PrintLayoutConfig printLayoutConfig;
    private static final Iterable<PrintColumn<TransposedItem>> GROUPED_COLUMNS_WITH_WAGE = ImmutableList.copyOf((Object[])EGroupedDetailColumn.values());
    private static final Iterable<PrintColumn<TransposedItem>> GROUPED_COLUMNS_WITHOUT_WAGE = ImmutableList.copyOf(IterableHelper.stream((Iterable)GROUPED_COLUMNS_WITH_WAGE).filter(item -> item != EGroupedDetailColumn.SQUAD_WAGE).iterator());

    public MeasurementGroupedPrintService(@NonNull UserService userService, @NonNull DateTimeHelperService dateTimeHelperService, @NonNull PrintHelper printHelper, @NonNull PrintLayoutConfig printLayoutConfig) {
        super(userService, dateTimeHelperService, printHelper);
        if (userService == null) {
            throw new NullPointerException("userService is marked non-null but is null");
        }
        if (dateTimeHelperService == null) {
            throw new NullPointerException("dateTimeHelperService is marked non-null but is null");
        }
        if (printHelper == null) {
            throw new NullPointerException("printHelper is marked non-null but is null");
        }
        if (printLayoutConfig == null) {
            throw new NullPointerException("printLayoutConfig is marked non-null but is null");
        }
        this.printLayoutConfig = printLayoutConfig;
    }

    @Nonnull
    public byte[] generatePDF(@NonNull MeasurementPrintGrouped measurementPrintGrouped, @NonNull MeasurementGroupedPrintConfiguration printConfiguration, @NonNull EPrintFontSize printFontSize, @NonNull ConfigurationCompany configurationCompany) {
        byte[] byArray;
        block19: {
            if (measurementPrintGrouped == null) {
                throw new NullPointerException("measurementPrintGrouped is marked non-null but is null");
            }
            if (printConfiguration == null) {
                throw new NullPointerException("printConfiguration is marked non-null but is null");
            }
            if (printFontSize == null) {
                throw new NullPointerException("printFontSize is marked non-null but is null");
            }
            if (configurationCompany == null) {
                throw new NullPointerException("configurationCompany is marked non-null but is null");
            }
            PDRectangle mediaBox = new PDRectangle(PDRectangle.A4.getHeight(), PDRectangle.A4.getWidth());
            PDDocument document = this.document((PrintInfo)measurementPrintGrouped, (PrintConfiguration)printConfiguration);
            try {
                PrintSetup printSetup = PrintHelper.printSetup((PrintLayoutConfig)this.printLayoutConfig, (ConfigurationCompany)configurationCompany, (EPrintFontSize)printFontSize, (PDDocument)document, PrintLayoutConfig::getMeasurementLogoPadding, PrintLayoutConfig::getMeasurementLogoHeight, PrintLayoutConfig::getMeasurementLogoBuffer);
                Table footer = MeasurementGroupedPrintService.footer((MeasurementPrintConfiguration)printConfiguration, (PrintSetup)printSetup, (PDRectangle)mediaBox);
                List headers = this.header((MeasurementPrintInfo)measurementPrintGrouped, (PrintConfiguration)printConfiguration, document, mediaBox, printSetup);
                float headerHeight = MeasurementGroupedPrintService.height((Iterable)headers);
                float footerHeight = footer.getHeight();
                float maxDetailsHeight = MeasurementGroupedPrintService.maxDetailsHeight((PDRectangle)mediaBox, (float)headerHeight, (float)footerHeight, (float)0.0f);
                boolean isWageToBePrinted = this.isWageToBePrinted((PrintConfiguration)printConfiguration);
                Iterable columns = isWageToBePrinted ? GROUPED_COLUMNS_WITH_WAGE : GROUPED_COLUMNS_WITHOUT_WAGE;
                List details = this.groupedDetails(measurementPrintGrouped, printConfiguration, printSetup, columns, mediaBox);
                Iterable pagedTables = MeasurementGroupedPrintService.splitVertically((Iterable)details, (int)2, (float)maxDetailsHeight, (float)10.0f);
                for (Iterable tablesOnPage : pagedTables) {
                    PDPage page = MeasurementGroupedPrintService.page((PDDocument)document, (PDRectangle)mediaBox);
                    try (PDPageContentStream contentStream = new PDPageContentStream(document, page);){
                        float yOffset = MeasurementGroupedPrintService.printHeader((PDPageContentStream)contentStream, (PDPage)page, (Iterable)headers);
                        yOffset -= 10.0f;
                        for (Table table : tablesOnPage) {
                            TableDrawer.builder().page(page).contentStream(contentStream).startX(20.0f).startY(yOffset).table(table).build().draw();
                            yOffset -= table.getHeight();
                            yOffset -= 10.0f;
                        }
                    }
                }
                MeasurementGroupedPrintService.writeMeta((PrintSetup)printSetup, (PDDocument)document, (Table)footer);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                document.save((OutputStream)outputStream);
                byArray = outputStream.toByteArray();
                if (document == null) break block19;
            }
            catch (Throwable throwable) {
                try {
                    if (document != null) {
                        try {
                            document.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return new byte[0];
                }
            }
            document.close();
        }
        return byArray;
    }

    @Nonnull
    private List<Table> groupedDetails(@NonNull MeasurementPrintGrouped measurementPrintGrouped, @NonNull MeasurementGroupedPrintConfiguration groupedPrintConfiguration, @NonNull PrintSetup printSetup, @NonNull Iterable<PrintColumn<TransposedItem>> columns, @NonNull PDRectangle mediaBox) {
        if (measurementPrintGrouped == null) {
            throw new NullPointerException("measurementPrintGrouped is marked non-null but is null");
        }
        if (groupedPrintConfiguration == null) {
            throw new NullPointerException("groupedPrintConfiguration is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (columns == null) {
            throw new NullPointerException("columns is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        PrintFonts printFonts = printSetup.getPrintFonts();
        int fontSize = printSetup.getDetailsFontSize();
        List measurementPositions = measurementPrintGrouped.getMeasurementPositions();
        int columnAmount = Iterables.size(columns);
        ImmutableList columnWidths = ImmutableList.copyOf(IterableHelper.stream(columns).map(PrintColumn::getWidth).iterator());
        ImmutableList columnNames = ImmutableList.copyOf(IterableHelper.stream(columns).map(PrintColumn::getName).iterator());
        ImmutableList.Builder tablesBuilder = ImmutableList.builder();
        for (MeasurementPositionTransposedPrintGroup measurementPositionTransposedPrintGroup : measurementPositions) {
            String remarks = measurementPositionTransposedPrintGroup.getRemarks();
            ImmutableList transposedItems = ImmutableList.copyOf((Iterable)measurementPositionTransposedPrintGroup.getValues());
            Table.TableBuilder tableBuilder = MeasurementGroupedPrintService.table((PDRectangle)mediaBox, (Iterable)columnWidths);
            Row headline1 = Row.builder().backgroundColor(groupedPrintConfiguration.getHeaderBgColor()).add((AbstractCell)MeasurementGroupedPrintService.detailHeader((PrintSetup)printSetup, (String)"Gruppe")).add((AbstractCell)MeasurementGroupedPrintService.detailHeader((PrintSetup)printSetup, (String)remarks, (int)(columnAmount - 1))).build();
            Row.RowBuilder headline2Builder = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER);
            columnNames.forEach(item -> headline2Builder.add((AbstractCell)MeasurementGroupedPrintService.detailHeader((PrintSetup)printSetup, (String)item)));
            Row headline2 = headline2Builder.build();
            tableBuilder.addRow(headline1);
            tableBuilder.addRow(headline2);
            for (TransposedItem transposedItem : transposedItems) {
                BigDecimal product = transposedItem.getProduct();
                if (null == product) continue;
                Row.RowBuilder rowBuilder = Row.builder();
                columns.forEach(column -> {
                    boolean valueCell = column.isValueCell();
                    String text = (String)column.getTextFn().apply(transposedItem);
                    BigDecimal value = (BigDecimal)column.getValueFn().apply(transposedItem);
                    EValueSource source = column.getSource();
                    if (valueCell) {
                        String rowKey = transposedItem.getQuotationSurrogatePositionNumber();
                        String columnKey = source.name();
                        rowBuilder.add((AbstractCell)MeasurementGroupedPrintService.valueCell((PDFont)printFonts.getRegular(), (int)fontSize, (String)rowKey, (String)columnKey, (BigDecimal)value, (EValueSource)source, (HorizontalAlignment)HorizontalAlignment.RIGHT, (Iterable)ALL, (Iterable)ImmutableList.of()));
                    } else {
                        rowBuilder.add((AbstractCell)MeasurementGroupedPrintService.descriptionCell((PrintSetup)printSetup, (String)text));
                    }
                });
                Row detailRow = rowBuilder.build();
                tableBuilder.addRow(detailRow);
            }
            Table table = tableBuilder.build();
            tablesBuilder.add((Object)table);
        }
        return tablesBuilder.build();
    }
}

