/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.pdf;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import de.qfm.erp.service.helper.BigDecimalHelper;
import de.qfm.erp.service.model.internal.invoice.EPdfExtractType;
import de.qfm.erp.service.model.internal.invoice.InvoicePdfExtraction;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.service.service.MessageService;
import de.qfm.erp.service.service.service.pdf.InvoicePdfExtractor;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class StromnetzBerlinInvoicePdfExtractor
extends InvoicePdfExtractor {
    private static final Logger log = LogManager.getLogger(StromnetzBerlinInvoicePdfExtractor.class);
    protected static final DateTimeFormatter DATE_TIME_FORMATTER_DE = DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM).withLocale(Locale.GERMAN);
    protected static final CharMatcher DATE_MATCHER = CharMatcher.anyOf((CharSequence)"0123456789.").precomputed();
    protected static final String TYPE_VOUCHER = "Gutschriftsanzeige";
    protected static final String TYPE_DEBIT_NOTE = "Belastungsanzeige";
    private final MessageService messageService;

    public StromnetzBerlinInvoicePdfExtractor(MessageService messageService) {
        super(EPdfExtractType.STROMNETZ_BERLIN);
        this.messageService = messageService;
    }

    public boolean canExtract(@NonNull PDDocument document, @NonNull String text, @NonNull Iterable<String> rows) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (rows == null) {
            throw new NullPointerException("rows is marked non-null but is null");
        }
        log.info("Parsing Result: {}", (Object)text);
        boolean addressFound = StringUtils.contains((CharSequence)text, (CharSequence)"Stromnetz Berlin GmbH");
        boolean isVoucher = this.isOfType(rows, "Gutschriftsanzeige");
        return addressFound && isVoucher;
    }

    public InvoicePdfExtraction extract(@NonNull String text, @NonNull Iterable<String> rows) {
        String voucherDateString;
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (rows == null) {
            throw new NullPointerException("rows is marked non-null but is null");
        }
        boolean isVoucher = this.isOfType(rows, "Gutschriftsanzeige");
        boolean isDebitNote = this.isOfType(rows, "Belastungsanzeige");
        if (!isVoucher) {
            if (isDebitNote) {
                return InvoicePdfExtraction.error((String)this.messageService.get((Translatable)EMessageKey.INVOICE__UPLOAD_PDF_ERROR__TYPE_IS_DEBIT_NOTE, new Object[]{"Belastungsanzeige"}), (EPdfExtractType)this.pdfExtractType);
            }
            return InvoicePdfExtraction.error((String)this.messageService.get((Translatable)EMessageKey.INVOICE__UPLOAD_PDF_ERROR__TYPE_NOT_SUPPORTED, new Object[]{"Gutschriftsanzeige"}), (EPdfExtractType)this.pdfExtractType);
        }
        List orderNumbers = StromnetzBerlinInvoicePdfExtractor.rowsBetweenStartingWith(rows, (String)"Belegnummer", (String)"Ihre Lieferantennummer");
        List orderNumbersCleaned = orderNumbers.stream().map(item -> StringUtils.substringBefore((String)item, (String)" ")).map(StringUtils::trimToEmpty).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List dates = orderNumbers.stream().map(item -> StringUtils.substringAfterLast((String)item, (String)"/")).map(arg_0 -> ((CharMatcher)DATE_MATCHER).retainFrom(arg_0)).map(StringUtils::trimToEmpty).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        String measurementNumbersCandidate = StromnetzBerlinInvoicePdfExtractor.rowBeforeStartingWith(rows, (String)"Leistungsort:").orElse("");
        ImmutableList measurementNumbers = ImmutableList.copyOf((Iterable)StromnetzBerlinInvoicePdfExtractor.measurementNumbers((String)measurementNumbersCandidate));
        if (measurementNumbers.isEmpty()) {
            return InvoicePdfExtraction.error((String)this.messageService.get(EMessageKey.INVOICE__UPLOAD_PDF_ERROR__NO_MEASUREMENT_FOUND), (EPdfExtractType)this.pdfExtractType);
        }
        String orderNumberCandidate = StromnetzBerlinInvoicePdfExtractor.rowAfterStartingWith(rows, (String)"Leistungsort:", (int)2).orElse("");
        String orderNumber = StringUtils.substringBefore((String)orderNumberCandidate, (String)" ");
        String constructionPeriodRow = StromnetzBerlinInvoicePdfExtractor.extract(rows, (String)"Leistungsort:");
        String constructionPeriodCandidate = StringUtils.trimToEmpty((String)StringUtils.substringAfterLast((String)constructionPeriodRow, (String)"Zeitraum:"));
        String orderNumber2 = "";
        String referenceNumber = StringUtils.substringBefore((String)"TODO", (String)" ");
        String voucherNumber = StringUtils.trimToEmpty((String)((String)Iterables.get(orderNumbersCleaned, (int)1, (Object)"")));
        String creditVoucherNumber = StringUtils.trimToEmpty((String)((String)Iterables.get(orderNumbersCleaned, (int)0, (Object)"")));
        String costCenter = "";
        String projectExecutionFromString = StringUtils.substringBefore((String)constructionPeriodCandidate, (String)" ");
        String projectExecutionEndString = StringUtils.substringAfterLast((String)constructionPeriodCandidate, (String)" ");
        String orderDateString = voucherDateString = (String)Iterables.get(dates, (int)0, (Object)"");
        String priceNetRow = StromnetzBerlinInvoicePdfExtractor.extract(rows, (String)"Summe Nettowert");
        String taxRow = StromnetzBerlinInvoicePdfExtractor.extract(rows, (String)"Umsatzsteuer");
        String priceGrossRow = StromnetzBerlinInvoicePdfExtractor.extract(rows, (String)"Endbetrag");
        String priceNetString = StringUtils.trimToEmpty((String)priceNetRow);
        String taxString = StringUtils.substringBefore((String)taxRow, (String)"%");
        String priceGrossString = StringUtils.trimToEmpty((String)priceGrossRow);
        LocalDate orderDate = LocalDate.from(DATE_TIME_FORMATTER_DE.parse(orderDateString));
        LocalDate voucherDate = LocalDate.from(DATE_TIME_FORMATTER_DE.parse(voucherDateString));
        LocalDate projectExecutionFrom = LocalDate.from(DATE_TIME_FORMATTER_DE.parse(projectExecutionFromString));
        LocalDate projectExecutionEnd = LocalDate.from(DATE_TIME_FORMATTER_DE.parse(projectExecutionEndString));
        BigDecimal priceNet = BigDecimalHelper.parseGermanCurrency((String)priceNetString);
        BigDecimal priceGross = BigDecimalHelper.parseGermanCurrency((String)priceGrossString);
        BigDecimal tax = BigDecimalHelper.parseGermanCurrency((String)taxString);
        BigDecimal valueOverallVAT = BigDecimal.ZERO;
        return InvoicePdfExtraction.success((EPdfExtractType)this.pdfExtractType, (String)orderNumber, (String)"", (String)referenceNumber, (String)voucherNumber, (String)creditVoucherNumber, (LocalDate)orderDate, (LocalDate)voucherDate, (String)"", (LocalDate)projectExecutionFrom, (LocalDate)projectExecutionEnd, (BigDecimal)priceNet, (BigDecimal)tax, (BigDecimal)valueOverallVAT, (BigDecimal)priceGross, (List)measurementNumbers);
    }

    @VisibleForTesting
    static List<String> rowsBetweenStartingWith(@NonNull Iterable<String> rows, @NonNull String r1, @NonNull String r2) {
        if (rows == null) {
            throw new NullPointerException("rows is marked non-null but is null");
        }
        if (r1 == null) {
            throw new NullPointerException("r1 is marked non-null but is null");
        }
        if (r2 == null) {
            throw new NullPointerException("r2 is marked non-null but is null");
        }
        ImmutableList.Builder extractedRowsBuilder = ImmutableList.builder();
        boolean extract = false;
        for (String row : rows) {
            if (StringUtils.startsWithIgnoreCase((CharSequence)row, (CharSequence)r1)) {
                extract = true;
                continue;
            }
            if (StringUtils.startsWithIgnoreCase((CharSequence)row, (CharSequence)r2)) {
                extract = false;
                break;
            }
            if (!extract) continue;
            extractedRowsBuilder.add((Object)row);
        }
        return extractedRowsBuilder.build();
    }

    @VisibleForTesting
    static Optional<String> rowBeforeStartingWith(@NonNull Iterable<String> rows, @NonNull String r1) {
        if (rows == null) {
            throw new NullPointerException("rows is marked non-null but is null");
        }
        if (r1 == null) {
            throw new NullPointerException("r1 is marked non-null but is null");
        }
        return StromnetzBerlinInvoicePdfExtractor.rowBeforeStartingWith(rows, (String)r1, (int)-1);
    }

    @VisibleForTesting
    static Optional<String> rowBeforeStartingWith(@NonNull Iterable<String> rows, @NonNull String r1, int addIndex) {
        String row;
        if (rows == null) {
            throw new NullPointerException("rows is marked non-null but is null");
        }
        if (r1 == null) {
            throw new NullPointerException("r1 is marked non-null but is null");
        }
        boolean found = false;
        int index = 0;
        Iterator<String> iterator = rows.iterator();
        while (iterator.hasNext() && !(found = StringUtils.startsWithIgnoreCase((CharSequence)(row = iterator.next()), (CharSequence)r1))) {
            ++index;
        }
        if (found && index > 0) {
            return Optional.ofNullable((String)Iterables.get(rows, (int)(index + addIndex)));
        }
        return Optional.empty();
    }

    @VisibleForTesting
    static Optional<String> rowAfterStartingWith(@NonNull Iterable<String> rows, @NonNull String r1, int addIndex) {
        String row;
        if (rows == null) {
            throw new NullPointerException("rows is marked non-null but is null");
        }
        if (r1 == null) {
            throw new NullPointerException("r1 is marked non-null but is null");
        }
        boolean found = false;
        int index = 0;
        Iterator<String> iterator = rows.iterator();
        while (iterator.hasNext() && !(found = StringUtils.startsWithIgnoreCase((CharSequence)(row = iterator.next()), (CharSequence)r1))) {
            ++index;
        }
        if (found && index > 0) {
            return Optional.ofNullable((String)Iterables.get(rows, (int)(index + addIndex)));
        }
        return Optional.empty();
    }

    private boolean isOfType(@NonNull Iterable<String> rows, String value) {
        if (rows == null) {
            throw new NullPointerException("rows is marked non-null but is null");
        }
        return !Iterables.isEmpty((Iterable)StromnetzBerlinInvoicePdfExtractor.contains(rows, (String)value));
    }
}

