/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.gaeb;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.thoughtworks.xstream.XStream;
import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.service.helper.MeasurementHelper;
import de.qfm.erp.service.model.external.gaeb.x31.BoQ;
import de.qfm.erp.service.model.external.gaeb.x31.BoQBkdn;
import de.qfm.erp.service.model.external.gaeb.x31.BoQBody;
import de.qfm.erp.service.model.external.gaeb.x31.BoQCtgy;
import de.qfm.erp.service.model.external.gaeb.x31.Creator;
import de.qfm.erp.service.model.external.gaeb.x31.GAEB;
import de.qfm.erp.service.model.external.gaeb.x31.GAEBInfo;
import de.qfm.erp.service.model.external.gaeb.x31.Item;
import de.qfm.erp.service.model.external.gaeb.x31.Itemlist;
import de.qfm.erp.service.model.external.gaeb.x31.Profiler;
import de.qfm.erp.service.model.external.gaeb.x31.ProjectInfo;
import de.qfm.erp.service.model.external.gaeb.x31.QuantityDetermination;
import de.qfm.erp.service.model.external.gaeb.x31.QuantityDeterminationInfo;
import de.qfm.erp.service.model.external.gaeb.x31.QuantityDeterminationItem;
import de.qfm.erp.service.model.external.gaeb.x31.QuantityTakeoff;
import de.qfm.erp.service.model.internal.gaeb.GaebX31ExportResult;
import de.qfm.erp.service.model.internal.measurement.MeasurementPositionGroup;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.MeasurementPosition;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.service.service.gaeb.GaebD11Helper;
import java.nio.charset.StandardCharsets;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class GaebX31ExportService {
    private static final Logger log = LogManager.getLogger(GaebX31ExportService.class);
    public static final boolean RENDER_POS_NUMBER_DEFAULT = false;
    private final XStream xStream;

    @Autowired
    public GaebX31ExportService(@Qualifier(value="xStreamX31") XStream xStream) {
        this.xStream = xStream;
    }

    @NonNull
    public GaebX31ExportResult generateD11(@NonNull Measurement measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        GAEB gaeb = new GAEB();
        GAEBInfo gaebInfo = this.gaebInfo();
        gaeb.setGaebInfo(gaebInfo);
        QuantityDetermination quantityDetermination = this.quantityDetermination(measurement);
        gaeb.setQuantityDetermination(quantityDetermination);
        String xml = this.xStream.toXML((Object)gaeb);
        return GaebX31ExportResult.of((GAEB)gaeb, (byte[])xml.getBytes(StandardCharsets.UTF_8));
    }

    private QuantityDetermination quantityDetermination(@NonNull Measurement measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        QuantityDetermination quantityDetermination = new QuantityDetermination();
        quantityDetermination.setDp("31");
        ProjectInfo projectInfo = this.projectInfo(measurement);
        quantityDetermination.setProjectInfo(projectInfo);
        QuantityDeterminationInfo quantityDeterminationInfo = this.quantityDeterminationInfo(measurement);
        quantityDetermination.setQuantityDeterminationInfo(quantityDeterminationInfo);
        BoQ boq = this.boq(measurement);
        quantityDetermination.setBoQ(boq);
        return quantityDetermination;
    }

    private BoQ boq(@NonNull Measurement measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        BoQBody boQBody = this.rootBody(measurement);
        List boQBkdns = this.boQInfo(measurement);
        BoQ boQ = new BoQ();
        boQ.setBkdn(boQBkdns);
        boQ.setBoQBody(boQBody);
        return boQ;
    }

    @Nonnull
    private BoQBody rootBody(@NonNull Measurement measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        Long sheetNumberValue = measurement.getSheetNumberValue();
        AtomicInteger categoryIndex = new AtomicInteger(0);
        AtomicInteger rowIndex = new AtomicInteger(0);
        Iterable positionGroups = MeasurementHelper.positionGroups((Measurement)measurement, (boolean)false);
        ArrayList allCategories = Lists.newArrayList();
        for (MeasurementPositionGroup positionGroup : positionGroups) {
            List categories = this.category(positionGroup, sheetNumberValue, categoryIndex, rowIndex);
            allCategories.addAll(categories);
        }
        BoQBody boQBody = new BoQBody();
        boQBody.setCategories((List)allCategories);
        return boQBody;
    }

    @Nonnull
    private List<BoQCtgy> category(@NonNull MeasurementPositionGroup positionGroup, @NonNull Long sheetNo, @NonNull AtomicInteger categoryIndex, @NonNull AtomicInteger rowIndex) {
        if (positionGroup == null) {
            throw new NullPointerException("positionGroup is marked non-null but is null");
        }
        if (sheetNo == null) {
            throw new NullPointerException("sheetNo is marked non-null but is null");
        }
        if (categoryIndex == null) {
            throw new NullPointerException("categoryIndex is marked non-null but is null");
        }
        if (rowIndex == null) {
            throw new NullPointerException("rowIndex is marked non-null but is null");
        }
        BoQCtgy self = new BoQCtgy();
        self.setId(Integer.toString(categoryIndex.getAndIncrement()));
        String key = positionGroup.getKey();
        boolean isChildKey = StringUtils.contains((CharSequence)key, (int)46);
        String rowNumberPartString = isChildKey ? StringUtils.substringAfterLast((String)key, (String)".") : key;
        self.setRowNumberPart(rowNumberPartString);
        BoQBody itemBody = this.itemBody(positionGroup, sheetNo, categoryIndex, rowIndex);
        self.setBodies((List)Lists.newArrayList((Object[])new BoQBody[]{itemBody}));
        return ImmutableList.builder().add((Object)self).build();
    }

    @Nonnull
    private BoQBody itemBody(@NonNull MeasurementPositionGroup positionGroup, @NonNull Long sheetNo, @NonNull AtomicInteger categoryIndex, @NonNull AtomicInteger rowIndex) {
        if (positionGroup == null) {
            throw new NullPointerException("positionGroup is marked non-null but is null");
        }
        if (sheetNo == null) {
            throw new NullPointerException("sheetNo is marked non-null but is null");
        }
        if (categoryIndex == null) {
            throw new NullPointerException("categoryIndex is marked non-null but is null");
        }
        if (rowIndex == null) {
            throw new NullPointerException("rowIndex is marked non-null but is null");
        }
        BoQBody boQBody = new BoQBody();
        ArrayList items = Lists.newArrayList();
        List measurementPositions = positionGroup.getPositions();
        for (MeasurementPosition measurementPosition : measurementPositions) {
            Item item = GaebX31ExportService.item((MeasurementPosition)measurementPosition, (boolean)false, (Long)sheetNo, (AtomicInteger)rowIndex);
            items.add(item);
        }
        Map children = positionGroup.getChildren();
        TreeSet strings = Sets.newTreeSet(children.keySet());
        ArrayList categories = Lists.newArrayList();
        for (String string : strings) {
            MeasurementPositionGroup childPositionGroup = (MeasurementPositionGroup)children.get(string);
            List childCategories = this.category(childPositionGroup, sheetNo, categoryIndex, rowIndex);
            categories.addAll(childCategories);
        }
        boQBody.setCategories((List)categories);
        Itemlist itemlist = new Itemlist();
        if (!items.isEmpty()) {
            itemlist.setItems((List)items);
            boQBody.setItemlist(itemlist);
        }
        return boQBody;
    }

    @Nonnull
    private static Item item(@NonNull MeasurementPosition measurementPosition, boolean renderPosNr, @NonNull Long sheetNo, @NonNull AtomicInteger rowIndex) {
        if (measurementPosition == null) {
            throw new NullPointerException("measurementPosition is marked non-null but is null");
        }
        if (sheetNo == null) {
            throw new NullPointerException("sheetNo is marked non-null but is null");
        }
        if (rowIndex == null) {
            throw new NullPointerException("rowIndex is marked non-null but is null");
        }
        Item item = new Item();
        String id = Long.toString(measurementPosition.getId());
        String positionNumber = measurementPosition.getQuotationPositionNumber();
        String dataRow = GaebD11Helper.dataRow((MeasurementPosition)measurementPosition, (boolean)renderPosNr, (long)sheetNo, (int)rowIndex.getAndIncrement());
        item.setId(id);
        item.setRNoPart(positionNumber);
        QuantityDetermination quantityDetermination = new QuantityDetermination();
        QuantityDeterminationItem quantityDeterminationItem = new QuantityDeterminationItem();
        QuantityTakeoff quantityTakeoff = new QuantityTakeoff();
        quantityTakeoff.setRow(dataRow);
        quantityDeterminationItem.setQuantityTakeoff(quantityTakeoff);
        quantityDetermination.setQuantityDeterminationItem(quantityDeterminationItem);
        item.setQuantityDetermination(quantityDetermination);
        return item;
    }

    @Nonnull
    private List<BoQBkdn> boQInfo(@NonNull Measurement measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        ArrayList groupingLevels = Lists.newArrayList();
        Quotation stage = measurement.getQuotation();
        String headlineG1 = (String)StringUtils.defaultIfEmpty((CharSequence)stage.getHeadlineG2(), (CharSequence)"G1");
        this.bkdn(headlineG1).ifPresent(groupingLevels::add);
        String headlineG2 = (String)StringUtils.defaultIfEmpty((CharSequence)stage.getHeadlineG2(), (CharSequence)"G2");
        this.bkdn(headlineG2).ifPresent(groupingLevels::add);
        String headlineG3 = (String)StringUtils.defaultIfEmpty((CharSequence)stage.getHeadlineG3(), (CharSequence)"G3");
        this.bkdn(headlineG3).ifPresent(groupingLevels::add);
        String headlineG4 = (String)StringUtils.defaultIfEmpty((CharSequence)stage.getHeadlineG3(), (CharSequence)"G4");
        this.bkdn(headlineG4).ifPresent(groupingLevels::add);
        BoQBkdn posLevel = new BoQBkdn();
        posLevel.setType("Item");
        posLevel.setLblBoQBkdn("Pos-Nr.");
        posLevel.setNum("No");
        posLevel.setLength(Integer.valueOf(20));
        posLevel.setAlignment("right");
        groupingLevels.add(posLevel);
        BoQBkdn indexLevel = new BoQBkdn();
        indexLevel.setType("Index");
        indexLevel.setLblBoQBkdn(null);
        indexLevel.setNum("Yes");
        indexLevel.setLength(Integer.valueOf(10));
        indexLevel.setAlignment("right");
        groupingLevels.add(indexLevel);
        return groupingLevels;
    }

    @Nonnull
    private Optional<BoQBkdn> bkdn(@NonNull String headline) {
        if (headline == null) {
            throw new NullPointerException("headline is marked non-null but is null");
        }
        if (StringUtils.isNotBlank((CharSequence)headline)) {
            BoQBkdn bkdn = new BoQBkdn();
            bkdn.setType("BoQLevel");
            bkdn.setLblBoQBkdn(headline);
            bkdn.setLength(Integer.valueOf(9));
            bkdn.setNum("no");
            bkdn.setAlignment("right");
            return Optional.of(bkdn);
        }
        return Optional.empty();
    }

    private QuantityDeterminationInfo quantityDeterminationInfo(Measurement measurement) {
        QuantityDeterminationInfo quantityDeterminationInfo = new QuantityDeterminationInfo();
        quantityDeterminationInfo.setMethodDescription("REB23003-2009");
        quantityDeterminationInfo.setProjectDescription(measurement.getConstructionSite());
        Creator creator = this.creator(measurement);
        quantityDeterminationInfo.setCreator(creator);
        Profiler profiler = this.profiler(measurement);
        quantityDeterminationInfo.setProfiler(profiler);
        return quantityDeterminationInfo;
    }

    @Nonnull
    private Creator creator(@NonNull Measurement measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        Creator item = new Creator();
        item.setName1("");
        item.setStreet("");
        item.setZipCode("");
        item.setCity("");
        return item;
    }

    @Nonnull
    private Profiler profiler(@NonNull Measurement measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        Profiler item = new Profiler();
        item.setName1("");
        item.setStreet("");
        item.setZipCode("");
        item.setCity("");
        return item;
    }

    @Nonnull
    private ProjectInfo projectInfo(@NonNull Measurement measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        ProjectInfo projectInfo = new ProjectInfo();
        return projectInfo;
    }

    @Nonnull
    private GAEBInfo gaebInfo() {
        GAEBInfo gaebInfo = new GAEBInfo();
        gaebInfo.setTime(LocalTime.now().truncatedTo(ChronoUnit.SECONDS));
        gaebInfo.setDate(DateTimeHelper.today());
        gaebInfo.setProgName("AppQ");
        gaebInfo.setProgSystem("AppQ");
        gaebInfo.setVersion("3.2");
        gaebInfo.setVersionDate("2013-10");
        return gaebInfo;
    }
}

