/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.er2;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import de.qfm.erp.service.model.internal.quotation.ER2StageInputBucket;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.service.service.ConfigService;
import de.qfm.erp.service.service.service.er2.StageER2CostUnitExportService;
import de.qfm.erp.service.service.service.er2.StageER2ExportService;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class StageER2CostUnitExportService
extends StageER2ExportService {
    private final ConfigService configService;

    @Autowired
    public StageER2CostUnitExportService(@NonNull ConfigService configService) {
        if (configService == null) {
            throw new NullPointerException("configService is marked non-null but is null");
        }
        this.configService = configService;
    }

    @Nonnull
    public Iterable<Iterable<String>> generate(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        return this.er2Rows(stage);
    }

    @Nonnull
    private Iterable<Iterable<String>> er2Rows(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        String stageOrEntityNumberPrefix = this.configService.getStageOrEntityNumberPrefix();
        ER2StageInputBucket er2StageInputBucket = ER2StageInputBucket.of((String)stageOrEntityNumberPrefix, (Quotation)stage);
        ImmutableList.Builder rowsBuilder = ImmutableList.builder();
        ImmutableList.Builder trPartsBuilder = ImmutableList.builder();
        for (ER2TR er2TR : ER2TR.values()) {
            int maxLength = er2TR.getLen();
            CharMatcher charMatcher = er2TR.getCharMatcher();
            String originalValue = StringUtils.trimToEmpty((String)((String)er2TR.getFn().apply(er2StageInputBucket)));
            String cleanedValue = charMatcher.retainFrom((CharSequence)originalValue);
            String ensuredLength = StringUtils.left((String)cleanedValue, (int)maxLength);
            trPartsBuilder.add((Object)ensuredLength);
        }
        ImmutableList trParts = trPartsBuilder.build();
        rowsBuilder.add((Object)trParts);
        return rowsBuilder.build();
    }
}

