/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.csv;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import de.qfm.erp.service.model.internal.csv.ECsvExportType;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public abstract class MeasurementCsvExportWriter {
    private static final Joiner ROW_JOINER = Joiner.on((String)System.lineSeparator()).skipNulls();

    public abstract ECsvExportType svExportType();

    public abstract Function<String, String> colCharFn();

    public abstract Joiner colJoiner();

    @Nonnull
    public abstract Stream<Iterable<String>> prepare(@NonNull Measurement var1);

    @Nonnull
    public String generate(@NonNull Measurement measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        Stream prepare = this.prepare(measurement);
        Joiner colJoiner = this.colJoiner();
        Function stringStringFunction = this.colCharFn();
        Iterable rows = prepare.map(row -> {
            Iterable safeRow = (Iterable)Streams.stream((Iterable)row).map(stringStringFunction).map(StringUtils::trimToEmpty).collect(ImmutableList.toImmutableList());
            return colJoiner.join(safeRow);
        }).collect(Collectors.toList());
        return ROW_JOINER.join(rows);
    }
}

