/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.csv;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import de.qfm.erp.service.helper.ASCIIFoldingHelper;
import de.qfm.erp.service.helper.BigDecimalHelper;
import de.qfm.erp.service.model.internal.csv.ECsvExportType;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.service.service.csv.MeasurementCsvExportWriter;
import java.math.BigDecimal;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MeasurementCsvExportWriteStromnetzBerlin
extends MeasurementCsvExportWriter {
    private static final String COL_JOIN_CHAR = ";";
    private static final Joiner J = Joiner.on((String)";").useForNull("");
    private static final CharMatcher UNSAFE_CHARS = CharMatcher.ascii().and(CharMatcher.anyOf((CharSequence)"\n\r").negate()).and(CharMatcher.isNot((char)';')).and(CharMatcher.isNot((char)'\"')).negate();
    private static final CharMatcher DIGIT_MATCHER = CharMatcher.inRange((char)'0', (char)'9').precomputed();

    public ECsvExportType svExportType() {
        return ECsvExportType.STROMNETZ_BERLIN;
    }

    public Function<String, String> colCharFn() {
        CharMatcher colCharMatcher = CharMatcher.anyOf((CharSequence)";");
        return arg_0 -> ((CharMatcher)colCharMatcher).removeFrom(arg_0);
    }

    public Joiner colJoiner() {
        return J;
    }

    @Nonnull
    public Stream<Iterable<String>> prepare(@NonNull Measurement measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        List measurementPositions = (List)MoreObjects.firstNonNull((Object)measurement.getMeasurementPositions(), (Object)ImmutableList.of());
        return measurementPositions.stream().map(mp -> {
            String s1 = MeasurementCsvExportWriteStromnetzBerlin.positionNumber((String)StringUtils.trimToEmpty((String)mp.getQuotationPositionNumber()));
            String s2 = StringUtils.trimToEmpty((String)mp.getPositionNumberExternal());
            String s3 = BigDecimalHelper.asString((BigDecimal)mp.getProduct());
            String s4 = MeasurementCsvExportWriteStromnetzBerlin.safeString((String)mp.getRemarks(), (int)250);
            return ImmutableList.of((Object)s1, (Object)s2, (Object)s3, (Object)s4);
        }).filter(item -> {
            boolean posNrPresent = StringUtils.isNotBlank((CharSequence)((CharSequence)item.get(0)));
            boolean extPosNrPresent = StringUtils.isNotBlank((CharSequence)((CharSequence)item.get(1)));
            return posNrPresent && extPosNrPresent;
        }).map(ImmutableList::copyOf);
    }

    @Nonnull
    private static String positionNumber(@NonNull String input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (StringUtils.contains((CharSequence)input, (int)46)) {
            return DIGIT_MATCHER.retainFrom((CharSequence)input);
        }
        return input;
    }

    @Nonnull
    private static String safeString(@Nullable String input, int maxLength) {
        return StringUtils.trimToEmpty((String)StringUtils.left((String)UNSAFE_CHARS.replaceFrom((CharSequence)ASCIIFoldingHelper.foldString((String)StringUtils.trimToEmpty((String)input)), (CharSequence)"_"), (int)maxLength));
    }
}

