/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.csv;

import com.google.common.collect.ImmutableMap;
import de.qfm.erp.service.model.internal.csv.ECsvExportType;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.service.service.csv.MeasurementCsvExportWriter;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CsvExportService {
    private final Map<ECsvExportType, MeasurementCsvExportWriter> measurementCsvExportWritersMap;

    @Autowired
    public CsvExportService(@NonNull List<MeasurementCsvExportWriter> measurementCsvExportWriters) {
        if (measurementCsvExportWriters == null) {
            throw new NullPointerException("measurementCsvExportWriters is marked non-null but is null");
        }
        this.measurementCsvExportWritersMap = (Map)measurementCsvExportWriters.stream().collect(ImmutableMap.toImmutableMap(MeasurementCsvExportWriter::svExportType, item -> item));
    }

    @Nonnull
    public String generate(@NonNull ECsvExportType csvExportType, @NonNull Measurement measurement) {
        if (csvExportType == null) {
            throw new NullPointerException("csvExportType is marked non-null but is null");
        }
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        if (this.measurementCsvExportWritersMap.containsKey(csvExportType)) {
            MeasurementCsvExportWriter measurementCsvExportWriter = (MeasurementCsvExportWriter)this.measurementCsvExportWritersMap.get(csvExportType);
            return measurementCsvExportWriter.generate(measurement);
        }
        throw new IllegalArgumentException("CSV Writer not found");
    }
}

