/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.security;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.common.websocket.request.RequestMessage;
import de.qfm.erp.service.configuration.ApplicationConfig;
import de.qfm.erp.service.helper.UserHelper;
import de.qfm.erp.service.model.exception.request.JwtTokenException;
import de.qfm.erp.service.model.internal.authentication.JwtToken;
import de.qfm.erp.service.model.jpa.user.Role;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import jakarta.servlet.http.HttpServletRequest;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.stereotype.Component;

@Component
public class JwtTokenProvider {
    private final ApplicationConfig applicationConfig;
    private final UserDetailsService userDetailsService;
    public static final Joiner AUTH_JOINER = Joiner.on((String)"|");

    @Nonnull
    public JwtToken signInToken(@NonNull String username, @NonNull Iterable<Role> roles) {
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        if (roles == null) {
            throw new NullPointerException("roles is marked non-null but is null");
        }
        JwtToken.JwtTokenPart accessToken = this.createAccessToken(username, roles);
        JwtToken.JwtTokenPart refreshToken = this.createRefreshToken(username);
        return JwtToken.builder().withAccessToken(accessToken).withRefreshToken(refreshToken).build();
    }

    @Nonnull
    public JwtToken refreshToken(@NonNull JwtToken.JwtTokenPart refreshToken, @NonNull String username, @NonNull Iterable<Role> roles) {
        if (refreshToken == null) {
            throw new NullPointerException("refreshToken is marked non-null but is null");
        }
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        if (roles == null) {
            throw new NullPointerException("roles is marked non-null but is null");
        }
        JwtToken.JwtTokenPart accessToken = this.createAccessToken(username, roles);
        return JwtToken.builder().withAccessToken(accessToken).withRefreshToken(refreshToken).build();
    }

    @Nonnull
    private JwtToken.JwtTokenPart createAccessToken(@NonNull String username, @NonNull Iterable<Role> roles) {
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        if (roles == null) {
            throw new NullPointerException("roles is marked non-null but is null");
        }
        String hashCodeAsString = this.claimAuth(roles);
        Claims claims = Jwts.claims().setSubject(username);
        claims.put((Object)"auth", (Object)hashCodeAsString);
        long accessTokenValidityInSeconds = this.applicationConfig.getAccessTokenValidityInSeconds();
        String secretKey = this.applicationConfig.getSecretKey();
        LocalDateTime now = DateTimeHelper.truncate((LocalDateTime)DateTimeHelper.now());
        LocalDateTime validUntil = DateTimeHelper.truncate((LocalDateTime)now.plus(accessTokenValidityInSeconds, ChronoUnit.SECONDS));
        Date dateCreated = Date.from(now.toInstant(ZoneOffset.UTC));
        Date dateValid = Date.from(validUntil.toInstant(ZoneOffset.UTC));
        String accessToken = Jwts.builder().setId(UUID.randomUUID().toString()).setClaims(claims).setIssuedAt(dateCreated).setExpiration(dateValid).signWith(SignatureAlgorithm.HS256, secretKey).compact();
        return JwtToken.JwtTokenPart.of((LocalDateTime)now, (LocalDateTime)validUntil, (String)accessToken);
    }

    @Nonnull
    private JwtToken.JwtTokenPart createRefreshToken(@NonNull String username) {
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        Claims claims = Jwts.claims().setSubject(username);
        claims.put((Object)"auth", (Object)ImmutableList.of((Object)new SimpleGrantedAuthority("ROLE_REFRESH_TOKEN")));
        long refreshTokenValidityInSeconds = this.applicationConfig.getRefreshTokenValidityInSeconds();
        String secretKey = this.applicationConfig.getSecretKey();
        LocalDateTime now = DateTimeHelper.truncate((LocalDateTime)DateTimeHelper.now());
        LocalDateTime validUntil = DateTimeHelper.truncate((LocalDateTime)now.plus(refreshTokenValidityInSeconds, ChronoUnit.SECONDS));
        Date dateCreated = Date.from(now.toInstant(ZoneOffset.UTC));
        Date dateValid = Date.from(validUntil.toInstant(ZoneOffset.UTC));
        String accessToken = Jwts.builder().setId(UUID.randomUUID().toString()).setClaims(claims).setIssuedAt(dateCreated).setExpiration(dateValid).signWith(SignatureAlgorithm.HS256, secretKey).compact();
        return JwtToken.JwtTokenPart.of((LocalDateTime)now, (LocalDateTime)validUntil, (String)accessToken);
    }

    @Nonnull
    public Authentication getAuthentication(@NonNull String token) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        UserDetails userDetails = this.userDetailsService.loadUserByUsername(this.getUsername(token));
        return new UsernamePasswordAuthenticationToken((Object)userDetails, (Object)"", userDetails.getAuthorities());
    }

    @Nonnull
    public String getUsername(@NonNull String token) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        return this.claims(token).getSubject();
    }

    @Nonnull
    public Claims claims(@NonNull String token) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        String secretKey = this.applicationConfig.getSecretKey();
        return (Claims)Jwts.parser().setSigningKey(secretKey).parseClaimsJws(token).getBody();
    }

    @Nullable
    public String resolveToken(@NonNull HttpServletRequest req) {
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        String bearerToken = req.getHeader("Authorization");
        if (bearerToken != null && bearerToken.startsWith("Bearer ")) {
            return bearerToken.substring(7);
        }
        return null;
    }

    @Nullable
    public String resolveToken(@NonNull RequestMessage message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        String bearerToken = message.getAuthorization();
        if (bearerToken != null && bearerToken.startsWith("Bearer ")) {
            return bearerToken.substring(7);
        }
        return null;
    }

    public boolean authenticate(@NonNull RequestMessage requestMessage) {
        if (requestMessage == null) {
            throw new NullPointerException("requestMessage is marked non-null but is null");
        }
        String token = this.resolveToken(requestMessage);
        return this.authenticate(token);
    }

    public boolean authenticate(@Nullable String token) {
        if (token != null && this.validateToken(token)) {
            Authentication auth = this.getAuthentication(token);
            SecurityContextHolder.getContext().setAuthentication(auth);
            return true;
        }
        SecurityContextHolder.clearContext();
        return false;
    }

    public boolean validateToken(@NonNull String token) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        String secretKey = this.applicationConfig.getSecretKey();
        try {
            Jwts.parser().setSigningKey(secretKey).parseClaimsJws(token);
            return true;
        }
        catch (JwtException | IllegalArgumentException e) {
            throw new JwtTokenException("Expired or invalid JWT token");
        }
    }

    @Nonnull
    private String claimAuth(@NonNull Iterable<Role> roles) {
        if (roles == null) {
            throw new NullPointerException("roles is marked non-null but is null");
        }
        Iterable grantedAuthorities = UserHelper.grantedAuthorities(roles);
        ImmutableList strings = ImmutableList.sortedCopyOf((Iterable)Streams.stream((Iterable)grantedAuthorities).map(GrantedAuthority::getAuthority).filter(StringUtils::isNotBlank).collect(Collectors.toList()));
        String allPrivilegesString = AUTH_JOINER.join((Iterable)strings);
        HashCode hashCode = Hashing.sha256().hashString((CharSequence)allPrivilegesString, StandardCharsets.UTF_8);
        return hashCode.toString();
    }

    public JwtTokenProvider(ApplicationConfig applicationConfig, UserDetailsService userDetailsService) {
        this.applicationConfig = applicationConfig;
        this.userDetailsService = userDetailsService;
    }
}

