/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import de.qfm.erp.service.configuration.NodeConfig;
import de.qfm.erp.service.model.jpa.project.SubProject;
import de.qfm.erp.service.model.search.EIndexEntryType;
import de.qfm.erp.service.model.search.ESubProjectIndexField;
import de.qfm.erp.service.model.search.IndexDocument;
import de.qfm.erp.service.model.search.IndexField;
import de.qfm.erp.service.model.search.IndexResult;
import de.qfm.erp.service.service.handler.SubProjectHandler;
import de.qfm.erp.service.service.mapper.SubProjectSearchMapper;
import de.qfm.erp.service.service.mapper.search.InternalQueryHelper;
import de.qfm.erp.service.service.route.AbstractSyncable;
import de.qfm.erp.service.service.service.search.IndexService;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.Query;
import org.springframework.stereotype.Service;

@Service
public class SubProjectSearchRoute
extends AbstractSyncable<SubProject> {
    private static final Logger log = LogManager.getLogger(SubProjectSearchRoute.class);
    private final SubProjectHandler subProjectHandler;
    private final SubProjectSearchMapper subProjectSearchMapper;
    private final IndexService indexService;

    public SubProjectSearchRoute(@NonNull NodeConfig nodeConfig, @NonNull SubProjectHandler subProjectHandler, @NonNull SubProjectSearchMapper subProjectSearchMapper, @NonNull IndexService indexService) {
        super(nodeConfig);
        if (nodeConfig == null) {
            throw new NullPointerException("nodeConfig is marked non-null but is null");
        }
        if (subProjectHandler == null) {
            throw new NullPointerException("subProjectHandler is marked non-null but is null");
        }
        if (subProjectSearchMapper == null) {
            throw new NullPointerException("subProjectSearchMapper is marked non-null but is null");
        }
        if (indexService == null) {
            throw new NullPointerException("indexService is marked non-null but is null");
        }
        this.subProjectHandler = subProjectHandler;
        this.subProjectSearchMapper = subProjectSearchMapper;
        this.indexService = indexService;
    }

    @Nonnull
    public EIndexEntryType indexEntryType() {
        return EIndexEntryType.SUB_PROJECT;
    }

    @Nonnull
    public Iterable<SubProject> refresh(@NonNull Iterable<SubProject> itemStream) {
        if (itemStream == null) {
            throw new NullPointerException("itemStream is marked non-null but is null");
        }
        ImmutableList.Builder entriesUpdatedBuilder = ImmutableList.builder();
        itemStream.forEach(item -> this.refresh(item).ifPresent(arg_0 -> ((ImmutableList.Builder)entriesUpdatedBuilder).add(arg_0)));
        return entriesUpdatedBuilder.build();
    }

    @Nonnull
    public Optional<SubProject> refresh(@NonNull SubProject subProject) {
        if (subProject == null) {
            throw new NullPointerException("subProject is marked non-null but is null");
        }
        Long entryId = subProject.getId();
        try {
            IndexResult index = this.index(subProject);
            log.debug("Refreshed Entity: {} in Index", (Object)subProject);
            return Optional.of(subProject);
        }
        catch (Exception ioe) {
            log.error("Error Refreshing Index for EntryId: {}, Entry: {}", (Object)entryId, (Object)subProject, (Object)ioe);
            return Optional.empty();
        }
    }

    public boolean dirty() {
        return this.subProjectHandler.dirty();
    }

    @Nonnull
    public Iterable<SubProject> streamDirty(int max) {
        return this.subProjectHandler.dirtyPage(max);
    }

    @Nonnull
    public Long id(@NonNull SubProject item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item.getId();
    }

    @Nonnull
    public Iterable<Long> ids(@NonNull Iterable<SubProject> items) {
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        return (Iterable)Streams.stream(items).map(SubProject::getId).collect(ImmutableSet.toImmutableSet());
    }

    public void start() {
        log.info("Detected Dirty Entries - refreshing Entries in Index");
    }

    public void finish(@NonNull Iterable<SubProject> itemsProcessed, @NonNull Stopwatch stopwatch) {
        if (itemsProcessed == null) {
            throw new NullPointerException("itemsProcessed is marked non-null but is null");
        }
        if (stopwatch == null) {
            throw new NullPointerException("stopwatch is marked non-null but is null");
        }
        int size = Iterables.size(itemsProcessed);
        long elapsedInMs = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        int markedAsIndexed = this.subProjectHandler.markIndexed(itemsProcessed);
        log.info("Finished Refreshing Dirty Entries, amount: {}, took: {} ms", (Object)size, (Object)elapsedInMs);
    }

    @Nonnull
    private Optional<String> delete(@NonNull SubProject stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        try {
            String documentId = SubProjectSearchMapper.documentId((EIndexEntryType)this.indexEntryType(), (Long)stage.getId());
            long indexGeneration = this.indexService.deleteFromIndex((Query)InternalQueryHelper.termQuery((IndexField)ESubProjectIndexField._ID, (String)documentId));
            log.debug("Deleted Entity: {}", (Object)stage);
            return Optional.of(Long.toString(stage.getId()));
        }
        catch (IOException e) {
            log.error("Error Deleting Entry from Index, error: {}", (Object)e.getMessage());
            return Optional.of(e.getMessage());
        }
    }

    @Nonnull
    private IndexResult index(@NonNull SubProject stage) throws IOException {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        IndexDocument indexDocument = this.subProjectSearchMapper.mapToDocument(stage, this.indexEntryType());
        return this.indexService.updateIndex(indexDocument);
    }

    @Nonnull
    private Iterable<IndexResult> index(@NonNull Iterable<SubProject> stages) throws IOException {
        if (stages == null) {
            throw new NullPointerException("stages is marked non-null but is null");
        }
        Iterable indexDocuments = this.subProjectSearchMapper.mapToDocument(stages, this.indexEntryType());
        return this.indexService.updateIndex(indexDocuments);
    }
}

