/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import de.qfm.erp.common.request.project.SubProjectUpdateRequest;
import de.qfm.erp.common.response.project.SubProjectCommon;
import de.qfm.erp.common.response.project.SubProjectPageCommon;
import de.qfm.erp.service.model.exception.request.BusinessRuleValidationException;
import de.qfm.erp.service.model.exception.request.RequestValidationException;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.project.SubProject;
import de.qfm.erp.service.model.jpa.quotation.QEntity;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.handler.EntityHandler;
import de.qfm.erp.service.service.handler.SubProjectHandler;
import de.qfm.erp.service.service.mapper.SubProjectMapper;
import de.qfm.erp.service.service.route.SubProjectRoute;
import de.qfm.erp.service.service.service.MessageService;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class SubProjectRouteImpl
implements SubProjectRoute {
    private static final Logger log = LogManager.getLogger(SubProjectRouteImpl.class);
    private final MessageService messageService;
    private final EntityFactory entityFactory;
    private final EntityHandler entityHandler;
    private final SubProjectHandler handler;
    private final SubProjectMapper mapper;

    @Nonnull
    public SubProjectPageCommon page(int page, int size, @NonNull Iterable<Long> qEntityIds, @NonNull String filterText) {
        if (qEntityIds == null) {
            throw new NullPointerException("qEntityIds is marked non-null but is null");
        }
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        return this.mapper.map(this.handler.page(page, size, qEntityIds, filterText));
    }

    @Nonnull
    public SubProjectCommon byId(long id) {
        return this.mapper.map((SubProject)this.handler.byIdFailing(Long.valueOf(id)));
    }

    public SubProjectCommon create(@NonNull Long qEntityId, @NonNull SubProjectUpdateRequest request) {
        if (qEntityId == null) {
            throw new NullPointerException("qEntityId is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        QEntity qEntity = (QEntity)this.entityHandler.byIdFailing(qEntityId);
        SubProject subProject = this.entityFactory.subProject();
        this.checkForDuplicateName(request, qEntity, subProject);
        SubProject subProjectMerged = this.mapper.merge(subProject, qEntity, request);
        SubProject subProjectUpdated = (SubProject)this.handler.update((EntityBase)subProjectMerged);
        return this.mapper.map(subProjectUpdated);
    }

    private void checkForDuplicateName(@NonNull SubProjectUpdateRequest request, @NonNull QEntity entity, @NonNull SubProject subProject) {
        String expectedName;
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (subProject == null) {
            throw new NullPointerException("subProject is marked non-null but is null");
        }
        Iterable existingSubProjects = (Iterable)MoreObjects.firstNonNull((Object)entity.getSubProjects(), (Object)ImmutableSet.of());
        ImmutableSet existingNames = (ImmutableSet)Streams.stream((Iterable)existingSubProjects).filter(item -> !Objects.equals(item.getId(), subProject.getId())).map(SubProject::getName).map(StringUtils::trimToEmpty).map(StringUtils::lowerCase).collect(ImmutableSet.toImmutableSet());
        if (existingNames.contains((Object)(expectedName = StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)request.getName()))))) {
            String mainMessage = this.messageService.get(EMessageKey.RULE_ENTITY__SUBPROJECT__DUPLICATE_NAME);
            RequestValidationException.Detail detail = RequestValidationException.Detail.of((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.SUBPROJECT__NAME), (Object)expectedName, (String)mainMessage, (Message)Message.of((EMessageKey)EMessageKey.RULE_ENTITY__SUBPROJECT__DUPLICATE_NAME, (String)expectedName), (List)ImmutableList.of());
            throw new BusinessRuleValidationException(mainMessage, (List)ImmutableList.of((Object)detail));
        }
    }

    public SubProjectCommon update(@NonNull Long id, @NonNull SubProjectUpdateRequest request) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        SubProject subProject = (SubProject)this.handler.byIdFailing(id);
        this.checkForDuplicateName(request, subProject.getQEntity(), subProject);
        SubProject subProjectMerged = this.mapper.merge(subProject, subProject.getQEntity(), request);
        SubProject subProjectUpdated = (SubProject)this.handler.update((EntityBase)subProjectMerged);
        return this.mapper.map(subProjectUpdated);
    }

    public SubProjectRouteImpl(MessageService messageService, EntityFactory entityFactory, EntityHandler entityHandler, SubProjectHandler handler, SubProjectMapper mapper) {
        this.messageService = messageService;
        this.entityFactory = entityFactory;
        this.entityHandler = entityHandler;
        this.handler = handler;
        this.mapper = mapper;
    }
}

