/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import de.leancoders.sharepoint.response.SharepointDriveItemResponse;
import de.leancoders.sharepoint.response.SharepointSitesResponse;
import de.leancoders.sharepoint.service.SharepointDriveClientService;
import de.qfm.erp.service.configuration.SharepointConfiguration;
import de.qfm.erp.service.model.internal.sharepoint.SharepointSyncMark;
import de.qfm.erp.service.model.jpa.customer.Customer;
import de.qfm.erp.service.service.handler.CustomerHandler;
import de.qfm.erp.service.service.route.SharepointRoute;
import de.qfm.erp.service.service.route.impl.SharepointRouteImpl;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class SharepointRouteImpl
implements SharepointRoute {
    private static final Logger log = LogManager.getLogger(SharepointRouteImpl.class);
    private final CustomerHandler customerHandler;
    private final SharepointConfiguration sharepointConfiguration;
    private final SharepointDriveClientService sharepointDriveClientService;

    @Transactional
    public boolean processNextCustomer() {
        if (this.sharepointConfiguration.isEnabled()) {
            Iterable customers = this.customerHandler.nextUnprocessedSharepoint(1);
            for (Customer customer : customers) {
                this.processCustomer(customer);
            }
        }
        return true;
    }

    @Transactional
    @Nonnull
    public Multimap<SharepointPathType, SharepointDriveItemResponse> processCustomer(@NonNull Customer customer) {
        if (customer == null) {
            throw new NullPointerException("customer is marked non-null but is null");
        }
        return this.process(customer);
    }

    @Nonnull
    private Multimap<SharepointPathType, SharepointDriveItemResponse> process(@NonNull Customer customer) {
        if (customer == null) {
            throw new NullPointerException("customer is marked non-null but is null");
        }
        log.info("Processing Sharepoint Sync for Customer: {}/{}", (Object)customer.getName(), (Object)customer.getDebtorAccountNumber());
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            Multimap expectedPaths = this.requiredPaths(customer);
            ImmutableMultimap result = this.handleSharepoint(expectedPaths);
            ImmutableCollection sharepointDriveItemResponses = result.get((Object)SharepointPathType.BY_CUSTOMER);
            SharepointDriveItemResponse next = (SharepointDriveItemResponse)sharepointDriveItemResponses.stream().iterator().next();
            String sharepointDriveId = this.sharepointConfiguration.getSharepointDriveId();
            String sharepointSiteId = this.sharepointConfiguration.getSharepointSiteId();
            SharepointSyncMark sharepointSyncMark = SharepointSyncMark.of((long)customer.getId(), (String)next.getWebUrl(), (String)sharepointSiteId, (String)sharepointDriveId, (String)next.getId());
            this.customerHandler.markSharepointSynced(sharepointSyncMark);
            log.info("Finished Sharepoint Sync for Customer: {}/{} after: {}ms", (Object)customer.getName(), (Object)customer.getDebtorAccountNumber(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
            return result;
        }
        catch (Exception ex) {
            log.error("Error processing Sharepoint Sync for v: {}/{}", (Object)customer.getName(), (Object)customer.getDebtorAccountNumber(), (Object)ex);
            return ImmutableMultimap.of();
        }
    }

    @Nonnull
    private ImmutableMultimap<SharepointPathType, SharepointDriveItemResponse> handleSharepoint(@NonNull Multimap<SharepointPathType, SharepointPath> expectedPaths) {
        if (expectedPaths == null) {
            throw new NullPointerException("expectedPaths is marked non-null but is null");
        }
        String driveId = this.sharepointConfiguration.getSharepointDriveId();
        ImmutableMultimap.Builder executedPathsBuilder = ImmutableMultimap.builder();
        Set entries = expectedPaths.asMap().entrySet();
        for (Map.Entry entry : entries) {
            SharepointPathType sharepointPathType = (SharepointPathType)entry.getKey();
            Collection sharepointPaths = (Collection)entry.getValue();
            for (SharepointPath sharepointPath : sharepointPaths) {
                Iterable path = sharepointPath.getPath();
                String name = sharepointPath.getName();
                if (SharepointPathType.BY_CUSTOMER != sharepointPathType) continue;
                SharepointSitesResponse sites = this.sharepointDriveClientService.sites();
                System.out.println("sites = " + String.valueOf(sites));
                System.out.println("name = " + name);
                SharepointDriveItemResponse folder = this.sharepointDriveClientService.createFolder(driveId, path, name);
                executedPathsBuilder.put((Object)((SharepointPathType)entry.getKey()), (Object)folder);
            }
        }
        expectedPaths.get((Object)SharepointPathType.BY_CUSTOMER).forEach(ps -> {
            Iterable path = ps.getPath();
            String name = ps.getName();
            ImmutableList fullPath = ImmutableList.builder().addAll(path).add((Object)name).build();
            SharepointDriveItemResponse folder = this.sharepointDriveClientService.driveItemByPath(driveId, (Iterable)fullPath);
            executedPathsBuilder.put((Object)SharepointPathType.BY_CUSTOMER, (Object)folder);
        });
        expectedPaths.get((Object)SharepointPathType.ROOT).forEach(ps -> {
            Iterable path = ps.getPath();
            String name = ps.getName();
            ImmutableList fullPath = ImmutableList.builder().addAll(path).add((Object)name).build();
            SharepointDriveItemResponse folder = this.sharepointDriveClientService.driveItemByPath(driveId, (Iterable)fullPath);
            executedPathsBuilder.put((Object)SharepointPathType.ROOT, (Object)folder);
        });
        return executedPathsBuilder.build();
    }

    @VisibleForTesting
    public Multimap<SharepointPathType, SharepointPath> requiredPaths(@NonNull Customer customer) {
        if (customer == null) {
            throw new NullPointerException("customer is marked non-null but is null");
        }
        Long id = customer.getId();
        String sharepointCustomerRoot = this.sharepointConfiguration.getSharepointCustomerRoot();
        String sharepointCustomerPath = this.sharepointConfiguration.getSharepointCustomerPath();
        String byCustomerId = StringUtils.replace((String)sharepointCustomerPath, (String)"{customerId}", (String)Long.toString(id));
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)SharepointPathType.ROOT, (Object)SharepointPath.of((SharepointPathType)SharepointPathType.ROOT, (Iterable)ImmutableList.of(), (String)sharepointCustomerRoot));
        builder.put((Object)SharepointPathType.BY_CUSTOMER, (Object)SharepointPath.of((SharepointPathType)SharepointPathType.BY_CUSTOMER, (Iterable)ImmutableList.of((Object)sharepointCustomerRoot), (String)byCustomerId));
        return builder.build();
    }

    @Autowired
    public SharepointRouteImpl(CustomerHandler customerHandler, SharepointConfiguration sharepointConfiguration, SharepointDriveClientService sharepointDriveClientService) {
        this.customerHandler = customerHandler;
        this.sharepointConfiguration = sharepointConfiguration;
        this.sharepointDriveClientService = sharepointDriveClientService;
    }
}

