/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.qfm.erp.service.configuration.CompanyConfig;
import de.qfm.erp.service.helper.BigDecimalHelper;
import de.qfm.erp.service.helper.EmployeeHelper;
import de.qfm.erp.service.helper.MapsHelper;
import de.qfm.erp.service.helper.comparator.WageTypeCalculationResultComparator;
import de.qfm.erp.service.model.internal.employee.payroll.EWageAccountOn;
import de.qfm.erp.service.model.internal.employee.payroll.EWageTypeCalculationResultType;
import de.qfm.erp.service.model.internal.employee.payroll.WageTypeCalculationResult;
import de.qfm.erp.service.model.internal.export.SBSPayrollMeta;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollItemType;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.calculator.wagetype.EWageType;
import de.qfm.erp.service.service.calculator.wagetype.WageTypeCalculators;
import de.qfm.erp.service.service.handler.PayrollItemTypeHandler;
import de.qfm.erp.service.service.route.SBSRoute;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class SBSRouteImpl
implements SBSRoute {
    private static final String EMPTY_56 = StringUtils.leftPad((String)"", (int)56, (String)" ");
    private static final Joiner ROW_JOINER = Joiner.on((String)"\n").useForNull("");
    private static final Joiner ROW_PART_JOINER = Joiner.on((String)"").useForNull("");
    private static final CharMatcher VALID_COST_BEARER = CharMatcher.anyOf((CharSequence)"0123456789");
    private final PayrollItemTypeHandler payrollItemTypeHandler;
    private final WageTypeCalculators wageTypeCalculators;
    private final CompanyConfig companyConfig;

    @Nonnull
    public byte[] generate(@NonNull Iterable<PayrollMonth> payrollMonths) {
        if (payrollMonths == null) {
            throw new NullPointerException("payrollMonths is marked non-null but is null");
        }
        ImmutableList.Builder rowsBuilder = ImmutableList.builder();
        for (PayrollMonth payrollMonth : payrollMonths) {
            rowsBuilder.addAll(this.sbsRows(payrollMonth));
        }
        ImmutableList rows = rowsBuilder.build();
        String allRowsAsString = ROW_JOINER.join((Iterable)rows);
        return allRowsAsString.getBytes(StandardCharsets.UTF_8);
    }

    @Nonnull
    private Iterable<String> sbsRows(@NonNull PayrollMonth payrollMonth) {
        if (payrollMonth == null) {
            throw new NullPointerException("payrollMonth is marked non-null but is null");
        }
        Iterable payrollItemTypes = this.payrollItemTypeHandler.relevantUnique(payrollMonth.getLaborUnionContract());
        Iterable wageTypeCalculationResults = this.wageTypeCalculators.calculate(payrollMonth, payrollItemTypes);
        Iterable wageTypeCalculationResultsRemapped = this.remap(wageTypeCalculationResults, payrollItemTypes);
        ImmutableList wageTypeCalculationResultsFilteredForSBS = (ImmutableList)Streams.stream((Iterable)wageTypeCalculationResultsRemapped).filter(item -> {
            PayrollItemType payrollItemType = item.getPayrollItemType();
            EWageTypeCalculationResultType sbsExportWageTypeCalculationResultType = payrollItemType.getSbsExportWageTypeCalculationResultType();
            return Objects.equals(sbsExportWageTypeCalculationResultType, item.getWageTypeCalculationResultType());
        }).collect(ImmutableList.toImmutableList());
        YearMonth yearMonth = YearMonth.from(payrollMonth.getAccountingMonth());
        User user = payrollMonth.getUser();
        String costCenter = EmployeeHelper.currentCostCenterFailing((User)user, (YearMonth)yearMonth);
        SBSPayrollMeta sbsPayrollMeta = SBSPayrollMeta.of((YearMonth)yearMonth, (User)user, (String)costCenter);
        ImmutableList.Builder sbsRowsBuilder = ImmutableList.builder();
        for (WageTypeCalculationResult wageTypeCalculationResult : wageTypeCalculationResultsFilteredForSBS) {
            Optional sbsRowCandidate = this.sbsRow(sbsPayrollMeta, wageTypeCalculationResult, false);
            if (!sbsRowCandidate.isPresent()) continue;
            String sbsRow = (String)sbsRowCandidate.get();
            sbsRowsBuilder.add((Object)sbsRow);
        }
        return sbsRowsBuilder.build();
    }

    @Nonnull
    private Iterable<WageTypeCalculationResult> remap(@NonNull Iterable<WageTypeCalculationResult> wageTypeCalculationResults, @NonNull Iterable<PayrollItemType> payrollItemTypes) {
        if (wageTypeCalculationResults == null) {
            throw new NullPointerException("wageTypeCalculationResults is marked non-null but is null");
        }
        if (payrollItemTypes == null) {
            throw new NullPointerException("payrollItemTypes is marked non-null but is null");
        }
        HashSet handledWageTypeCalculationResults = Sets.newHashSet();
        HashSet mergedWageTypeCalculationResults = Sets.newHashSet();
        Iterable payrollItemTypesWithRemap = (Iterable)Streams.stream(payrollItemTypes).filter(item -> null != item.getSbsValuePayrollItemType()).collect(ImmutableList.toImmutableList());
        ImmutableSet neededPayrollItemTypes = ImmutableSet.builder().addAll(payrollItemTypesWithRemap).addAll(Streams.stream((Iterable)payrollItemTypesWithRemap).map(PayrollItemType::getSbsValuePayrollItemType).iterator()).build();
        Map wageTypeCalculationResultsByWageTypeNumber = MapsHelper.mapFirst((Iterable)Streams.stream(wageTypeCalculationResults).filter(arg_0 -> SBSRouteImpl.lambda$remap$2((Iterable)neededPayrollItemTypes, arg_0)).collect(Collectors.toSet()), WageTypeCalculationResult::getPayrollItemType, item -> item);
        for (PayrollItemType payrollItemTypeToMergeFrom : payrollItemTypesWithRemap) {
            PayrollItemType payrollItemTypeToMergeInto = payrollItemTypeToMergeFrom.getSbsValuePayrollItemType();
            if (!wageTypeCalculationResultsByWageTypeNumber.containsKey(payrollItemTypeToMergeFrom) || !wageTypeCalculationResultsByWageTypeNumber.containsKey(payrollItemTypeToMergeInto)) continue;
            WageTypeCalculationResult wageTypeCalculationResultToMergeFrom = (WageTypeCalculationResult)wageTypeCalculationResultsByWageTypeNumber.get(payrollItemTypeToMergeFrom);
            WageTypeCalculationResult wageTypeCalculationResultToMergeInto = (WageTypeCalculationResult)wageTypeCalculationResultsByWageTypeNumber.get(payrollItemTypeToMergeInto);
            handledWageTypeCalculationResults.add(wageTypeCalculationResultToMergeFrom);
            handledWageTypeCalculationResults.add(wageTypeCalculationResultToMergeInto);
            WageTypeCalculationResult mergedWageTypeCalculationResult = this.mergeValue(wageTypeCalculationResultToMergeFrom, wageTypeCalculationResultToMergeInto);
            mergedWageTypeCalculationResults.add(mergedWageTypeCalculationResult);
        }
        Iterable wageTypeCalculationResultsWithoutHandled = (Iterable)Streams.stream(wageTypeCalculationResults).filter(item -> !handledWageTypeCalculationResults.contains(item)).collect(ImmutableList.toImmutableList());
        ImmutableList allWageTypeCalculationResults = ImmutableList.builder().addAll(wageTypeCalculationResultsWithoutHandled).addAll((Iterable)mergedWageTypeCalculationResults).build();
        return ImmutableList.sortedCopyOf((Comparator)WageTypeCalculationResultComparator.INSTANCE, (Iterable)allWageTypeCalculationResults);
    }

    @Nonnull
    private WageTypeCalculationResult mergeValue(@NonNull WageTypeCalculationResult wageTypeCalculationResultToMergeFrom, @NonNull WageTypeCalculationResult wageTypeCalculationResultToMergeInto) {
        if (wageTypeCalculationResultToMergeFrom == null) {
            throw new NullPointerException("wageTypeCalculationResultToMergeFrom is marked non-null but is null");
        }
        if (wageTypeCalculationResultToMergeInto == null) {
            throw new NullPointerException("wageTypeCalculationResultToMergeInto is marked non-null but is null");
        }
        BigDecimal value1 = wageTypeCalculationResultToMergeFrom.getValue();
        BigDecimal value2 = wageTypeCalculationResultToMergeInto.getValue();
        BigDecimal valueMerged = value1.add(value2);
        return WageTypeCalculationResult.of((EWageType)wageTypeCalculationResultToMergeInto.getWageCalculation(), (PayrollItemType)wageTypeCalculationResultToMergeInto.getPayrollItemType(), (LocalDate)wageTypeCalculationResultToMergeInto.getDate(), (EWageTypeCalculationResultType)wageTypeCalculationResultToMergeInto.getWageTypeCalculationResultType(), (Integer)wageTypeCalculationResultToMergeInto.getOrder(), (String)wageTypeCalculationResultToMergeInto.getDescription(), (BigDecimal)wageTypeCalculationResultToMergeInto.getDescriptionValue(), (BigDecimal)wageTypeCalculationResultToMergeInto.getTimes(), (BigDecimal)wageTypeCalculationResultToMergeInto.getFactor(), (BigDecimal)valueMerged, (String)wageTypeCalculationResultToMergeInto.getCostBearer(), (boolean)wageTypeCalculationResultToMergeInto.isSbsCorrectionFactorEnabled(), (BigDecimal)wageTypeCalculationResultToMergeInto.getSbsCorrectionFactor());
    }

    @Nonnull
    private Optional<String> sbsRow(@NonNull SBSPayrollMeta sbsPayrollMeta, @NonNull WageTypeCalculationResult wageTypeCalculationResult, boolean exportZero) {
        if (sbsPayrollMeta == null) {
            throw new NullPointerException("sbsPayrollMeta is marked non-null but is null");
        }
        if (wageTypeCalculationResult == null) {
            throw new NullPointerException("wageTypeCalculationResult is marked non-null but is null");
        }
        User user = sbsPayrollMeta.getUser();
        String costCenter = StringUtils.trimToEmpty((String)sbsPayrollMeta.getCostCenter());
        LocalDate localDate = wageTypeCalculationResult.getDate();
        String costCenterTakeOver = VALID_COST_BEARER.retainFrom((CharSequence)StringUtils.trimToEmpty((String)wageTypeCalculationResult.getCostBearer()));
        PayrollItemType payrollItemType = wageTypeCalculationResult.getPayrollItemType();
        Boolean flagExportTimes = payrollItemType.getFlagSBSExportTimes();
        Boolean flagExportFactor = payrollItemType.getFlagSBSExportFactor();
        Boolean flagExportValue = payrollItemType.getFlagSBSExportValue();
        EWageAccountOn sbsWageAccountOn = (EWageAccountOn)MoreObjects.firstNonNull((Object)payrollItemType.getSbsWageAccountOn(), (Object)EWageAccountOn.DAY);
        boolean sbsCorrectionFactorEnabled = wageTypeCalculationResult.isSbsCorrectionFactorEnabled();
        BigDecimal sbsCorrectionFactor = wageTypeCalculationResult.getSbsCorrectionFactor();
        BigDecimal times = wageTypeCalculationResult.getTimes();
        BigDecimal timesWithCorrection = sbsCorrectionFactorEnabled ? times.multiply(sbsCorrectionFactor).setScale(2, RoundingMode.HALF_UP) : times;
        ArrayList factorsBuilder = Lists.newArrayList();
        if (Objects.equals(Boolean.TRUE, flagExportTimes)) {
            factorsBuilder.add(timesWithCorrection);
        }
        if (Objects.equals(Boolean.TRUE, flagExportFactor)) {
            factorsBuilder.add(wageTypeCalculationResult.getFactor());
        }
        if (Objects.equals(Boolean.TRUE, flagExportValue)) {
            factorsBuilder.add(wageTypeCalculationResult.getValue());
        }
        int currentSize = factorsBuilder.size();
        int missing = 5 - currentSize;
        IntStream.range(0, missing).forEach(i -> factorsBuilder.add(BigDecimal.ZERO));
        ImmutableList factors = ImmutableList.copyOf((Collection)factorsBuilder);
        boolean allZero = BigDecimalHelper.allZero((Iterable)factors);
        if (!allZero || exportZero) {
            ImmutableList.Builder rowPartsBuilder = ImmutableList.builder();
            String year = StringUtils.right((String)Integer.toString(localDate.get(ChronoField.YEAR)), (int)2);
            rowPartsBuilder.add((Object)year);
            String month = SBSRouteImpl.from((Integer)localDate.getMonthValue(), (int)2);
            rowPartsBuilder.add((Object)month);
            String dayOfMonth = sbsWageAccountOn == EWageAccountOn.DAY ? SBSRouteImpl.from((Integer)localDate.getDayOfMonth(), (int)2) : SBSRouteImpl.from((Integer)0, (int)2);
            rowPartsBuilder.add((Object)dayOfMonth);
            String personalNumber = SBSRouteImpl.from((Integer)user.getPersonalNumber(), (int)6);
            rowPartsBuilder.add((Object)personalNumber);
            Integer wageTypeNumber = payrollItemType.getWageTypeNumber();
            String wageType = SBSRouteImpl.from((Integer)wageTypeNumber, (int)4);
            rowPartsBuilder.add((Object)wageType);
            BigDecimal amountValue = wageTypeCalculationResult.getValue();
            boolean negative = amountValue.compareTo(BigDecimal.ZERO) < 0;
            String sign = negative ? "1" : "0";
            rowPartsBuilder.add((Object)sign);
            for (BigDecimal factor : factors) {
                BigDecimal safeValue = factor.abs();
                String valueString = SBSRouteImpl.from((BigDecimal)safeValue, (int)8);
                rowPartsBuilder.add((Object)valueString);
            }
            String costCenterString = StringUtils.leftPad((String)costCenter, (int)12, (String)"0");
            rowPartsBuilder.add((Object)costCenterString);
            String costCenterTakeOverString = StringUtils.leftPad((String)costCenterTakeOver, (int)12, (String)"0");
            rowPartsBuilder.add((Object)costCenterTakeOverString);
            rowPartsBuilder.add((Object)"000");
            rowPartsBuilder.add((Object)"0");
            rowPartsBuilder.add((Object)"  ");
            String currency = this.companyConfig.getSbsCurrency();
            rowPartsBuilder.add((Object)currency);
            rowPartsBuilder.add((Object)"000000");
            rowPartsBuilder.add((Object)EMPTY_56);
            ImmutableList rowParts = rowPartsBuilder.build();
            String content = ROW_PART_JOINER.join((Iterable)rowParts);
            return Optional.of(content);
        }
        return Optional.empty();
    }

    @Nonnull
    @VisibleForTesting
    public Iterable<Iterable<Pair<String, String>>> read(@NonNull String input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        String[] rows = StringUtils.split((String)input, (String)"\r\n");
        ImmutableList.Builder sbsRowsBuilder = ImmutableList.builder();
        for (String row : rows) {
            ImmutableList.Builder sbsRowBuilder = ImmutableList.builder();
            AtomicInteger position = new AtomicInteger();
            sbsRowBuilder.add((Object)SBSRouteImpl.consume((String)row, (String)"year", (AtomicInteger)position, (int)2));
            sbsRowBuilder.add((Object)SBSRouteImpl.consume((String)row, (String)"month", (AtomicInteger)position, (int)2));
            sbsRowBuilder.add((Object)SBSRouteImpl.consume((String)row, (String)"lastday", (AtomicInteger)position, (int)2));
            sbsRowBuilder.add((Object)SBSRouteImpl.consume((String)row, (String)"personal number", (AtomicInteger)position, (int)6));
            sbsRowBuilder.add((Object)SBSRouteImpl.consume((String)row, (String)"wage type", (AtomicInteger)position, (int)4));
            sbsRowBuilder.add((Object)SBSRouteImpl.consume((String)row, (String)"sign", (AtomicInteger)position, (int)1));
            sbsRowBuilder.add((Object)SBSRouteImpl.consume((String)row, (String)"factor a", (AtomicInteger)position, (int)8));
            sbsRowBuilder.add((Object)SBSRouteImpl.consume((String)row, (String)"factor b", (AtomicInteger)position, (int)8));
            sbsRowBuilder.add((Object)SBSRouteImpl.consume((String)row, (String)"factor c", (AtomicInteger)position, (int)8));
            sbsRowBuilder.add((Object)SBSRouteImpl.consume((String)row, (String)"factor d", (AtomicInteger)position, (int)8));
            sbsRowBuilder.add((Object)SBSRouteImpl.consume((String)row, (String)"factor e", (AtomicInteger)position, (int)8));
            sbsRowBuilder.add((Object)SBSRouteImpl.consume((String)row, (String)"cost center", (AtomicInteger)position, (int)12));
            sbsRowBuilder.add((Object)SBSRouteImpl.consume((String)row, (String)"cost center take over", (AtomicInteger)position, (int)12));
            sbsRowBuilder.add((Object)SBSRouteImpl.consume((String)row, (String)"babz", (AtomicInteger)position, (int)3));
            sbsRowBuilder.add((Object)SBSRouteImpl.consume((String)row, (String)"frei-f", (AtomicInteger)position, (int)1));
            sbsRowBuilder.add((Object)SBSRouteImpl.consume((String)row, (String)"ada", (AtomicInteger)position, (int)2));
            sbsRowBuilder.add((Object)SBSRouteImpl.consume((String)row, (String)"currency", (AtomicInteger)position, (int)1));
            sbsRowBuilder.add((Object)SBSRouteImpl.consume((String)row, (String)"correction date", (AtomicInteger)position, (int)6));
            sbsRowBuilder.add((Object)SBSRouteImpl.consume((String)row, (String)"const 56", (AtomicInteger)position, (int)56));
            ImmutableList sbsRow = sbsRowBuilder.build();
            sbsRowsBuilder.add((Object)sbsRow);
        }
        return sbsRowsBuilder.build();
    }

    @Nonnull
    private static Pair<String, String> consume(@NonNull String row, @NonNull String name, @NonNull AtomicInteger position, int length) {
        if (row == null) {
            throw new NullPointerException("row is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        int start = position.getAndAdd(length);
        int end = position.get();
        String value = StringUtils.substring((String)row, (int)start, (int)end);
        return Pair.of((Object)name, (Object)value);
    }

    @Nonnull
    private static String from(@Nullable BigDecimal bigDecimal, int length) {
        BigDecimal safeValue = (BigDecimal)MoreObjects.firstNonNull((Object)bigDecimal, (Object)BigDecimal.ZERO);
        int intValue = safeValue.multiply(BigDecimal.valueOf(100L)).intValue();
        return SBSRouteImpl.from((Integer)intValue, (int)length);
    }

    @Nonnull
    private static String from(@Nullable Integer value, int length) {
        Integer safeValue = (Integer)MoreObjects.firstNonNull((Object)value, (Object)0);
        return StringUtils.leftPad((String)Integer.toString(safeValue), (int)length, (String)"0");
    }

    public SBSRouteImpl(PayrollItemTypeHandler payrollItemTypeHandler, WageTypeCalculators wageTypeCalculators, CompanyConfig companyConfig) {
        this.payrollItemTypeHandler = payrollItemTypeHandler;
        this.wageTypeCalculators = wageTypeCalculators;
        this.companyConfig = companyConfig;
    }

    private static /* synthetic */ boolean lambda$remap$2(Iterable neededPayrollItemTypes, WageTypeCalculationResult item) {
        PayrollItemType payrollItemType = item.getPayrollItemType();
        return Iterables.contains((Iterable)neededPayrollItemTypes, (Object)payrollItemType);
    }
}

