/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import de.qfm.erp.common.response.measurement.ReleaseOrderCommonV1;
import de.qfm.erp.common.response.measurement.ReleaseOrdersCommonV1;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.handler.ReleaseOrderHandler;
import de.qfm.erp.service.service.handler.StageHandler;
import de.qfm.erp.service.service.handler.UserHandler;
import de.qfm.erp.service.service.mapper.ReleaseOrderMapper;
import de.qfm.erp.service.service.route.ReleaseOrderRoute;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReleaseOrderRouteImpl
implements ReleaseOrderRoute {
    private final StageHandler stageHandler;
    private final UserHandler userService;
    private final ReleaseOrderHandler releaseOrderHandler;
    private final ReleaseOrderMapper releaseOrderMapper;

    @Transactional(readOnly=true)
    @Nonnull
    public ReleaseOrdersCommonV1 listByQuotationAndSquad(@Nullable Long quotationId, @Nullable Long userId, int page, int size) {
        Page releaseOrders;
        if (null == quotationId && null == userId) {
            releaseOrders = this.releaseOrderHandler.list(page, size);
        } else if (null != quotationId && null == userId) {
            Quotation quotation = (Quotation)this.stageHandler.byIdFailing(quotationId);
            releaseOrders = this.releaseOrderHandler.listByQuotation(quotation, page, size);
        } else if (null == quotationId && null != userId) {
            User user = (User)this.userService.byIdFailing(userId);
            releaseOrders = this.releaseOrderHandler.listBySquad(user, page, size);
        } else {
            Quotation quotation = (Quotation)this.stageHandler.byIdFailing(quotationId);
            User user = (User)this.userService.byIdFailing(userId);
            releaseOrders = this.releaseOrderHandler.listByQuotationAndSquad(quotation, user, page, size);
        }
        return this.releaseOrderMapper.mapV1(releaseOrders);
    }

    @Nonnull
    @Transactional(readOnly=true)
    public ReleaseOrderCommonV1 byReferenceId(@NonNull String refId) {
        if (refId == null) {
            throw new NullPointerException("refId is marked non-null but is null");
        }
        return this.releaseOrderMapper.mapV1(this.releaseOrderHandler.byReferenceIdFailing(refId));
    }

    public ReleaseOrderRouteImpl(StageHandler stageHandler, UserHandler userService, ReleaseOrderHandler releaseOrderHandler, ReleaseOrderMapper releaseOrderMapper) {
        this.stageHandler = stageHandler;
        this.userService = userService;
        this.releaseOrderHandler = releaseOrderHandler;
        this.releaseOrderMapper = releaseOrderMapper;
    }
}

