/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import de.qfm.erp.common.response.pss.PssReleaseOrderCommon;
import de.qfm.erp.common.response.pss.PssReleaseOrdersCommon;
import de.qfm.erp.service.model.internal.pss.PssReleaseOrderUpdateBucket;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.measurement.ExtPssReleaseOrder;
import de.qfm.erp.service.model.jpa.measurement.PssReleaseOrder;
import de.qfm.erp.service.model.jpa.queue.EQueueItemType;
import de.qfm.erp.service.model.jpa.queue.EReferenceType;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.service.calculator.pss.PssCalculators;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.handler.ExtPssHandler;
import de.qfm.erp.service.service.handler.PssHandler;
import de.qfm.erp.service.service.handler.QueueService;
import de.qfm.erp.service.service.handler.StageHandler;
import de.qfm.erp.service.service.mapper.PssMapper;
import de.qfm.erp.service.service.route.PssRoute;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PssRouteImpl
implements PssRoute {
    private final EntityFactory entityFactory;
    private final ExtPssHandler extPssHandler;
    private final PssHandler pssHandler;
    private final PssMapper mapper;
    private final StageHandler quotationService;
    private final QueueService queueService;
    private final PssCalculators pssCalculators;

    @Nonnull
    @Transactional(readOnly=true)
    public PssReleaseOrdersCommon pssReleaseOrders(@NonNull Long quotationId, @NonNull String filterText, int page, int size) {
        if (quotationId == null) {
            throw new NullPointerException("quotationId is marked non-null but is null");
        }
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        Quotation quotation = (Quotation)this.quotationService.byIdFailing(quotationId);
        Page pssReleaseOrders = this.pssHandler.pssReleaseOrders(quotation, filterText, page, size);
        return this.mapper.map(pssReleaseOrders);
    }

    @Nonnull
    @Transactional(readOnly=true)
    public PssReleaseOrderCommon byId(@NonNull Long id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return this.mapper.map((PssReleaseOrder)this.pssHandler.byIdFailing(id));
    }

    @Nonnull
    @Transactional(readOnly=true)
    public PssReleaseOrderCommon byReferenceId(@NonNull String referenceId) {
        if (referenceId == null) {
            throw new NullPointerException("referenceId is marked non-null but is null");
        }
        return this.mapper.map(this.pssHandler.byReferenceIdFailing(referenceId));
    }

    @Nonnull
    private PssReleaseOrder saveAndEmitMessage(PssReleaseOrder pssReleaseOrder) {
        this.pssCalculators.sync().calculateAndApply(pssReleaseOrder);
        PssReleaseOrder pssReleaseOrderSaved = (PssReleaseOrder)this.pssHandler.update((EntityBase)pssReleaseOrder);
        this.queueService.put(EQueueItemType.UPDATED, EReferenceType.PSS_RELEASE_ORDER, pssReleaseOrderSaved.getId());
        return pssReleaseOrderSaved;
    }

    @Transactional
    public boolean handleCreated(@NonNull Long referenceId) {
        if (referenceId == null) {
            throw new NullPointerException("referenceId is marked non-null but is null");
        }
        Optional extPssReleaseOrderCandidate = this.extPssHandler.byIdNotFailing(referenceId);
        if (extPssReleaseOrderCandidate.isPresent()) {
            ExtPssReleaseOrder extPssReleaseOrder = (ExtPssReleaseOrder)extPssReleaseOrderCandidate.get();
            Long externalPssReleaseOrderId = extPssReleaseOrder.getPssId();
            PssReleaseOrder pssReleaseOrder = this.pssHandler.byPssReleaseOrderIdNotFailing(externalPssReleaseOrderId).orElse(this.entityFactory.pssReleaseOrder());
            PssReleaseOrderUpdateBucket bucket = PssReleaseOrderUpdateBucket.of((ExtPssReleaseOrder)extPssReleaseOrder, (PssReleaseOrder)pssReleaseOrder);
            PssReleaseOrder pssReleaseOrderMerged = this.mapper.merge(bucket);
            this.saveAndEmitMessage(pssReleaseOrderMerged);
            return true;
        }
        return false;
    }

    @Transactional
    public boolean handleUpdated(@NonNull Long referenceId) {
        if (referenceId == null) {
            throw new NullPointerException("referenceId is marked non-null but is null");
        }
        Optional extPssReleaseOrderCandidate = this.extPssHandler.byIdNotFailing(referenceId);
        if (extPssReleaseOrderCandidate.isPresent()) {
            ExtPssReleaseOrder extPssReleaseOrder = (ExtPssReleaseOrder)extPssReleaseOrderCandidate.get();
            Long externalPssReleaseOrderId = extPssReleaseOrder.getPssId();
            PssReleaseOrder pssReleaseOrder = this.pssHandler.byPssReleaseOrderIdNotFailing(externalPssReleaseOrderId).orElse(this.entityFactory.pssReleaseOrder());
            PssReleaseOrderUpdateBucket bucket = PssReleaseOrderUpdateBucket.of((ExtPssReleaseOrder)extPssReleaseOrder, (PssReleaseOrder)pssReleaseOrder);
            PssReleaseOrder pssReleaseOrderMerged = this.mapper.merge(bucket);
            this.saveAndEmitMessage(pssReleaseOrderMerged);
            return true;
        }
        return false;
    }

    @Transactional
    public boolean handleDeleted(@NonNull Long referenceId) {
        if (referenceId == null) {
            throw new NullPointerException("referenceId is marked non-null but is null");
        }
        Optional extPssReleaseOrderCandidate = this.extPssHandler.byIdNotFailing(referenceId);
        if (extPssReleaseOrderCandidate.isPresent()) {
            ExtPssReleaseOrder extPssReleaseOrder = (ExtPssReleaseOrder)extPssReleaseOrderCandidate.get();
            Long externalPssReleaseOrderId = extPssReleaseOrder.getPssId();
            PssReleaseOrder pssReleaseOrder = this.pssHandler.byPssReleaseOrderIdNotFailing(externalPssReleaseOrderId).orElse(this.entityFactory.pssReleaseOrder());
            PssReleaseOrderUpdateBucket bucket = PssReleaseOrderUpdateBucket.of((ExtPssReleaseOrder)extPssReleaseOrder, (PssReleaseOrder)pssReleaseOrder);
            PssReleaseOrder pssReleaseOrderMerged = this.mapper.merge(bucket);
            this.saveAndEmitMessage(pssReleaseOrderMerged);
            return true;
        }
        return false;
    }

    public PssRouteImpl(EntityFactory entityFactory, ExtPssHandler extPssHandler, PssHandler pssHandler, PssMapper mapper, StageHandler quotationService, QueueService queueService, PssCalculators pssCalculators) {
        this.entityFactory = entityFactory;
        this.extPssHandler = extPssHandler;
        this.pssHandler = pssHandler;
        this.mapper = mapper;
        this.quotationService = quotationService;
        this.queueService = queueService;
        this.pssCalculators = pssCalculators;
    }
}

