/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import de.qfm.erp.common.request.project.ProjectUpdateRequest;
import de.qfm.erp.common.response.project.ProjectAutoCompleteResponse;
import de.qfm.erp.common.response.project.ProjectCommon;
import de.qfm.erp.common.response.project.ProjectPageCommon;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.project.Project;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.handler.ProjectHandler;
import de.qfm.erp.service.service.mapper.ProjectMapper;
import de.qfm.erp.service.service.route.ProjectRoute;
import de.qfm.erp.service.service.security.UserService;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProjectRouteImpl
implements ProjectRoute {
    private static final Logger log = LogManager.getLogger(ProjectRouteImpl.class);
    private final EntityFactory entityFactory;
    private final ProjectHandler handler;
    private final ProjectMapper mapper;
    private final UserService userService;

    @Transactional(readOnly=true)
    @Nonnull
    public ProjectPageCommon page(int page, int size, @NonNull String filterText) {
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        return this.mapper.map(this.handler.page((Pageable)PageRequest.of((int)page, (int)size, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"name"})), filterText));
    }

    @Transactional(readOnly=true)
    @Nonnull
    public ProjectCommon byId(long id) {
        return this.mapper.map((Project)this.handler.byIdFailing(Long.valueOf(id)));
    }

    @Transactional(readOnly=true)
    @Nonnull
    public ProjectAutoCompleteResponse standardAutoComplete(@NonNull String filterText, int size) {
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        return this.mapper.mapAutoComplete(this.handler.page((Pageable)PageRequest.of((int)0, (int)size, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"name"})), filterText));
    }

    @Transactional
    @Nonnull
    public ProjectCommon create(@NonNull ProjectUpdateRequest updateRequest) {
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        this.userService.checkPrivilege(EPrivilege.VIS_MENU__ADMIN_PROJECTS);
        Project project = this.entityFactory.project();
        Project projectUpdated = this.mergeAndPersist(project, updateRequest);
        return this.mapper.map(projectUpdated);
    }

    @Transactional
    @Nonnull
    public ProjectCommon update(long id, @NonNull ProjectUpdateRequest updateRequest) {
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        this.userService.checkPrivilege(EPrivilege.VIS_MENU__ADMIN_PROJECTS);
        Project project = (Project)this.handler.byIdFailing(Long.valueOf(id));
        Project projectMerged = this.mapper.merge(project, updateRequest);
        Project projectUpdated = (Project)this.handler.update((EntityBase)projectMerged);
        return this.mapper.map(projectUpdated);
    }

    @Transactional
    @Nonnull
    public ProjectCommon delete(long id) {
        this.userService.checkPrivilege(EPrivilege.VIS_MENU__ADMIN_PROJECTS);
        Project project = (Project)this.handler.byIdFailing(Long.valueOf(id));
        Project deleted = (Project)this.handler.delete((EntityBase)project);
        return this.mapper.map(deleted);
    }

    @Nonnull
    private Project mergeAndPersist(@NonNull Project project, @NonNull ProjectUpdateRequest updateRequest) {
        if (project == null) {
            throw new NullPointerException("project is marked non-null but is null");
        }
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        Project projectMerged = this.mapper.merge(project, updateRequest);
        return (Project)this.handler.update((EntityBase)projectMerged);
    }

    public ProjectRouteImpl(EntityFactory entityFactory, ProjectHandler handler, ProjectMapper mapper, UserService userService) {
        this.entityFactory = entityFactory;
        this.handler = handler;
        this.mapper = mapper;
        this.userService = userService;
    }
}

