/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import com.google.common.collect.ImmutableList;
import de.qfm.erp.common.response.role.PrivilegeCommon;
import de.qfm.erp.common.response.role.PrivilegeListCommon;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.service.mapper.PrivilegeMapper;
import de.qfm.erp.service.service.route.PrivilegeRoute;
import jakarta.annotation.PostConstruct;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.stereotype.Service;

@Service
public class PrivilegeRouteImpl
implements PrivilegeRoute {
    private static PrivilegeListCommon PRIVILEGE_COMMON = PrivilegeListCommon.EMPTY;
    private final PrivilegeMapper privilegeMapper;

    @PostConstruct
    public void initPrivilegeMap() {
        EPrivilege[] privileges;
        ImmutableList.Builder privilegeCommonListBuilder = ImmutableList.builder();
        for (EPrivilege privilege : privileges = EPrivilege.values()) {
            if (EPrivilege.PRIVILEGES_HIDDEN.contains(privilege)) continue;
            PrivilegeCommon privilegeCommon = this.privilegeMapper.map(privilege);
            privilegeCommonListBuilder.add((Object)privilegeCommon);
        }
        ImmutableList privilegeCommonList = privilegeCommonListBuilder.build();
        PRIVILEGE_COMMON = new PrivilegeListCommon(privilegeCommonList.size(), (List)privilegeCommonList);
    }

    @Nonnull
    public PrivilegeListCommon list() {
        return PRIVILEGE_COMMON;
    }

    public PrivilegeRouteImpl(PrivilegeMapper privilegeMapper) {
        this.privilegeMapper = privilegeMapper;
    }
}

