/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.leancoders.common.helper.DateTimeHelper;
import de.leancoders.common.helper.IterableHelper;
import de.qfm.erp.common.request.employee.attendance.AttendanceListUpdateRequest;
import de.qfm.erp.common.request.employee.attendance.AttendanceModificationItem;
import de.qfm.erp.common.request.employee.attendance.AttendanceUpdateItem;
import de.qfm.erp.common.request.employee.attendance.AttendanceUpdateRequest;
import de.qfm.erp.common.request.employee.payroll.PayrollItemModificationItem;
import de.qfm.erp.common.request.employee.payroll.PayrollItemUpdateItem;
import de.qfm.erp.common.request.employee.payroll.PayrollMonthUpdateItem;
import de.qfm.erp.common.request.employee.payroll.PayrollMonthUpdateRequest;
import de.qfm.erp.common.response.employee.attendance.AttendanceCommon;
import de.qfm.erp.common.response.employee.attendance.AttendancesListCommon;
import de.qfm.erp.common.response.employee.payroll.PayrollMonthAutocompleteItemListCommon;
import de.qfm.erp.common.response.employee.payroll.PayrollMonthCommon;
import de.qfm.erp.common.response.employee.payroll.PayrollMonthItemListCommon;
import de.qfm.erp.common.response.employee.payroll.PayrollMonthPageCommon;
import de.qfm.erp.common.response.employee.payroll.WagesAssignedToPayrollCommon;
import de.qfm.erp.common.response.employee.wagedistribution.StageWageListCommon;
import de.qfm.erp.common.response.generic.PayrollItemTypePageCommon;
import de.qfm.erp.service.configuration.CompanyConfig;
import de.qfm.erp.service.helper.DateRange;
import de.qfm.erp.service.helper.DurationHelper;
import de.qfm.erp.service.helper.EmployeeHelper;
import de.qfm.erp.service.helper.MapsHelper;
import de.qfm.erp.service.helper.PayrollMonthHelper;
import de.qfm.erp.service.model.exception.request.EntityAccessRestrictionException;
import de.qfm.erp.service.model.exception.request.RequestValidationException;
import de.qfm.erp.service.model.exception.request.ValueRangeException;
import de.qfm.erp.service.model.exception.response.PDFGenerationException;
import de.qfm.erp.service.model.exception.response.ResourceNotFoundException;
import de.qfm.erp.service.model.internal.EYearMonthDateRange;
import de.qfm.erp.service.model.internal.MergedBucket;
import de.qfm.erp.service.model.internal.bankingholiday.BankingHolidayChangeMessage;
import de.qfm.erp.service.model.internal.costcenter.CostCenterFilter;
import de.qfm.erp.service.model.internal.dashboard.IReportCountStringLong;
import de.qfm.erp.service.model.internal.employee.StageWage;
import de.qfm.erp.service.model.internal.employee.payroll.AttendanceResetBucket;
import de.qfm.erp.service.model.internal.employee.payroll.AttendanceUpdateBucket;
import de.qfm.erp.service.model.internal.employee.payroll.EWageTypeCalculationResultType;
import de.qfm.erp.service.model.internal.employee.payroll.PayrollMonthBusinessUnitStatistic;
import de.qfm.erp.service.model.internal.employee.payroll.PayrollMonthItemUpdateBucket;
import de.qfm.erp.service.model.internal.employee.payroll.PayrollMonthLaborUnionContractStatistic;
import de.qfm.erp.service.model.internal.employee.payroll.PayrollMonthResetBucket;
import de.qfm.erp.service.model.internal.employee.payroll.PayrollMonthUpdateBucket;
import de.qfm.erp.service.model.internal.employee.payroll.PayrollStateChangeBucket;
import de.qfm.erp.service.model.internal.employee.payroll.WageTypeCalculationResult;
import de.qfm.erp.service.model.internal.eventbus.AttendanceChangeMessage;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.fieldname.SimpleFieldName;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.model.internal.payroll.EExportFileName;
import de.qfm.erp.service.model.internal.payroll.EPayrollPrintTemplate;
import de.qfm.erp.service.model.internal.payroll.IAggregatedPayrollUser;
import de.qfm.erp.service.model.internal.payroll.PayrollItemTypeFilter;
import de.qfm.erp.service.model.internal.payroll.PayrollMonthFilter;
import de.qfm.erp.service.model.internal.payroll.ProjectBasedWageReportBucket;
import de.qfm.erp.service.model.internal.payroll.WagesExport;
import de.qfm.erp.service.model.internal.payroll.WagesExportPaidWageItem;
import de.qfm.erp.service.model.internal.payroll.WagesExportStageWageItem;
import de.qfm.erp.service.model.internal.print.EPrintFontSize;
import de.qfm.erp.service.model.internal.print.attendances.CostCenterAttendancePrintBucket;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementStandardPrintConfiguration;
import de.qfm.erp.service.model.internal.print.payroll.AttendanceReportInfo;
import de.qfm.erp.service.model.internal.print.payroll.AttendanceReportPrintAggregationRow;
import de.qfm.erp.service.model.internal.print.payroll.AttendanceReportPrintConfiguration;
import de.qfm.erp.service.model.internal.print.payroll.BadWeatherReportPrintConfiguration;
import de.qfm.erp.service.model.internal.print.payroll.BadWeatherReportPrintInfo;
import de.qfm.erp.service.model.internal.print.payroll.PayrollMonthAttendanceInfo;
import de.qfm.erp.service.model.internal.print.payroll.PayrollMonthPrintConfiguration;
import de.qfm.erp.service.model.internal.print.payroll.PayrollMonthReportInfo;
import de.qfm.erp.service.model.internal.print.payroll.PayrollMonthSlipInfo;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.configuration.ConfigurationCompany;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.model.jpa.employee.attendance.EAggregatedAttendanceDayType;
import de.qfm.erp.service.model.jpa.employee.attendance.EAttendanceDayType;
import de.qfm.erp.service.model.jpa.employee.attendance.EAttendanceOrigin;
import de.qfm.erp.service.model.jpa.employee.contract.EmployeeContract;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionContract;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionWageGroup;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionWageGroupRate;
import de.qfm.erp.service.model.jpa.employee.payroll.EPayrollItemClazz;
import de.qfm.erp.service.model.jpa.employee.payroll.EPayrollItemUnit;
import de.qfm.erp.service.model.jpa.employee.payroll.EPayrollMonthState;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollItemType;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonthItem;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonthSnapShot;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonthSnapShotItem;
import de.qfm.erp.service.model.jpa.employee.payroll.WageAccount;
import de.qfm.erp.service.model.jpa.generic.EFederalState;
import de.qfm.erp.service.model.jpa.history.type.EEntityClass;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceType;
import de.qfm.erp.service.model.jpa.project.Project;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.calculator.attendance.AttendanceGenerator;
import de.qfm.erp.service.service.calculator.wagetype.AttendanceDurationAggregators;
import de.qfm.erp.service.service.calculator.wagetype.EWageType;
import de.qfm.erp.service.service.calculator.wagetype.WageTypeCalculators;
import de.qfm.erp.service.service.calculator.wagetype.calculator.WageCalculatorHelper;
import de.qfm.erp.service.service.handler.AttendanceHandler;
import de.qfm.erp.service.service.handler.BankingHolidayHandler;
import de.qfm.erp.service.service.handler.ConfigurationCompanyHandler;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.handler.LaborUnionContractHandler;
import de.qfm.erp.service.service.handler.PayrollItemTypeHandler;
import de.qfm.erp.service.service.handler.PayrollMonthHandler;
import de.qfm.erp.service.service.handler.PayrollMonthItemHandler;
import de.qfm.erp.service.service.handler.PayrollMonthSnapShotHandler;
import de.qfm.erp.service.service.handler.ProjectHandler;
import de.qfm.erp.service.service.handler.StageHandler;
import de.qfm.erp.service.service.handler.UserHandler;
import de.qfm.erp.service.service.handler.WageAccountHandler;
import de.qfm.erp.service.service.mapper.AttendanceMapper;
import de.qfm.erp.service.service.mapper.AttendancePrintMapper;
import de.qfm.erp.service.service.mapper.PayrollItemTypeMapper;
import de.qfm.erp.service.service.mapper.PayrollMonthItemMapper;
import de.qfm.erp.service.service.mapper.PayrollMonthMapper;
import de.qfm.erp.service.service.mapper.PayrollPrintMapper;
import de.qfm.erp.service.service.route.PayrollMonthRoute;
import de.qfm.erp.service.service.route.PdfRoute;
import de.qfm.erp.service.service.route.SBSRoute;
import de.qfm.erp.service.service.route.impl.PayrollMonthRouteImpl;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.service.DateTimeHelperService;
import de.qfm.erp.service.service.service.MessageService;
import de.qfm.erp.service.service.service.PayrollMonthHelperService;
import de.qfm.erp.service.service.service.print.PDFHelperService;
import de.qfm.erp.service.service.service.xls.PayrollMonthSnapShotXlsExportService;
import de.qfm.erp.service.service.service.xls.ProjectWageReportXlsExportService;
import de.qfm.erp.service.service.validator.Validator;
import de.qfm.erp.service.service.validator.Validators;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationListener;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class PayrollMonthRouteImpl
implements PayrollMonthRoute,
ApplicationListener<BankingHolidayChangeMessage> {
    private static final Logger log = LogManager.getLogger(PayrollMonthRouteImpl.class);
    public static final Joiner ID_JOINER = Joiner.on((String)",").skipNulls();
    public static final int MIN_ALLOWED_YEAR = 2000;
    public static final int BANKING_HOLIDAY_REFRESH_MINUS_MONTHS = 1;
    private static final DateTimeFormatter YEAR_MONTH_YYYY_MM_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM");
    public static final Function<Attendance, Boolean> BAD_WEATHER_EDITING_DISABLED_FN = attendance -> {
        PayrollMonth payrollMonth = attendance.getPayrollMonth();
        EPayrollMonthState payrollMonthState = payrollMonth.getPayrollMonthState();
        EAttendanceOrigin lastOrigin = attendance.getLastOrigin();
        YearMonth thisMonth = YearMonth.now();
        YearMonth accountingMonth = YearMonth.from(payrollMonth.getAccountingMonth());
        boolean postEdit = null != lastOrigin && EAttendanceOrigin.BAD_WEATHER != lastOrigin;
        boolean released = null != payrollMonthState && EPayrollMonthState.RELEASED == payrollMonthState;
        boolean tooLate = thisMonth.isAfter(accountingMonth);
        return tooLate || postEdit || released;
    };
    public static final Predicate<PayrollMonthItem> FN_PAYROLL_MONTH_AUXILIARY_WAGE_INCLUDE_IN_REPORT = item -> {
        PayrollItemType payrollItemType = item.getPayrollItemType();
        return null != payrollItemType && Boolean.TRUE == payrollItemType.getFlagProjectBasedWageExportInclude();
    };
    private final CompanyConfig companyConfig;
    private final EntityFactory entityFactory;
    private final AttendanceHandler attendanceHandler;
    private final AttendanceMapper mapper;
    private final BankingHolidayHandler bankingHolidayHandler;
    private final LaborUnionContractHandler laborUnionContractHandler;
    private final PayrollItemTypeHandler payrollItemTypeHandler;
    private final PayrollMonthHandler payrollMonthHandler;
    private final PayrollMonthItemHandler payrollMonthItemHandler;
    private final PayrollMonthSnapShotHandler payrollMonthSnapShotHandler;
    private final PayrollMonthSnapShotXlsExportService payrollMonthSnapShotXlsExportService;
    private final ProjectWageReportXlsExportService projectWageReportXlsExportService;
    private final StageHandler stageHandler;
    private final WageAccountHandler wageAccountHandler;
    private final MessageService messageService;
    private final ProjectHandler projectHandler;
    private final UserHandler userHandler;
    private final UserService userService;
    private final AttendancePrintMapper attendancePrintMapper;
    private final PayrollItemTypeMapper payrollItemTypeMapper;
    private final PayrollMonthMapper payrollMonthMapper;
    private final PayrollMonthItemMapper payrollMonthItemMapper;
    private final PayrollPrintMapper printMapper;
    private final AttendanceDurationAggregators attendanceDurationAggregators;
    private final WageTypeCalculators wageTypeCalculators;
    private final PayrollMonthHelperService payrollMonthHelperService;
    private final AttendanceGenerator attendanceGenerator;
    private final DateTimeHelperService dateTimeHelperService;
    private final PDFHelperService pdfHelperService;
    private final PdfRoute pdfRoute;
    private final SBSRoute sbsRoute;
    private final Validators validators;
    private final ConfigurationCompanyHandler configurationCompanyHandler;
    private ApplicationEventPublisher applicationEventPublisher;
    public static final Pair<String, byte[]> EMPTY = Pair.of((Object)"", (Object)new byte[0]);
    private static final CharMatcher ALLOWED_FILE_NAME = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9'));
    private static final CharMatcher ALLOWED_FILE_NAME__NEGATION = ALLOWED_FILE_NAME.negate();
    private static final Range<Integer> MONTH_RANGE = Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(12));

    @Transactional(readOnly=true)
    @Nonnull
    public AttendanceCommon attendanceById(long id) {
        Attendance attendance = (Attendance)this.attendanceHandler.byIdFailing(Long.valueOf(id));
        YearMonth accountingMonth = YearMonth.from(attendance.getDate());
        Function userReleasedFn = PayrollMonthHelper.usersInReleasedStateFn((YearMonth)accountingMonth, (Iterable)ImmutableList.of((Object)attendance), (Iterable)ImmutableList.of(), (arg_0, arg_1) -> ((PayrollMonthHandler)this.payrollMonthHandler).releasedPayrollMonthsByUsersAndAccountingMonth(arg_0, arg_1));
        return this.mapper.map(attendance, userReleasedFn, x -> false);
    }

    @Transactional(readOnly=true)
    @Nonnull
    public StageWageListCommon listQuotationWages(long id, @NonNull String operation, boolean hideZero) {
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        PayrollMonth payrollMonth = (PayrollMonth)this.payrollMonthHandler.byIdFailing(Long.valueOf(id));
        this.checkPermissionToAccess(payrollMonth);
        Iterable quotationWages = this.getQuotationWages(payrollMonth, operation, hideZero);
        return this.payrollMonthMapper.mapStageWages(quotationWages);
    }

    @Transactional(readOnly=true)
    @Nonnull
    public StageWageListCommon listQuotationWages(@NonNull EAttendanceOrigin origin, long userId, int year, int month, @NonNull String operation, boolean hideZero) {
        if (origin == null) {
            throw new NullPointerException("origin is marked non-null but is null");
        }
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        PayrollMonth payrollMonth = this.getOrCreatePayrollMonth(origin, userId, year, month);
        this.checkPermissionToAccess(payrollMonth);
        Iterable quotationWages = this.getQuotationWages(payrollMonth, operation, hideZero);
        return this.payrollMonthMapper.mapStageWages(quotationWages);
    }

    @Nonnull
    private Iterable<StageWage> getQuotationWages(@NonNull PayrollMonth payrollMonth, @NonNull String operation, boolean hideZero) {
        if (payrollMonth == null) {
            throw new NullPointerException("payrollMonth is marked non-null but is null");
        }
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        EYearMonthDateRange yearMonthDateRange = EYearMonthDateRange.lookup((String)operation, (EYearMonthDateRange)EYearMonthDateRange.LE);
        return this.payrollMonthHelperService.determineStageWages(payrollMonth, yearMonthDateRange, hideZero);
    }

    @Transactional(readOnly=true)
    @Nonnull
    public PayrollItemTypePageCommon availablePayrollItemTypes(int page, int size, boolean all, long payrollMonthId) {
        EmployeeContract employeeContract;
        LaborUnionContract laborUnionContract;
        PayrollMonth payrollMonth = (PayrollMonth)this.payrollMonthHandler.byIdFailing(Long.valueOf(payrollMonthId));
        User user = payrollMonth.getUser();
        LocalDate accountingMonth = payrollMonth.getAccountingMonth();
        Optional employeeContractCandidate = EmployeeHelper.currentEmployeeContractNotFailing((User)user, (LocalDate)accountingMonth);
        ImmutableList.Builder laborUnionContractsBuilder = ImmutableList.builder();
        if (employeeContractCandidate.isPresent() && null != (laborUnionContract = (employeeContract = (EmployeeContract)employeeContractCandidate.get()).getLaborUnionContract())) {
            laborUnionContractsBuilder.add((Object)laborUnionContract);
        }
        ImmutableList laborUnionContracts = laborUnionContractsBuilder.build();
        PayrollItemTypeFilter payrollItemTypeFilter = PayrollItemTypeFilter.of((int)page, (int)size, (boolean)all, (Iterable)laborUnionContracts);
        return this.payrollItemTypeMapper.map(this.payrollItemTypeHandler.all(payrollItemTypeFilter));
    }

    @Transactional(readOnly=true)
    @Deprecated
    @Nonnull
    public PayrollMonthItemListCommon incentiveWagesAssignedToPayroll(long id) {
        PayrollMonth payrollMonth = (PayrollMonth)this.payrollMonthHandler.byIdFailing(Long.valueOf(id));
        this.checkPermissionToAccess(payrollMonth);
        User user = payrollMonth.getUser();
        YearMonth accountingMonth = YearMonth.from(payrollMonth.getAccountingMonth());
        Iterable attendances = (Iterable)MoreObjects.firstNonNull((Object)payrollMonth.getAttendances(), (Object)ImmutableSet.of());
        Iterable payrollMonthItems = (Iterable)MoreObjects.firstNonNull((Object)this.payrollMonthItemHandler.incentiveWagesAssignedToPayroll(user, accountingMonth), (Object)ImmutableList.of());
        Function fn = PayrollMonthHelper.usersInReleasedStateFn((YearMonth)accountingMonth, (Iterable)attendances, (Iterable)payrollMonthItems, (arg_0, arg_1) -> ((PayrollMonthHandler)this.payrollMonthHandler).releasedPayrollMonthsByUsersAndAccountingMonth(arg_0, arg_1));
        return this.payrollMonthItemMapper.mapPayrollMonthItems(payrollMonthItems, fn);
    }

    @Transactional(readOnly=true)
    @Nonnull
    public WagesAssignedToPayrollCommon wagesAssignedToPayroll(long id) {
        PayrollMonth payrollMonth = (PayrollMonth)this.payrollMonthHandler.byIdFailing(Long.valueOf(id));
        this.checkPermissionToAccess(payrollMonth);
        User user = payrollMonth.getUser();
        YearMonth accountingMonth = YearMonth.from(payrollMonth.getAccountingMonth());
        Iterable incentiveWagesAssignedToPayroll = this.payrollMonthItemHandler.incentiveWagesAssignedToPayroll(user, accountingMonth);
        Iterable wageAccountAssignedToPayroll = this.payrollMonthItemHandler.wageAccountAssignedToPayroll(user, accountingMonth);
        Iterable routedIncentiveWagesAssignedToPayroll = this.payrollMonthItemHandler.routedIncentiveWagesAssignedToPayroll(user, accountingMonth);
        Iterable squadLeaderAttendancesAssignedToPayroll = this.attendanceHandler.findSquadLeaderAttendances(payrollMonth);
        BigDecimal incentiveWageSum = WageCalculatorHelper.incentiveWageSum((Iterable)incentiveWagesAssignedToPayroll, (Iterable)routedIncentiveWagesAssignedToPayroll, (Iterable)wageAccountAssignedToPayroll);
        Iterable allPayrollItemTypes = this.payrollItemTypeHandler.relevantUnique(payrollMonth.getLaborUnionContract());
        Iterable calculate = this.wageTypeCalculators.calculate(payrollMonth, allPayrollItemTypes);
        ImmutableList collect = (ImmutableList)Streams.stream((Iterable)calculate).filter(item -> item.getWageCalculation() == EWageType.STANDARD_WAGE).collect(ImmutableList.toImmutableList());
        BigDecimal calculatedWageSum = collect.isEmpty() ? BigDecimal.ZERO : ((WageTypeCalculationResult)collect.get(0)).getValue();
        BigDecimal wageCalculatedSum = (BigDecimal)MoreObjects.firstNonNull((Object)calculatedWageSum, (Object)BigDecimal.ZERO);
        return this.payrollMonthItemMapper.mapWagesAssignedToPayroll(incentiveWageSum, wageCalculatedSum, incentiveWagesAssignedToPayroll, wageAccountAssignedToPayroll, squadLeaderAttendancesAssignedToPayroll, x -> true);
    }

    @Transactional(readOnly=true)
    @Nonnull
    public AttendancesListCommon attendancesByTypeAndYearAndMonth(@NonNull String type, int year, int month) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        EAttendanceDayType attendanceDayType = EAttendanceDayType.lookupFailing((String)type);
        YearMonth accountingMonth = PayrollMonthRouteImpl.yearMonth((int)year, (int)month);
        Range dateRange = PayrollMonthRouteImpl.dateRange((YearMonth)accountingMonth);
        Iterable attendances = this.attendanceHandler.findByTypeAndDateIsBetween(attendanceDayType, dateRange);
        Function released = this.usersInReleasedStateFn(accountingMonth, attendances);
        return this.mapper.map(attendances, released, BAD_WEATHER_EDITING_DISABLED_FN);
    }

    @Transactional
    @Nonnull
    public AttendancesListCommon attendancesByUserIdAndYearAndMonth(@NonNull EAttendanceOrigin origin, long userId, int year, int month) {
        if (origin == null) {
            throw new NullPointerException("origin is marked non-null but is null");
        }
        PayrollMonth payrollMonth = this.getOrCreatePayrollMonth(origin, userId, year, month);
        List attendances = (List)MoreObjects.firstNonNull((Object)payrollMonth.getAttendances(), (Object)ImmutableList.of());
        Function releasedStateFn = this.usersInReleasedStateFn(payrollMonth);
        return this.mapper.map((Iterable)attendances, releasedStateFn, x -> false);
    }

    @Transactional(readOnly=true)
    @Nonnull
    public AttendancesListCommon attendancesById(long id) {
        PayrollMonth payrollMonth = (PayrollMonth)this.payrollMonthHandler.byIdFailing(Long.valueOf(id));
        List attendances = (List)MoreObjects.firstNonNull((Object)payrollMonth.getAttendances(), (Object)ImmutableList.of());
        return this.mapper.map((Iterable)attendances, x -> false, x -> false);
    }

    @Transactional
    @Nonnull
    public AttendancesListCommon update(@Nonnull AttendanceListUpdateRequest attendanceListUpdateRequest) {
        List attendanceUpdateItems = attendanceListUpdateRequest.getItems();
        Iterable attendanceUpdateBuckets = this.buckets(EAttendanceOrigin.PAYROLL_MONTH, attendanceUpdateItems);
        MergedBucket attendanceMergedBucket = this.mapper.merge(attendanceUpdateBuckets);
        Iterable attendancesUpdated = attendanceMergedBucket.getUpdated();
        Iterable attendanceUpdated = this.attendanceHandler.update(attendancesUpdated);
        this.emitAttendanceUpdates(attendanceMergedBucket);
        return this.mapper.map(attendanceUpdated, item -> false, x -> false);
    }

    @Nonnull
    @Transactional
    public PayrollMonthCommon update(long id, @NonNull PayrollMonthUpdateRequest request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        PayrollMonthUpdateBucket payrollMonthUpdateBucket = this.bucket(id, request);
        this.checkPermissionToAccess(payrollMonthUpdateBucket.getPayrollMonth());
        boolean validated = this.validators.payrollMonthUpdate(payrollMonthUpdateBucket).beforeMerge().validate();
        Pair mergeResult = this.payrollMonthMapper.merge(payrollMonthUpdateBucket);
        PayrollMonth payrollMonthMerged = (PayrollMonth)mergeResult.getLeft();
        Iterable allPayrollItemTypes = this.payrollItemTypeHandler.relevantUnique(payrollMonthUpdateBucket.getLaborUnionContract());
        BigDecimal summarizedWage = this.wageTypeCalculators.summarizedWage(payrollMonthMerged, allPayrollItemTypes);
        payrollMonthMerged.setCurrentWage(summarizedWage);
        PayrollMonth payrollMonthUpdated = (PayrollMonth)this.payrollMonthHandler.update((EntityBase)payrollMonthMerged, false);
        WageAccount wageAccountUpdated = (WageAccount)this.wageAccountHandler.update((EntityBase)payrollMonthUpdateBucket.getWageAccount(), true);
        MergedBucket attendanceMergedBucket = (MergedBucket)mergeResult.getRight();
        this.emitAttendanceUpdates(attendanceMergedBucket);
        Function fn = this.usersInReleasedStateFn(payrollMonthUpdated);
        return this.payrollMonthMapper.map(payrollMonthUpdated, fn);
    }

    private void emitAttendanceUpdates(@NonNull MergedBucket<Attendance> attendanceMergedBucket) {
        if (attendanceMergedBucket == null) {
            throw new NullPointerException("attendanceMergedBucket is marked non-null but is null");
        }
        Iterable attendancesUpdated = attendanceMergedBucket.getUpdated();
        attendancesUpdated.forEach(item -> this.applicationEventPublisher.publishEvent((ApplicationEvent)AttendanceChangeMessage.of((Object)this, (Attendance)item)));
    }

    @Transactional
    @Nonnull
    public AttendanceCommon update(@NonNull EAttendanceOrigin origin, long id, @NonNull AttendanceUpdateRequest request) {
        Attendance attendance;
        if (origin == null) {
            throw new NullPointerException("origin is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Iterable attendanceUpdateBuckets = this.buckets(origin, (List)ImmutableList.of((Object)request));
        this.validators.attendanceUpdate(attendanceUpdateBuckets).beforeMerge().validate();
        MergedBucket attendanceMergedBucket = this.mapper.merge(attendanceUpdateBuckets);
        Iterable allAttendances = attendanceMergedBucket.all();
        if (Iterables.size((Iterable)allAttendances) == 1 && null != (attendance = (Attendance)Iterables.get((Iterable)allAttendances, (int)0))) {
            PayrollMonth payrollMonth = attendance.getPayrollMonth();
            Attendance attendanceUpdated = (Attendance)this.attendanceHandler.update((EntityBase)attendance);
            this.emitAttendanceUpdates(attendanceMergedBucket);
            return this.mapper.map(attendanceUpdated, this.usersInReleasedStateFn(payrollMonth), BAD_WEATHER_EDITING_DISABLED_FN);
        }
        throw new IllegalArgumentException("Attendance Update failed as there is no Attendance, which is impossible");
    }

    @Nonnull
    private Function<User, Boolean> usersInReleasedStateFn(@NonNull PayrollMonth payrollMonth) {
        if (payrollMonth == null) {
            throw new NullPointerException("payrollMonth is marked non-null but is null");
        }
        YearMonth accountingMonth = YearMonth.from(payrollMonth.getAccountingMonth());
        List attendances = (List)MoreObjects.firstNonNull((Object)payrollMonth.getAttendances(), (Object)ImmutableList.of());
        List payrollMonthItems = (List)MoreObjects.firstNonNull((Object)payrollMonth.getPayrollMonthItems(), (Object)ImmutableList.of());
        return this.usersInReleasedStateFn(accountingMonth, (Iterable)attendances, (Iterable)payrollMonthItems);
    }

    @Nonnull
    private Function<User, Boolean> usersInReleasedStateFn(@NonNull YearMonth accountingMonth, @NonNull Iterable<Attendance> attendances) {
        if (accountingMonth == null) {
            throw new NullPointerException("accountingMonth is marked non-null but is null");
        }
        if (attendances == null) {
            throw new NullPointerException("attendances is marked non-null but is null");
        }
        return this.usersInReleasedStateFn(accountingMonth, attendances, (Iterable)ImmutableList.of());
    }

    @Nonnull
    private Function<User, Boolean> usersInReleasedStateFn(@NonNull YearMonth accountingMonth, @NonNull Iterable<Attendance> attendances, @NonNull Iterable<PayrollMonthItem> payrollMonthItems) {
        if (accountingMonth == null) {
            throw new NullPointerException("accountingMonth is marked non-null but is null");
        }
        if (attendances == null) {
            throw new NullPointerException("attendances is marked non-null but is null");
        }
        if (payrollMonthItems == null) {
            throw new NullPointerException("payrollMonthItems is marked non-null but is null");
        }
        return PayrollMonthHelper.usersInReleasedStateFn((YearMonth)accountingMonth, attendances, payrollMonthItems, (arg_0, arg_1) -> ((PayrollMonthHandler)this.payrollMonthHandler).releasedPayrollMonthsByUsersAndAccountingMonth(arg_0, arg_1));
    }

    @Transactional
    @Nonnull
    public Pair<String, byte[]> printPayrollMonth(long id, @NonNull String templateCandidate) {
        if (templateCandidate == null) {
            throw new NullPointerException("templateCandidate is marked non-null but is null");
        }
        EPayrollPrintTemplate printTemplateCandidate = EPayrollPrintTemplate.lookupFailing((String)templateCandidate);
        PayrollMonth payrollMonth = (PayrollMonth)this.payrollMonthHandler.byIdFailing(Long.valueOf(id));
        this.checkPermissionToAccess(payrollMonth);
        try {
            LocalDate accountingMonth = payrollMonth.getAccountingMonth();
            User user = payrollMonth.getUser();
            Integer personalNumber = user.getPersonalNumber();
            String personalNumberString = null != personalNumber ? Integer.toString(personalNumber) : "xxx";
            String timePart = YEAR_MONTH_YYYY_MM_FORMAT.format(accountingMonth);
            ConfigurationCompany configurationCompany = this.configurationCompanyHandler.getDefaultFailing();
            switch (1.$SwitchMap$de$qfm$erp$service$model$internal$payroll$EPayrollPrintTemplate[printTemplateCandidate.ordinal()]) {
                case 1: {
                    Pair printInformation = this.preparePrintSlip(payrollMonth);
                    PayrollMonthPrintConfiguration payrollMonthPrintConfiguration = (PayrollMonthPrintConfiguration)printInformation.getLeft();
                    PayrollMonthSlipInfo payrollMonthSlipInfo = (PayrollMonthSlipInfo)printInformation.getRight();
                    byte[] buffer = this.pdfRoute.generatePDF(payrollMonthSlipInfo, payrollMonthPrintConfiguration, EPrintFontSize.DEFAULT, configurationCompany);
                    this.payrollMonthHandler.updateSlipPrinted(payrollMonth);
                    String name = this.messageService.get((Translatable)EExportFileName.PAYROLL_SLIP_PDF, new Object[]{timePart, personalNumberString});
                    return Pair.of((Object)name, (Object)buffer);
                }
                case 2: {
                    String name = this.messageService.get((Translatable)EExportFileName.PAYROLL_REPORT_PDF, new Object[]{timePart, personalNumberString});
                    Pair printInformation = this.printReport(payrollMonth);
                    PayrollMonthPrintConfiguration payrollMonthPrintConfiguration = (PayrollMonthPrintConfiguration)printInformation.getLeft();
                    PayrollMonthReportInfo payrollMonthReportInfo = (PayrollMonthReportInfo)printInformation.getRight();
                    byte[] buffer = this.pdfRoute.generatePDF(payrollMonthReportInfo, payrollMonthPrintConfiguration, EPrintFontSize.SMALLER, configurationCompany);
                    return Pair.of((Object)name, (Object)buffer);
                }
                case 3: 
                case 4: {
                    String name = this.messageService.get((Translatable)EExportFileName.PAYROLL_ATTENDANCE_PDF, new Object[]{timePart, personalNumberString});
                    Pair printInformation = this.printAttendance(payrollMonth);
                    PayrollMonthPrintConfiguration payrollMonthPrintConfiguration = (PayrollMonthPrintConfiguration)printInformation.getLeft();
                    PayrollMonthAttendanceInfo payrollMonthAttendanceInfo = (PayrollMonthAttendanceInfo)printInformation.getRight();
                    byte[] buffer = this.pdfRoute.generatePDF(payrollMonthAttendanceInfo, payrollMonthPrintConfiguration, EPrintFontSize.SMALLER, configurationCompany);
                    return Pair.of((Object)name, (Object)buffer);
                }
                case 5: {
                    throw new IllegalArgumentException(String.format("Print Template Candidate: %s not known", templateCandidate));
                }
            }
        }
        catch (Exception e) {
            String msg = String.format("Error generating PDF: %s for Payroll: %s and Template: %s", e.getMessage(), id, templateCandidate);
            log.error(msg, (Throwable)e);
            throw new PDFGenerationException(msg);
        }
        return EMPTY;
    }

    @Transactional
    @Nonnull
    public Pair<String, byte[]> printPayrollMonthsAsZIP(@NonNull Iterable<Long> ids, @NonNull String printTemplateCandidate) throws IOException {
        if (ids == null) {
            throw new NullPointerException("ids is marked non-null but is null");
        }
        if (printTemplateCandidate == null) {
            throw new NullPointerException("printTemplateCandidate is marked non-null but is null");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipOutputStream zipOut = new ZipOutputStream(bos);
        for (Long id : ids) {
            Pair printResult = this.printPayrollMonth(id.longValue(), printTemplateCandidate);
            String fileName = (String)printResult.getLeft();
            byte[] bytes = (byte[])printResult.getRight();
            ZipEntry zipEntry = new ZipEntry(fileName);
            zipOut.putNextEntry(zipEntry);
            zipOut.write(bytes);
        }
        zipOut.close();
        byte[] zipBuffer = bos.toByteArray();
        String fileNameZIP = this.messageService.get((Translatable)EExportFileName.PAYROLL_SLIPS_AS_ZIP, new Object[]{this.dateTimeHelperService.timeStampForFile()});
        return Pair.of((Object)fileNameZIP, (Object)zipBuffer);
    }

    @Transactional
    @Nonnull
    public Pair<String, byte[]> printPayrollMonthsAsPDF(@NonNull Iterable<Long> ids, @NonNull String printTemplateCandidate) throws IOException {
        if (ids == null) {
            throw new NullPointerException("ids is marked non-null but is null");
        }
        if (printTemplateCandidate == null) {
            throw new NullPointerException("printTemplateCandidate is marked non-null but is null");
        }
        String fileTimeStamp = YEAR_MONTH_YYYY_MM_FORMAT.format(YearMonth.now());
        PDFMergerUtility pdfMergerUtility = new PDFMergerUtility();
        String title = String.format("Lohnkarten Monat: %s", fileTimeStamp);
        String subject = String.format("Lohnkarten Monat: %s", fileTimeStamp);
        try (PDDocument document = this.pdfHelperService.document(title, subject);){
            Iterable sortedIds = this.payrollMonthHandler.idsSortedByName(ids);
            for (Long id : sortedIds) {
                Pair printResult = this.printPayrollMonth(id.longValue(), printTemplateCandidate);
                PDDocument pdDocument = Loader.loadPDF((byte[])((byte[])printResult.getRight()));
                pdfMergerUtility.appendDocument(document, pdDocument);
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            document.save((OutputStream)outputStream);
            String fileName = this.messageService.get((Translatable)EExportFileName.PAYROLL_SLIPS_AS_PDF, new Object[]{this.dateTimeHelperService.timeStampForFile()});
            Pair pair = Pair.of((Object)fileName, (Object)outputStream.toByteArray());
            return pair;
        }
    }

    @Transactional
    @Nonnull
    public Pair<String, byte[]> printByCostCenter(@NonNull String costCenter, @NonNull String templateCandidate, int year, int month) {
        if (costCenter == null) {
            throw new NullPointerException("costCenter is marked non-null but is null");
        }
        if (templateCandidate == null) {
            throw new NullPointerException("templateCandidate is marked non-null but is null");
        }
        CostCenterFilter costCenterFilter = CostCenterFilter.from((String)StringUtils.trimToEmpty((String)costCenter));
        Optional printTemplateCandidate = EPayrollPrintTemplate.lookup((String)templateCandidate);
        if (printTemplateCandidate.isPresent()) {
            ConfigurationCompany configurationCompany = this.configurationCompanyHandler.getDefaultFailing();
            EPayrollPrintTemplate ePayrollPrintTemplate = (EPayrollPrintTemplate)printTemplateCandidate.get();
            try {
                switch (1.$SwitchMap$de$qfm$erp$service$model$internal$payroll$EPayrollPrintTemplate[ePayrollPrintTemplate.ordinal()]) {
                    case 3: {
                        YearMonth yearMonth = YearMonth.of(year, month);
                        Pair printInformation = this.printAttendancesReport(yearMonth, costCenterFilter);
                        AttendanceReportInfo info = (AttendanceReportInfo)printInformation.getRight();
                        AttendanceReportPrintConfiguration configuration = (AttendanceReportPrintConfiguration)printInformation.getLeft();
                        byte[] buffer = this.pdfRoute.generatePDF(info, configuration, EPrintFontSize.SMALLEST, configurationCompany);
                        String fileName = this.messageService.getDE((Translatable)EExportFileName.PAYROLL_ATTENDANCE_BY_CC_PDF, new Object[]{this.dateTimeHelperService.timeStampForFile(), costCenter});
                        return Pair.of((Object)fileName, (Object)buffer);
                    }
                    case 6: {
                        YearMonth yearMonth = YearMonth.of(year, month);
                        Pair printInformation = this.printBadWeatherReport(yearMonth, costCenterFilter);
                        BadWeatherReportPrintInfo info = (BadWeatherReportPrintInfo)printInformation.getRight();
                        BadWeatherReportPrintConfiguration configuration = (BadWeatherReportPrintConfiguration)printInformation.getLeft();
                        byte[] buffer = this.pdfRoute.generatePDF(info, configuration, EPrintFontSize.SMALLEST, configurationCompany);
                        String fileName = this.messageService.getDE((Translatable)EExportFileName.PAYROLL_BAD_WEATHER_BY_CC_PDF, new Object[]{this.dateTimeHelperService.timeStampForFile(), costCenter});
                        return Pair.of((Object)fileName, (Object)buffer);
                    }
                    case 5: {
                        throw new IllegalArgumentException(String.format("Print Template Candidate: %s not known", templateCandidate));
                    }
                }
            }
            catch (Exception e) {
                String msg = String.format("Error generating PDF: %s for Business Unit Id: %s and Template: %s", e.getMessage(), costCenterFilter, templateCandidate);
                log.error(msg, (Throwable)e);
                throw new PDFGenerationException(msg);
            }
        } else {
            throw Validator.throwEnumException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PRINT_TEMPLATE), (String)templateCandidate, EPayrollPrintTemplate.class, EPayrollPrintTemplate::allowedKeys);
        }
        return EMPTY;
    }

    @Nonnull
    private Pair<AttendanceReportPrintConfiguration, AttendanceReportInfo> printAttendancesReport(@NonNull YearMonth accountingMonth, @NonNull CostCenterFilter stringSearchFilter) {
        if (accountingMonth == null) {
            throw new NullPointerException("accountingMonth is marked non-null but is null");
        }
        if (stringSearchFilter == null) {
            throw new NullPointerException("stringSearchFilter is marked non-null but is null");
        }
        LocalDate referenceDate = accountingMonth.atDay(1);
        Optional managerCandidate = this.userHandler.currentManagerNotFailing(stringSearchFilter, referenceDate);
        Iterable users = this.userHandler.usersInCostCenter(stringSearchFilter, referenceDate);
        Iterable payrollMonthsInCostCenter = this.payrollMonthHandler.findByUserAndYearMonthNotFailing(users, accountingMonth);
        Iterable costCenterAttendancePrintBuckets = (Iterable)Streams.stream((Iterable)payrollMonthsInCostCenter).filter(item -> Objects.equals(EPayrollMonthState.RELEASED, item.getPayrollMonthState())).map(arg_0 -> this.costCenterAttendancePrintBucket(arg_0)).collect(ImmutableList.toImmutableList());
        Iterable additionalAggregationRows = this.attendanceReportAggregationRows(payrollMonthsInCostCenter);
        ImmutableList bankingHolidays = ImmutableList.of();
        Iterable attendancePrintStandardRows = this.attendancePrintMapper.attendanceReportRows(accountingMonth, costCenterAttendancePrintBuckets, (Iterable)bankingHolidays);
        User currentUser = this.userService.authenticatedUser();
        long currentUserId = currentUser.getId();
        String currentUserFullName = currentUser.getFullName();
        long managerId = managerCandidate.map(User::getId).orElse(0L);
        String managerFullName = managerCandidate.map(User::getFullName).orElse("");
        AttendanceReportPrintConfiguration printConfiguration = AttendanceReportPrintConfiguration.of((Color)MeasurementStandardPrintConfiguration.DEFAULT_HEADER_BG_COLOR, (Iterable)ImmutableList.of(), (LocalDate)DateTimeHelper.today());
        AttendanceReportInfo printInfo = AttendanceReportInfo.of((Long)currentUserId, (String)currentUserFullName, (Long)managerId, (String)managerFullName, (String)stringSearchFilter.getCostCenter(), (Currency)Currency.getInstance(Locale.GERMANY), (YearMonth)accountingMonth, (Iterable)attendancePrintStandardRows, (Iterable)additionalAggregationRows);
        return Pair.of((Object)printConfiguration, (Object)printInfo);
    }

    @Nonnull
    private Iterable<AttendanceReportPrintAggregationRow> attendanceReportAggregationRows(@NonNull Iterable<PayrollMonth> payrollMonths) {
        if (payrollMonths == null) {
            throw new NullPointerException("payrollMonths is marked non-null but is null");
        }
        Page allPayrollItemTypes = this.payrollItemTypeHandler.page(Pageable.unpaged());
        List<PayrollItemType> payrollItemTypesWithAggregation = allPayrollItemTypes.getContent().stream().filter(item -> (Boolean)MoreObjects.firstNonNull((Object)item.getFlagAttendanceReportAggregation(), (Object)false)).toList();
        ArrayListMultimap values = ArrayListMultimap.create();
        payrollItemTypesWithAggregation.forEach(arg_0 -> PayrollMonthRouteImpl.lambda$attendanceReportAggregationRows$13((Multimap)values, arg_0));
        for (PayrollMonth payrollMonth : payrollMonths) {
            EPayrollMonthState payrollMonthState = payrollMonth.getPayrollMonthState();
            if (EPayrollMonthState.RELEASED != payrollMonthState) continue;
            List payrollMonthItems = payrollMonth.getPayrollMonthItems();
            payrollMonthItems.stream().filter(item -> EPayrollItemClazz.AUXILIARY_WAGE == item.getPayrollItemClazz()).filter(item -> null != item.getPayrollItemType()).filter(item -> (Boolean)MoreObjects.firstNonNull((Object)item.getPayrollItemType().getFlagAttendanceReportAggregation(), (Object)false)).forEach(arg_0 -> PayrollMonthRouteImpl.lambda$attendanceReportAggregationRows$17((Multimap)values, arg_0));
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        values.asMap().forEach((payrollItemType, value) -> {
            String name = payrollItemType.getName();
            EPayrollItemUnit unit = payrollItemType.getUnit();
            BigDecimal sum = value.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            builder.add((Object)AttendanceReportPrintAggregationRow.of((String)name, (EPayrollItemUnit)unit, (BigDecimal)sum));
        });
        return builder.build();
    }

    @Nonnull
    private CostCenterAttendancePrintBucket costCenterAttendancePrintBucket(@NonNull PayrollMonth payrollMonth) {
        if (payrollMonth == null) {
            throw new NullPointerException("payrollMonth is marked non-null but is null");
        }
        LocalDate accountingMonth = payrollMonth.getAccountingMonth();
        Map durations = this.attendanceDurationAggregators.duration(payrollMonth);
        Map counts = this.attendanceDurationAggregators.count(payrollMonth);
        List payrollMonthItems = (List)MoreObjects.firstNonNull((Object)payrollMonth.getPayrollMonthItems(), (Object)ImmutableList.of());
        ImmutableList payrollMonthItemsWithHours = (ImmutableList)payrollMonthItems.stream().filter(item -> item.getPayrollItemClazz() == EPayrollItemClazz.AUXILIARY_WAGE).filter(item -> {
            PayrollItemType payrollItemType = item.getPayrollItemType();
            if (null != payrollItemType) {
                EPayrollItemUnit unit = (EPayrollItemUnit)MoreObjects.firstNonNull((Object)payrollItemType.getUnit(), (Object)EPayrollItemUnit.UNKNOWN);
                boolean condition1 = Objects.equals(unit, EPayrollItemUnit.HOUR);
                Boolean flagMonthlyReportExclude = (Boolean)MoreObjects.firstNonNull((Object)payrollItemType.getFlagMonthlyReportExclude(), (Object)Boolean.FALSE);
                boolean condition2 = Objects.equals(flagMonthlyReportExclude, Boolean.FALSE);
                return condition1 && condition2;
            }
            return false;
        }).filter(item -> ((BigDecimal)MoreObjects.firstNonNull((Object)item.getValue(), (Object)BigDecimal.ZERO)).compareTo(BigDecimal.ZERO) != 0).collect(ImmutableList.toImmutableList());
        ImmutableMap.Builder remappedBuilder = ImmutableMap.builder();
        durations.entrySet().stream().filter(item -> item.getKey() != EAggregatedAttendanceDayType.AGG_HELP_WAGE_HOURS).forEach(arg_0 -> ((ImmutableMap.Builder)remappedBuilder).put(arg_0));
        remappedBuilder.put((Object)EAggregatedAttendanceDayType.AGG_HELP_WAGE_HOURS, (Object)DurationHelper.hours((BigDecimal)payrollMonthItemsWithHours.stream().map(PayrollMonthItem::getValue).reduce(BigDecimal.ZERO, BigDecimal::add)));
        ImmutableMap remappedDurations = remappedBuilder.build();
        return CostCenterAttendancePrintBucket.of((LocalDate)accountingMonth, (PayrollMonth)payrollMonth, (Map)remappedDurations, (Map)counts);
    }

    @Nonnull
    private Pair<BadWeatherReportPrintConfiguration, BadWeatherReportPrintInfo> printBadWeatherReport(@NonNull YearMonth accountingMonth, @NonNull CostCenterFilter stringSearchFilter) {
        if (accountingMonth == null) {
            throw new NullPointerException("accountingMonth is marked non-null but is null");
        }
        if (stringSearchFilter == null) {
            throw new NullPointerException("stringSearchFilter is marked non-null but is null");
        }
        LocalDate referenceDate = accountingMonth.atDay(1);
        Iterable users = this.userHandler.usersInCostCenter(stringSearchFilter, referenceDate);
        Iterable payrollMonthsInCostCenter = this.payrollMonthHandler.findByUserAndYearMonthNotFailing(users, accountingMonth);
        Iterable costCenterAttendancePrintBuckets = (Iterable)Streams.stream((Iterable)payrollMonthsInCostCenter).filter(item -> Objects.equals(EPayrollMonthState.RELEASED, item.getPayrollMonthState())).map(arg_0 -> this.costCenterAttendancePrintBucket(arg_0)).collect(ImmutableList.toImmutableList());
        ImmutableList bankingHolidays = ImmutableList.of();
        Iterable attendancePrintStandardRows = this.attendancePrintMapper.badWeatherReportRows(accountingMonth, costCenterAttendancePrintBuckets, (Iterable)bankingHolidays);
        User currentUser = this.userService.authenticatedUser();
        long currentUserId = currentUser.getId();
        String currentUserFullName = currentUser.getFullName();
        BadWeatherReportPrintConfiguration printConfiguration = BadWeatherReportPrintConfiguration.of((Color)MeasurementStandardPrintConfiguration.DEFAULT_HEADER_BG_COLOR, (Iterable)ImmutableList.of(), (LocalDate)DateTimeHelper.today());
        BadWeatherReportPrintInfo printInfo = BadWeatherReportPrintInfo.of((Long)currentUserId, (String)currentUserFullName, (YearMonth)accountingMonth, (Iterable)attendancePrintStandardRows);
        return Pair.of((Object)printConfiguration, (Object)printInfo);
    }

    @Nonnull
    @VisibleForTesting
    public Pair<PayrollMonthPrintConfiguration, PayrollMonthSlipInfo> preparePrintSlip(@NonNull PayrollMonth payrollMonth) {
        if (payrollMonth == null) {
            throw new NullPointerException("payrollMonth is marked non-null but is null");
        }
        this.checkPermissionToAccess(payrollMonth);
        YearMonth yearMonth = YearMonth.from(payrollMonth.getAccountingMonth());
        User user = payrollMonth.getUser();
        Integer personalNumber = user.getPersonalNumber();
        Currency currency = Currency.getInstance(Locale.GERMANY);
        String personalNumberAsString = null != personalNumber ? Integer.toString(personalNumber) : "";
        Optional wageGroupRateCandidate = EmployeeHelper.currentWageGroupRateNotFailing((User)user, (YearMonth)yearMonth);
        if (wageGroupRateCandidate.isEmpty()) {
            throw new IllegalArgumentException("No WageGroup / Contract for Employee configured or found");
        }
        LaborUnionWageGroupRate laborUnionWageGroupRate = (LaborUnionWageGroupRate)wageGroupRateCandidate.get();
        LaborUnionWageGroup laborUnionWageGroup = laborUnionWageGroupRate.getLaborUnionWageGroup();
        LaborUnionContract laborUnionContractOfWageGroup = laborUnionWageGroup.getLaborUnionContract();
        Iterable payrollItemTypes = this.payrollItemTypeHandler.relevantUnique(laborUnionContractOfWageGroup);
        Long employeeContractId = laborUnionContractOfWageGroup.getId();
        String employeeContractName = laborUnionContractOfWageGroup.getName();
        Iterable wageTypeCalculationResults = this.wageTypeCalculators.calculate(payrollMonth, payrollItemTypes);
        Map aggregations = this.attendanceDurationAggregators.duration(payrollMonth);
        ImmutableMap M = ImmutableMap.of((Object)EWageTypeCalculationResultType.STANDARD, (Object)ImmutableSet.of((Object)EWageTypeCalculationResultType.STANDARD), (Object)EWageTypeCalculationResultType.DETAIL_GROUPED, (Object)ImmutableSet.of((Object)EWageTypeCalculationResultType.STANDARD, (Object)EWageTypeCalculationResultType.DETAIL_GROUPED), (Object)EWageTypeCalculationResultType.DETAIL_UNGROUPED, (Object)ImmutableSet.of((Object)EWageTypeCalculationResultType.STANDARD, (Object)EWageTypeCalculationResultType.DETAIL_UNGROUPED));
        ImmutableList wageTypeCalculationResultsPrint = (ImmutableList)Streams.stream((Iterable)wageTypeCalculationResults).filter(arg_0 -> PayrollMonthRouteImpl.lambda$preparePrintSlip$24((Map)M, arg_0)).collect(ImmutableList.toImmutableList());
        Iterable payrollMonthSlipItemPrintRows = this.printMapper.mapPayrollMonthSlipItemPrintRow((Iterable)wageTypeCalculationResultsPrint);
        User releaseUser = payrollMonth.getReleasedBy();
        Long releaseUserId = null == releaseUser ? null : releaseUser.getId();
        String releaseUserFullName = null == releaseUser ? null : releaseUser.getFullName();
        EPayrollMonthState payrollMonthState = payrollMonth.getPayrollMonthState();
        boolean released = EPayrollMonthState.RELEASED == payrollMonthState;
        LocalDateTime releasedOn = payrollMonth.getReleasedOn();
        String remarks = StringUtils.trimToEmpty((String)payrollMonth.getRemarks());
        PayrollMonthSlipInfo payrollMonthSlipInfo = PayrollMonthSlipInfo.of((Long)user.getId(), (String)user.getFullName(), (String)personalNumberAsString, (Long)employeeContractId, (String)employeeContractName, (Currency)currency, (YearMonth)yearMonth, (boolean)released, (Long)releaseUserId, (String)releaseUserFullName, (LocalDateTime)releasedOn, (String)remarks, (Iterable)payrollMonthSlipItemPrintRows, (Map)aggregations);
        PayrollMonthPrintConfiguration printConfiguration = PayrollMonthPrintConfiguration.of((Color)MeasurementStandardPrintConfiguration.DEFAULT_HEADER_BG_COLOR, (Iterable)ImmutableList.of(), (LocalDate)DateTimeHelper.today());
        return Pair.of((Object)printConfiguration, (Object)payrollMonthSlipInfo);
    }

    @Nonnull
    public Pair<String, byte[]> exportWagesAsXLS(@NonNull YearMonth yearMonth) throws IOException {
        if (yearMonth == null) {
            throw new NullPointerException("yearMonth is marked non-null but is null");
        }
        this.userService.checkPrivilege(EPrivilege.REPORTING__STAGE_WAGE_AND_PAID_WAGE_MONTHLY_REPORT);
        Iterable snapShots = this.payrollMonthSnapShotHandler.findByAccountingMonth(yearMonth);
        Iterable payrollMonths = (Iterable)Streams.stream((Iterable)snapShots).map(PayrollMonthSnapShot::getPayrollMonth).collect(ImmutableList.toImmutableList());
        ImmutableList stageWageItems = PayrollMonthRouteImpl.wagesExportStageWageItems((YearMonth)yearMonth, (Iterable)snapShots);
        Iterable paidWageItems = this.wagesExportPaidWageItems(yearMonth, payrollMonths);
        WagesExport wagesExport = WagesExport.of((Iterable)stageWageItems, (Iterable)paidWageItems);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (SXSSFWorkbook sxssfWorkbook = this.payrollMonthSnapShotXlsExportService.detailXLS(wagesExport);){
            sxssfWorkbook.setActiveSheet(0);
            sxssfWorkbook.write((OutputStream)bos);
            byte[] bytes = bos.toByteArray();
            String dateForFile = this.dateTimeHelperService.dateForFile();
            String naming = "Lohn Export " + String.valueOf(yearMonth);
            String fileName = this.messageService.get((Translatable)EExportFileName.QUOTATION__BOQ_MEASUREMENT_TEMPLATE_AS_XLSX, new Object[]{dateForFile, naming});
            Pair pair = Pair.of((Object)fileName, (Object)bytes);
            return pair;
        }
    }

    public Pair<String, byte[]> projectBasedWageExportAsXLS(@NonNull YearMonth accountingMonth, @NonNull String costCenterCand) throws IOException {
        if (accountingMonth == null) {
            throw new NullPointerException("accountingMonth is marked non-null but is null");
        }
        if (costCenterCand == null) {
            throw new NullPointerException("costCenterCand is marked non-null but is null");
        }
        CostCenterFilter costCenterFilter = CostCenterFilter.from((String)costCenterCand);
        Iterable usersInCC = this.userHandler.usersInCostCenter(costCenterFilter, accountingMonth.atDay(1));
        Page allProjects = this.projectHandler.page(Pageable.unpaged(), "");
        Map projectMapping = (Map)allProjects.stream().collect(ImmutableMap.toImmutableMap(Project::getName, Project::getReferenceId));
        ImmutableList.Builder projectBasedWageReportBucketsBuilder = ImmutableList.builder();
        for (User user : usersInCC) {
            BigDecimal limit;
            BigDecimal balance;
            ImmutableList.Builder stageWageItemsBuilder = ImmutableList.builder();
            Optional payrollMonthSnapShotCand = this.payrollMonthSnapShotHandler.findByAccountingMonth(accountingMonth, user);
            if (payrollMonthSnapShotCand.isPresent()) {
                PayrollMonthSnapShot payrollMonthSnapShot = (PayrollMonthSnapShot)payrollMonthSnapShotCand.get();
                balance = payrollMonthSnapShot.getWageAccountBalance();
                limit = payrollMonthSnapShot.getWageAccountLimit();
                Iterable snapShotItems = (Iterable)MoreObjects.firstNonNull((Object)payrollMonthSnapShot.getSnapShotItems(), (Object)ImmutableList.of());
                for (PayrollMonthSnapShotItem snapShotItem : snapShotItems) {
                    Quotation stage = snapShotItem.getStage();
                    Project project = stage.getProject();
                    stageNumber = stage.getQNumber();
                    projectName = null != project ? project.getName() : "n/a";
                    amountAvailable = (BigDecimal)MoreObjects.firstNonNull((Object)snapShotItem.getAmountAvailable(), (Object)BigDecimal.ZERO);
                    stageWageItemsBuilder.add((Object)StageWageItem.of((boolean)true, (String)stageNumber, (String)projectName, (BigDecimal)amountAvailable));
                }
            } else {
                WageAccount wageAccount = user.getWageAccount();
                balance = wageAccount.getBalance();
                limit = wageAccount.getLimit();
                Optional payrollMonthC = this.payrollMonthHandler.findByUserAndYearMonthNotFailing(user, accountingMonth);
                if (payrollMonthC.isPresent()) {
                    PayrollMonth payrollMonth = (PayrollMonth)payrollMonthC.get();
                    Iterable stageWages = this.payrollMonthHelperService.determineStageWages(payrollMonth, EYearMonthDateRange.LE, false);
                    for (StageWage stageWage : stageWages) {
                        stageNumber = stageWage.getStageNumber();
                        projectName = stageWage.getProjectName();
                        amountAvailable = stageWage.getWageAvailableOverallSum();
                        stageWageItemsBuilder.add((Object)StageWageItem.of((boolean)false, (String)stageNumber, (String)projectName, (BigDecimal)amountAvailable));
                    }
                }
            }
            ImmutableList stageWageItems = stageWageItemsBuilder.build();
            Iterable incentiveWagesAssignedToPayroll = this.payrollMonthItemHandler.incentiveWagesAssignedToPayroll(user, accountingMonth);
            Iterable wageAccountAssignedToPayroll = this.payrollMonthItemHandler.wageAccountAssignedToPayroll(user, accountingMonth);
            Iterable auxiliarWagesAssignedToPayrollForExport = this.payrollMonthItemHandler.auxiliaryWagesAssignedToPayroll(user, accountingMonth, FN_PAYROLL_MONTH_AUXILIARY_WAGE_INCLUDE_IN_REPORT);
            ImmutableList allPayrollMonthItemsAssignedToPayroll = ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)incentiveWagesAssignedToPayroll, (Iterable)wageAccountAssignedToPayroll, (Iterable)auxiliarWagesAssignedToPayrollForExport));
            ProjectBasedWageReportBucket projectBasedWageReportBucket = this.map(user, balance, limit, (Iterable)stageWageItems, (Iterable)allPayrollMonthItemsAssignedToPayroll);
            projectBasedWageReportBucketsBuilder.add((Object)projectBasedWageReportBucket);
        }
        ImmutableList projectBasedWageReportBuckets = projectBasedWageReportBucketsBuilder.build();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (SXSSFWorkbook sxssfWorkbook = this.projectWageReportXlsExportService.detailXLS(accountingMonth, costCenterCand, projectMapping, (Iterable)projectBasedWageReportBuckets);){
            sxssfWorkbook.setActiveSheet(0);
            sxssfWorkbook.write((OutputStream)bos);
            byte[] bytes = bos.toByteArray();
            String dateForFile = this.dateTimeHelperService.dateForFile();
            String yearMonthStr = DateTimeHelperService.germanMonthDotYear((LocalDate)accountingMonth.atDay(1));
            String costCenterStr = costCenterFilter.asFileName();
            String fileName = this.messageService.get((Translatable)EExportFileName.PROJECT_BASED_WAGE_EXPORT_AS_XLSX, new Object[]{dateForFile, yearMonthStr, costCenterStr});
            Pair pair = Pair.of((Object)fileName, (Object)bytes);
            return pair;
        }
    }

    @Transactional(readOnly=true)
    @Nonnull
    public PayrollMonthAutocompleteItemListCommon badWeatherCandidateAutocomplete(long userId, int year, int month, @NonNull String filterText) {
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        Iterable payrollMonths = this.payrollMonthHandler.payrollMonthsWithBadWeatherAttendances(Long.valueOf(userId), YearMonth.of(year, month));
        return this.mapper.mapToPayrollMonthAutocomplete(payrollMonths, filterText);
    }

    @NonNull
    public ProjectBasedWageReportBucket map(@NonNull User user, @NonNull BigDecimal balance, @NonNull BigDecimal limit, @NonNull Iterable<StageWageItem> snapShotItems, @NonNull Iterable<PayrollMonthItem> payrollMonthItems) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (balance == null) {
            throw new NullPointerException("balance is marked non-null but is null");
        }
        if (limit == null) {
            throw new NullPointerException("limit is marked non-null but is null");
        }
        if (snapShotItems == null) {
            throw new NullPointerException("snapShotItems is marked non-null but is null");
        }
        if (payrollMonthItems == null) {
            throw new NullPointerException("payrollMonthItems is marked non-null but is null");
        }
        Integer personalNumber = (Integer)MoreObjects.firstNonNull((Object)user.getPersonalNumber(), (Object)0);
        String firstName = user.getFirstName();
        String lastName = user.getLastName();
        HashMap wageInStages = Maps.newHashMap();
        HashMap wageInProjects = Maps.newHashMap();
        boolean snapShotData = false;
        for (StageWageItem snapShotItem : snapShotItems) {
            snapShotData |= snapShotItem.isSnapShotData();
            String projectName = snapShotItem.getProjectName();
            String stageNumber = snapShotItem.getStageNumber();
            BigDecimal amountAvailable = snapShotItem.getValue();
            BigDecimal stageExisting = wageInStages.getOrDefault(stageNumber, BigDecimal.ZERO);
            wageInStages.put(stageNumber, stageExisting.add(amountAvailable));
            BigDecimal projectExisting = wageInProjects.getOrDefault(projectName, BigDecimal.ZERO);
            wageInProjects.put(projectName, projectExisting.add(amountAvailable));
        }
        Iterable projectBasedWageIncentiveWageItems = this.payrollMonthItemMapper.mapToProjectBasedWageIncentiveWageItem(payrollMonthItems);
        return ProjectBasedWageReportBucket.of((boolean)snapShotData, (Integer)personalNumber, (String)firstName, (String)lastName, (BigDecimal)balance, (BigDecimal)limit, (Map)wageInStages, (Map)wageInProjects, (Iterable)projectBasedWageIncentiveWageItems);
    }

    @Nonnull
    private Iterable<WagesExportPaidWageItem> wagesExportPaidWageItems(@NonNull YearMonth yearMonth, @NonNull Iterable<PayrollMonth> payrollMonths) {
        if (yearMonth == null) {
            throw new NullPointerException("yearMonth is marked non-null but is null");
        }
        if (payrollMonths == null) {
            throw new NullPointerException("payrollMonths is marked non-null but is null");
        }
        ImmutableList.Builder paidWageItemBuilder = ImmutableList.builder();
        for (PayrollMonth payrollMonth : payrollMonths) {
            List payrollMonthItems = (List)MoreObjects.firstNonNull((Object)payrollMonth.getPayrollMonthItems(), (Object)ImmutableList.of());
            ImmutableList incentivePayments = (ImmutableList)payrollMonthItems.stream().filter(EPayrollItemClazz.INCENTIVE_PREDICATE).collect(ImmutableList.toImmutableList());
            for (PayrollMonthItem payrollMonthItem : incentivePayments) {
                Quotation stage = payrollMonthItem.getQuotation();
                Long stageId = stage.getId();
                String quotationNumber = stage.getQuotationNumber();
                String stageNumber = stage.getQNumber();
                String stageAlias = stage.getAlias();
                Project project = stage.getProject();
                Long projectId = null != project ? project.getId() : -1L;
                String projectReferenceId = null != project ? project.getReferenceId() : "n/a";
                String projectName = null != project ? project.getName() : "n/a";
                EInvoiceType stageDefaultInvoiceType = (EInvoiceType)MoreObjects.firstNonNull((Object)stage.getFinanceDefaultInvoiceType(), (Object)EInvoiceType.UNKNOWN);
                Boolean stageFlagSubContractor = (Boolean)MoreObjects.firstNonNull((Object)stage.getFinanceFlagSubcontractor(), (Object)false);
                User sender = payrollMonthItem.getSender();
                Integer senderPersonalNumber = sender.getPersonalNumber();
                String senderFullName = sender.getFullName();
                String senderCostCenter = EmployeeHelper.currentCostCenterFailing((User)sender, (YearMonth)yearMonth);
                User recipient = payrollMonthItem.getRecipient();
                Integer recipientPersonalNumber = recipient.getPersonalNumber();
                String recipientFullName = recipient.getFullName();
                String recipientCostCenter = EmployeeHelper.currentCostCenterFailing((User)recipient, (YearMonth)yearMonth);
                BigDecimal value = payrollMonthItem.getValue();
                paidWageItemBuilder.add((Object)WagesExportPaidWageItem.of((Long)stageId, (String)quotationNumber, (String)stageNumber, (String)stageAlias, (Long)projectId, (String)projectReferenceId, (String)projectName, (EInvoiceType)stageDefaultInvoiceType, (Boolean)stageFlagSubContractor, (Integer)senderPersonalNumber, (String)senderFullName, (String)senderCostCenter, (Integer)recipientPersonalNumber, (String)recipientFullName, (String)recipientCostCenter, (BigDecimal)value));
            }
        }
        return paidWageItemBuilder.build();
    }

    private static ImmutableList<WagesExportStageWageItem> wagesExportStageWageItems(YearMonth yearMonth, Iterable<PayrollMonthSnapShot> snapShots) {
        ImmutableList.Builder stageWageItemsBuilder = ImmutableList.builder();
        for (PayrollMonthSnapShot snapShot : snapShots) {
            PayrollMonth payrollMonth = snapShot.getPayrollMonth();
            User user = payrollMonth.getUser();
            List snapShotItems = snapShot.getSnapShotItems();
            for (PayrollMonthSnapShotItem snapShotItem : snapShotItems) {
                Quotation stage = snapShotItem.getStage();
                Long stageId = stage.getId();
                String quotationNumber = stage.getQuotationNumber();
                String stageNumber = stage.getQNumber();
                String stageAlias = stage.getAlias();
                Project project = stage.getProject();
                Long projectId = null != project ? project.getId() : -1L;
                String projectReferenceId = null != project ? project.getReferenceId() : "n/a";
                String projectName = null != project ? project.getName() : "n/a";
                EInvoiceType stageDefaultInvoiceType = (EInvoiceType)MoreObjects.firstNonNull((Object)stage.getFinanceDefaultInvoiceType(), (Object)EInvoiceType.UNKNOWN);
                Boolean stageFlagSubContractor = (Boolean)MoreObjects.firstNonNull((Object)stage.getFinanceFlagSubcontractor(), (Object)false);
                Integer userPersonalNumber = user.getPersonalNumber();
                String userFullName = user.getFullName();
                String userCurrentLaborUnionContractName = EmployeeHelper.currentLaborUnionContractFailing((User)user, (YearMonth)yearMonth).getName();
                BigDecimal wageGeneratedOverall = snapShotItem.getAmountOverall();
                BigDecimal wagePaidOverall = snapShotItem.getAmountPaid();
                BigDecimal wagePaidThisMonth = snapShotItem.getAmountAvailableWithoutThisMonth().subtract(snapShotItem.getAmountPaid());
                stageWageItemsBuilder.add((Object)WagesExportStageWageItem.of((Long)stageId, (String)quotationNumber, (String)stageNumber, (String)stageAlias, (Long)projectId, (String)projectReferenceId, (String)projectName, (EInvoiceType)stageDefaultInvoiceType, (Boolean)stageFlagSubContractor, (Integer)userPersonalNumber, (String)userFullName, (String)userCurrentLaborUnionContractName, (BigDecimal)wageGeneratedOverall, (BigDecimal)wagePaidOverall, (BigDecimal)wagePaidThisMonth));
            }
        }
        return stageWageItemsBuilder.build();
    }

    @Nonnull
    private Pair<PayrollMonthPrintConfiguration, PayrollMonthReportInfo> printReport(@NonNull PayrollMonth payrollMonth) {
        if (payrollMonth == null) {
            throw new NullPointerException("payrollMonth is marked non-null but is null");
        }
        User user = payrollMonth.getUser();
        YearMonth accountingMonth = YearMonth.from(payrollMonth.getAccountingMonth());
        Integer personalNumber = user.getPersonalNumber();
        Currency currency = Currency.getInstance(Locale.GERMANY);
        String personalNumberAsString = null != personalNumber ? Integer.toString(personalNumber) : "";
        LocalDate referenceDate = accountingMonth.atDay(1);
        Optional wageGroupRateCandidate = EmployeeHelper.currentWageGroupRateNotFailing((User)user, (YearMonth)accountingMonth);
        if (wageGroupRateCandidate.isEmpty()) {
            throw new IllegalArgumentException("No WageGroup / Contract for Employee configured or found");
        }
        Optional managerCandidate = this.userHandler.currentManagerNotFailing(user, referenceDate);
        LaborUnionWageGroupRate laborUnionWageGroupRate = (LaborUnionWageGroupRate)wageGroupRateCandidate.get();
        LaborUnionWageGroup laborUnionWageGroup = laborUnionWageGroupRate.getLaborUnionWageGroup();
        LaborUnionContract laborUnionContractOfWageGroup = laborUnionWageGroup.getLaborUnionContract();
        BigDecimal effectiveWagePerHour = WageCalculatorHelper.effectiveWagePerHour((YearMonth)accountingMonth, (User)user);
        Long employeeContractId = laborUnionContractOfWageGroup.getId();
        String employeeContractName = laborUnionContractOfWageGroup.getName();
        Long employeeUserId = user.getId();
        String employeeFullName = user.getFullName();
        Long parentEmployeeUserId = managerCandidate.map(User::getId).orElse(0L);
        String parentEmployeeFullName = managerCandidate.map(User::getFullName).orElse("");
        User releaseUser = payrollMonth.getReleasedBy();
        Long releaseUserId = null == releaseUser ? null : releaseUser.getId();
        String releaseUserFullName = null == releaseUser ? null : releaseUser.getFullName();
        EPayrollMonthState payrollMonthState = payrollMonth.getPayrollMonthState();
        boolean released = EPayrollMonthState.RELEASED == payrollMonthState;
        LocalDateTime releasedOn = payrollMonth.getReleasedOn();
        List payrollMonthItems = (List)MoreObjects.firstNonNull((Object)payrollMonth.getPayrollMonthItems(), (Object)ImmutableList.of());
        Iterable auxiliaryWages = (Iterable)IterableHelper.stream((Iterable)payrollMonthItems).filter(item -> EPayrollItemClazz.AUXILIARY_WAGE == item.getPayrollItemClazz()).collect(ImmutableList.toImmutableList());
        Iterable incentiveWages = (Iterable)IterableHelper.stream((Iterable)payrollMonthItems).filter(EPayrollItemClazz.INCENTIVE_PREDICATE).collect(ImmutableList.toImmutableList());
        Iterable payrollMonthReportAuxiliaryPrintRows = this.printMapper.mapPayrollMonthReportAuxiliaryPrintRow(effectiveWagePerHour, auxiliaryWages);
        Iterable payrollMonthReportIncentivePrintRows = this.printMapper.mapPayrollMonthReportIncentivePrintRow(incentiveWages);
        Iterable squadLeaderAttendances = this.attendanceHandler.findSquadLeaderAttendances(payrollMonth);
        Iterable payrollMonthReportSquadLeaderPrintRows = this.printMapper.mapPayrollMonthReportSquadLeaderPrintRow(squadLeaderAttendances);
        PayrollMonthReportInfo payrollMonthReportInfo = PayrollMonthReportInfo.of((Long)parentEmployeeUserId, (String)parentEmployeeFullName, (String)parentEmployeeFullName, (Long)employeeUserId, (String)employeeFullName, (String)personalNumberAsString, (Long)employeeContractId, (String)employeeContractName, (Currency)currency, (YearMonth)accountingMonth, (boolean)released, (Long)releaseUserId, (String)releaseUserFullName, (LocalDateTime)releasedOn, (Iterable)payrollMonthReportIncentivePrintRows, (Iterable)payrollMonthReportAuxiliaryPrintRows, (Iterable)payrollMonthReportSquadLeaderPrintRows);
        PayrollMonthPrintConfiguration printConfiguration = PayrollMonthPrintConfiguration.of((Color)MeasurementStandardPrintConfiguration.DEFAULT_HEADER_BG_COLOR, (Iterable)ImmutableList.of(), (LocalDate)DateTimeHelper.today());
        return Pair.of((Object)printConfiguration, (Object)payrollMonthReportInfo);
    }

    @Nonnull
    private Pair<PayrollMonthPrintConfiguration, PayrollMonthAttendanceInfo> printAttendance(@NonNull PayrollMonth payrollMonth) {
        if (payrollMonth == null) {
            throw new NullPointerException("payrollMonth is marked non-null but is null");
        }
        User user = payrollMonth.getUser();
        YearMonth accountingMonth = YearMonth.from(payrollMonth.getAccountingMonth());
        Integer personalNumber = user.getPersonalNumber();
        Currency currency = Currency.getInstance(Locale.GERMANY);
        String personalNumberAsString = null != personalNumber ? Integer.toString(personalNumber) : "";
        Optional wageGroupRateCandidate = EmployeeHelper.currentWageGroupRateNotFailing((User)user, (YearMonth)accountingMonth);
        if (wageGroupRateCandidate.isEmpty()) {
            throw new IllegalArgumentException("No WageGroup / Contract for Employee configured or found");
        }
        LaborUnionContract laborUnionContract = payrollMonth.getLaborUnionContract();
        LaborUnionWageGroupRate laborUnionWageGroupRate = (LaborUnionWageGroupRate)wageGroupRateCandidate.get();
        LaborUnionWageGroup laborUnionWageGroup = laborUnionWageGroupRate.getLaborUnionWageGroup();
        LaborUnionContract laborUnionContractOfWageGroup = laborUnionWageGroup.getLaborUnionContract();
        Long employeeContractId = laborUnionContractOfWageGroup.getId();
        String employeeContractName = laborUnionContractOfWageGroup.getName();
        Long employeeUserId = user.getId();
        String employeeFullName = user.getFullName();
        User releaseUser = payrollMonth.getReleasedBy();
        Long releaseUserId = null == releaseUser ? null : releaseUser.getId();
        String releaseUserFullName = null == releaseUser ? null : releaseUser.getFullName();
        EPayrollMonthState payrollMonthState = payrollMonth.getPayrollMonthState();
        boolean released = EPayrollMonthState.RELEASED == payrollMonthState;
        LocalDateTime releasedOn = payrollMonth.getReleasedOn();
        String remarks = StringUtils.trimToEmpty((String)payrollMonth.getRemarks());
        EFederalState federalState = (EFederalState)MoreObjects.firstNonNull((Object)laborUnionContract.getFederalState(), (Object)EFederalState.ALL);
        Iterable bankingHolidays = this.bankingHolidayHandler.findByFederalStateAndYearMonthNotFailing(federalState, accountingMonth);
        Iterable payrollMonthAttendances = this.attendancePrintMapper.payrollMonthAttendanceRows(payrollMonth, bankingHolidays);
        PayrollMonthAttendanceInfo payrollMonthAttendanceInfo = PayrollMonthAttendanceInfo.of((Long)employeeUserId, (String)employeeFullName, (String)personalNumberAsString, (Long)employeeContractId, (String)employeeContractName, (Currency)currency, (YearMonth)accountingMonth, (boolean)released, (Long)releaseUserId, (String)releaseUserFullName, (LocalDateTime)releasedOn, (String)remarks, (Iterable)payrollMonthAttendances);
        PayrollMonthPrintConfiguration printConfiguration = PayrollMonthPrintConfiguration.of((Color)MeasurementStandardPrintConfiguration.DEFAULT_HEADER_BG_COLOR, (Iterable)ImmutableList.of(), (LocalDate)DateTimeHelper.today());
        return Pair.of((Object)printConfiguration, (Object)payrollMonthAttendanceInfo);
    }

    @Nonnull
    public Pair<String, byte[]> exportToSBS(@NonNull Iterable<Long> payrollMonthIdsRequested) {
        if (payrollMonthIdsRequested == null) {
            throw new NullPointerException("payrollMonthIdsRequested is marked non-null but is null");
        }
        Iterable payrollMonths = this.payrollMonthHandler.allByIds(payrollMonthIdsRequested);
        Map<Long, PayrollMonth> payrollMonthsExistingById = Streams.stream((Iterable)payrollMonths).collect(Collectors.toMap(PayrollMonth::getId, item -> item));
        Set<Long> payrollMonthIdsExisting = payrollMonthsExistingById.keySet();
        Sets.SetView payrollMonthIdsMissing = Sets.difference(payrollMonthIdsExisting, (Set)ImmutableSet.copyOf(payrollMonthIdsRequested));
        if (!payrollMonthIdsMissing.isEmpty()) {
            String idsMissingMsg = ID_JOINER.join((Iterable)payrollMonthIdsMissing);
            throw ResourceNotFoundException.of((String)PayrollMonth.class.getSimpleName(), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.ID), (String)idsMissingMsg);
        }
        byte[] buffer = this.sbsRoute.generate(payrollMonths);
        this.payrollMonthHandler.updateExportedFlags(payrollMonths);
        return Pair.of((Object)this.companyConfig.getSbsFileName(), (Object)buffer);
    }

    @Nonnull
    public PayrollMonthPageCommon page(@Nullable LocalDate referenceDate, @Nullable String costCenterCandidate, int page, int size, boolean includeStatistics, boolean includeInactive, boolean includeTemporary) {
        CostCenterFilter stringSearchFilter = CostCenterFilter.from((String)StringUtils.trimToEmpty((String)costCenterCandidate));
        Range yearMonthDateRange = null != referenceDate ? EYearMonthDateRange.EQ.from(referenceDate) : EYearMonthDateRange.ALL.from(DateTimeHelper.today());
        PayrollMonthFilter payrollMonthFilter = PayrollMonthFilter.of((int)page, (int)size, (boolean)includeInactive, (boolean)includeTemporary, (CostCenterFilter)stringSearchFilter, (Range)yearMonthDateRange);
        Page payrollMonths = this.payrollMonthHandler.all(payrollMonthFilter);
        ImmutableList.Builder businessUnitStatisticBuilder = ImmutableList.builder();
        ImmutableList.Builder laborUnionStatisticBuilder = ImmutableList.builder();
        if (includeStatistics && null != referenceDate) {
            YearMonth accountingMonth = YearMonth.from(referenceDate);
            Iterable usersPerCostCenterExpected = this.userHandler.usersPerCostCenter(referenceDate);
            Iterable releasedPayrollIdAndUserIdForMonth = this.payrollMonthHandler.releasedPayrollIdAndUserIdForMonth(referenceDate);
            ArrayListMultimap payrollMonthPerCostCenterAvailable = ArrayListMultimap.create();
            ArrayListMultimap payrollMonthPerContractAvailable = ArrayListMultimap.create();
            for (IAggregatedPayrollUser iAggregatedPayrollUser : releasedPayrollIdAndUserIdForMonth) {
                Long payrollMonthId = iAggregatedPayrollUser.getPayrollMonthId();
                Long contractId = iAggregatedPayrollUser.getContractId();
                String costCenter = iAggregatedPayrollUser.getCostCenter();
                Long userId = iAggregatedPayrollUser.getUserId();
                payrollMonthPerCostCenterAvailable.put((Object)costCenter, (Object)payrollMonthId);
                payrollMonthPerContractAvailable.put((Object)contractId, (Object)payrollMonthId);
            }
            Page laborUnionContracts = this.laborUnionContractHandler.page(Pageable.unpaged());
            ImmutableMap laborUnionContractsById = Maps.uniqueIndex((Iterable)laborUnionContracts, LaborUnionContract::getId);
            Page users = this.userHandler.page(Pageable.unpaged());
            ArrayListMultimap contractUsers = ArrayListMultimap.create();
            for (User user : users) {
                EmployeeHelper.currentLaborUnionContract((User)user, (YearMonth)accountingMonth).ifPresent(arg_0 -> PayrollMonthRouteImpl.lambda$page$27(user, (Multimap)contractUsers, arg_0));
            }
            Map contractCountExpected = MapsHelper.transformAsCountFromLong((Multimap)contractUsers);
            Map payrollMonthCountPerContract = MapsHelper.transformAsCountFromLong((Multimap)payrollMonthPerContractAvailable);
            Map payrollMonthCountPerCostCenter = MapsHelper.transformAsCountFromString((Multimap)payrollMonthPerCostCenterAvailable);
            contractCountExpected.forEach((arg_0, arg_1) -> PayrollMonthRouteImpl.lambda$page$28((Map)laborUnionContractsById, payrollMonthCountPerContract, laborUnionStatisticBuilder, arg_0, arg_1));
            for (IReportCountStringLong iReportCountStringLong : usersPerCostCenterExpected) {
                String costCenter = iReportCountStringLong.getLabel();
                Integer employeeAmountInCCExpected = iReportCountStringLong.getAmount().intValue();
                int payrollMonthAmountAvailableInBU = payrollMonthCountPerCostCenter.getOrDefault(costCenter, 0);
                BigDecimal percent = BigDecimal.valueOf(payrollMonthAmountAvailableInBU).divide(BigDecimal.valueOf(employeeAmountInCCExpected.intValue()), 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)).setScale(2, RoundingMode.HALF_UP);
                businessUnitStatisticBuilder.add((Object)PayrollMonthBusinessUnitStatistic.of((String)costCenter, (String)costCenter, (int)employeeAmountInCCExpected, (int)payrollMonthAmountAvailableInBU, (BigDecimal)percent));
            }
        }
        ImmutableList laborUnionStatistics = laborUnionStatisticBuilder.build();
        ImmutableList businessUnitStatistics = businessUnitStatisticBuilder.build();
        return this.payrollMonthMapper.map(payrollMonths, (Iterable)businessUnitStatistics, (Iterable)laborUnionStatistics);
    }

    @Nonnull
    public PayrollMonthCommon release(long id) {
        PayrollMonth payrollMonth = (PayrollMonth)this.payrollMonthHandler.byIdFailing(Long.valueOf(id));
        YearMonth accountingMonth = YearMonth.from(payrollMonth.getAccountingMonth());
        Iterable squadLeadersReferenced = (Iterable)payrollMonth.getAttendances().stream().map(Attendance::getSquadLeader).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        Iterable byUserAndYearMonthNotFailing = this.payrollMonthHandler.findByUserAndYearMonthNotFailing(squadLeadersReferenced, accountingMonth);
        Iterable stageWages = this.payrollMonthHelperService.determineStageWages(payrollMonth, EYearMonthDateRange.LE, false);
        PayrollStateChangeBucket payrollStateChangeBucket = PayrollStateChangeBucket.of((PayrollMonth)payrollMonth, (EPayrollMonthState)EPayrollMonthState.RELEASED, (Iterable)byUserAndYearMonthNotFailing, (Iterable)stageWages);
        this.validators.payrollMonthStateChange(payrollStateChangeBucket).validStateChange().validate();
        PayrollMonth payrollMonthReleased = this.payrollMonthHandler.updateStateToReleased(payrollMonth);
        PayrollMonthSnapShot payrollMonthSnapShot = this.createOrUpdateSnapShot(payrollMonthReleased, stageWages);
        Function fn = this.usersInReleasedStateFn(payrollMonth);
        return this.payrollMonthMapper.map(payrollMonthReleased, fn);
    }

    @Nonnull
    private PayrollMonthSnapShot createOrUpdateSnapShot(@NonNull PayrollMonth payrollMonth, @NonNull Iterable<StageWage> stageWages) {
        if (payrollMonth == null) {
            throw new NullPointerException("payrollMonth is marked non-null but is null");
        }
        if (stageWages == null) {
            throw new NullPointerException("stageWages is marked non-null but is null");
        }
        PayrollMonthSnapShot existingPayrollMonthSN = this.payrollMonthSnapShotHandler.findByPayrollMonth(payrollMonth).orElse(this.entityFactory.payrollMonthSnapShot(payrollMonth));
        User payrollMonthUser = payrollMonth.getUser();
        WageAccount wageAccount = payrollMonthUser.getWageAccount();
        BigDecimal wageAccountBalance = null != wageAccount ? wageAccount.getBalance() : BigDecimal.ZERO;
        BigDecimal wageAccountLimit = null != wageAccount ? wageAccount.getLimit() : BigDecimal.ZERO;
        existingPayrollMonthSN.setWageAccountBalance(wageAccountBalance);
        existingPayrollMonthSN.setWageAccountLimit(wageAccountLimit);
        List snapShotItems = (List)MoreObjects.firstNonNull((Object)existingPayrollMonthSN.getSnapShotItems(), (Object)Lists.newArrayList());
        snapShotItems.forEach(item -> item.setPayrollMonthSnapShot(null));
        snapShotItems.clear();
        ImmutableSet requiredStageIds = (ImmutableSet)Streams.stream(stageWages).map(StageWage::getStageId).collect(ImmutableSet.toImmutableSet());
        Iterable allStages = this.stageHandler.allByIds((Iterable)requiredStageIds);
        ImmutableMap stagesById = Maps.uniqueIndex((Iterable)allStages, Quotation::getId);
        stageWages.forEach(stageWage -> {
            Long stageId = stageWage.getStageId();
            Quotation quotation = (Quotation)stagesById.get((Object)stageId);
            PayrollMonthSnapShotItem snapShotItem = this.entityFactory.payrollMonthSnapShotItem();
            snapShotItem.setStage(quotation);
            snapShotItem.setAmountAvailable(stageWage.getAmountAvailableWithoutFuturePayments());
            snapShotItem.setAmountAvailableWithoutThisMonth(stageWage.getWageAvailableOverallWithoutThisMonthSum());
            snapShotItem.setAmountOverall(stageWage.getWageAvailableOverallSum());
            snapShotItem.setAmountPaid(stageWage.getPaidWagesSum());
            snapShotItems.add(snapShotItem);
        });
        snapShotItems.forEach(item -> item.setPayrollMonthSnapShot(existingPayrollMonthSN));
        return (PayrollMonthSnapShot)this.payrollMonthSnapShotHandler.update((EntityBase)existingPayrollMonthSN);
    }

    @Nonnull
    public PayrollMonthCommon unrelease(long id) {
        PayrollMonth payrollMonth = (PayrollMonth)this.payrollMonthHandler.byIdFailing(Long.valueOf(id));
        PayrollStateChangeBucket payrollStateChangeBucket = PayrollStateChangeBucket.of((PayrollMonth)payrollMonth, (EPayrollMonthState)EPayrollMonthState.UNRELEASED, (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of());
        this.validators.payrollMonthStateChange(payrollStateChangeBucket).validStateChange().validate();
        PayrollMonth payrollMonthUnreleased = this.payrollMonthHandler.updateStateToUnreleased(payrollMonth);
        Function fn = this.usersInReleasedStateFn(payrollMonthUnreleased);
        return this.payrollMonthMapper.map(payrollMonthUnreleased, fn);
    }

    @Nonnull
    public PayrollMonthCommon reset(long id) {
        PayrollMonth payrollMonth = (PayrollMonth)this.payrollMonthHandler.byIdFailing(Long.valueOf(id));
        this.checkPermissionToAccess(payrollMonth);
        this.validators.payrollMonthReset(PayrollMonthResetBucket.of((PayrollMonth)payrollMonth)).beforeReset().validate();
        PayrollMonth payrollMonthResetted = this.reset(payrollMonth, true);
        Function fn = this.usersInReleasedStateFn(payrollMonthResetted);
        return this.payrollMonthMapper.map(payrollMonthResetted, fn);
    }

    @Nonnull
    private PayrollMonth reset(@NonNull PayrollMonth payrollMonth, boolean force) {
        if (payrollMonth == null) {
            throw new NullPointerException("payrollMonth is marked non-null but is null");
        }
        User user = payrollMonth.getUser();
        YearMonth accountingMonth = YearMonth.from(payrollMonth.getAccountingMonth());
        LaborUnionContract laborUnionContract = EmployeeHelper.currentLaborUnionContractFailing((User)user, (YearMonth)accountingMonth);
        Iterable nonWorkingDays = PayrollMonthRouteImpl.determineNonWorkingDays((YearMonth)accountingMonth, (User)user);
        List attendancesExisting = (List)MoreObjects.firstNonNull((Object)payrollMonth.getAttendances(), (Object)ImmutableList.of());
        ImmutableList attendancesNew = ImmutableList.copyOf((Iterable)this.createMissing(EAttendanceOrigin.PAYROLL_MONTH, user, accountingMonth, laborUnionContract, nonWorkingDays));
        boolean resetNeeded = this.checkDiff((Iterable)attendancesExisting, (List)attendancesNew);
        if (force || resetNeeded) {
            payrollMonth.setPayrollMonthState(EPayrollMonthState.TEMPORARY);
            for (Attendance attendance : attendancesExisting) {
                attendance.setPayrollMonth(null);
                this.attendanceHandler.delete((EntityBase)attendance);
            }
            List payrollMonthItems = (List)MoreObjects.firstNonNull((Object)payrollMonth.getPayrollMonthItems(), (Object)Lists.newArrayList());
            BigDecimal wageAccountTransfer = payrollMonthItems.stream().filter(item -> EPayrollItemClazz.WAGE_ACCOUNT == item.getPayrollItemClazz()).map(PayrollMonthItem::getValue).reduce(BigDecimal.ZERO, BigDecimal::add);
            WageAccount wageAccount = user.getWageAccount();
            BigDecimal balanceCurrent = (BigDecimal)MoreObjects.firstNonNull((Object)wageAccount.getBalance(), (Object)BigDecimal.ZERO);
            BigDecimal balanceNew = balanceCurrent.add(wageAccountTransfer);
            wageAccount.setBalance(balanceNew);
            this.wageAccountHandler.update((EntityBase)wageAccount);
            for (PayrollMonthItem payrollMonthItem : payrollMonthItems) {
                payrollMonthItem.setPayrollMonth(null);
                this.payrollMonthItemHandler.delete((EntityBase)payrollMonthItem);
            }
            payrollMonth.getAttendances().clear();
            payrollMonthItems.clear();
            for (Attendance attendance : attendancesNew) {
                attendance.setPayrollMonth(payrollMonth);
            }
            payrollMonth.getAttendances().addAll(attendancesNew);
            return (PayrollMonth)this.payrollMonthHandler.update((EntityBase)payrollMonth);
        }
        return payrollMonth;
    }

    @Transactional
    @Nonnull
    public Iterable<Attendance> refreshBankingHolidays() {
        YearMonth accountingMonth = YearMonth.now().minusMonths(1L);
        Iterable affectedPayrollMonths = this.payrollMonthHandler.findByAccountingMonthGreaterThanEqual(accountingMonth);
        ImmutableList.Builder attendancesChangedBuilder = ImmutableList.builder();
        for (PayrollMonth payrollMonth : affectedPayrollMonths) {
            Iterable attendances = this.refreshBankingHoliday(payrollMonth);
            attendancesChangedBuilder.addAll(attendances);
        }
        return attendancesChangedBuilder.build();
    }

    @Nonnull
    private Iterable<Attendance> refreshBankingHoliday(@NonNull PayrollMonth payrollMonth) {
        if (payrollMonth == null) {
            throw new NullPointerException("payrollMonth is marked non-null but is null");
        }
        User user = payrollMonth.getUser();
        YearMonth accountingMonth = YearMonth.from(payrollMonth.getAccountingMonth());
        LaborUnionContract laborUnionContract = EmployeeHelper.currentLaborUnionContractFailing((User)user, (YearMonth)accountingMonth);
        Iterable nonWorkingDays = PayrollMonthRouteImpl.determineNonWorkingDays((YearMonth)accountingMonth, (User)user);
        List attendancesExisting = (List)MoreObjects.firstNonNull((Object)payrollMonth.getAttendances(), (Object)ImmutableList.of());
        ImmutableList attendancesShould = ImmutableList.copyOf((Iterable)this.createMissing(EAttendanceOrigin.PAYROLL_MONTH, user, accountingMonth, laborUnionContract, nonWorkingDays));
        ImmutableMap existingByDate = Maps.uniqueIndex((Iterable)attendancesExisting, Attendance::getDate);
        ImmutableMap shouldByDate = Maps.uniqueIndex((Iterable)attendancesShould, Attendance::getDate);
        ImmutableList.Builder attendancesChangedBuilder = ImmutableList.builder();
        ImmutableSet entriesExisting = existingByDate.entrySet();
        for (Map.Entry entryExisting : entriesExisting) {
            LocalDate date = (LocalDate)entryExisting.getKey();
            Attendance attendanceExisting = (Attendance)entryExisting.getValue();
            Attendance attendanceShould = (Attendance)shouldByDate.get((Object)date);
            if (null == attendanceShould || Objects.equals(attendanceExisting.getDayType(), attendanceShould.getDayType())) continue;
            attendanceExisting.setDayType(attendanceShould.getDayType());
            attendancesChangedBuilder.add((Object)attendanceExisting);
        }
        ImmutableList attendancesChanged = attendancesChangedBuilder.build();
        return this.attendanceHandler.update((Iterable)attendancesChanged);
    }

    @Nonnull
    public AttendanceCommon attendanceByDay(@NonNull EAttendanceOrigin origin, long userId, @NonNull LocalDate date) {
        if (origin == null) {
            throw new NullPointerException("origin is marked non-null but is null");
        }
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        YearMonth yearMonth = YearMonth.from(date);
        PayrollMonth payrollMonth = this.getOrCreatePayrollMonth(origin, userId, yearMonth);
        List attendances = payrollMonth.getAttendances();
        ImmutableMap attendanceByDay = Maps.uniqueIndex((Iterable)attendances, Attendance::getDate);
        Attendance attendance = (Attendance)attendanceByDay.get((Object)date);
        return this.mapper.map(attendance, this.usersInReleasedStateFn(payrollMonth), BAD_WEATHER_EDITING_DISABLED_FN);
    }

    @Nonnull
    public AttendanceCommon resetAttendance(@NonNull EAttendanceOrigin origin, long attendanceId) {
        if (origin == null) {
            throw new NullPointerException("origin is marked non-null but is null");
        }
        Attendance attendance = (Attendance)this.attendanceHandler.byIdFailing(Long.valueOf(attendanceId));
        AttendanceResetBucket attendanceResetBucket = AttendanceResetBucket.of((EAttendanceOrigin)origin, (Attendance)attendance);
        this.validators.attendanceReset(attendanceResetBucket).beforeReset().validate();
        PayrollMonth payrollMonth = attendance.getPayrollMonth();
        User user = payrollMonth.getUser();
        YearMonth accountingMonth = YearMonth.from(payrollMonth.getAccountingMonth());
        Iterable notWorkingDays = PayrollMonthRouteImpl.determineNonWorkingDays((YearMonth)accountingMonth, (User)user);
        LocalDate referenceDate = attendance.getDate();
        boolean nonWorkingDay = Iterables.contains((Iterable)notWorkingDays, (Object)referenceDate);
        Attendance attendanceReset = this.attendanceGenerator.reset(attendance, nonWorkingDay);
        Attendance attendanceUpdated = (Attendance)this.attendanceHandler.update((EntityBase)attendanceReset);
        return this.mapper.map(attendanceUpdated, this.usersInReleasedStateFn(payrollMonth), BAD_WEATHER_EDITING_DISABLED_FN);
    }

    @Nonnull
    private PayrollMonthUpdateBucket bucket(long id, @NonNull PayrollMonthUpdateRequest request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        PayrollMonth payrollMonth = (PayrollMonth)this.payrollMonthHandler.byIdFailing(Long.valueOf(id));
        YearMonth accountingMonth = YearMonth.from(payrollMonth.getAccountingMonth());
        User user = payrollMonth.getUser();
        WageAccount wageAccount = user.getWageAccount();
        List attendanceUpdateItems = (List)MoreObjects.firstNonNull((Object)request.getAttendances(), (Object)ImmutableList.of());
        Iterable attendanceUpdateBuckets = this.buckets(EAttendanceOrigin.PAYROLL_MONTH, attendanceUpdateItems);
        List incentiveUpdateItems = (List)MoreObjects.firstNonNull((Object)request.getIncentivePayrollItems(), (Object)ImmutableList.of());
        Iterable incentiveItemsUpdateBuckets = this.payrollItemBuckets(payrollMonth, (Iterable)incentiveUpdateItems, EPayrollItemClazz.INCENTIVE_PAYMENT);
        List auxiliaryUpdateItems = (List)MoreObjects.firstNonNull((Object)request.getAuxiliaryWagePayrollItems(), (Object)ImmutableList.of());
        Iterable auxiliaryItemsUpdateBuckets = this.payrollItemBuckets(payrollMonth, (Iterable)auxiliaryUpdateItems, EPayrollItemClazz.AUXILIARY_WAGE);
        List wageAccountUpdateItems = (List)MoreObjects.firstNonNull((Object)request.getWageAccountPayrollItems(), (Object)ImmutableList.of());
        Iterable wageAccountItemsUpdateBuckets = this.payrollItemBuckets(payrollMonth, (Iterable)wageAccountUpdateItems, EPayrollItemClazz.WAGE_ACCOUNT);
        String costCenter = EmployeeHelper.currentCostCenterFailing((User)user, (YearMonth)accountingMonth);
        LaborUnionContract laborUnionContract = EmployeeHelper.currentLaborUnionContractFailing((User)user, (YearMonth)accountingMonth);
        Iterable incentiveQuotationNumbers = PayrollMonthHelper.incentiveQuotationNumbers((PayrollMonthUpdateRequest)request);
        Iterable availableQuotationNumbers = this.payrollMonthHelperService.wageRelevantQuotationNumbers(payrollMonth, EYearMonthDateRange.LE);
        EPayrollMonthState payrollMonthState = (EPayrollMonthState)MoreObjects.firstNonNull((Object)payrollMonth.getPayrollMonthState(), (Object)EPayrollMonthState.UNKNOWN);
        EPayrollMonthState payrollMonthStateNew = EPayrollMonthState.TEMPORARY == payrollMonthState ? EPayrollMonthState.UNRELEASED : payrollMonthState;
        Iterable incentiveWagesAssignedToPayroll = this.payrollMonthItemHandler.incentiveWagesAssignedToPayroll(user, accountingMonth);
        return PayrollMonthUpdateBucket.of((PayrollMonth)payrollMonth, (WageAccount)wageAccount, (PayrollMonthUpdateItem)request, (Iterable)attendanceUpdateBuckets, (Iterable)incentiveItemsUpdateBuckets, (Iterable)auxiliaryItemsUpdateBuckets, (Iterable)wageAccountItemsUpdateBuckets, (String)costCenter, (LaborUnionContract)laborUnionContract, (Iterable)incentiveQuotationNumbers, (Iterable)availableQuotationNumbers, (EPayrollMonthState)payrollMonthStateNew, (Iterable)incentiveWagesAssignedToPayroll);
    }

    @Nonnull
    public PayrollMonthCommon byUserIdAndYearAndMonth(@NonNull EAttendanceOrigin origin, long userId, int year, int month) {
        if (origin == null) {
            throw new NullPointerException("origin is marked non-null but is null");
        }
        PayrollMonth payrollMonth = this.getOrCreatePayrollMonth(origin, userId, year, month);
        this.checkPermissionToAccess(payrollMonth);
        Function fn = this.usersInReleasedStateFn(payrollMonth);
        return this.payrollMonthMapper.map(payrollMonth, fn);
    }

    @Nonnull
    private PayrollMonth getOrCreatePayrollMonth(@NonNull EAttendanceOrigin origin, long userId, int year, int month) {
        if (origin == null) {
            throw new NullPointerException("origin is marked non-null but is null");
        }
        YearMonth yearMonth = PayrollMonthRouteImpl.yearMonth((int)year, (int)month);
        return this.getOrCreatePayrollMonth(origin, userId, yearMonth);
    }

    @Nonnull
    private PayrollMonth getOrCreatePayrollMonth(@NonNull EAttendanceOrigin origin, long userId, @NonNull YearMonth accountingMonth) {
        if (origin == null) {
            throw new NullPointerException("origin is marked non-null but is null");
        }
        if (accountingMonth == null) {
            throw new NullPointerException("accountingMonth is marked non-null but is null");
        }
        User user = (User)this.userHandler.byIdFailing(Long.valueOf(userId));
        String costCenter = EmployeeHelper.currentCostCenterFailing((User)user, (YearMonth)accountingMonth);
        LaborUnionContract laborUnionContract = EmployeeHelper.currentLaborUnionContractFailing((User)user, (YearMonth)accountingMonth);
        Iterable notWorkingDays = PayrollMonthRouteImpl.determineNonWorkingDays((YearMonth)accountingMonth, (User)user);
        User manager = user.getManager();
        EPayrollMonthState initialState = EAttendanceOrigin.BAD_WEATHER == origin ? EPayrollMonthState.UNRELEASED : EPayrollMonthState.TEMPORARY;
        Optional payrollMonthCandidate = this.payrollMonthHandler.findByUserAndYearMonthNotFailing(user, accountingMonth);
        if (payrollMonthCandidate.isPresent()) {
            PayrollMonth payrollMonth = (PayrollMonth)payrollMonthCandidate.get();
            EPayrollMonthState payrollMonthState = payrollMonth.getPayrollMonthState();
            if (EPayrollMonthState.TEMPORARY == payrollMonthState) {
                return this.reset(payrollMonth, false);
            }
            return payrollMonth;
        }
        Iterable attendances = this.createMissing(origin, user, accountingMonth, laborUnionContract, notWorkingDays);
        PayrollMonth payrollMonthCreated = this.entityFactory.payrollMonth(user, manager, accountingMonth, laborUnionContract, costCenter, initialState, attendances);
        return (PayrollMonth)this.payrollMonthHandler.update((EntityBase)payrollMonthCreated);
    }

    private static Iterable<LocalDate> determineNonWorkingDays(YearMonth accountingMonth, User user) {
        EmployeeContract employeeContract = EmployeeHelper.currentEmployeeContractFailing((User)user, (YearMonth)accountingMonth);
        LocalDate validBegin = employeeContract.getValidBegin();
        LocalDate validEnd = employeeContract.getValidEnd();
        Iterable notWorkingDays = PayrollMonthRouteImpl.notWorkingDays((YearMonth)accountingMonth, (LocalDate)validBegin, (LocalDate)validEnd);
        return notWorkingDays;
    }

    @Nonnull
    @VisibleForTesting
    static Iterable<LocalDate> notWorkingDays(@NonNull YearMonth yearMonth, @NonNull LocalDate validBegin, @NonNull LocalDate validEnd) {
        if (yearMonth == null) {
            throw new NullPointerException("yearMonth is marked non-null but is null");
        }
        if (validBegin == null) {
            throw new NullPointerException("validBegin is marked non-null but is null");
        }
        if (validEnd == null) {
            throw new NullPointerException("validEnd is marked non-null but is null");
        }
        Iterable neededDates = DateRange.from((YearMonth)yearMonth).asList();
        Range validRange = Range.closed((Comparable)validBegin, (Comparable)validEnd);
        ImmutableSet.Builder datesNotWorking = ImmutableSet.builder();
        for (LocalDate neededDate : neededDates) {
            if (validRange.contains((Comparable)neededDate)) continue;
            datesNotWorking.add((Object)neededDate);
        }
        return datesNotWorking.build();
    }

    @Nonnull
    public PayrollMonthPageCommon ensureAttendance(@NonNull EAttendanceOrigin origin, int year, int month) {
        if (origin == null) {
            throw new NullPointerException("origin is marked non-null but is null");
        }
        YearMonth accountingMonth = PayrollMonthRouteImpl.yearMonth((int)year, (int)month);
        Range closed = PayrollMonthRouteImpl.dateRange((YearMonth)accountingMonth);
        Page all = this.payrollMonthHandler.all(PayrollMonthFilter.of((int)0, (int)100, (boolean)false, (boolean)false, (CostCenterFilter)CostCenterFilter.EMPTY, (Range)closed));
        ImmutableList.Builder payrollMonthBuilder = ImmutableList.builder();
        for (PayrollMonth payrollMonth : all) {
            User user;
            Optional laborUnionContractCand;
            List attendancesExisting = (List)MoreObjects.firstNonNull((Object)payrollMonth.getAttendances(), (Object)ImmutableList.of());
            if (!attendancesExisting.isEmpty() || !(laborUnionContractCand = EmployeeHelper.currentLaborUnionContract((User)(user = payrollMonth.getUser()), (LocalDate)accountingMonth.atDay(1))).isPresent()) continue;
            Iterable notWorkingDays = PayrollMonthRouteImpl.determineNonWorkingDays((YearMonth)accountingMonth, (User)user);
            LaborUnionContract laborUnionContract = (LaborUnionContract)laborUnionContractCand.get();
            Iterable attendances = this.createMissing(origin, user, accountingMonth, laborUnionContract, notWorkingDays);
            payrollMonth.setLaborUnionContract(laborUnionContract);
            payrollMonth.setAttendances((List)Lists.newArrayList());
            for (Attendance attendance : attendances) {
                attendance.setPayrollMonth(payrollMonth);
                payrollMonth.getAttendances().add(attendance);
            }
            payrollMonthBuilder.add((Object)((PayrollMonth)this.payrollMonthHandler.update((EntityBase)payrollMonth)));
        }
        ImmutableList build = payrollMonthBuilder.build();
        return this.payrollMonthMapper.map((Page)new PageImpl((List)build, (Pageable)PageRequest.of((int)0, (int)build.size()), (long)build.size()));
    }

    public void onApplicationEvent(@NonNull BankingHolidayChangeMessage changeMessage) {
        if (changeMessage == null) {
            throw new NullPointerException("changeMessage is marked non-null but is null");
        }
        this.refreshBankingHolidays();
    }

    @Nonnull
    private static Range<LocalDate> dateRange(YearMonth yearMonth) {
        return Range.closed((Comparable)yearMonth.atDay(1), (Comparable)yearMonth.atEndOfMonth());
    }

    @Nonnull
    private Iterable<Attendance> createMissing(@NonNull EAttendanceOrigin origin, @NonNull User user, @NonNull YearMonth yearMonth, @NonNull LaborUnionContract laborUnionContract, @NonNull Iterable<LocalDate> notWorkingDays) {
        if (origin == null) {
            throw new NullPointerException("origin is marked non-null but is null");
        }
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (yearMonth == null) {
            throw new NullPointerException("yearMonth is marked non-null but is null");
        }
        if (laborUnionContract == null) {
            throw new NullPointerException("laborUnionContract is marked non-null but is null");
        }
        if (notWorkingDays == null) {
            throw new NullPointerException("notWorkingDays is marked non-null but is null");
        }
        Iterable neededDates = DateRange.from((YearMonth)yearMonth).asList();
        Iterable attendancesCreated = (Iterable)Streams.stream((Iterable)neededDates).map(arg_0 -> ((EntityFactory)this.entityFactory).attendance(arg_0)).collect(ImmutableList.toImmutableList());
        return this.attendanceGenerator.apply(origin, user, yearMonth, laborUnionContract, attendancesCreated, notWorkingDays);
    }

    @Nonnull
    private static YearMonth yearMonth(int year, int month) {
        Range yearRange = Range.closed((Comparable)Integer.valueOf(2000), (Comparable)Integer.valueOf(DateTimeHelper.today().getYear() + 1));
        if (!yearRange.contains((Comparable)Integer.valueOf(year))) {
            SimpleFieldName fieldName = FieldNamesFactory.simpleFieldName((EField)EField.YEAR);
            throw PayrollMonthRouteImpl.getValueRangeException((Range)yearRange, (FieldName)fieldName, (int)year);
        }
        if (!MONTH_RANGE.contains((Comparable)Integer.valueOf(month))) {
            SimpleFieldName fieldName = FieldNamesFactory.simpleFieldName((EField)EField.MONTH);
            throw PayrollMonthRouteImpl.getValueRangeException((Range)MONTH_RANGE, (FieldName)fieldName, (int)month);
        }
        return YearMonth.of(year, month);
    }

    @Nonnull
    private static ValueRangeException getValueRangeException(@NonNull Range<Integer> referenceRange, @NonNull FieldName fieldName, int value) {
        if (referenceRange == null) {
            throw new NullPointerException("referenceRange is marked non-null but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        String fieldPath = fieldName.path();
        String messageText = String.format("Field: %s has value: %s and is supposed to be in range: %s", fieldPath, value, referenceRange);
        Message message = Message.of((EMessageKey)EMessageKey.RANGE, (List)ImmutableList.of((Object)fieldPath, (Object)value, referenceRange, (Object)messageText));
        RequestValidationException.Detail detail = RequestValidationException.Detail.of((FieldName)fieldName, (Object)value, (String)messageText, (Message)message, (List)ImmutableList.of((Object)String.valueOf(referenceRange.lowerEndpoint()), (Object)String.valueOf(referenceRange.upperEndpoint())));
        return new ValueRangeException(messageText, (List)ImmutableList.of((Object)detail));
    }

    @Nonnull
    private Iterable<AttendanceUpdateBucket> buckets(@NonNull EAttendanceOrigin origin, @NonNull List<AttendanceUpdateItem> attendanceUpdateItems) {
        Iterable attendances;
        Map<Long, Attendance> attendancesExistingById;
        Set<Long> attendanceIdExisting;
        if (origin == null) {
            throw new NullPointerException("origin is marked non-null but is null");
        }
        if (attendanceUpdateItems == null) {
            throw new NullPointerException("attendanceUpdateItems is marked non-null but is null");
        }
        Map<Long, AttendanceUpdateItem> updateItemsById = attendanceUpdateItems.stream().collect(Collectors.toMap(AttendanceModificationItem::getId, item -> item));
        Set<Long> attendanceIdInRequest = updateItemsById.keySet();
        Sets.SetView idsMissing = Sets.difference(attendanceIdInRequest, attendanceIdExisting = (attendancesExistingById = Streams.stream((Iterable)(attendances = this.attendanceHandler.allByIds(attendanceIdInRequest))).collect(Collectors.toMap(Attendance::getId, item -> item))).keySet());
        if (!idsMissing.isEmpty()) {
            String idsMissingMsg = ID_JOINER.join((Iterable)idsMissing);
            throw ResourceNotFoundException.of((String)Attendance.class.getSimpleName(), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.ID), (String)idsMissingMsg);
        }
        Iterable squadLeaderIds = (Iterable)attendanceUpdateItems.stream().map(AttendanceModificationItem::getSquadLeaderId).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        Iterable users = this.userHandler.byIdsFailing(squadLeaderIds);
        Map userById = MapsHelper.mapFirst((Iterable)users, User::getId);
        ImmutableList.Builder attendanceUpdateBucketsBuilder = ImmutableList.builder();
        for (AttendanceUpdateItem attendanceUpdateItem : attendanceUpdateItems) {
            Long attendanceId = attendanceUpdateItem.getId();
            Long squadLeaderId = attendanceUpdateItem.getSquadLeaderId();
            Attendance attendance = attendancesExistingById.get(attendanceId);
            User user = null != squadLeaderId ? (User)userById.get(squadLeaderId) : null;
            String employeeDayTypeCandidate = StringUtils.trimToEmpty((String)attendanceUpdateItem.getAttendanceDayType());
            EAttendanceDayType employeeDayType = EAttendanceDayType.lookup((String)employeeDayTypeCandidate, (EAttendanceDayType)EAttendanceDayType.UNKNOWN);
            attendanceUpdateBucketsBuilder.add((Object)AttendanceUpdateBucket.of((EAttendanceOrigin)origin, (AttendanceUpdateItem)attendanceUpdateItem, (Attendance)attendance, (User)user, (EAttendanceDayType)employeeDayType));
        }
        return attendanceUpdateBucketsBuilder.build();
    }

    @Nonnull
    private Iterable<PayrollMonthItemUpdateBucket> payrollItemBuckets(@NonNull PayrollMonth payrollMonth, @NonNull Iterable<PayrollItemUpdateItem> payrollItemUpdateItems, @NonNull EPayrollItemClazz payrollItemClazz) {
        if (payrollMonth == null) {
            throw new NullPointerException("payrollMonth is marked non-null but is null");
        }
        if (payrollItemUpdateItems == null) {
            throw new NullPointerException("payrollItemUpdateItems is marked non-null but is null");
        }
        if (payrollItemClazz == null) {
            throw new NullPointerException("payrollItemClazz is marked non-null but is null");
        }
        User sender = payrollMonth.getUser();
        Map<Long, PayrollItemUpdateItem> updateItemsById = Streams.stream(payrollItemUpdateItems).filter(item -> null != item.getId()).collect(Collectors.toMap(PayrollItemModificationItem::getId, item -> item));
        Set<Long> payrollItemIdsInRequest = updateItemsById.keySet();
        Set payrollItemTypeIdsInRequest = (Set)Streams.stream(payrollItemUpdateItems).map(PayrollItemModificationItem::getPayrollItemTypeId).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        Set assignedUserIdsInRequest = (Set)Streams.stream(payrollItemUpdateItems).map(PayrollItemModificationItem::getRecipientUserId).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        Map payrollMonthItemsExistingById = this.fetchPayrollItems(payrollItemIdsInRequest);
        Map payrollItemTypesExistingById = this.fetchPayrollItemTypes(payrollItemTypeIdsInRequest);
        Map usersExistingById = this.fetchUsers(assignedUserIdsInRequest);
        ImmutableList.Builder payrollMonthItemUpdateBucketBuilder = ImmutableList.builder();
        for (PayrollItemUpdateItem payrollItemUpdateItem : payrollItemUpdateItems) {
            Project project;
            Quotation stage;
            User recipient;
            PayrollItemType payrollItemType;
            Long id = payrollItemUpdateItem.getId();
            Long payrollItemTypeId = payrollItemUpdateItem.getPayrollItemTypeId();
            PayrollMonthItem payrollMonthItem = null != id ? (PayrollMonthItem)payrollMonthItemsExistingById.get(id) : null;
            PayrollItemType payrollItemType2 = payrollItemType = null != payrollItemTypeId ? (PayrollItemType)payrollItemTypesExistingById.get(payrollItemTypeId) : null;
            if (EPayrollItemClazz.INCENTIVE_PAYMENT == payrollItemClazz) {
                Long assignedUserId = payrollItemUpdateItem.getRecipientUserId();
                recipient = null != assignedUserId ? (User)usersExistingById.get(assignedUserId) : null;
                String quotationNumber = payrollItemUpdateItem.getQuotationNumber();
                stage = null != quotationNumber ? this.stageHandler.firstByQuotationNumberFailing(quotationNumber) : null;
                project = null;
            } else if (EPayrollItemClazz.WAGE_ACCOUNT == payrollItemClazz) {
                recipient = payrollMonth.getUser();
                String quotationNumber = payrollItemUpdateItem.getQuotationNumber();
                stage = StringUtils.isNotBlank((CharSequence)quotationNumber) ? this.stageHandler.firstByQuotationNumberFailing(quotationNumber) : null;
                project = null;
            } else {
                recipient = payrollMonth.getUser();
                stage = null;
                Long projectId = payrollItemUpdateItem.getProjectId();
                project = null != projectId ? (Project)this.projectHandler.byIdFailing(projectId) : null;
            }
            payrollMonthItemUpdateBucketBuilder.add((Object)PayrollMonthItemUpdateBucket.of((EPayrollItemClazz)payrollItemClazz, (PayrollItemUpdateItem)payrollItemUpdateItem, (PayrollMonthItem)payrollMonthItem, (PayrollItemType)payrollItemType, (Quotation)stage, (User)recipient, (User)sender, (Project)project));
        }
        return payrollMonthItemUpdateBucketBuilder.build();
    }

    @Nonnull
    private Map<Long, User> fetchUsers(@NonNull Set<Long> assignedUserIdsInRequest) {
        if (assignedUserIdsInRequest == null) {
            throw new NullPointerException("assignedUserIdsInRequest is marked non-null but is null");
        }
        Iterable users = this.userHandler.allByIds(assignedUserIdsInRequest);
        Map<Long, User> usersExistingById = Streams.stream((Iterable)users).collect(Collectors.toMap(User::getId, item -> item));
        Set<Long> userIdsExisting = usersExistingById.keySet();
        Sets.SetView userIdsMissing = Sets.difference(userIdsExisting, assignedUserIdsInRequest);
        if (!userIdsMissing.isEmpty()) {
            String idsMissingMsg = ID_JOINER.join((Iterable)userIdsMissing);
            throw ResourceNotFoundException.of((String)User.class.getSimpleName(), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.ID), (String)idsMissingMsg);
        }
        return ImmutableMap.copyOf(usersExistingById);
    }

    @Nonnull
    private Map<Long, PayrollMonthItem> fetchPayrollItems(@NonNull Set<Long> payrollItemIdsInRequest) {
        if (payrollItemIdsInRequest == null) {
            throw new NullPointerException("payrollItemIdsInRequest is marked non-null but is null");
        }
        Iterable payrollMonthItems = this.payrollMonthItemHandler.allByIds(payrollItemIdsInRequest);
        Map<Long, PayrollMonthItem> payrollMonthItemsExistingById = Streams.stream((Iterable)payrollMonthItems).collect(Collectors.toMap(PayrollMonthItem::getId, item -> item));
        Set<Long> payrollItemIdsExisting = payrollMonthItemsExistingById.keySet();
        Sets.SetView idsMissing = Sets.difference(payrollItemIdsInRequest, payrollItemIdsExisting);
        if (!idsMissing.isEmpty()) {
            String idsMissingMsg = ID_JOINER.join((Iterable)idsMissing);
            throw ResourceNotFoundException.of((String)PayrollMonthItem.class.getSimpleName(), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.ID), (String)idsMissingMsg);
        }
        return ImmutableMap.copyOf(payrollMonthItemsExistingById);
    }

    @Nonnull
    private Map<Long, PayrollItemType> fetchPayrollItemTypes(@NonNull Set<Long> payrollItemTypeIdsInRequest) {
        if (payrollItemTypeIdsInRequest == null) {
            throw new NullPointerException("payrollItemTypeIdsInRequest is marked non-null but is null");
        }
        Iterable payrollItemTypes = this.payrollItemTypeHandler.allByIds(payrollItemTypeIdsInRequest);
        Map<Long, PayrollItemType> payrollItemTypesExistingById = Streams.stream((Iterable)payrollItemTypes).collect(Collectors.toMap(PayrollItemType::getId, item -> item));
        Set<Long> payrollItemTypesIdsExisting = payrollItemTypesExistingById.keySet();
        Sets.SetView payrollItemTypeIdsMissing = Sets.difference(payrollItemTypesIdsExisting, payrollItemTypeIdsInRequest);
        if (!payrollItemTypeIdsMissing.isEmpty()) {
            String idsMissingMsg = ID_JOINER.join((Iterable)payrollItemTypeIdsMissing);
            throw ResourceNotFoundException.of((String)PayrollItemType.class.getSimpleName(), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.ID), (String)idsMissingMsg);
        }
        return ImmutableMap.copyOf(payrollItemTypesExistingById);
    }

    private void checkPermissionToAccess(@NonNull PayrollMonth payrollMonth) {
        boolean isAllowed;
        if (payrollMonth == null) {
            throw new NullPointerException("payrollMonth is marked non-null but is null");
        }
        User authenticatedUser = this.userService.authenticatedUser();
        User payrollMonthUser = payrollMonth.getUser();
        boolean isSameUser = Objects.equals(authenticatedUser, payrollMonthUser);
        boolean hasPermission = this.userService.hasPrivilege(EPrivilege.ACCESS_USERS_ALL);
        boolean bl = isAllowed = isSameUser || hasPermission;
        if (!isAllowed) {
            Long id = payrollMonth.getId();
            String message = String.format("User is not allowed to open Payroll Month (Id: %s)", id);
            throw new EntityAccessRestrictionException(message, EEntityClass.PAYROLL_MONTH, id, Long.toString(id));
        }
    }

    private boolean checkDiff(@NonNull Iterable<Attendance> attendancesLeft, @NonNull List<Attendance> attendancesRight) {
        if (attendancesLeft == null) {
            throw new NullPointerException("attendancesLeft is marked non-null but is null");
        }
        if (attendancesRight == null) {
            throw new NullPointerException("attendancesRight is marked non-null but is null");
        }
        ImmutableMap leftByDate = Maps.uniqueIndex(attendancesLeft, Attendance::getDate);
        ImmutableMap rightByDate = Maps.uniqueIndex(attendancesRight, Attendance::getDate);
        ImmutableSet entriesLeft = leftByDate.entrySet();
        for (Map.Entry entryLeft : entriesLeft) {
            LocalDate date = (LocalDate)entryLeft.getKey();
            Attendance attendanceLeft = (Attendance)entryLeft.getValue();
            Attendance attendanceRight = (Attendance)rightByDate.get((Object)date);
            if (null != attendanceRight && Objects.equals(attendanceLeft.getDayType(), attendanceRight.getDayType())) continue;
            return true;
        }
        return false;
    }

    public PayrollMonthRouteImpl(CompanyConfig companyConfig, EntityFactory entityFactory, AttendanceHandler attendanceHandler, AttendanceMapper mapper, BankingHolidayHandler bankingHolidayHandler, LaborUnionContractHandler laborUnionContractHandler, PayrollItemTypeHandler payrollItemTypeHandler, PayrollMonthHandler payrollMonthHandler, PayrollMonthItemHandler payrollMonthItemHandler, PayrollMonthSnapShotHandler payrollMonthSnapShotHandler, PayrollMonthSnapShotXlsExportService payrollMonthSnapShotXlsExportService, ProjectWageReportXlsExportService projectWageReportXlsExportService, StageHandler stageHandler, WageAccountHandler wageAccountHandler, MessageService messageService, ProjectHandler projectHandler, UserHandler userHandler, UserService userService, AttendancePrintMapper attendancePrintMapper, PayrollItemTypeMapper payrollItemTypeMapper, PayrollMonthMapper payrollMonthMapper, PayrollMonthItemMapper payrollMonthItemMapper, PayrollPrintMapper printMapper, AttendanceDurationAggregators attendanceDurationAggregators, WageTypeCalculators wageTypeCalculators, PayrollMonthHelperService payrollMonthHelperService, AttendanceGenerator attendanceGenerator, DateTimeHelperService dateTimeHelperService, PDFHelperService pdfHelperService, PdfRoute pdfRoute, SBSRoute sbsRoute, Validators validators, ConfigurationCompanyHandler configurationCompanyHandler, ApplicationEventPublisher applicationEventPublisher) {
        this.companyConfig = companyConfig;
        this.entityFactory = entityFactory;
        this.attendanceHandler = attendanceHandler;
        this.mapper = mapper;
        this.bankingHolidayHandler = bankingHolidayHandler;
        this.laborUnionContractHandler = laborUnionContractHandler;
        this.payrollItemTypeHandler = payrollItemTypeHandler;
        this.payrollMonthHandler = payrollMonthHandler;
        this.payrollMonthItemHandler = payrollMonthItemHandler;
        this.payrollMonthSnapShotHandler = payrollMonthSnapShotHandler;
        this.payrollMonthSnapShotXlsExportService = payrollMonthSnapShotXlsExportService;
        this.projectWageReportXlsExportService = projectWageReportXlsExportService;
        this.stageHandler = stageHandler;
        this.wageAccountHandler = wageAccountHandler;
        this.messageService = messageService;
        this.projectHandler = projectHandler;
        this.userHandler = userHandler;
        this.userService = userService;
        this.attendancePrintMapper = attendancePrintMapper;
        this.payrollItemTypeMapper = payrollItemTypeMapper;
        this.payrollMonthMapper = payrollMonthMapper;
        this.payrollMonthItemMapper = payrollMonthItemMapper;
        this.printMapper = printMapper;
        this.attendanceDurationAggregators = attendanceDurationAggregators;
        this.wageTypeCalculators = wageTypeCalculators;
        this.payrollMonthHelperService = payrollMonthHelperService;
        this.attendanceGenerator = attendanceGenerator;
        this.dateTimeHelperService = dateTimeHelperService;
        this.pdfHelperService = pdfHelperService;
        this.pdfRoute = pdfRoute;
        this.sbsRoute = sbsRoute;
        this.validators = validators;
        this.configurationCompanyHandler = configurationCompanyHandler;
        this.applicationEventPublisher = applicationEventPublisher;
    }

    private static /* synthetic */ void lambda$page$28(Map laborUnionContractsById, Map payrollMonthCountPerContract, ImmutableList.Builder laborUnionStatisticBuilder, Long contractId, Integer contractAmountExpected) {
        LaborUnionContract laborUnionContract = (LaborUnionContract)laborUnionContractsById.get(contractId);
        int contractAmountAvailable = payrollMonthCountPerContract.getOrDefault(contractId, 0);
        BigDecimal percent = BigDecimal.valueOf(contractAmountAvailable).divide(BigDecimal.valueOf(contractAmountExpected.intValue()), 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)).setScale(2, RoundingMode.HALF_UP);
        laborUnionStatisticBuilder.add((Object)PayrollMonthLaborUnionContractStatistic.of((long)contractId, (String)laborUnionContract.getName(), (int)contractAmountExpected, (int)contractAmountAvailable, (BigDecimal)percent));
    }

    private static /* synthetic */ void lambda$page$27(User user, Multimap contractUsers, LaborUnionContract laborUnionContract) {
        Long userId = user.getId();
        Long laborUnionContractId = laborUnionContract.getId();
        contractUsers.put((Object)laborUnionContractId, (Object)userId);
    }

    private static /* synthetic */ boolean lambda$preparePrintSlip$24(Map M, WageTypeCalculationResult item) {
        EWageTypeCalculationResultType wageTypeCalculationResultType = item.getWageTypeCalculationResultType();
        EWageTypeCalculationResultType configuredPrintType = item.getPayrollItemType().getPrintWageTypeCalculationResultType();
        Iterable typeToBePrintedForPrintType = (Iterable)MoreObjects.firstNonNull((Object)((Iterable)M.get(configuredPrintType)), (Object)ImmutableSet.of());
        return Iterables.contains((Iterable)typeToBePrintedForPrintType, (Object)wageTypeCalculationResultType);
    }

    private static /* synthetic */ void lambda$attendanceReportAggregationRows$17(Multimap values, PayrollMonthItem payrollMonthItem) {
        PayrollItemType payrollItemType = payrollMonthItem.getPayrollItemType();
        BigDecimal value = (BigDecimal)MoreObjects.firstNonNull((Object)payrollMonthItem.getValue(), (Object)BigDecimal.ZERO);
        values.put((Object)payrollItemType, (Object)value);
    }

    private static /* synthetic */ void lambda$attendanceReportAggregationRows$13(Multimap values, PayrollItemType item) {
        values.put((Object)item, (Object)BigDecimal.ZERO);
    }
}

