/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.common.request.contract.LaborUnionContractUpdateRequest;
import de.qfm.erp.common.request.contract.LaborUnionWageGroupModificationItem;
import de.qfm.erp.common.request.contract.LaborUnionWageGroupRateModificationItem;
import de.qfm.erp.common.request.contract.LaborUnionWageGroupRateUpdateItem;
import de.qfm.erp.common.request.contract.LaborUnionWageGroupRatesUpdateRequest;
import de.qfm.erp.common.request.contract.LaborUnionWageGroupUpdateItem;
import de.qfm.erp.common.request.contract.LaborUnionWageGroupsUpdateRequest;
import de.qfm.erp.common.response.contract.LaborUnionContractCommon;
import de.qfm.erp.common.response.contract.LaborUnionContractPageCommon;
import de.qfm.erp.common.response.contract.LaborUnionWageGroupListCommon;
import de.qfm.erp.common.response.contract.LaborUnionWageGroupRateCommon;
import de.qfm.erp.common.response.contract.LaborUnionWageGroupRateListCommon;
import de.qfm.erp.service.configuration.ApplicationConfig;
import de.qfm.erp.service.helper.EmployeeHelper;
import de.qfm.erp.service.model.exception.response.ResourceNotFoundException;
import de.qfm.erp.service.model.internal.MergedBucket;
import de.qfm.erp.service.model.internal.contract.LaborUnionContractUpdateBucket;
import de.qfm.erp.service.model.internal.contract.LaborUnionWageGroupRateUpdateBucket;
import de.qfm.erp.service.model.internal.contract.LaborUnionWageGroupRatesUpdateBucket;
import de.qfm.erp.service.model.internal.contract.LaborUnionWageGroupsUpdateBucket;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionContract;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionWageGroup;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionWageGroupRate;
import de.qfm.erp.service.model.jpa.generic.EFederalState;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.handler.LaborUnionContractHandler;
import de.qfm.erp.service.service.handler.LaborUnionWageGroupHandler;
import de.qfm.erp.service.service.handler.LaborUnionWageGroupRateHandler;
import de.qfm.erp.service.service.mapper.BaseMapper;
import de.qfm.erp.service.service.mapper.LaborUnionContractMapper;
import de.qfm.erp.service.service.mapper.LaborUnionWageGroupMapper;
import de.qfm.erp.service.service.route.LaborUnionContractRoute;
import de.qfm.erp.service.service.security.AuthenticationHelper;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class LaborUnionContractRouteImpl
implements LaborUnionContractRoute {
    private static final Logger log = LogManager.getLogger(LaborUnionContractRouteImpl.class);
    public static final Joiner ID_JOINER = Joiner.on((String)",").skipNulls();
    public static final Predicate<LaborUnionWageGroupRate> NO_FILTER = laborUnionWageGroupRate -> true;
    @NonNull
    public static final BiConsumer<LaborUnionWageGroupRate, LaborUnionWageGroupRateUpdateItem> NOOP_UI = (laborUnionWageGroupRate, updateItem) -> {};
    @NonNull
    public static final BiConsumer<LaborUnionWageGroupRate, LaborUnionWageGroupRateUpdateBucket> NOOP_UB = (laborUnionWageGroupRate, updateItem) -> {};
    private final ApplicationConfig applicationConfig;
    private final AuthenticationHelper authenticationHelper;
    private final EntityFactory entityFactory;
    private final LaborUnionContractHandler handler;
    private final LaborUnionContractMapper mapper;
    private final LaborUnionWageGroupHandler laborUnionWageGroupHandler;
    private final LaborUnionWageGroupRateHandler laborUnionWageGroupRateHandler;
    private final LaborUnionWageGroupMapper laborUnionWageGroupMapper;

    @Nonnull
    public LaborUnionContractPageCommon page(int page, int size) {
        Page laborUnionContractPage = this.handler.page((Pageable)PageRequest.of((int)page, (int)size));
        return this.mapper.map(laborUnionContractPage);
    }

    @Nonnull
    public LaborUnionContractCommon byId(long id) {
        LaborUnionContract laborUnionContract = (LaborUnionContract)this.handler.byIdFailing(Long.valueOf(id));
        return this.mapper.map(laborUnionContract);
    }

    @Nonnull
    public LaborUnionWageGroupListCommon wageGroupsByContractId(long id) {
        LaborUnionContract laborUnionContract = (LaborUnionContract)this.handler.byIdFailing(Long.valueOf(id));
        Set wageGroups = (Set)MoreObjects.firstNonNull((Object)laborUnionContract.getWageGroups(), (Object)ImmutableSet.of());
        return this.laborUnionWageGroupMapper.map((Iterable)wageGroups, NO_FILTER);
    }

    @Nonnull
    public LaborUnionWageGroupListCommon update(long id, @NonNull LaborUnionWageGroupsUpdateRequest updateRequest) {
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        LaborUnionContract laborUnionContract = (LaborUnionContract)this.handler.byIdFailing(Long.valueOf(id));
        Iterable wageGroupUpdateItems = (Iterable)MoreObjects.firstNonNull((Object)updateRequest.getItems(), (Object)ImmutableList.of());
        LaborUnionWageGroupsUpdateBucket laborUnionWageGroupsUpdateBucket = this.wageGroupsBucket(laborUnionContract, wageGroupUpdateItems);
        MergedBucket wageGroupsMerged = this.mapper.mergeWageGroups(laborUnionWageGroupsUpdateBucket, this.mergeLaborUnionWageGroupRatesBiConsumer());
        LaborUnionContract laborUnionContractUpdated = (LaborUnionContract)this.handler.update((EntityBase)laborUnionContract);
        return this.laborUnionWageGroupMapper.map((Iterable)laborUnionContractUpdated.getWageGroups(), NO_FILTER);
    }

    @Nonnull
    private BiConsumer<LaborUnionWageGroup, LaborUnionWageGroupUpdateItem> mergeLaborUnionWageGroupRatesBiConsumer() {
        return (laborUnionWageGroup, laborUnionWageGroupUpdateItem) -> {
            List wageGroupRates = (List)MoreObjects.firstNonNull((Object)laborUnionWageGroupUpdateItem.getWageGroupRates(), (Object)ImmutableList.of());
            LaborUnionWageGroupRatesUpdateBucket laborUnionWageGroupRatesUpdateBucket = this.wageGroupRatesUpdateBucket(laborUnionWageGroup, (Iterable)wageGroupRates);
            MergedBucket mergedBucketWageGroupRate = BaseMapper.merge((EntityBase)laborUnionWageGroup, LaborUnionWageGroup::getWageGroupRates, arg_0 -> ((LaborUnionWageGroup)laborUnionWageGroup).setWageGroupRates(arg_0), (Iterable)laborUnionWageGroupRatesUpdateBucket.getLaborUnionWageGroupRateUpdateBuckets(), LaborUnionWageGroupRateUpdateBucket::getId, LaborUnionWageGroupRate::getId, () -> ((EntityFactory)this.entityFactory).laborUnionWageGroupRate(), (arg_0, arg_1) -> ((LaborUnionContractMapper)this.mapper).mergeWageGroupRateUB(arg_0, arg_1), LaborUnionWageGroupRate::setLaborUnionWageGroup, () -> ((AuthenticationHelper)this.authenticationHelper).currentUserName(), (BiConsumer)NOOP_UB);
            MergedBucket.printMergeBucket((Object)laborUnionWageGroup, LaborUnionWageGroupRate.class, (MergedBucket)mergedBucketWageGroupRate);
        };
    }

    @Nonnull
    public LaborUnionWageGroupListCommon wageGroupsByContractIdAndReferenceDate(long id, @NonNull LocalDate referenceDate) {
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        LaborUnionContract laborUnionContract = (LaborUnionContract)this.handler.byIdFailing(Long.valueOf(id));
        Set wageGroups = (Set)MoreObjects.firstNonNull((Object)laborUnionContract.getWageGroups(), (Object)ImmutableSet.of());
        return this.laborUnionWageGroupMapper.map((Iterable)wageGroups, item -> referenceDate.compareTo(item.getValidBegin()) >= 0 && referenceDate.compareTo(item.getValidEnd()) <= 0);
    }

    @Nonnull
    public LaborUnionWageGroupRateListCommon wageGroupRatesByWageGroupId(long wageGroupId) {
        LaborUnionWageGroup laborUnionWageGroup = (LaborUnionWageGroup)this.laborUnionWageGroupHandler.byIdFailing(Long.valueOf(wageGroupId));
        Set wageGroupRates = laborUnionWageGroup.getWageGroupRates();
        return this.laborUnionWageGroupMapper.mapWageGroupRates((Iterable)wageGroupRates, NO_FILTER);
    }

    @Nonnull
    public LaborUnionWageGroupRateListCommon update(long id, @NonNull LaborUnionWageGroupRatesUpdateRequest updateRequest) {
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        LaborUnionWageGroup laborUnionWageGroup = (LaborUnionWageGroup)this.laborUnionWageGroupHandler.byIdFailing(Long.valueOf(id));
        Iterable laborUnionWageGroupRateUpdateItems = (Iterable)MoreObjects.firstNonNull((Object)updateRequest.getItems(), (Object)ImmutableList.of());
        LaborUnionWageGroupRatesUpdateBucket wageGroupRatesUpdateBucket = this.wageGroupRatesUpdateBucket(laborUnionWageGroup, laborUnionWageGroupRateUpdateItems);
        MergedBucket wageGroupRatesMerged = this.mapper.mergeWageGroupRates(wageGroupRatesUpdateBucket);
        LaborUnionWageGroup laborUnionWageGroupUpdated = (LaborUnionWageGroup)this.laborUnionWageGroupHandler.update((EntityBase)laborUnionWageGroup);
        return this.laborUnionWageGroupMapper.mapWageGroupRates((Iterable)laborUnionWageGroupUpdated.getWageGroupRates(), NO_FILTER);
    }

    @Nonnull
    private LaborUnionWageGroupRatesUpdateBucket wageGroupRatesUpdateBucket(@NonNull LaborUnionWageGroup laborUnionWageGroup, @NonNull Iterable<LaborUnionWageGroupRateUpdateItem> laborUnionWageGroupRateUpdateItems) {
        if (laborUnionWageGroup == null) {
            throw new NullPointerException("laborUnionWageGroup is marked non-null but is null");
        }
        if (laborUnionWageGroupRateUpdateItems == null) {
            throw new NullPointerException("laborUnionWageGroupRateUpdateItems is marked non-null but is null");
        }
        ImmutableSet requiredLaborUnionWageGroupRateIds = (ImmutableSet)Streams.stream(laborUnionWageGroupRateUpdateItems).map(LaborUnionWageGroupRateModificationItem::getId).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        Iterable laborUnionWageGroupRatesForIds = this.laborUnionWageGroupRateHandler.allByIds((Iterable)requiredLaborUnionWageGroupRateIds);
        Map<Long, LaborUnionWageGroupRate> laborUnionWageGroupRatesExistingById = Streams.stream((Iterable)laborUnionWageGroupRatesForIds).collect(Collectors.toMap(LaborUnionWageGroupRate::getId, item -> item));
        Set<Long> laborUnionWageGroupRateIdsExisting = laborUnionWageGroupRatesExistingById.keySet();
        Sets.SetView laborUnionWageGroupRateIdsMissing = Sets.difference(laborUnionWageGroupRateIdsExisting, (Set)requiredLaborUnionWageGroupRateIds);
        if (!laborUnionWageGroupRateIdsMissing.isEmpty()) {
            String idsMissingMsg = ID_JOINER.join((Iterable)laborUnionWageGroupRateIdsMissing);
            throw ResourceNotFoundException.of((String)LaborUnionWageGroupRate.class.getSimpleName(), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.ID), (String)idsMissingMsg);
        }
        ImmutableList sortedUpdateItem = ImmutableList.sortedCopyOf((l, r) -> Comparator.reverseOrder().compare(l.getValidBegin(), r.getValidBegin()), laborUnionWageGroupRateUpdateItems);
        ImmutableList.Builder updateBucketsBuilder = ImmutableList.builder();
        LocalDate currentEnd = this.applicationConfig.getDefaultEndDate();
        for (LaborUnionWageGroupRateUpdateItem updateItem : sortedUpdateItem) {
            Long id = updateItem.getId();
            LocalDate validBegin = updateItem.getValidBegin();
            LocalDate validEnd = currentEnd;
            updateBucketsBuilder.add((Object)LaborUnionWageGroupRateUpdateBucket.of((Long)id, (LaborUnionWageGroup)laborUnionWageGroup, (LocalDate)validBegin, (LocalDate)validEnd, (LaborUnionWageGroupRateUpdateItem)updateItem));
            currentEnd = validBegin.minusDays(1L);
        }
        ImmutableList updateBuckets = updateBucketsBuilder.build();
        return LaborUnionWageGroupRatesUpdateBucket.of((LaborUnionWageGroup)laborUnionWageGroup, (Iterable)updateBuckets);
    }

    @Nonnull
    public LaborUnionWageGroupRateCommon wageGroupRatesByWageGroupIdAndReferenceDate(long wageGroupId, @NonNull LocalDate referenceDate) {
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        LaborUnionWageGroup laborUnionWageGroup = (LaborUnionWageGroup)this.laborUnionWageGroupHandler.byIdFailing(Long.valueOf(wageGroupId));
        Set wageGroupRates = laborUnionWageGroup.getWageGroupRates();
        Optional laborUnionWageGroupRateCandidate = EmployeeHelper.currentWageGroupRateNotFailing((Iterable)wageGroupRates, (LocalDate)referenceDate);
        if (laborUnionWageGroupRateCandidate.isPresent()) {
            LaborUnionWageGroupRate laborUnionWageGroupRate = (LaborUnionWageGroupRate)laborUnionWageGroupRateCandidate.get();
            return this.laborUnionWageGroupMapper.mapWageGroupRate(laborUnionWageGroupRate);
        }
        throw ResourceNotFoundException.of((String)LaborUnionWageGroupRate.class.getSimpleName(), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PARAM_WAGE_GROUP_RATE__REFERENCE_DATE), (String)DateTimeHelper.toIsoDate((LocalDate)referenceDate));
    }

    @Nonnull
    public LaborUnionContractCommon create(@NonNull LaborUnionContractUpdateRequest laborUnionContractUpdateRequest) {
        if (laborUnionContractUpdateRequest == null) {
            throw new NullPointerException("laborUnionContractUpdateRequest is marked non-null but is null");
        }
        LaborUnionContract laborUnionContract = this.entityFactory.laborUnionContract();
        return this.mergeAndPersist(laborUnionContractUpdateRequest, laborUnionContract);
    }

    @Nonnull
    public LaborUnionContractCommon update(long id, @NonNull LaborUnionContractUpdateRequest laborUnionContractUpdateRequest) {
        if (laborUnionContractUpdateRequest == null) {
            throw new NullPointerException("laborUnionContractUpdateRequest is marked non-null but is null");
        }
        LaborUnionContract laborUnionContract = (LaborUnionContract)this.handler.byIdFailing(Long.valueOf(id));
        return this.mergeAndPersist(laborUnionContractUpdateRequest, laborUnionContract);
    }

    @Nonnull
    private LaborUnionContractCommon mergeAndPersist(@NonNull LaborUnionContractUpdateRequest laborUnionContractUpdateRequest, @NonNull LaborUnionContract laborUnionContract) {
        if (laborUnionContractUpdateRequest == null) {
            throw new NullPointerException("laborUnionContractUpdateRequest is marked non-null but is null");
        }
        if (laborUnionContract == null) {
            throw new NullPointerException("laborUnionContract is marked non-null but is null");
        }
        LaborUnionContractUpdateBucket bucket = this.bucket(laborUnionContract, laborUnionContractUpdateRequest);
        LaborUnionContract laborUnionContractMerged = this.mapper.merge(bucket, this.mergeLaborUnionWageGroupRatesBiConsumer());
        LaborUnionContract laborUnionContractUpdated = (LaborUnionContract)this.handler.update((EntityBase)laborUnionContractMerged);
        return this.mapper.map(laborUnionContractUpdated);
    }

    @Nonnull
    private LaborUnionContractUpdateBucket bucket(@NonNull LaborUnionContract laborUnionContract, @NonNull LaborUnionContractUpdateRequest laborUnionContractUpdateRequest) {
        if (laborUnionContract == null) {
            throw new NullPointerException("laborUnionContract is marked non-null but is null");
        }
        if (laborUnionContractUpdateRequest == null) {
            throw new NullPointerException("laborUnionContractUpdateRequest is marked non-null but is null");
        }
        String federalStateCandidate = laborUnionContractUpdateRequest.getFederalState();
        EFederalState federalState = EFederalState.lookupFailing((String)federalStateCandidate);
        List wageGroups = (List)MoreObjects.firstNonNull((Object)laborUnionContractUpdateRequest.getWageGroups(), (Object)ImmutableList.of());
        LaborUnionWageGroupsUpdateBucket wageGroupsUpdateBucket = this.wageGroupsBucket(laborUnionContract, (Iterable)wageGroups);
        return LaborUnionContractUpdateBucket.of((LaborUnionContractUpdateRequest)laborUnionContractUpdateRequest, (LaborUnionContract)laborUnionContract, (EFederalState)federalState, (LaborUnionWageGroupsUpdateBucket)wageGroupsUpdateBucket);
    }

    @Nonnull
    private LaborUnionWageGroupsUpdateBucket wageGroupsBucket(@NonNull LaborUnionContract laborUnionContract, @NonNull Iterable<LaborUnionWageGroupUpdateItem> wageGroupUpdateItems) {
        if (laborUnionContract == null) {
            throw new NullPointerException("laborUnionContract is marked non-null but is null");
        }
        if (wageGroupUpdateItems == null) {
            throw new NullPointerException("wageGroupUpdateItems is marked non-null but is null");
        }
        ImmutableSet requiredLaborUnionWageGroupIds = (ImmutableSet)Streams.stream(wageGroupUpdateItems).map(LaborUnionWageGroupModificationItem::getId).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        Iterable laborUnionWageGroupsForIds = this.laborUnionWageGroupHandler.allByIds((Iterable)requiredLaborUnionWageGroupIds);
        Map<Long, LaborUnionWageGroup> laborUnionWageGroupsExistingById = Streams.stream((Iterable)laborUnionWageGroupsForIds).collect(Collectors.toMap(LaborUnionWageGroup::getId, item -> item));
        Set<Long> laborUnionWageGroupIdsExisting = laborUnionWageGroupsExistingById.keySet();
        Sets.SetView laborUnionWageGroupIdsMissing = Sets.difference(laborUnionWageGroupIdsExisting, (Set)requiredLaborUnionWageGroupIds);
        if (!laborUnionWageGroupIdsMissing.isEmpty()) {
            String idsMissingMsg = ID_JOINER.join((Iterable)laborUnionWageGroupIdsMissing);
            throw ResourceNotFoundException.of((String)LaborUnionWageGroup.class.getSimpleName(), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.ID), (String)idsMissingMsg);
        }
        return LaborUnionWageGroupsUpdateBucket.of((LaborUnionContract)laborUnionContract, (Iterable)laborUnionWageGroupsForIds, wageGroupUpdateItems);
    }

    public LaborUnionContractRouteImpl(ApplicationConfig applicationConfig, AuthenticationHelper authenticationHelper, EntityFactory entityFactory, LaborUnionContractHandler handler, LaborUnionContractMapper mapper, LaborUnionWageGroupHandler laborUnionWageGroupHandler, LaborUnionWageGroupRateHandler laborUnionWageGroupRateHandler, LaborUnionWageGroupMapper laborUnionWageGroupMapper) {
        this.applicationConfig = applicationConfig;
        this.authenticationHelper = authenticationHelper;
        this.entityFactory = entityFactory;
        this.handler = handler;
        this.mapper = mapper;
        this.laborUnionWageGroupHandler = laborUnionWageGroupHandler;
        this.laborUnionWageGroupRateHandler = laborUnionWageGroupRateHandler;
        this.laborUnionWageGroupMapper = laborUnionWageGroupMapper;
    }
}

