/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import de.qfm.erp.common.response.entityusage.EntityUsageCommon;
import de.qfm.erp.common.response.entityusage.EntityUsagePageCommon;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.jpa.history.type.EEntityClass;
import de.qfm.erp.service.model.jpa.navigation.EntityUsage;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.handler.EntityUsageHandler;
import de.qfm.erp.service.service.mapper.EntityUsageMapper;
import de.qfm.erp.service.service.route.EntityUsageRoute;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.validator.Validator;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EntityUsageRouteImpl
implements EntityUsageRoute {
    private final UserService userService;
    private final EntityUsageMapper mapper;
    private final EntityUsageHandler handler;

    @Nonnull
    @Transactional(readOnly=true)
    public EntityUsageCommon byId(long userId) {
        return this.mapper.map((EntityUsage)this.handler.byIdFailing(Long.valueOf(userId)));
    }

    @Nonnull
    @Transactional(readOnly=true)
    public EntityUsagePageCommon page(int page, int size) {
        PageRequest pageRequest = PageRequest.of((int)page, (int)size, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"}));
        return this.mapper.map(this.handler.page((Pageable)pageRequest));
    }

    @Nonnull
    public EntityUsagePageCommon page(@NonNull String entityClazzCandidate, int page, int size) {
        if (entityClazzCandidate == null) {
            throw new NullPointerException("entityClazzCandidate is marked non-null but is null");
        }
        Optional entityClass = EEntityClass.lookup((String)entityClazzCandidate);
        if (entityClass.isEmpty()) {
            throw Validator.throwEnumException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.ENTITY_CLASS), (String)entityClazzCandidate, EEntityClass.class, EEntityClass::allowedKeys);
        }
        User user = this.userService.authenticatedUser();
        Page entityUsagePage = this.handler.pageByUserAndEntityClass(user, (EEntityClass)entityClass.get(), page, size);
        return this.mapper.map(entityUsagePage);
    }

    public EntityUsageRouteImpl(UserService userService, EntityUsageMapper mapper, EntityUsageHandler handler) {
        this.userService = userService;
        this.mapper = mapper;
        this.handler = handler;
    }
}

