/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Longs;
import de.qfm.erp.common.request.employee.attendance.AttendanceListUpdateRequest;
import de.qfm.erp.common.request.employee.attendance.AttendanceUpdateRequest;
import de.qfm.erp.common.request.employee.payroll.PayrollMonthUpdateRequest;
import de.qfm.erp.common.response.employee.attendance.AttendanceCommon;
import de.qfm.erp.common.response.employee.attendance.AttendancesListCommon;
import de.qfm.erp.common.response.employee.payroll.PayrollMonthAutocompleteItemListCommon;
import de.qfm.erp.common.response.employee.payroll.PayrollMonthCommon;
import de.qfm.erp.common.response.employee.payroll.PayrollMonthItemListCommon;
import de.qfm.erp.common.response.employee.payroll.PayrollMonthPageCommon;
import de.qfm.erp.common.response.employee.payroll.WagesAssignedToPayrollCommon;
import de.qfm.erp.common.response.employee.wagedistribution.StageWageListCommon;
import de.qfm.erp.common.response.generic.PayrollItemTypePageCommon;
import de.qfm.erp.service.model.internal.print.payroll.PayrollMonthPrintConfiguration;
import de.qfm.erp.service.model.internal.print.payroll.PayrollMonthSlipInfo;
import de.qfm.erp.service.model.jpa.employee.attendance.EAttendanceOrigin;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import java.io.IOException;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;

public interface PayrollMonthRoute {
    public static final Splitter S = Splitter.on((String)",").trimResults().omitEmptyStrings();
    public static final CharMatcher C = CharMatcher.inRange((char)'0', (char)'9').precomputed();

    @Nonnull
    public AttendanceCommon attendanceById(long var1);

    @Nonnull
    public PayrollMonthPageCommon ensureAttendance(@NonNull EAttendanceOrigin var1, int var2, int var3);

    @Nonnull
    public AttendancesListCommon attendancesByTypeAndYearAndMonth(@NonNull String var1, int var2, int var3);

    @Nonnull
    public AttendancesListCommon attendancesByUserIdAndYearAndMonth(@NonNull EAttendanceOrigin var1, long var2, int var4, int var5);

    @Nonnull
    public AttendancesListCommon attendancesById(long var1);

    @Nonnull
    public AttendancesListCommon update(@Nonnull AttendanceListUpdateRequest var1);

    @Nonnull
    public StageWageListCommon listQuotationWages(long var1, @NonNull String var3, boolean var4);

    @Nonnull
    public StageWageListCommon listQuotationWages(@NonNull EAttendanceOrigin var1, long var2, int var4, int var5, @NonNull String var6, boolean var7);

    @Nonnull
    public PayrollItemTypePageCommon availablePayrollItemTypes(int var1, int var2, boolean var3, long var4);

    @Deprecated
    @Nonnull
    public PayrollMonthItemListCommon incentiveWagesAssignedToPayroll(long var1);

    @Nonnull
    public WagesAssignedToPayrollCommon wagesAssignedToPayroll(long var1);

    @Nonnull
    public PayrollMonthCommon byUserIdAndYearAndMonth(@NonNull EAttendanceOrigin var1, long var2, int var4, int var5);

    @Nonnull
    public PayrollMonthCommon update(long var1, @NonNull PayrollMonthUpdateRequest var3);

    @Nonnull
    public AttendanceCommon update(@NonNull EAttendanceOrigin var1, long var2, @NonNull AttendanceUpdateRequest var4);

    @Nonnull
    public Pair<String, byte[]> printPayrollMonth(long var1, @NonNull String var3);

    @Nonnull
    public Pair<String, byte[]> printPayrollMonthsAsZIP(@NonNull Iterable<Long> var1, @NonNull String var2) throws IOException;

    @Nonnull
    default public Pair<String, byte[]> printPayrollMonthsAsPDF(@NonNull String ids, @NonNull String printTemplate) throws IOException {
        if (ids == null) {
            throw new NullPointerException("ids is marked non-null but is null");
        }
        if (printTemplate == null) {
            throw new NullPointerException("printTemplate is marked non-null but is null");
        }
        ImmutableSet collect = (ImmutableSet)S.splitToList((CharSequence)ids).stream().map(arg_0 -> ((CharMatcher)C).retainFrom(arg_0)).map(Longs::tryParse).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        return this.printPayrollMonthsAsPDF((Iterable)collect, printTemplate);
    }

    @Nonnull
    public Pair<String, byte[]> printPayrollMonthsAsPDF(@NonNull Iterable<Long> var1, @NonNull String var2) throws IOException;

    @Nonnull
    public Pair<String, byte[]> printByCostCenter(@NonNull String var1, @NonNull String var2, int var3, int var4);

    @Nonnull
    public Pair<String, byte[]> exportToSBS(Iterable<Long> var1);

    @Nonnull
    public PayrollMonthPageCommon page(@Nullable LocalDate var1, @Nullable String var2, int var3, int var4, boolean var5, boolean var6, boolean var7);

    @Nonnull
    public PayrollMonthCommon release(long var1);

    @Nonnull
    public PayrollMonthCommon unrelease(long var1);

    @Nonnull
    public PayrollMonthCommon reset(long var1);

    @Nonnull
    public AttendanceCommon attendanceByDay(@NonNull EAttendanceOrigin var1, long var2, LocalDate var4);

    @Nonnull
    public AttendanceCommon resetAttendance(@NonNull EAttendanceOrigin var1, long var2);

    @Nonnull
    public Pair<PayrollMonthPrintConfiguration, PayrollMonthSlipInfo> preparePrintSlip(@NonNull PayrollMonth var1);

    @Nonnull
    public Pair<String, byte[]> exportWagesAsXLS(@NonNull YearMonth var1) throws IOException;

    @Nonnull
    public Pair<String, byte[]> projectBasedWageExportAsXLS(@NonNull YearMonth var1, @NonNull String var2) throws IOException;

    @Nonnull
    public PayrollMonthAutocompleteItemListCommon badWeatherCandidateAutocomplete(long var1, int var3, int var4, String var5);
}

