/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route;

import com.google.common.base.Stopwatch;
import de.qfm.erp.service.configuration.NodeConfig;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.search.EIndexEntryType;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractSyncable<T extends EntityBase> {
    private static final Logger log = LogManager.getLogger(AbstractSyncable.class);
    @NonNull
    protected final NodeConfig nodeConfig;

    @Nonnull
    public abstract EIndexEntryType indexEntryType();

    public abstract boolean dirty();

    @Nonnull
    public abstract Iterable<T> streamDirty(int var1);

    @Nonnull
    public abstract Long id(@NonNull T var1);

    @Nonnull
    public abstract Iterable<Long> ids(@NonNull Iterable<T> var1);

    @Nonnull
    public abstract Iterable<T> refresh(@NonNull Iterable<T> var1);

    public abstract void start();

    public abstract void finish(@NonNull Iterable<T> var1, @NonNull Stopwatch var2);

    @Transactional(readOnly=false)
    public synchronized boolean refresh() {
        boolean isDirty = this.dirty();
        if (isDirty) {
            this.start();
            Stopwatch stopwatch = Stopwatch.createStarted();
            int maxSyncSize = this.nodeConfig.getSyncBatchSize();
            Iterable items = this.streamDirty(maxSyncSize);
            Iterable refreshed = this.refresh(items);
            this.finish(refreshed, stopwatch.stop());
        }
        return isDirty;
    }

    protected AbstractSyncable(@NonNull NodeConfig nodeConfig) {
        if (nodeConfig == null) {
            throw new NullPointerException("nodeConfig is marked non-null but is null");
        }
        this.nodeConfig = nodeConfig;
    }
}

