/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.queue;

import de.qfm.erp.service.configuration.Q1Config;
import de.qfm.erp.service.model.jpa.queue.EQueueItemType;
import de.qfm.erp.service.model.jpa.queue.EReferenceType;
import de.qfm.erp.service.model.jpa.queue.QueueItem;
import de.qfm.erp.service.service.queue.PushUserToTargetItemProcessor;
import de.qfm.erp.service.service.queue.QueueProcessor;
import de.qfm.erp.service.service.route.UserRoute;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class PushUserToTargetItemProcessor
implements QueueProcessor {
    private static final Logger log = LogManager.getLogger(PushUserToTargetItemProcessor.class);
    private final Q1Config q1Config;
    private final UserRoute userRoute;

    @Nonnull
    public EReferenceType referenceType() {
        return EReferenceType.USER;
    }

    public boolean process(@NonNull QueueItem item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        try {
            EQueueItemType queueItemType = item.getQueueItemType();
            switch (1.$SwitchMap$de$qfm$erp$service$model$jpa$queue$EQueueItemType[queueItemType.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    return this.notifyQ1(item);
                }
            }
        }
        catch (Exception e) {
            log.error("Error Processing QueueItem, Error: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
        return true;
    }

    private boolean notifyQ1(@NonNull QueueItem queueItem) {
        if (queueItem == null) {
            throw new NullPointerException("queueItem is marked non-null but is null");
        }
        Long referenceId = queueItem.getReferenceId();
        EReferenceType referenceType = queueItem.getReferenceType();
        EQueueItemType queueItemType = queueItem.getQueueItemType();
        if (this.q1Config.isEmployeePushEnabled()) {
            return this.userRoute.pushToQ1(referenceId);
        }
        return true;
    }

    public PushUserToTargetItemProcessor(Q1Config q1Config, UserRoute userRoute) {
        this.q1Config = q1Config;
        this.userRoute = userRoute;
    }
}

