/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.psx;

import de.qfm.erp.service.configuration.PsxConfig;
import de.qfm.erp.service.model.external.psx.ExtPsxConstructionSiteCommon;
import de.qfm.erp.service.model.external.psx.ExtPsxConstructionSitePageCommon;
import de.qfm.erp.service.service.psx.PsxBaseClientService;
import de.qfm.erp.service.service.psx.PsxClientService;
import de.qfm.erp.service.service.psx.PsxPaths;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import io.restassured.specification.ResponseSpecification;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PsxConstructionSiteClientService
extends PsxBaseClientService
implements PsxPaths {
    @Autowired
    public PsxConstructionSiteClientService(PsxClientService clientService) {
        super(clientService);
    }

    @Nonnull
    public ExtPsxConstructionSitePageCommon constructionSites(@NonNull String filterText, @NonNull Iterable<String> filterStageReferenceIds, @NonNull Iterable<String> filterUserReferenceIds) {
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        if (filterStageReferenceIds == null) {
            throw new NullPointerException("filterStageReferenceIds is marked non-null but is null");
        }
        if (filterUserReferenceIds == null) {
            throw new NullPointerException("filterUserReferenceIds is marked non-null but is null");
        }
        PsxConfig config = this.clientService.getConfig();
        Iterable measurementConstructionSiteStates = config.getMeasurementConstructionSiteStates();
        return (ExtPsxConstructionSitePageCommon)((Response)((ResponseSpecification)((RequestSpecification)this.authContext().authorizedRequest().queryParam("page", new Object[]{0}).queryParam("size", new Object[]{1000}).queryParam("filter_text", new Object[]{filterText}).queryParam("filter_stage_reference_ids", new Object[]{REF_ID_JOINER.join(filterStageReferenceIds)}).queryParam("filter_user_reference_ids", new Object[]{REF_ID_JOINER.join(filterUserReferenceIds)}).queryParam("filter_construction_site_state", new Object[]{REF_ID_JOINER.join(measurementConstructionSiteStates)}).log().all()).expect().statusCode(200).log().all()).when().get("/api/v1/psx/constructionsites/", new Object[0])).as(ExtPsxConstructionSitePageCommon.class);
    }

    @Nonnull
    public ExtPsxConstructionSiteCommon constructionSite(@NonNull String psxConstructionSiteReferenceId) {
        if (psxConstructionSiteReferenceId == null) {
            throw new NullPointerException("psxConstructionSiteReferenceId is marked non-null but is null");
        }
        return (ExtPsxConstructionSiteCommon)((Response)((ResponseSpecification)((RequestSpecification)this.authContext().authorizedRequest().log().all()).expect().statusCode(200).log().all()).when().get("/api/v1/psx/constructionsites/{referenceId}/", new Object[]{psxConstructionSiteReferenceId})).as(ExtPsxConstructionSiteCommon.class);
    }
}

