/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper.search;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import de.qfm.erp.service.model.search.SubProjectIndexEntry;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class SubProjectIndexEntrySerializer {
    private static final Logger log = LogManager.getLogger(SubProjectIndexEntrySerializer.class);
    private final ObjectMapper objectMapper;

    @NonNull
    @VisibleForTesting
    public String serialize(@NonNull SubProjectIndexEntry item) throws JsonProcessingException {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return this.objectMapper.writeValueAsString((Object)item);
    }

    @Nonnull
    public Optional<SubProjectIndexEntry> unSerialize(@NonNull String json) {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        try {
            return Optional.of((SubProjectIndexEntry)this.objectMapper.readValue(json, SubProjectIndexEntry.class));
        }
        catch (JsonProcessingException e) {
            log.error("Cannot Unserialize SubProjectIndexEntry from value: {}, Error: {}", (Object)json, (Object)e.getMessage());
            return Optional.empty();
        }
    }

    public SubProjectIndexEntrySerializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

