/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import de.leancoders.common.helper.IterableHelper;
import de.qfm.erp.common.request.measurement.MeasurementPositionToTransposeRequestItem;
import de.qfm.erp.common.request.measurement.MeasurementPositionsStandardToTransposeRequest;
import de.qfm.erp.common.request.measurement.MeasurementTransposedRemarkUpdateItem;
import de.qfm.erp.common.response.measurement.MeasurementPositionsTransposedCommon;
import de.qfm.erp.common.response.measurement.MeasurementPositionsUntransposedCommon;
import de.qfm.erp.common.response.measurement.MeasurementTransposedRemarkCommon;
import de.qfm.erp.service.model.internal.transposition.Cell;
import de.qfm.erp.service.model.internal.transposition.Column;
import de.qfm.erp.service.model.internal.transposition.MeasurementPositionStandardToTranspose;
import de.qfm.erp.service.model.internal.transposition.MeasurementPositionTransposedToStandard;
import de.qfm.erp.service.model.internal.transposition.MeasurementPositionsTransposed;
import de.qfm.erp.service.model.internal.transposition.MeasurementTransposedRemark;
import de.qfm.erp.service.model.internal.transposition.Row;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Service;

@Service
public class TranspositionMapper {
    @Nonnull
    public Pair<Iterable<MeasurementTransposedRemark>, Iterable<MeasurementPositionStandardToTranspose>> mapToIntern(@NonNull MeasurementPositionsStandardToTransposeRequest measurementPositionsStandardToTransposeRequest) {
        if (measurementPositionsStandardToTransposeRequest == null) {
            throw new NullPointerException("measurementPositionsStandardToTransposeRequest is marked non-null but is null");
        }
        List measurementPositions = measurementPositionsStandardToTransposeRequest.getMeasurementPositions();
        List measurementTransposedRemarkItems = measurementPositionsStandardToTransposeRequest.getMeasurementTransposedRemarkItems();
        ImmutableList left = (ImmutableList)IterableHelper.stream((Iterable)measurementTransposedRemarkItems).map(arg_0 -> this.map(arg_0)).collect(ImmutableList.toImmutableList());
        ImmutableList right = (ImmutableList)IterableHelper.stream((Iterable)measurementPositions).map(arg_0 -> this.map(arg_0)).collect(ImmutableList.toImmutableList());
        return Pair.of((Object)left, (Object)right);
    }

    @Nonnull
    private MeasurementTransposedRemark map(@NonNull MeasurementTransposedRemarkUpdateItem measurementTransposedRemarkRequestItem) {
        if (measurementTransposedRemarkRequestItem == null) {
            throw new NullPointerException("measurementTransposedRemarkRequestItem is marked non-null but is null");
        }
        return MeasurementTransposedRemark.of((String)measurementTransposedRemarkRequestItem.getRemark(), (Integer)measurementTransposedRemarkRequestItem.getRowIndex());
    }

    @Nonnull
    private MeasurementPositionStandardToTranspose map(@NonNull MeasurementPositionToTransposeRequestItem measurementPositionToTransposeRequestItem) {
        if (measurementPositionToTransposeRequestItem == null) {
            throw new NullPointerException("measurementPositionToTransposeRequestItem is marked non-null but is null");
        }
        BigDecimal amount = measurementPositionToTransposeRequestItem.getAmount();
        BigDecimal factor1 = measurementPositionToTransposeRequestItem.getFactor1();
        BigDecimal factor2 = measurementPositionToTransposeRequestItem.getFactor2();
        BigDecimal factor3 = measurementPositionToTransposeRequestItem.getFactor3();
        String remarks = (String)MoreObjects.firstNonNull((Object)measurementPositionToTransposeRequestItem.getRemarks(), (Object)"");
        String surrogatePositionNumber = measurementPositionToTransposeRequestItem.surrogatePositionNumber();
        LocalDate accountingMonth = measurementPositionToTransposeRequestItem.getAccountingMonth();
        BigDecimal squadWagePerUnit = (BigDecimal)MoreObjects.firstNonNull((Object)measurementPositionToTransposeRequestItem.getSquadWagePerUnit(), (Object)BigDecimal.ZERO);
        BigDecimal pricePerUnit = (BigDecimal)MoreObjects.firstNonNull((Object)measurementPositionToTransposeRequestItem.getPricePerUnit(), (Object)BigDecimal.ZERO);
        String shortText = StringUtils.trimToEmpty((String)measurementPositionToTransposeRequestItem.getShortText());
        String unit = StringUtils.trimToEmpty((String)measurementPositionToTransposeRequestItem.getUnit());
        Integer sequenceNumberMeasurementStandard = measurementPositionToTransposeRequestItem.getSequenceNumberMeasurementStandard();
        Integer transposedSortIndex = measurementPositionToTransposeRequestItem.getTransposedSortIndex();
        Long id = measurementPositionToTransposeRequestItem.getId();
        Long positionId = measurementPositionToTransposeRequestItem.getPositionId();
        return MeasurementPositionStandardToTranspose.of((String)surrogatePositionNumber, (BigDecimal)amount, (BigDecimal)factor1, (BigDecimal)factor2, (BigDecimal)factor3, (String)remarks, (LocalDate)accountingMonth, (BigDecimal)squadWagePerUnit, (BigDecimal)pricePerUnit, (String)shortText, (String)unit, (Integer)sequenceNumberMeasurementStandard, (Integer)transposedSortIndex, (Long)id, (Long)positionId);
    }

    @Nonnull
    public MeasurementPositionsTransposedCommon map(@NonNull MeasurementPositionsTransposed measurementPositionsTransposed) {
        if (measurementPositionsTransposed == null) {
            throw new NullPointerException("measurementPositionsTransposed is marked non-null but is null");
        }
        Iterable columns = measurementPositionsTransposed.getColumns();
        Iterable rows = measurementPositionsTransposed.getRows();
        Iterable measurementTransposedRemarks = measurementPositionsTransposed.getMeasurementTransposedRemarks();
        ImmutableList columnsExternal = ImmutableList.copyOf(IterableHelper.stream((Iterable)columns).map(arg_0 -> this.map(arg_0)).iterator());
        ImmutableList rowsExternal = ImmutableList.copyOf(IterableHelper.stream((Iterable)rows).map(arg_0 -> this.map(arg_0)).iterator());
        List remarks = (List)IterableHelper.stream((Iterable)measurementTransposedRemarks).map(arg_0 -> this.map(arg_0)).collect(ImmutableList.toImmutableList());
        return MeasurementPositionsTransposedCommon.of((List)columnsExternal, (List)rowsExternal, (List)remarks);
    }

    @Nonnull
    public MeasurementPositionsTransposed map(@NonNull MeasurementPositionsTransposedCommon measurementPositionsTransposedCommon, @NonNull Iterable<MeasurementTransposedRemarkCommon> measurementTransposedRemarksCommon) {
        if (measurementPositionsTransposedCommon == null) {
            throw new NullPointerException("measurementPositionsTransposedCommon is marked non-null but is null");
        }
        if (measurementTransposedRemarksCommon == null) {
            throw new NullPointerException("measurementTransposedRemarksCommon is marked non-null but is null");
        }
        List columns = measurementPositionsTransposedCommon.getColumns();
        List rows = measurementPositionsTransposedCommon.getRows();
        ImmutableList columnsExternal = ImmutableList.copyOf(columns.stream().map(arg_0 -> this.map(arg_0)).iterator());
        ImmutableList rowsExternal = ImmutableList.copyOf(rows.stream().map(arg_0 -> this.map(arg_0)).iterator());
        Iterable measurementTransposedRemarks = (Iterable)IterableHelper.stream(measurementTransposedRemarksCommon).map(arg_0 -> this.map(arg_0)).distinct().collect(ImmutableList.toImmutableList());
        return MeasurementPositionsTransposed.of((Iterable)columnsExternal, (Iterable)rowsExternal, (Iterable)measurementTransposedRemarks);
    }

    @Nonnull
    private MeasurementPositionsTransposedCommon.Column map(@NonNull Column column) {
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        return MeasurementPositionsTransposedCommon.Column.of((String)column.getId(), (String)column.getSurrogatePositionNumber(), (String)column.getShortText(), (String)column.getUnit(), (BigDecimal)column.getSquadWagePerUnit(), (BigDecimal)column.getSquadWageAggregated(), (BigDecimal)column.getAmountAggregated(), (BigDecimal)column.getPricePerUnit(), (Integer)column.getTransposedSortIndex(), (Long)column.getPositionId());
    }

    @Nonnull
    private Column map(@NonNull MeasurementPositionsTransposedCommon.Column column) {
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        return Column.of((String)column.getId(), (String)column.getSurrogatePositionNumber(), (String)column.getShortText(), (String)column.getUnit(), (BigDecimal)column.getSquadWagePerUnit(), (BigDecimal)column.getSquadWageAggregated(), (BigDecimal)column.getAmountAggregated(), (BigDecimal)column.getPricePerUnit(), (Integer)column.getTransposedSortIndex(), (Long)column.getPositionId());
    }

    @Nonnull
    private MeasurementPositionsTransposedCommon.Row map(@NonNull Row row) {
        if (row == null) {
            throw new NullPointerException("row is marked non-null but is null");
        }
        Map cellsMap = Maps.transformValues((Map)row.getCells(), arg_0 -> this.map(arg_0));
        return MeasurementPositionsTransposedCommon.Row.of((String)row.getRemarks(), (Integer)row.getSequentialNumber(), (Map)cellsMap);
    }

    @Nonnull
    private MeasurementTransposedRemarkCommon map(@NonNull MeasurementTransposedRemark measurementTransposedRemark) {
        if (measurementTransposedRemark == null) {
            throw new NullPointerException("measurementTransposedRemark is marked non-null but is null");
        }
        String remark = measurementTransposedRemark.getRemark();
        Integer rowIndex = measurementTransposedRemark.getRowIndex();
        return MeasurementTransposedRemarkCommon.of((String)remark, (Integer)rowIndex);
    }

    @Nonnull
    private MeasurementTransposedRemark map(@NonNull MeasurementTransposedRemarkCommon measurementTransposedRemark) {
        if (measurementTransposedRemark == null) {
            throw new NullPointerException("measurementTransposedRemark is marked non-null but is null");
        }
        String remark = measurementTransposedRemark.getRemark();
        Integer rowIndex = measurementTransposedRemark.getRowIndex();
        return MeasurementTransposedRemark.of((String)remark, (Integer)rowIndex);
    }

    @Nonnull
    private Row map(@NonNull MeasurementPositionsTransposedCommon.Row row) {
        if (row == null) {
            throw new NullPointerException("row is marked non-null but is null");
        }
        Map cells = (Map)MoreObjects.firstNonNull((Object)row.getCells(), (Object)ImmutableMap.of());
        Map cellsMap = Maps.transformValues((Map)cells, arg_0 -> this.map(arg_0));
        String remarks = (String)MoreObjects.firstNonNull((Object)row.getRemarks(), (Object)"");
        Integer sequentialNumber = (Integer)MoreObjects.firstNonNull((Object)row.getSequentialNumber(), (Object)999);
        return Row.of((String)remarks, (Integer)sequentialNumber, (Map)cellsMap);
    }

    @Nonnull
    private MeasurementPositionsTransposedCommon.Cell map(@NonNull Cell cell) {
        if (cell == null) {
            throw new NullPointerException("cell is marked non-null but is null");
        }
        return MeasurementPositionsTransposedCommon.Cell.of((String)cell.getColumnId(), (BigDecimal)cell.getAmount(), (Integer)cell.getSequenceNumberMeasurementStandard(), (Integer)cell.getSequenceNumberMeasurementTransposed(), (LocalDate)cell.getAccountingMonth(), (Iterable)cell.getMeasurementPositionIds());
    }

    @Nonnull
    private Cell map(@NonNull MeasurementPositionsTransposedCommon.Cell cell) {
        if (cell == null) {
            throw new NullPointerException("cell is marked non-null but is null");
        }
        return Cell.of((String)cell.getColumnId(), (BigDecimal)cell.getAmount(), (Integer)cell.getSequenceNumberMeasurementStandard(), (Integer)cell.getSequenceNumberMeasurementTransposed(), (LocalDate)cell.getAccountingMonth(), (Iterable)cell.getMeasurementPositionIds());
    }

    @Nonnull
    public MeasurementPositionsUntransposedCommon map(@NonNull MeasurementPositionTransposedToStandard measurementPositionTransposedToStandard) {
        if (measurementPositionTransposedToStandard == null) {
            throw new NullPointerException("measurementPositionTransposedToStandard is marked non-null but is null");
        }
        MeasurementPositionsUntransposedCommon common = new MeasurementPositionsUntransposedCommon();
        common.setMeasurementPositionId(measurementPositionTransposedToStandard.getMeasurementPositionId());
        common.setQuotationPositionId(measurementPositionTransposedToStandard.getPositionId());
        common.setSurrogatePositionNumber(measurementPositionTransposedToStandard.surrogatePositionNumber());
        common.setAmount(measurementPositionTransposedToStandard.getAmount());
        common.setFactor1(measurementPositionTransposedToStandard.getFactor1());
        common.setFactor2(measurementPositionTransposedToStandard.getFactor2());
        common.setFactor3(measurementPositionTransposedToStandard.getFactor3());
        common.setRemarks(measurementPositionTransposedToStandard.getRemarks());
        common.setAccountingMonth(measurementPositionTransposedToStandard.getAccountingMonth());
        common.setSequenceNumberMeasurementStandard(measurementPositionTransposedToStandard.getSequenceNumberStandard());
        common.setSequenceNumberMeasurementTransposed(measurementPositionTransposedToStandard.getSequenceNumberTransposed());
        common.setTransposedSortIndex(measurementPositionTransposedToStandard.getTransposedSortIndex());
        return common;
    }
}

