/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.qfm.erp.service.helper.search.LuceneHelper;
import de.qfm.erp.service.model.jpa.project.SubProject;
import de.qfm.erp.service.model.jpa.quotation.QEntity;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.search.EIndexEntryType;
import de.qfm.erp.service.model.search.ESubProjectIndexField;
import de.qfm.erp.service.model.search.IndexDocument;
import de.qfm.erp.service.model.search.IndexField;
import de.qfm.erp.service.model.search.SubProjectIndexEntry;
import de.qfm.erp.service.service.mapper.search.SubProjectIndexEntrySerializer;
import java.time.LocalDateTime;
import java.util.LinkedHashSet;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class SubProjectSearchMapper {
    private static final Logger log = LogManager.getLogger(SubProjectSearchMapper.class);
    private static final Joiner ALL_JOINER = Joiner.on((char)' ').skipNulls();
    private static final Joiner ID_JOINER = Joiner.on((char)'_').useForNull("x");
    private final SubProjectIndexEntrySerializer subProjectIndexEntrySerializer;

    @Nonnull
    public IndexDocument mapToDocument(@NonNull SubProject item, @NonNull EIndexEntryType indexEntryType) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (indexEntryType == null) {
            throw new NullPointerException("indexEntryType is marked non-null but is null");
        }
        return this.mapToDocument(this.mapToIndexEntry(item, indexEntryType));
    }

    @Nonnull
    public Iterable<IndexDocument> mapToDocument(@NonNull Iterable<SubProject> items, @NonNull EIndexEntryType indexEntryType) {
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        if (indexEntryType == null) {
            throw new NullPointerException("indexEntryType is marked non-null but is null");
        }
        return (Iterable)Streams.stream(items).map(item -> this.mapToIndexEntry(item, indexEntryType)).map(arg_0 -> this.mapToDocument(arg_0)).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public SubProjectIndexEntry mapToIndexEntry(@NonNull SubProject item, @NonNull EIndexEntryType indexEntryType) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (indexEntryType == null) {
            throw new NullPointerException("indexEntryType is marked non-null but is null");
        }
        SubProjectIndexEntry indexEntry = new SubProjectIndexEntry();
        indexEntry.setId(item.getId());
        indexEntry.setIndexEntryType(indexEntryType);
        indexEntry.setCreatedOn(item.getCreatedOn());
        indexEntry.setCreatedBy(item.getCreatedBy());
        indexEntry.setUpdatedOn(item.getUpdatedOn());
        indexEntry.setUpdatedBy(item.getUpdatedBy());
        indexEntry.setEntityState(item.getEntityState());
        indexEntry.setName(item.getName());
        QEntity entity = item.getQEntity();
        if (null != entity) {
            indexEntry.setEntityId(entity.getId());
            indexEntry.setEntityNumber(entity.getQNumber());
            Quotation primaryStage = entity.getPrimaryStage();
            if (null != primaryStage) {
                indexEntry.setPrimaryStageId(primaryStage.getId());
                indexEntry.setPrimaryStageNumber(primaryStage.getQNumber());
            }
        }
        return indexEntry;
    }

    @Nonnull
    public IndexDocument mapToDocument(@Nonnull SubProjectIndexEntry indexEntry) {
        String source;
        Document document = new Document();
        String documentId = SubProjectSearchMapper.documentId((SubProjectIndexEntry)indexEntry);
        String type = indexEntry.getIndexEntryType().name();
        try {
            source = this.subProjectIndexEntrySerializer.serialize(indexEntry);
        }
        catch (JsonProcessingException e) {
            source = "";
        }
        LuceneHelper.notTokenized((IndexField)ESubProjectIndexField._ID, (String)documentId).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)ESubProjectIndexField._TYPE, (String)type).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        document.add((IndexableField)LuceneHelper.store((IndexField)ESubProjectIndexField._SOURCE, (String)source));
        LuceneHelper.notTokenized((IndexField)ESubProjectIndexField.ENTRY_TYPE, (String)type).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.dateTimeStr((IndexField)ESubProjectIndexField.SUB_PROJECT__CREATED_ON, (LocalDateTime)indexEntry.getCreatedOn()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.dateTimeStr((IndexField)ESubProjectIndexField.SUB_PROJECT__UPDATED_ON, (LocalDateTime)indexEntry.getUpdatedOn()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)ESubProjectIndexField.SUB_PROJECT__CREATED_BY, (String)indexEntry.getCreatedBy()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)ESubProjectIndexField.SUB_PROJECT__UPDATED_BY, (String)indexEntry.getUpdatedBy()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)ESubProjectIndexField.SUB_PROJECT__ENTITY_STATE, (String)indexEntry.getEntityState().name()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.tokenized((IndexField)ESubProjectIndexField.SUB_PROJECT__NAME, (String)indexEntry.getName()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.tokenized((IndexField)ESubProjectIndexField.SUB_PROJECT__ENTITY_NUMBER, (String)indexEntry.getEntityNumber()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.tokenized((IndexField)ESubProjectIndexField.SUB_PROJECT__STAGE_NUMBER, (String)indexEntry.getPrimaryStageNumber()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.numeric((IndexField)ESubProjectIndexField.SUB_PROJECT__ENTITY_ID, (Long)indexEntry.getEntityId()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.numeric((IndexField)ESubProjectIndexField.SUB_PROJECT__STAGE_ID, (Long)indexEntry.getPrimaryStageId()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        String allFromDocument = SubProjectSearchMapper.allFromDocument((Document)document);
        LuceneHelper.tokenized((IndexField)ESubProjectIndexField._ALL, (String)allFromDocument).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        return IndexDocument.of((String)documentId, (String)type, (Document)document);
    }

    @Nonnull
    @VisibleForTesting
    public static String documentId(@NonNull SubProjectIndexEntry indexEntry) {
        if (indexEntry == null) {
            throw new NullPointerException("indexEntry is marked non-null but is null");
        }
        return ID_JOINER.join((Object)indexEntry.getIndexEntryType(), (Object)indexEntry.getId(), new Object[0]);
    }

    @Nonnull
    @VisibleForTesting
    public static String documentId(@NonNull EIndexEntryType indexEntryType, @NonNull Long id) {
        if (indexEntryType == null) {
            throw new NullPointerException("indexEntryType is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return ID_JOINER.join((Object)indexEntryType, (Object)id, new Object[0]);
    }

    @Nonnull
    private static String allFromDocument(@NonNull Document document) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        LinkedHashSet allFieldValuesCollector = Sets.newLinkedHashSet();
        ESubProjectIndexField.CATCH_ALL_FIELDS.forEach(EIndexField -> {
            String fieldName = EIndexField.fieldName();
            String value = StringUtils.trimToEmpty((String)document.get(fieldName));
            if (StringUtils.isNotBlank((CharSequence)value)) {
                allFieldValuesCollector.add(value);
            }
        });
        return ALL_JOINER.join((Iterable)allFieldValuesCollector);
    }

    public SubProjectSearchMapper(SubProjectIndexEntrySerializer subProjectIndexEntrySerializer) {
        this.subProjectIndexEntrySerializer = subProjectIndexEntrySerializer;
    }
}

