/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import de.leancoders.common.helper.DateTimeFormats;
import de.leancoders.common.response.reporting.ReportDatasetCommon;
import de.leancoders.common.response.reporting.ReportResponse;
import de.qfm.erp.service.model.internal.dashboard.IReportCountDateBigDecimalBigDecimal;
import de.qfm.erp.service.model.internal.dashboard.ReportDateBigDecimalBigDecimal;
import de.qfm.erp.service.model.internal.reporting.EReportType;
import java.math.BigDecimal;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.stereotype.Service;

@Service
public class ReportingMapper {
    @Nonnull
    public ReportResponse<String, BigDecimal> map(@NonNull EReportType reportType, @NonNull Iterable<IReportCountDateBigDecimalBigDecimal> values, @NonNull Function<IReportCountDateBigDecimalBigDecimal, BigDecimal> fn) {
        if (reportType == null) {
            throw new NullPointerException("reportType is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        if (fn == null) {
            throw new NullPointerException("fn is marked non-null but is null");
        }
        ImmutableList labels = ImmutableList.copyOf(Streams.stream(values).map(IReportCountDateBigDecimalBigDecimal::getLabel).map(item -> item.format(DateTimeFormats.GERMAN_FULL_DATE)).iterator());
        ImmutableList fnValues1 = ImmutableList.copyOf(Streams.stream(values).map(fn).iterator());
        return ReportResponse.of((String)reportType.name(), (List)labels, (List)ImmutableList.of((Object)ReportDatasetCommon.of((Object)reportType.name(), (List)fnValues1)), (List)ImmutableList.of());
    }

    @Nonnull
    public ReportResponse<String, BigDecimal> map(@NonNull EReportType reportType, @NonNull Iterable<ReportDateBigDecimalBigDecimal> values, @NonNull String label1, @NonNull Function<ReportDateBigDecimalBigDecimal, BigDecimal> fn1, @NonNull String label2, @NonNull Function<ReportDateBigDecimalBigDecimal, BigDecimal> fn2) {
        if (reportType == null) {
            throw new NullPointerException("reportType is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        if (label1 == null) {
            throw new NullPointerException("label1 is marked non-null but is null");
        }
        if (fn1 == null) {
            throw new NullPointerException("fn1 is marked non-null but is null");
        }
        if (label2 == null) {
            throw new NullPointerException("label2 is marked non-null but is null");
        }
        if (fn2 == null) {
            throw new NullPointerException("fn2 is marked non-null but is null");
        }
        ImmutableList labels = ImmutableList.copyOf(Streams.stream(values).map(ReportDateBigDecimalBigDecimal::getReferenceDate).map(item -> item.format(DateTimeFormats.GERMAN_FULL_DATE)).iterator());
        ImmutableList fnValues1 = ImmutableList.copyOf(Streams.stream(values).map(fn1).iterator());
        ImmutableList fnValues2 = ImmutableList.copyOf(Streams.stream(values).map(fn2).iterator());
        return ReportResponse.of((String)reportType.name(), (List)labels, (List)ImmutableList.of((Object)ReportDatasetCommon.of((Object)label1, (List)fnValues1), (Object)ReportDatasetCommon.of((Object)label2, (List)fnValues2)), (List)ImmutableList.of());
    }
}

