/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import de.leancoders.common.helper.IterableHelper;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.quotation.QuotationPositionCommon;
import de.qfm.erp.service.helper.StagePositionHelper;
import de.qfm.erp.service.helper.comparator.quotation.QuotationPositionComparator;
import de.qfm.erp.service.model.internal.quotation.EQuotationPositionSortOption;
import de.qfm.erp.service.model.internal.quotation.QuotationBucket;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.quotation.QuotationPosition;
import de.qfm.erp.service.model.jpa.shared.EAlternativePositionType;
import de.qfm.erp.service.model.jpa.shared.EPositionType;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.service.mapper.BaseMapper;
import de.qfm.erp.service.service.security.UserService;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.stereotype.Service;

@Service
public class QuotationPositionMapper {
    private final UserService userService;

    @Nonnull
    public List<QuotationPositionCommon> mapPositionItemToCommon(@NonNull QuotationBucket bucket) {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        boolean hasValuePrivilege = this.userService.hasPrivilege(EPrivilege.QUOTATION__ALL_ATTRIBUTES_VISIBLE);
        EQuotationPositionSortOption quotationPositionSortOption = bucket.getQuotationPositionSortOption();
        Quotation quotation = bucket.getQuotation();
        Iterable sortedPositions = StagePositionHelper.automaticShuffle((Quotation)quotation, (EQuotationPositionSortOption)quotationPositionSortOption, (Iterable)bucket.getPositions());
        return ImmutableList.copyOf(IterableHelper.stream((Iterable)sortedPositions).map(item -> this.mapPositionItemToCommon(item, quotation, hasValuePrivilege)).iterator());
    }

    @Nonnull
    public Iterable<QuotationPositionCommon> mapCPPositions(@NonNull Quotation quotation, @NonNull Iterable<QuotationPosition> quotationPositions) {
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        if (quotationPositions == null) {
            throw new NullPointerException("quotationPositions is marked non-null but is null");
        }
        QuotationPositionComparator comparator = EQuotationPositionSortOption.SEQUENTIAL_NUMBER_ASC.getComparator();
        return ImmutableList.copyOf(IterableHelper.stream(quotationPositions).sorted(comparator).map(item -> this.mapPositionItemToCommon(item, quotation, true)).iterator());
    }

    @Nonnull
    public QuotationPositionCommon mapPositionItemToCommon(@NonNull QuotationPosition entity, @NonNull Quotation quotation, boolean hasValuePrivilege) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        QuotationPositionCommon common = new QuotationPositionCommon();
        BaseMapper.map((EntityBase)entity, (EntityBaseCommon)common);
        common.setId(entity.getId());
        common.setReferenceId(entity.getReferenceId());
        common.setQuotationId(quotation.getId());
        common.setQuotationNumber(quotation.getQuotationNumber());
        common.setAddendumNumber(entity.getAddendumNumber());
        common.setPositionNumber(entity.getPositionNumber());
        common.setSubPositionNumber(entity.getSubPositionNumber());
        common.setFlagAlternativePosition(entity.getFlagAlternativePosition());
        EAlternativePositionType flagAlternativePosition = (EAlternativePositionType)MoreObjects.firstNonNull((Object)entity.getAlternativePositionType(), (Object)EAlternativePositionType.NO);
        String alternativePositionString = flagAlternativePosition.name();
        common.setAlternativePositionType(alternativePositionString);
        common.setSurrogatePositionNumber(entity.getSurrogatePositionNumber());
        common.setGroupingElementLevel1(entity.getGroupingElementLevel1());
        common.setGroupingElementLevel2(entity.getGroupingElementLevel2());
        common.setGroupingElementLevel3(entity.getGroupingElementLevel3());
        common.setGroupingElementLevel4(entity.getGroupingElementLevel4());
        common.setSequentialNumber(entity.getSequenceNumberQuotationStandard());
        common.setShortText(entity.getShortText());
        common.setLongText(entity.getLongText());
        common.setOrderedAmount(entity.getOrderedAmount());
        common.setUnit(entity.getUnit());
        common.setUnitAmount(entity.getUnitAmount());
        common.setArticleCode(entity.getArticleCode());
        common.setArticleName(entity.getArticleName());
        common.setSupplierCode(entity.getSupplierCode());
        common.setHasBidderComplement(((Boolean)MoreObjects.firstNonNull((Object)entity.getHasBidderComplement(), (Object)false)).booleanValue());
        common.setBidderComplement(entity.getBidderComplement());
        common.setSquadWagePerUnit(entity.getSquadWagePerUnit());
        if (hasValuePrivilege) {
            common.setCompanyWagePerItem(entity.getCompanyWagePerItem());
            common.setCompanyWageAggregated(entity.getCompanyWageAggregated());
            common.setWagePerUnit(entity.getWagePerUnit());
            common.setInternalWageAggregated(entity.getInternalWageAggregated());
            common.setMaterialWholesalePriceExcludingDiscountPerItem(entity.getMaterialWholesalePriceExcludingDiscountPerItem());
            common.setMaterialWholesalePriceIncludingDiscountPerItem(entity.getMaterialWholesalePriceIncludingDiscountPerItem());
            common.setMaterialWholesalePriceExcludingDiscountAggregated(entity.getMaterialWholesalePriceExcludingDiscountAggregated());
            common.setMaterialWholesalePriceIncludingDiscountAggregated(entity.getMaterialWholesalePriceIncludingDiscountAggregated());
            common.setMaterialWholesalePriceDiscount(entity.getMaterialWholesalePriceDiscount());
            common.setMaterialFactor(entity.getMaterialFactor());
            common.setWageFactor(entity.getWageFactor());
            common.setMaterialSellingPricePerUnit(entity.getMaterialSellingPricePerUnit());
            common.setFlagFlatRate(entity.getFlagFlatRate());
            common.setMaterialSellingPriceAggregated(entity.getMaterialSellingPriceAggregated());
            common.setPriceAggregated(entity.getPriceAggregated());
            common.setPricePerUnit(entity.getPricePerUnit());
            common.setOverallPricePerItem(entity.getPricePerUnit());
            common.setMaterialPercentage(entity.getMaterialPercentage());
            common.setWagePercentage(entity.getWagePercentage());
            common.setAggregatedPercentage(entity.getAggregatedPercentage());
            common.setExternalServicePurchasePriceAggregated(entity.getExternalServicePurchasePriceAggregated());
            common.setExternalServiceSellingPriceAggregated(entity.getExternalServiceSellingPriceAggregated());
            common.setExternalServicePurchasePricePerUnit(entity.getExternalServicePurchasePricePerUnit());
            common.setExternalServicePercentage(entity.getExternalServicePercentage());
            common.setExternalServiceSellingPricePerUnit(entity.getExternalServiceSellingPricePerUnit());
            common.setFlagFeePosition((Boolean)MoreObjects.firstNonNull((Object)entity.getFlagFeePosition(), (Object)false));
        }
        EPositionType positionType = (EPositionType)MoreObjects.firstNonNull((Object)entity.getPositionType(), (Object)EPositionType.UNKNOWN);
        common.setPositionType(positionType.name());
        EPositionType jumboPositionType = (EPositionType)MoreObjects.firstNonNull((Object)entity.getJumboPositionType(), (Object)EPositionType.UNKNOWN);
        common.setPositionType(jumboPositionType.name());
        return common;
    }

    public QuotationPositionMapper(UserService userService) {
        this.userService = userService;
    }
}

