/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import de.leancoders.common.response.PageCommon;
import de.qfm.erp.common.response.search.ConstructionSiteSearchItem;
import de.qfm.erp.common.response.search.HighlightCommon;
import de.qfm.erp.common.response.search.ReleaseOrderSearchItem;
import de.qfm.erp.service.model.external.psx.ExtPsxPageCommon;
import de.qfm.erp.service.model.external.psx.search.PsxConstructionSiteSearchItem;
import de.qfm.erp.service.model.external.psx.search.PsxHighlightCommon;
import de.qfm.erp.service.model.external.psx.search.PsxReleaseOrderSearchItem;
import de.qfm.erp.service.model.external.psx.search.PsxSearchResponse;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.stereotype.Service;

@Service
public class PsxSearchMapper {
    @Nonnull
    public PageCommon<ConstructionSiteSearchItem> mapConstructionSite(@NonNull PsxSearchResponse buckets) {
        if (buckets == null) {
            throw new NullPointerException("buckets is marked non-null but is null");
        }
        ExtPsxPageCommon constructionSites = buckets.getConstructionSites();
        int page = constructionSites.getPage();
        int size = constructionSites.getSize();
        int totalPages = constructionSites.getTotalPages();
        long totalElements = constructionSites.getTotalElements();
        List remoteSearchItems = constructionSites.getItems();
        List localSearchItems = (List)remoteSearchItems.stream().map(arg_0 -> this.mapToSearchItem(arg_0)).collect(ImmutableList.toImmutableList());
        return new PageCommon(page, size, totalPages, totalElements, localSearchItems);
    }

    @Nonnull
    public ConstructionSiteSearchItem mapToSearchItem(@NonNull PsxConstructionSiteSearchItem searchItem) {
        if (searchItem == null) {
            throw new NullPointerException("searchItem is marked non-null but is null");
        }
        long id = searchItem.getId();
        String referenceId = Long.toString(id);
        String text = searchItem.getText();
        Iterable rootHighlight = searchItem.getTextHighlights();
        String details = searchItem.getDetails();
        String field = searchItem.getField();
        String fieldName = searchItem.getFieldName();
        Iterable detailHighlights = searchItem.getDetailHighlights();
        Iterable rootHighlightCommon = this.map(rootHighlight);
        Iterable detailHighlightCommon = this.map(detailHighlights);
        return ConstructionSiteSearchItem.of((String)referenceId, (String)text, (Iterable)rootHighlightCommon, (String)details, (String)field, (String)fieldName, (Iterable)detailHighlightCommon);
    }

    @Nonnull
    public PageCommon<ReleaseOrderSearchItem> mapReleaseOrder(@NonNull PsxSearchResponse buckets) {
        if (buckets == null) {
            throw new NullPointerException("buckets is marked non-null but is null");
        }
        ExtPsxPageCommon releaseOrders = buckets.getReleaseOrders();
        int page = releaseOrders.getPage();
        int size = releaseOrders.getSize();
        int totalPages = releaseOrders.getTotalPages();
        long totalElements = releaseOrders.getTotalElements();
        List remoteSearchItems = releaseOrders.getItems();
        List localSearchItems = (List)remoteSearchItems.stream().map(arg_0 -> this.mapToSearchItem(arg_0)).collect(ImmutableList.toImmutableList());
        return new PageCommon(page, size, totalPages, totalElements, localSearchItems);
    }

    @Nonnull
    public ReleaseOrderSearchItem mapToSearchItem(@NonNull PsxReleaseOrderSearchItem searchItem) {
        if (searchItem == null) {
            throw new NullPointerException("searchItem is marked non-null but is null");
        }
        long id = searchItem.getId();
        String referenceId = Long.toString(id);
        String text = searchItem.getText();
        Iterable rootHighlight = searchItem.getTextHighlights();
        String details = searchItem.getDetails();
        String field = searchItem.getField();
        String fieldName = searchItem.getFieldName();
        Iterable detailHighlights = searchItem.getDetailHighlights();
        Iterable rootHighlightCommon = this.map(rootHighlight);
        Iterable detailHighlightCommon = this.map(detailHighlights);
        return ReleaseOrderSearchItem.of((String)referenceId, (String)text, (Iterable)rootHighlightCommon, (String)details, (String)field, (String)fieldName, (Iterable)detailHighlightCommon);
    }

    @Nonnull
    private Iterable<HighlightCommon> map(@NonNull Iterable<PsxHighlightCommon> appQHighlightCommons) {
        if (appQHighlightCommons == null) {
            throw new NullPointerException("appQHighlightCommons is marked non-null but is null");
        }
        return (Iterable)Streams.stream(appQHighlightCommons).map(arg_0 -> this.map(arg_0)).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    private HighlightCommon map(@NonNull PsxHighlightCommon appQHighlightCommon) {
        if (appQHighlightCommon == null) {
            throw new NullPointerException("appQHighlightCommon is marked non-null but is null");
        }
        return HighlightCommon.of((String)appQHighlightCommon.getOriginal(), (int)appQHighlightCommon.getFrom(), (int)appQHighlightCommon.getTo());
    }
}

