/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.collect.ImmutableList;
import de.qfm.erp.common.request.project.ProjectUpdateRequest;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.project.ProjectAutoCompleteItemCommon;
import de.qfm.erp.common.response.project.ProjectAutoCompleteResponse;
import de.qfm.erp.common.response.project.ProjectCommon;
import de.qfm.erp.common.response.project.ProjectPageCommon;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.project.Project;
import de.qfm.erp.service.service.mapper.BaseMapper;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

@Service
public class ProjectMapper {
    @Nonnull
    public ProjectCommon map(@NonNull Project entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        ProjectCommon common = new ProjectCommon();
        BaseMapper.map((EntityBase)entity, (EntityBaseCommon)common);
        common.setId(entity.getId());
        common.setName(StringUtils.trimToEmpty((String)entity.getName()));
        common.setReferenceId(StringUtils.trimToEmpty((String)entity.getReferenceId()));
        common.setCostBearer(StringUtils.trimToEmpty((String)entity.getCostBearer()));
        return common;
    }

    @Nonnull
    public ProjectPageCommon map(@NonNull Page<Project> page) {
        if (page == null) {
            throw new NullPointerException("page is marked non-null but is null");
        }
        return (ProjectPageCommon)BaseMapper.map(page, arg_0 -> this.map(arg_0), (pageNumber, pageSize, totalElements, totalPages, items) -> new ProjectPageCommon(pageNumber, pageSize, totalPages, totalElements, items));
    }

    @Nonnull
    public ProjectAutoCompleteResponse mapAutoComplete(@Nonnull Page<Project> page) {
        int size = page.getSize();
        List commons = this.mapAutoComplete(page.getContent());
        return new ProjectAutoCompleteResponse(size, commons);
    }

    @Nonnull
    private List<ProjectAutoCompleteItemCommon> mapAutoComplete(@NonNull List<Project> projects) {
        if (projects == null) {
            throw new NullPointerException("projects is marked non-null but is null");
        }
        return (List)projects.stream().map(arg_0 -> this.mapAutoComplete(arg_0)).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    private ProjectAutoCompleteItemCommon mapAutoComplete(@NonNull Project project) {
        if (project == null) {
            throw new NullPointerException("project is marked non-null but is null");
        }
        ProjectAutoCompleteItemCommon common = new ProjectAutoCompleteItemCommon();
        common.setId(project.getId());
        common.setText(project.getName());
        return common;
    }

    @Nonnull
    public Project merge(@NonNull Project project, @NonNull ProjectUpdateRequest updateRequest) {
        if (project == null) {
            throw new NullPointerException("project is marked non-null but is null");
        }
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        project.setName(StringUtils.trimToEmpty((String)updateRequest.getName()));
        project.setReferenceId(StringUtils.trimToEmpty((String)updateRequest.getReferenceId()));
        project.setCostBearer(StringUtils.trimToEmpty((String)updateRequest.getCostBearer()));
        return project;
    }
}

